/*
 * Decompiled with CFR 0.152.
 */
package plugins.ferreol.demics;

import icy.file.Loader;
import icy.gui.frame.progress.AnnounceFrame;
import icy.image.colormap.IceColorMap;
import icy.image.colormap.IcyColorMap;
import icy.main.Icy;
import icy.plugin.PluginDescriptor;
import icy.plugin.PluginInstaller;
import icy.plugin.PluginRepositoryLoader;
import icy.plugin.PluginUpdater;
import icy.sequence.Sequence;
import icy.system.thread.ThreadUtil;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.SwingUtilities;
import loci.formats.ome.OMEXMLMetadataImpl;
import microTiPi.epifluorescence.WideFieldModel;
import microTiPi.microUtils.BlindDeconvJob;
import microTiPi.microscopy.MicroscopeMetadata;
import microTiPi.microscopy.PSF_Estimation;
import mitiv.array.ArrayUtils;
import mitiv.array.Double2D;
import mitiv.array.DoubleArray;
import mitiv.array.ShapedArray;
import mitiv.base.Shape;
import mitiv.base.mapping.DoubleFunction;
import mitiv.jobs.DeconvolutionJob;
import mitiv.utils.TiPiHook;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.ezplug.EzButton;
import plugins.adufour.ezplug.EzComponent;
import plugins.adufour.ezplug.EzGroup;
import plugins.adufour.ezplug.EzLabel;
import plugins.adufour.ezplug.EzPanel;
import plugins.adufour.ezplug.EzStoppable;
import plugins.adufour.ezplug.EzTabs;
import plugins.adufour.ezplug.EzVar;
import plugins.adufour.ezplug.EzVarBoolean;
import plugins.adufour.ezplug.EzVarChannel;
import plugins.adufour.ezplug.EzVarDouble;
import plugins.adufour.ezplug.EzVarDoubleArrayNative;
import plugins.adufour.ezplug.EzVarFile;
import plugins.adufour.ezplug.EzVarInteger;
import plugins.adufour.ezplug.EzVarListener;
import plugins.adufour.ezplug.EzVarSequence;
import plugins.adufour.ezplug.EzVarText;
import plugins.adufour.vars.lang.Var;
import plugins.ferreol.demics.DEMICSPlug;
import plugins.mitiv.io.DeconvHook;
import plugins.mitiv.io.Icy2TiPi;
import plugins.mitiv.io.IcyImager;

public class EpiDEMIC
extends DEMICSPlug
implements EzStoppable,
Block {
    private EzTabs tabbedPane;
    private EzPanel dataPanel;
    private EzButton saveMetaData;
    private EzButton showPSF;
    protected MicroscopeMetadata meta = null;
    private EzGroup ezWeightingGroup;
    private EzGroup ezPadGroup;
    private EzPanel deconvPanel;
    private EzVarDouble epsilon;
    private EzGroup ezDeconvolutionGroup;
    protected int Nxy = 128;
    private EzPanel bdecPanel;
    private EzVarText nbAlphaCoef;
    private EzVarText nbBetaCoef;
    private final String[] nAlphaOptions = new String[]{"0", "1", "3", "7", "8", "12", "18", "19", "25", "33", "34", "42", "52", "53", "63", "75", "76", "88", "102", "103"};
    private final String[] nBetaOptions = new String[]{"0", "3", "4", "6", "10", "11", "15", "21", "22", "28", "36", "37", "45", "55", "56", "66", "78", "79", "91", "105", "106"};
    private final String[] nAlphaOptionsR = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9"};
    private final String[] nBetaOptionsR = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9"};
    private EzVarBoolean radial;
    private EzButton showPSF2;
    private EzButton showModulus;
    private EzButton showPhase;
    private EzButton startBlind;
    private EzButton showFullObject2;
    private EzButton resetPSF;
    private EzButton saveParam;
    private EzButton loadParam;
    private EzLabel docDec;
    private EzVarInteger totalNbOfBlindDecLoop;
    private EzVarInteger maxIterDefocus;
    private EzVarInteger maxIterPhase;
    private EzVarInteger maxIterModulus;
    private EzLabel docBlind;
    private EzGroup visuPSF;
    private EzGroup ezBlindDeconvolutionGroup;
    private EzVarDoubleArrayNative pupilShift;
    private EzVarDoubleArrayNative phaseCoefs;
    private EzVarDoubleArrayNative modulusCoefs;
    private EzVarSequence outputHeadlessPSF = null;
    private PSF_Estimation psfEstimation;
    private DeconvolutionJob deconvolver;
    private WideFieldModel pupil = null;
    private boolean debug = false;
    private boolean verbose = false;
    private EzPanel debuggingPanel;
    private EzVarText resultCostPrior;
    private EzVarText resultDefocus;
    private EzVarText resultPhase;
    private EzVarText resultModulus;
    private String psfPath = null;
    private BlindDeconvJob bdec;
    private ShapedArray badArray = null;

    public void clean() {
    }

    @Override
    protected void updatePaddedSize() {
        super.updatePaddedSize();
        this.Nx = this.Ny = (this.Nxy = Math.max(this.Nx, this.Ny));
        this.psfShape = new Shape(this.Nxy, this.Nxy, this.Nz);
        this.outputShape = new Shape(this.Nxy, this.Nxy, this.Nz);
    }

    @Override
    protected void setDefaultValue() {
        super.setDefaultValue();
        this.radial.setValue((Object)false);
        this.paddingSizeXY.setValue((Object)30);
        if (this.debug) {
            this.resultCostPrior.setValue((Object)"No results yet");
            this.resultDefocus.setValue((Object)"No results yet");
            this.resultModulus.setValue((Object)"No results yet");
            this.resultPhase.setValue((Object)"No results yet");
        }
        if (!this.isHeadLess() && this.debug) {
            this.resultCostPrior.setEnabled(false);
            this.resultDefocus.setEnabled(false);
            this.resultModulus.setEnabled(false);
            this.resultPhase.setEnabled(false);
        }
    }

    protected void initialize() {
        PluginRepositoryLoader.waitLoaded();
        PluginDescriptor pluginDescriptor = PluginRepositoryLoader.getPlugin((String)"plugins.mitiv.deconv.MitivDeconvolution");
        if (pluginDescriptor != null && pluginDescriptor.isInstalled()) {
            if (!this.isHeadLess()) {
                new AnnounceFrame("Removing the now useless MitivDeconvolution plugin.");
            }
            PluginInstaller.desinstall((PluginDescriptor)pluginDescriptor, (boolean)false, (boolean)false);
            while (PluginUpdater.isCheckingForUpdate() || PluginInstaller.isProcessing() || PluginInstaller.isInstalling() || PluginInstaller.isDesinstalling()) {
                ThreadUtil.sleep((int)1);
            }
        }
        if (!this.isHeadLess()) {
            this.getUI().setParametersIOVisible(false);
            this.getUI().setActionPanelVisible(false);
        }
        this.tabbedPane = new EzTabs("BlindTabs", EzTabs.TabPlacement.TOP);
        this.dataPanel = new EzPanel("Step 1: Data", new EzComponent[0]);
        this.data = new EzVarSequence("Sequence:");
        this.channel = new EzVarChannel("Channel:", (Var)this.data.getVariable(), false);
        this.dataSize = new EzVarText("Image size:");
        this.outputSize = new EzVarText("Output size:");
        this.paddingSizeXY = new EzVarInteger("padding xy:", 0, Integer.MAX_VALUE, 1);
        this.paddingSizeZ = new EzVarInteger("padding z :", 0, Integer.MAX_VALUE, 1);
        this.restart = new EzVarSequence("Starting point:");
        this.restart.setNoSequenceSelection();
        this.channelRestart = new EzVarChannel("Initialization channel :", (Var)this.restart.getVariable(), false);
        this.saveMetaData = new EzButton("Save metadata", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (EpiDEMIC.this.debug) {
                    System.out.println("Saving metadata");
                }
                EpiDEMIC.this.updateMetaData();
            }
        });
        EzVarListener<Integer> ezVarListener = new EzVarListener<Integer>(){

            public void variableChanged(EzVar<Integer> ezVar, Integer n) {
                EpiDEMIC.this.updatePaddedSize();
                EpiDEMIC.this.updateImageSize();
                EpiDEMIC.this.updateOutputSize();
                EpiDEMIC.this.pupil = null;
            }
        };
        this.paddingSizeXY.addVarChangeListener((EzVarListener)ezVarListener);
        this.paddingSizeZ.addVarChangeListener((EzVarListener)ezVarListener);
        this.data.addVarChangeListener((EzVarListener)new EzVarListener<Sequence>(){

            public void variableChanged(EzVar<Sequence> ezVar, Sequence sequence) {
                if (EpiDEMIC.this.debug) {
                    System.out.println("Seq ch..." + sequence);
                }
                EpiDEMIC.this.dataChanged();
                if (EpiDEMIC.this.dataSeq != null) {
                    EpiDEMIC.this.startDec.setEnabled(true);
                    EpiDEMIC.this.startBlind.setEnabled(true);
                    EpiDEMIC.this.meta = EpiDEMIC.this.getMetaData(EpiDEMIC.this.dataSeq);
                    EpiDEMIC.this.dxy_nm.setValue((Object)EpiDEMIC.this.meta.dxy);
                    EpiDEMIC.this.dz_nm.setValue((Object)EpiDEMIC.this.meta.dz);
                    EpiDEMIC.this.scale.setValue((Object)new double[]{1.0, 1.0, (Double)EpiDEMIC.this.dxy_nm.getValue() / (Double)EpiDEMIC.this.dz_nm.getValue()});
                    EpiDEMIC.this.na.setValue((Object)EpiDEMIC.this.meta.na);
                    EpiDEMIC.this.lambda.setValue((Object)EpiDEMIC.this.meta.lambda);
                    EpiDEMIC.this.ni.setValue((Object)EpiDEMIC.this.meta.ni);
                    if (EpiDEMIC.this.debug) {
                        System.out.println("Seq changed:" + EpiDEMIC.this.sizeX + "  " + EpiDEMIC.this.Nxy);
                    }
                    EpiDEMIC.this.restart.setValue(sequence);
                } else {
                    EpiDEMIC.this.startDec.setEnabled(false);
                    EpiDEMIC.this.startBlind.setEnabled(false);
                }
            }
        });
        this.channel.addVarChangeListener((EzVarListener)new EzVarListener<Integer>(){

            public void variableChanged(EzVar<Integer> ezVar, Integer n) {
                EpiDEMIC.this.channelRestart.setValue((Object)n);
            }
        });
        this.restart.addVarChangeListener((EzVarListener)new EzVarListener<Sequence>(){

            public void variableChanged(EzVar<Sequence> ezVar, Sequence sequence) {
                sequence = (Sequence)EpiDEMIC.this.restart.getValue();
                if (EpiDEMIC.this.debug && (sequence != null || sequence != null && sequence.isEmpty())) {
                    System.out.println("restart changed:" + sequence.getName());
                }
            }
        });
        EzVarListener<Double> ezVarListener2 = new EzVarListener<Double>(){

            public void variableChanged(EzVar<Double> ezVar, Double d) {
                EpiDEMIC.this.scale.setValue((Object)new double[]{1.0, 1.0, (Double)EpiDEMIC.this.dz_nm.getValue() / (Double)EpiDEMIC.this.dxy_nm.getValue()});
                EpiDEMIC.this.pupil = null;
            }
        };
        this.dxy_nm = new EzVarDouble("dxy(nm):", 64.5, 0.0, Double.MAX_VALUE, 1.0);
        this.dxy_nm.addVarChangeListener((EzVarListener)ezVarListener2);
        this.dz_nm = new EzVarDouble("dz(nm):", 128.0, 0.0, Double.MAX_VALUE, 1.0);
        this.dz_nm.addVarChangeListener((EzVarListener)ezVarListener2);
        this.na = new EzVarDouble("NA:", 1.4, 0.0, Double.MAX_VALUE, 0.05);
        this.na.addVarChangeListener((EzVarListener)ezVarListener2);
        this.ni = new EzVarDouble("ni:", 1.518, 1.0, 2.0, 0.01);
        this.ni.addVarChangeListener((EzVarListener)ezVarListener2);
        this.lambda = new EzVarDouble("\u03bb(nm):", 540.0, 10.0, 15000.0, 5.0);
        this.lambda.addVarChangeListener((EzVarListener)ezVarListener2);
        this.showPSF = new EzButton("Show PSF", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EpiDEMIC.this.psfClicked();
                if (EpiDEMIC.this.debug) {
                    System.out.println("Showing PSF Button");
                }
            }
        });
        this.weightsMethod = new EzVarText("Weighting:", this.weightOptions, Boolean.valueOf(false));
        this.weights = new EzVarSequence("Map:");
        this.gain = new EzVarDouble("Gain:", 1.0, 0.01, Double.MAX_VALUE, 1.0);
        this.noise = new EzVarDouble("Readout Noise:", 10.0, 0.0, Double.MAX_VALUE, 0.1);
        this.deadPixel = new EzVarSequence("Bad data map:");
        this.deadPixel.addVarChangeListener((EzVarListener)new EzVarListener<Sequence>(){

            public void variableChanged(EzVar<Sequence> ezVar, Sequence sequence) {
                if (sequence != null) {
                    EpiDEMIC.this.badArray = Icy2TiPi.sequenceToArray(sequence);
                } else {
                    EpiDEMIC.this.badArray = null;
                }
            }
        });
        this.weights.setNoSequenceSelection();
        this.weightsMethod.addVarChangeListener((EzVarListener)new EzVarListener<String>(){

            public void variableChanged(EzVar<String> ezVar, String string) {
                if (EpiDEMIC.this.weightsMethod.getValue() == EpiDEMIC.this.weightOptions[0]) {
                    EpiDEMIC.this.weights.setVisible(false);
                    EpiDEMIC.this.gain.setVisible(false);
                    EpiDEMIC.this.noise.setVisible(false);
                } else if (EpiDEMIC.this.weightsMethod.getValue() == EpiDEMIC.this.weightOptions[1] || EpiDEMIC.this.weightsMethod.getValue() == EpiDEMIC.this.weightOptions[2]) {
                    EpiDEMIC.this.weights.setVisible(true);
                    EpiDEMIC.this.gain.setVisible(false);
                    EpiDEMIC.this.noise.setVisible(false);
                    EpiDEMIC.this.weights.setNoSequenceSelection();
                } else if (EpiDEMIC.this.weightsMethod.getValue() == EpiDEMIC.this.weightOptions[3]) {
                    EpiDEMIC.this.weights.setVisible(false);
                    EpiDEMIC.this.gain.setVisible(true);
                    EpiDEMIC.this.noise.setVisible(true);
                    EpiDEMIC.this.weights.setNoSequenceSelection();
                } else {
                    EpiDEMIC.this.throwError("Invalid argument passed to weight method");
                    return;
                }
            }
        });
        this.weights.setVisible(false);
        this.gain.setVisible(false);
        this.noise.setVisible(false);
        this.deadPixel.setVisible(true);
        this.showWeight = new EzButton("Show weight map", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EpiDEMIC.this.showWeightClicked();
                if (EpiDEMIC.this.debug) {
                    System.out.println("Weight compute");
                }
            }
        });
        this.ezPadGroup = new EzGroup("Padding", new EzComponent[]{this.paddingSizeXY, this.paddingSizeZ});
        this.ezPadGroup.setFoldedState(true);
        this.ezWeightingGroup = new EzGroup("Weighting", new EzComponent[]{this.weightsMethod, this.weights, this.gain, this.noise, this.deadPixel, this.showWeight});
        this.ezWeightingGroup.setFoldedState(true);
        this.loadFile = new EzVarFile("Load parameters from", "", "*.xml");
        this.loadParam = new EzButton("Load parameters", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (EpiDEMIC.this.loadFile.getValue() != null) {
                    EpiDEMIC.this.loadParamClicked();
                }
                if (EpiDEMIC.this.debug) {
                    System.out.println("Load parameters");
                }
            }
        });
        this.deconvPanel = new EzPanel("Step 2: Deconvolution", new EzComponent[0]);
        this.mu = new EzVarDouble("Regularization level:", 1.0E-5, 0.0, Double.MAX_VALUE, 0.01);
        this.logmu = new EzVarDouble("Log10 of the Regularization level:", -5.0, -1.7976931348623157E308, Double.MAX_VALUE, 1.0);
        this.epsilon = new EzVarDouble("Threshold level:", 0.01, 0.0, Double.MAX_VALUE, 1.0);
        this.scale = new EzVarDoubleArrayNative("Aspect ratio of a voxel", (double[][])new double[][]{{1.0, 1.0, 1.0}}, true);
        this.nbIterDeconv = new EzVarInteger("Number of iterations: ", 10, 0, Integer.MAX_VALUE, 1);
        this.positivity = new EzVarBoolean("Enforce nonnegativity:", true);
        this.singlePrecision = new EzVarBoolean("Compute in single precision:", false);
        this.singlePrecision.addVarChangeListener((EzVarListener)new EzVarListener<Boolean>(){

            public void variableChanged(EzVar<Boolean> ezVar, Boolean bl) {
                EpiDEMIC.this.pupil = null;
                EpiDEMIC.this.psfEstimation = null;
                EpiDEMIC.this.cursequence = null;
            }
        });
        this.docDec = new EzLabel("Launch a deconvolution using the current PSF", Color.red);
        this.startDec = new EzButton("Start Deconvolution", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EpiDEMIC.this.launchClicked(false);
            }
        });
        EzVarListener<Double> ezVarListener3 = new EzVarListener<Double>(){

            public void variableChanged(EzVar<Double> ezVar, Double d) {
                EpiDEMIC.this.mu.setValue((Object)Math.pow(10.0, (Double)EpiDEMIC.this.logmu.getValue()));
            }
        };
        this.logmu.addVarChangeListener((EzVarListener)ezVarListener3);
        this.showFullObject = new EzButton("Show the full (padded) object", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (EpiDEMIC.this.debug) {
                    System.out.println("showFull");
                }
                Sequence sequence = new Sequence("Deconvolved image");
                sequence.copyMetaDataFrom((Sequence)EpiDEMIC.this.data.getValue(), false);
                if (EpiDEMIC.this.objArray != null) {
                    IcyImager.show(EpiDEMIC.this.objArray, sequence, "Deconvolved " + ((Sequence)EpiDEMIC.this.data.getValue()).getName() + " with padding. mu " + EpiDEMIC.this.mu.getValue(), EpiDEMIC.this.isHeadLess());
                } else {
                    IcyImager.show(ArrayUtils.extract((ShapedArray)EpiDEMIC.this.dataArray, (Shape)EpiDEMIC.this.outputShape), sequence, "Deconvolved " + ((Sequence)EpiDEMIC.this.data.getValue()).getName() + "with padding. mu=" + EpiDEMIC.this.mu.getValue(), EpiDEMIC.this.isHeadLess());
                }
            }
        });
        this.ezDeconvolutionGroup = new EzGroup("Expert  parameters", new EzComponent[]{this.epsilon, this.scale, this.positivity, this.singlePrecision, this.showFullObject});
        this.ezDeconvolutionGroup.setFoldedState(true);
        this.pupilShift = new EzVarDoubleArrayNative("pupilShift", (double[][])new double[][]{{0.0, 0.0}}, false);
        this.pupilShift.setVisible(false);
        this.phaseCoefs = new EzVarDoubleArrayNative("phase coefs", (double[][])null, false);
        this.phaseCoefs.setVisible(false);
        this.modulusCoefs = new EzVarDoubleArrayNative("modulusCoefs", (double[][])new double[][]{{1.0}}, 0, false);
        this.modulusCoefs.setVisible(false);
        this.bdecPanel = new EzPanel("Step 3: Blind dec.", new EzComponent[0]);
        this.nbAlphaCoef = new EzVarText("Number of phase coefs N\u03b1:", this.nAlphaOptions, 3, Boolean.valueOf(false));
        this.nbBetaCoef = new EzVarText("Number of modulus coefs N\u03b2:", this.nBetaOptions, 0, Boolean.valueOf(false));
        this.radial = new EzVarBoolean("Radially symmetric PSF", false);
        this.maxIterDefocus = new EzVarInteger("Max. nb. of iterations for defocus:", 20, 0, Integer.MAX_VALUE, 1);
        this.maxIterPhase = new EzVarInteger("Max. nb. of iterations for phase:", 20, 0, Integer.MAX_VALUE, 1);
        this.maxIterModulus = new EzVarInteger("Max. nb. of iterations for modulus:", 0, 0, Integer.MAX_VALUE, 1);
        this.totalNbOfBlindDecLoop = new EzVarInteger("Number of loops:", 2, 0, Integer.MAX_VALUE, 1);
        this.showIteration = new EzVarBoolean("Show intermediate results:", true);
        if (this.isHeadLess()) {
            this.showIteration.setValue((Object)false);
        }
        this.resetPSF = new EzButton("Reset PSF", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EpiDEMIC.this.pupil = null;
                EpiDEMIC.this.phaseCoefs.setValue((Object)new double[Integer.parseInt((String)EpiDEMIC.this.nbAlphaCoef.getValue())]);
                double[] dArray = new double[Integer.parseInt((String)EpiDEMIC.this.nbBetaCoef.getValue())];
                dArray[0] = 1.0;
                EpiDEMIC.this.modulusCoefs.setValue((Object)dArray);
            }
        });
        this.nbAlphaCoef.addVarChangeListener((EzVarListener)new EzVarListener<String>(){

            public void variableChanged(EzVar<String> ezVar, String string) {
                EpiDEMIC.this.pupil = null;
            }
        });
        this.nbBetaCoef.addVarChangeListener((EzVarListener)new EzVarListener<String>(){

            public void variableChanged(EzVar<String> ezVar, String string) {
                EpiDEMIC.this.pupil = null;
            }
        });
        this.radial.addVarChangeListener((EzVarListener)new EzVarListener<Boolean>(){

            public void variableChanged(EzVar<Boolean> ezVar, Boolean bl) {
                if (bl.booleanValue()) {
                    EpiDEMIC.this.nbAlphaCoef.setDefaultValues((Object[])EpiDEMIC.this.nAlphaOptionsR, 3, false);
                    EpiDEMIC.this.nbBetaCoef.setDefaultValues((Object[])EpiDEMIC.this.nBetaOptionsR, 1, false);
                    EpiDEMIC.this.pupil = null;
                } else {
                    EpiDEMIC.this.nbAlphaCoef.setDefaultValues((Object[])EpiDEMIC.this.nAlphaOptions, 7, false);
                    EpiDEMIC.this.nbBetaCoef.setDefaultValues((Object[])EpiDEMIC.this.nBetaOptions, 0, false);
                    EpiDEMIC.this.pupil = null;
                }
            }
        });
        this.showPSF2 = new EzButton("Show PSF", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EpiDEMIC.this.psfClicked();
                if (EpiDEMIC.this.debug) {
                    System.out.println("First PSF compute");
                }
            }
        });
        this.showPhase = new EzButton("Phase of the pupil function", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EpiDEMIC.this.phaseClicked();
                if (EpiDEMIC.this.debug) {
                    System.out.println("Show phase");
                }
            }
        });
        this.showModulus = new EzButton("Modulus of the pupil function", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EpiDEMIC.this.modulusClicked();
                if (EpiDEMIC.this.debug) {
                    System.out.println("Show modulus");
                }
            }
        });
        this.docBlind = new EzLabel("Joint estimation of the image and PSF", Color.RED);
        this.startBlind = new EzButton("Blind deconvolution", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EpiDEMIC.this.launchClicked(true);
            }
        });
        this.showFullObject2 = new EzButton("Show the full (padded) object", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (EpiDEMIC.this.debug) {
                    System.out.println("showFull");
                }
                Sequence sequence = new Sequence("Deconvolved image");
                sequence.copyMetaDataFrom((Sequence)EpiDEMIC.this.data.getValue(), false);
                if (EpiDEMIC.this.objArray != null) {
                    IcyImager.show(EpiDEMIC.this.objArray, sequence, "Deconvolved " + ((Sequence)EpiDEMIC.this.data.getValue()).getName() + " with padding. mu " + EpiDEMIC.this.mu.getValue(), EpiDEMIC.this.isHeadLess());
                } else {
                    IcyImager.show(ArrayUtils.extract((ShapedArray)EpiDEMIC.this.dataArray, (Shape)EpiDEMIC.this.outputShape), sequence, "Deconvolved " + ((Sequence)EpiDEMIC.this.data.getValue()).getName() + "with padding. mu=" + EpiDEMIC.this.mu.getValue(), EpiDEMIC.this.isHeadLess());
                }
            }
        });
        this.visuPSF = new EzGroup("Visualization", new EzComponent[]{this.showFullObject2, this.showIteration, this.showPSF2, this.showPhase, this.showModulus});
        this.saveFile = new EzVarFile("Save parameters in", "");
        this.saveParam = new EzButton("Save parameters", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EpiDEMIC.this.saveParamClicked();
                if (EpiDEMIC.this.debug) {
                    System.out.println("Save parameters");
                }
            }
        });
        this.ezBlindDeconvolutionGroup = new EzGroup("Expert  parameters", new EzComponent[]{this.nbAlphaCoef, this.nbBetaCoef, this.radial, this.maxIterDefocus, this.maxIterPhase, this.maxIterModulus});
        this.ezBlindDeconvolutionGroup.setFoldedState(true);
        this.debuggingPanel = new EzPanel("Results", new EzComponent[0]);
        this.resultCostPrior = new EzVarText("Costs");
        this.resultDefocus = new EzVarText("Defocus");
        this.resultModulus = new EzVarText("Modulus");
        this.resultPhase = new EzVarText("Phase");
        this.data.setToolTipText("Sequence to  deconvolve");
        this.weights.setToolTipText("Map of space varying noise variance or precision");
        this.weightsMethod.setToolTipText("Map of space varying noise variance or precision");
        this.deadPixel.setToolTipText("The binary map with 0 for bad pixels");
        this.channel.setToolTipText("Choose the image channel to use for the deconvolution");
        this.dxy_nm.setToolTipText("Lateral pixel size (nm)");
        this.dz_nm.setToolTipText("Axial pixel size (nm)");
        this.na.setToolTipText("Numerical Aperture");
        this.lambda.setToolTipText("Wavelength (nm)");
        this.ni.setToolTipText("Refractive index of the immersion medium");
        this.gain.setToolTipText("The detector gain in electrons per analog digital unit (ADU)");
        this.noise.setToolTipText("The standard deviation of the readout noise in e-/pixel");
        this.mu.setToolTipText("Hyper-parameter");
        this.epsilon.setToolTipText("Threshold of hyperbolic TV");
        this.nbIterDeconv.setToolTipText("Maximum number of iterations");
        this.paddingSizeXY.setToolTipText("Pad with X lines");
        this.paddingSizeZ.setToolTipText("Pad with X lines");
        this.nbAlphaCoef.setToolTipText("Number of zernike describing the pupil phase");
        this.nbBetaCoef.setToolTipText("Number of zernike describing the pupil modulus");
        this.totalNbOfBlindDecLoop.setToolTipText("The maximum number of loops of the algorithm, the higher the potentially longer");
        this.restart.setToolTipText("Restart from previous result, if enabled will start with last image and PSF");
        this.positivity.setToolTipText("Enforce the positivity of the solution");
        this.showFullObject.setToolTipText("Crop the output with the same field of view as the input.");
        this.showFullObject2.setToolTipText("Crop the output with the same field of view as the input.");
        this.debuggingPanel.setToolTipText("The output size as the nearest power of 2 size");
        this.dataPanel.add(new EzComponent[]{this.data});
        this.dataPanel.add(new EzComponent[]{this.channel});
        this.dataPanel.add(new EzComponent[]{this.dataSize});
        this.dataPanel.add(new EzComponent[]{this.ezPadGroup});
        this.dataPanel.add(new EzComponent[]{this.outputSize});
        this.dataPanel.add(new EzComponent[]{this.dxy_nm});
        this.dataPanel.add(new EzComponent[]{this.dz_nm});
        this.dataPanel.add(new EzComponent[]{this.na});
        this.dataPanel.add(new EzComponent[]{this.ni});
        this.dataPanel.add(new EzComponent[]{this.lambda});
        this.dataPanel.add(new EzComponent[]{this.ezWeightingGroup});
        this.dataPanel.add(new EzComponent[]{this.saveMetaData});
        this.dataPanel.add(new EzComponent[]{this.showPSF});
        this.dataPanel.add(new EzComponent[]{this.loadFile});
        this.dataPanel.add(new EzComponent[]{this.loadParam});
        this.tabbedPane.add(new EzComponent[]{this.dataPanel});
        this.deconvPanel.add(new EzComponent[]{this.logmu});
        this.deconvPanel.add(new EzComponent[]{this.mu});
        this.deconvPanel.add(new EzComponent[]{this.nbIterDeconv});
        this.deconvPanel.add(new EzComponent[]{this.restart});
        this.deconvPanel.add(new EzComponent[]{this.channelRestart});
        this.deconvPanel.add(new EzComponent[]{this.ezDeconvolutionGroup});
        this.deconvPanel.add(new EzComponent[]{this.docDec});
        this.deconvPanel.add(new EzComponent[]{this.startDec});
        this.tabbedPane.add(new EzComponent[]{this.deconvPanel});
        this.bdecPanel.add(new EzComponent[]{this.resetPSF});
        this.bdecPanel.add(new EzComponent[]{this.totalNbOfBlindDecLoop});
        this.bdecPanel.add(new EzComponent[]{this.ezBlindDeconvolutionGroup});
        this.bdecPanel.add(new EzComponent[]{this.docBlind});
        this.bdecPanel.add(new EzComponent[]{this.startBlind});
        this.bdecPanel.add(new EzComponent[]{this.visuPSF});
        this.bdecPanel.add(new EzComponent[]{this.saveFile});
        this.bdecPanel.add(new EzComponent[]{this.saveParam});
        this.tabbedPane.add(new EzComponent[]{this.bdecPanel});
        if (this.debug) {
            this.debuggingPanel.add(new EzComponent[]{this.resultCostPrior});
            this.debuggingPanel.add(new EzComponent[]{this.resultDefocus});
            this.debuggingPanel.add(new EzComponent[]{this.resultModulus});
            this.debuggingPanel.add(new EzComponent[]{this.resultPhase});
            this.tabbedPane.add(new EzComponent[]{this.debuggingPanel});
        }
        this.addEzComponent((EzComponent)this.pupilShift);
        this.addEzComponent((EzComponent)this.phaseCoefs);
        this.addEzComponent((EzComponent)this.modulusCoefs);
        this.addEzComponent((EzComponent)this.tabbedPane);
        this.visuPSF.setFoldedState(true);
        this.setDefaultValue();
        this.updatePaddedSize();
        this.updateOutputSize();
        this.updateImageSize();
        if (this.isHeadLess()) {
            this.outputHeadlessImage = new EzVarSequence("Output Image");
            this.outputHeadlessPSF = new EzVarSequence("Output PSF");
            this.outputHeadlessWght = new EzVarSequence("Computed weight");
        }
    }

    private void launchClicked(final boolean bl) {
        if (this.deconvolver != null && this.deconvolver.isRunning()) {
            this.stopExecution();
        } else if (this.bdec != null && this.bdec.isRunning()) {
            this.stopExecution();
        } else {
            Thread thread = new Thread(){

                @Override
                public void run() {
                    EpiDEMIC.this.launch(bl);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (EpiDEMIC.this.debug) {
                                System.out.println("invoke later");
                            }
                            EpiDEMIC.this.restart.setValue(EpiDEMIC.this.cursequence);
                            EpiDEMIC.this.channelRestart.setValue((Object)0);
                        }
                    });
                }
            };
            thread.start();
        }
    }

    private void loadParamClicked() {
        File file = (File)this.loadFile.getValue();
        if (!this.isHeadLess()) {
            new AnnounceFrame("Loading deconvolution parameters from " + file.getAbsolutePath().toString(), 3);
        }
        this.loadParameters((File)this.loadFile.getValue());
        this.loadFile.setValue((Object)file);
        this.buildpupil();
        this.pupil.setPupilAxis((double[])this.pupilShift.getValue());
        this.pupil.setNi((Double)this.ni.getValue());
        this.pupil.setModulus((double[])this.modulusCoefs.getValue());
        this.pupil.setPhase((double[])this.phaseCoefs.getValue());
        if (this.dataSeq != null) {
            this.sizeX = this.dataSeq.getSizeX();
            this.sizeY = this.dataSeq.getSizeY();
            this.sizeZ = this.dataSeq.getSizeZ();
            if (this.sizeZ == 1) {
                this.throwError("Input data must be 3D");
                return;
            }
            this.updatePaddedSize();
            this.updateOutputSize();
            this.updateImageSize();
            this.dataShape = new Shape(this.sizeX, this.sizeY, this.sizeZ);
        }
    }

    private void saveParamClicked() {
        File file;
        if (this.pupil != null) {
            this.pupilShift.setValue((Object)this.pupil.getPupilShift());
            if (this.pupil.getPhaseCoefs() != null) {
                this.phaseCoefs.setValue((Object)this.pupil.getPhaseCoefs().getData());
            }
            this.modulusCoefs.setValue((Object)this.pupil.getModulusCoefs().getData());
        }
        if (this.debug) {
            System.out.println("--------------");
            System.out.println("defocus");
            System.out.println(this.pupil.getDefocus().toString());
        }
        if ((file = (File)this.saveFile.getValue()) != null) {
            if (!file.getName().endsWith(".xml")) {
                file = new File(file.getAbsolutePath() + ".xml");
            }
            if (!this.isHeadLess()) {
                new AnnounceFrame("Saving deconvolution parameters in " + file.getAbsolutePath().toString(), 3);
            }
            this.saveParameters(file);
        }
    }

    protected void execute() {
        if (this.isHeadLess()) {
            if (Icy.getCommandLinePluginArgs().length != 0) {
                this.initialize();
                this.parseCmdLine();
            }
            this.showIteration.setValue((Object)false);
        }
        long l = System.currentTimeMillis();
        this.launch(true);
        long l2 = System.currentTimeMillis();
        long l3 = l2 - l;
        System.out.println("time: " + l3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void launch(boolean bl) {
        try {
            this.startBlind.setText("Emergency stop");
            this.startDec.setText("Emergency stop");
            this.buildpupil();
            if (this.debug || this.isHeadLess()) {
                System.out.println("-------------IMAGE-------------------");
                System.out.println("File: " + this.data.getValue());
                System.out.println("Canal: " + this.channel.getValue());
                System.out.println("image size: " + (String)this.dataSize.getValue());
                System.out.println("--------------PSF------------------");
                System.out.println("dxy: " + (Double)this.dxy_nm.getValue() * 1.0E-9);
                System.out.println("dz: " + (Double)this.dz_nm.getValue() * 1.0E-9);
                System.out.println("Nxy: " + this.Nxy);
                System.out.println("Nx: " + this.Nz);
                System.out.println("NA: " + this.na.getValue());
                System.out.println("\u03bb: " + (Double)this.lambda.getValue() * 1.0E-9);
                System.out.println("ni: " + this.ni.getValue());
                System.out.println("--------------Variance------------------");
                System.out.println("Weights method: " + (String)this.weightsMethod.getValue());
                System.out.println("Weights: " + this.weights.getValue());
                System.out.println("Gain: " + this.gain.getValue());
                System.out.println("Noise: " + this.noise.getValue());
                System.out.println("deadPix: " + this.deadPixel.getValue());
                System.out.println("--------------DECONV------------------");
                System.out.println("zeroPad xy: " + this.paddingSizeXY.getValue());
                System.out.println("zeroPad z: " + this.paddingSizeZ.getValue());
                System.out.println("nbIter: " + this.nbIterDeconv.getValue());
                System.out.println("Restart: " + this.restart.getValue());
                System.out.println("Positivity: " + this.positivity.getValue());
                System.out.println("--------------BDEC------------------");
                System.out.println("output size: " + (String)this.outputSize.getValue());
                System.out.println("nbIter: " + this.nbIterDeconv.getValue());
                System.out.println("Number of total iterations: " + this.totalNbOfBlindDecLoop.getValue());
                System.out.println("------------------------------------");
                System.out.println("");
            }
            if (bl) {
                int n = Integer.parseInt((String)this.nbAlphaCoef.getValue());
                int n2 = Integer.parseInt((String)this.nbBetaCoef.getValue());
                if (n == 0) {
                    this.maxIterPhase.setValue((Object)0);
                } else {
                    this.pupil.setNPhase(n);
                }
                if (n2 == 0) {
                    this.maxIterModulus.setValue((Object)0);
                } else {
                    this.pupil.setNModulus(n2);
                }
                this.preProcessing();
                this.psfEstimation = new PSF_Estimation(this.pupil);
                this.psfEstimation.setWeight(ArrayUtils.pad((ShapedArray)this.wgtArray, (Shape)this.outputShape));
                this.psfEstimation.setData(ArrayUtils.pad((ShapedArray)this.dataArray, (Shape)this.outputShape));
                this.psfEstimation.enablePositivity(false);
                this.psfEstimation.setAbsoluteTolerance(0.0);
                int[] nArray = new int[]{(Integer)this.maxIterDefocus.getValue(), (Integer)this.maxIterPhase.getValue(), (Integer)this.maxIterModulus.getValue()};
                this.bdec = new BlindDeconvJob((Integer)this.totalNbOfBlindDecLoop.getValue(), this.pupil.getParametersFlags(), nArray, this.psfEstimation, this.deconvolver, this.debug);
                this.objArray = this.bdec.blindDeconv(this.objArray);
                if ((Integer)this.maxIterDefocus.getValue() > 0) {
                    this.ni.setValue((Object)((WideFieldModel)this.psfEstimation.getModel()).getNi());
                    this.pupilShift.setValue((Object)((WideFieldModel)this.psfEstimation.getModel()).getPupilShift());
                }
                if ((Integer)this.maxIterPhase.getValue() > 0) {
                    this.phaseCoefs.setValue((Object)((WideFieldModel)this.psfEstimation.getModel()).getPhaseCoefs().getData());
                }
                if ((Integer)this.maxIterModulus.getValue() > 0) {
                    this.modulusCoefs.setValue((Object)((WideFieldModel)this.psfEstimation.getModel()).getModulusCoefs().getData());
                }
                this.pupil = (WideFieldModel)this.psfEstimation.getModel();
                this.bdec = null;
            } else {
                this.psfArray = ArrayUtils.roll((ShapedArray)this.pupil.getPsf());
                this.pupil.freeMem();
                this.preProcessing();
                this.deconv();
            }
            if (this.pupil != null) {
                this.pupil.freeMem();
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    EpiDEMIC.this.enableVars(true);
                    EpiDEMIC.this.restart.setValue(EpiDEMIC.this.cursequence);
                    EpiDEMIC.this.channelRestart.setValue((Object)0);
                    EpiDEMIC.this.ni.setValue((Object)EpiDEMIC.this.pupil.getNi());
                    if (EpiDEMIC.this.isHeadLess()) {
                        if (EpiDEMIC.this.outputHeadlessImage == null) {
                            EpiDEMIC.this.outputHeadlessImage = new EzVarSequence("Output Image");
                        }
                        if (EpiDEMIC.this.outputHeadlessPSF == null) {
                            EpiDEMIC.this.outputHeadlessPSF = new EzVarSequence("Output PSF");
                        }
                        if (EpiDEMIC.this.outputHeadlessWght == null) {
                            EpiDEMIC.this.outputHeadlessWght = new EzVarSequence("Computed weights");
                        }
                        Sequence sequence = null;
                        sequence = Icy2TiPi.arrayToSequence(ArrayUtils.roll((ShapedArray)EpiDEMIC.this.pupil.getPsf()), sequence);
                        EpiDEMIC.this.outputHeadlessPSF.setValue(sequence);
                        EpiDEMIC.this.outputHeadlessImage.setValue(EpiDEMIC.this.cursequence);
                        EpiDEMIC.this.outputHeadlessWght.setValue(Icy2TiPi.arrayToSequence(EpiDEMIC.this.wgtArray));
                        if (EpiDEMIC.this.outputPath != null) {
                            IcyImager.save(EpiDEMIC.this.cursequence, EpiDEMIC.this.outputPath);
                        }
                        if (EpiDEMIC.this.psfPath != null) {
                            IcyImager.save(sequence, EpiDEMIC.this.psfPath);
                        }
                        if (EpiDEMIC.this.saveFile.getValue() != null) {
                            EpiDEMIC.this.saveParamClicked();
                        }
                    }
                }
            });
        }
        catch (IllegalArgumentException illegalArgumentException) {
            new AnnounceFrame("Oops, Error: " + illegalArgumentException.getMessage());
            this.enableVars(true);
            if (this.debug) {
                illegalArgumentException.printStackTrace();
            }
        }
        finally {
            this.startBlind.setText("Guess PSF");
            this.startDec.setText("Start Deconvolution");
        }
    }

    private void enableVars(boolean bl) {
        if (!this.isHeadLess()) {
            this.nbAlphaCoef.setEnabled(bl);
            this.nbBetaCoef.setEnabled(bl);
            this.radial.setEnabled(bl);
            this.na.setEnabled(bl);
            this.lambda.setEnabled(bl);
            this.dxy_nm.setEnabled(bl);
            this.dz_nm.setEnabled(bl);
            this.ni.setEnabled(bl);
            this.data.setEnabled(bl);
            this.channel.setEnabled(bl);
            this.paddingSizeXY.setEnabled(bl);
            this.paddingSizeZ.setEnabled(bl);
            this.singlePrecision.setEnabled(bl);
            this.loadParam.setEnabled(bl);
        }
    }

    private void buildpupil() {
        if (this.pupil == null) {
            this.pupil = new WideFieldModel(this.psfShape, Integer.parseInt((String)this.nbAlphaCoef.getValue()), Integer.parseInt((String)this.nbBetaCoef.getValue()), (Double)this.na.getValue(), (Double)this.lambda.getValue() * 1.0E-9, (Double)this.ni.getValue(), (Double)this.dxy_nm.getValue() * 1.0E-9, (Double)this.dz_nm.getValue() * 1.0E-9, (Boolean)this.radial.getValue(), (Boolean)this.singlePrecision.getValue());
            this.pupil.setPupilAxis((double[])this.pupilShift.getValue());
            this.pupil.setModulus((double[])this.modulusCoefs.getValue());
            if (this.phaseCoefs.getValue() != null) {
                this.pupil.setPhase((double[])this.phaseCoefs.getValue());
            }
        }
    }

    private void psfClicked() {
        Thread thread = new Thread(){

            @Override
            public void run() {
                if (EpiDEMIC.this.pupil == null) {
                    EpiDEMIC.this.buildpupil();
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Sequence sequence = new Sequence();
                        if (EpiDEMIC.this.dataSeq != null) {
                            sequence.copyMetaDataFrom(EpiDEMIC.this.dataSeq, false);
                        }
                        if (EpiDEMIC.this.bdec != null && EpiDEMIC.this.bdec.isRunning()) {
                            IcyImager.show(EpiDEMIC.this.bdec.getPsf(), sequence, "Estimated PSF", EpiDEMIC.this.isHeadLess());
                        } else {
                            IcyImager.show(ArrayUtils.roll((ShapedArray)EpiDEMIC.this.pupil.getPsf()), sequence, "Estimated PSF", EpiDEMIC.this.isHeadLess());
                        }
                        sequence.getFirstViewer().getLut().getLutChannel(0).setColorMap((IcyColorMap)new IceColorMap(), false);
                    }
                });
            }
        };
        thread.start();
    }

    private void phaseClicked() {
        if (this.pupil == null) {
            this.buildpupil();
        }
        Double2D double2D = this.bdec != null && this.bdec.isRunning() ? Double2D.wrap((double[])((WideFieldModel)this.bdec.getPupil()).getPhi(), (Shape)new Shape(this.Nxy, this.Nxy)) : Double2D.wrap((double[])this.pupil.getPhi(), (Shape)new Shape(this.Nxy, this.Nxy));
        IcyImager.show(ArrayUtils.roll((ShapedArray)double2D), null, "Phase of the pupil", false);
    }

    private void modulusClicked() {
        if (this.pupil == null) {
            this.buildpupil();
        }
        Double2D double2D = this.bdec != null && this.bdec.isRunning() ? Double2D.wrap((double[])((WideFieldModel)this.bdec.getPupil()).getRho(), (Shape)new Shape(this.Nxy, this.Nxy)) : Double2D.wrap((double[])this.pupil.getRho(), (Shape)new Shape(this.Nxy, this.Nxy));
        IcyImager.show(ArrayUtils.roll((ShapedArray)double2D), null, "Modulus of the pupil", false);
    }

    private void showWeightClicked() {
        this.dataSeq = (Sequence)this.data.getValue();
        this.dataArray = Icy2TiPi.sequenceToArray(this.dataSeq, (Integer)this.channel.getValue()).toDouble();
        this.wgtArray = this.createWeights(this.dataArray, this.badArray).toDouble();
        IcyImager.show(this.wgtArray, null, "Weight map", false);
    }

    public void stopExecution() {
        if (this.deconvolver != null) {
            this.deconvolver.abort();
        }
        if (this.bdec != null) {
            this.bdec.abort();
        }
    }

    private void preProcessing() {
        this.dataSeq = (Sequence)this.data.getValue();
        if (this.dataSeq == null) {
            this.throwError("No image/sequence");
            return;
        }
        this.dataArray = Icy2TiPi.sequenceToArray(this.dataSeq, (Integer)this.channel.getValue());
        this.dataShape = this.dataArray.getShape();
        if (this.deadPixel.getValue() == null) {
            this.badArray = null;
            if (this.dataSeq.getChannelMax(((Integer)this.channel.getValue()).intValue()) == this.dataSeq.getChannelTypeMax(((Integer)this.channel.getValue()).intValue())) {
                this.badArray = this.dataArray.copy().toDouble();
                class SaturationFunc
                implements DoubleFunction {
                    double sat;

                    public SaturationFunc(double d) {
                        this.sat = d;
                    }

                    public double apply(double d) {
                        if (d >= this.sat) {
                            return 1.0;
                        }
                        return 0.0;
                    }
                }
                ((DoubleArray)this.badArray).map((DoubleFunction)new SaturationFunc(this.dataSeq.getChannelTypeMax(((Integer)this.channel.getValue()).intValue())));
                this.badArray = this.badArray.toByte();
                if (!this.isHeadLess()) {
                    new AnnounceFrame("Warning, saturated pixel detected, accounting them as dead pixels", "show", new Runnable(){

                        @Override
                        public void run() {
                            Sequence sequence = new Sequence("Saturations map");
                            sequence.copyMetaDataFrom(EpiDEMIC.this.dataSeq, false);
                            IcyImager.show(EpiDEMIC.this.badArray, sequence, "saturations map", EpiDEMIC.this.isHeadLess());
                        }
                    }, 10);
                }
            }
        }
        this.dataArray = Icy2TiPi.sequenceToArray(this.dataSeq, (Integer)this.channel.getValue());
        this.dataShape = this.dataArray.getShape();
        if (this.cursequence == null) {
            this.cursequence = new Sequence("Current Iterate");
            this.cursequence.copyMetaDataFrom(this.dataSeq, false);
        }
        Sequence sequence = (Sequence)this.restart.getValue();
        if (this.restart.getValue() != null && sequence != null) {
            this.objArray = Icy2TiPi.sequenceToArray(sequence, (Integer)this.channelRestart.getValue());
            if (this.debug) {
                System.out.println("restart seq:" + sequence.getName());
            }
        } else if (this.debug) {
            System.out.println("restart seq is null:");
        }
        if (((double[])this.scale.getValue()).length != 3) {
            this.throwError("Pixel scale must have 3 elements");
            return;
        }
        this.wgtArray = (Boolean)this.singlePrecision.getValue() != false ? this.createWeights((ShapedArray)this.dataArray.toFloat(), this.badArray).toFloat() : this.createWeights((ShapedArray)this.dataArray.toDouble(), this.badArray).toDouble();
        if (((double[])this.scale.getValue()).length != 3) {
            this.throwError("Pixel scale must have 3 elements");
            return;
        }
        if (this.cursequence == null) {
            this.cursequence = new Sequence("Current Iterate");
            this.cursequence.copyMetaDataFrom((Sequence)this.data.getValue(), false);
        }
        IcyImager icyImager = new IcyImager(this.cursequence, this.isHeadLess());
        DeconvHook deconvHook = new DeconvHook(icyImager, this.dataShape, null, this.debug);
        DeconvHook deconvHook2 = new DeconvHook(icyImager, this.dataShape, "Deconvolved " + this.dataSeq.getName(), this.debug);
        this.deconvolver = new DeconvolutionJob(this.dataArray, this.psfArray, this.wgtArray, this.outputShape, ((Double)this.mu.getValue()).doubleValue(), ((Double)this.epsilon.getValue()).doubleValue(), (double[])this.scale.getValue(), ((Boolean)this.positivity.getValue()).booleanValue(), ((Boolean)this.singlePrecision.getValue()).booleanValue(), ((Integer)this.nbIterDeconv.getValue()).intValue(), (TiPiHook)deconvHook, (TiPiHook)deconvHook2);
    }

    private void deconv() {
        if (this.debug) {
            System.out.println("Launch it:" + this.nbIterDeconv.getValue());
        }
        this.objArray = this.deconvolver.deconv(this.objArray);
    }

    @Override
    public void declareInput(VarList varList) {
        this.initialize();
        super.declareInput(varList);
        varList.add("dxy", this.dxy_nm.getVariable());
        varList.add("dz", this.dz_nm.getVariable());
        varList.add("NA", this.na.getVariable());
        varList.add("ni", this.ni.getVariable());
        varList.add("lambda", this.lambda.getVariable());
        varList.add("espilon", this.epsilon.getVariable());
        varList.add("padding xy", this.paddingSizeXY.getVariable());
        varList.add("padding z", this.paddingSizeZ.getVariable());
        varList.add("radial", this.radial.getVariable());
        varList.add("nbAlphaCoef", this.nbAlphaCoef.getVariable());
        varList.add("nbBetaCoef", this.nbBetaCoef.getVariable());
        varList.add("defocusMaxIter", this.maxIterDefocus.getVariable());
        varList.add("phaseMaxIter", this.maxIterPhase.getVariable());
        varList.add("modulusMaxIter", this.maxIterModulus.getVariable());
        varList.add("bDecTotalIteration", this.totalNbOfBlindDecLoop.getVariable());
        varList.add("loadFile", this.loadFile.getVariable());
        this.deadPixel.setNoSequenceSelection();
    }

    @Override
    public void declareOutput(VarList varList) {
        super.declareOutput(varList);
        varList.add("outputPSF", (Var)this.outputHeadlessPSF.getVariable());
        varList.add("pupilShift", this.pupilShift.getVariable());
        varList.add("phaseCoefs", this.phaseCoefs.getVariable());
        varList.add("modulusCoefs", this.modulusCoefs.getVariable());
    }

    private void parseCmdLine() {
        String[] stringArray = Icy.getCommandLinePluginArgs();
        this.loadFile.setValue((Object)new File(stringArray[0]));
        this.loadParamClicked();
        System.out.println("Load Param... " + stringArray[0]);
        block18: for (int i = 1; i < stringArray.length; ++i) {
            switch (stringArray[i]) {
                case "-i": {
                    if (i + 1 >= stringArray.length || stringArray[i + 1].startsWith("-")) continue block18;
                    System.out.println("load image:" + stringArray[i + 1]);
                    this.data.setValue(Loader.loadSequence((String)stringArray[i + 1], (int)0, (boolean)false));
                    this.dataChanged();
                    if (i + 3 >= stringArray.length) continue block18;
                    if (stringArray[i + 2].equalsIgnoreCase("-c")) {
                        this.channel.setValue((Object)Integer.parseInt(stringArray[i + 3]));
                        i += 3;
                        continue block18;
                    }
                    ++i;
                    continue block18;
                }
                case "-r": {
                    if (i + 1 >= stringArray.length || stringArray[i + 1].startsWith("-")) continue block18;
                    System.out.println("load restart:" + stringArray[i + 1]);
                    this.restart.setValue(Loader.loadSequence((String)stringArray[i + 1], (int)0, (boolean)false));
                    if (i + 3 >= stringArray.length) continue block18;
                    if (stringArray[i + 2].equalsIgnoreCase("-c")) {
                        System.out.println("channel restart:" + Integer.parseInt(stringArray[i + 3]));
                        this.channelRestart.setValue((Object)Integer.parseInt(stringArray[i + 3]));
                        i += 3;
                        continue block18;
                    }
                    ++i;
                    continue block18;
                }
                case "-o": {
                    if (i + 1 >= stringArray.length || stringArray[i + 1].startsWith("-")) continue block18;
                    this.outputPath = stringArray[i + 1];
                    ++i;
                    continue block18;
                }
                case "-p": {
                    if (i + 1 >= stringArray.length || stringArray[i + 1].startsWith("-")) continue block18;
                    this.psfPath = stringArray[i + 1];
                    ++i;
                    continue block18;
                }
                case "-s": {
                    if (i + 1 >= stringArray.length || stringArray[i + 1].startsWith("-")) continue block18;
                    this.saveFile.setValue((Object)new File(stringArray[i + 1]));
                    ++i;
                    continue block18;
                }
                case "-badpix": {
                    if (i + 1 >= stringArray.length || stringArray[i + 1].startsWith("-")) continue block18;
                    this.deadPixel.setValue(Loader.loadSequence((String)stringArray[i + 1], (int)0, (boolean)false));
                    ++i;
                    continue block18;
                }
                case "-wghtmap": {
                    if (i + 1 >= stringArray.length || stringArray[i + 1].startsWith("-")) continue block18;
                    this.weights.setValue(Loader.loadSequence((String)stringArray[i + 1], (int)0, (boolean)false));
                    ++i;
                    continue block18;
                }
                default: {
                    System.out.println("Wrong command line");
                    System.out.println("-i input data file");
                    System.out.println("-r restart file");
                    System.out.println("-o deconvolved output file");
                    System.out.println("-p psf output file");
                    System.out.println("-s parameter output file");
                    System.out.println("-badpix bad pixels file");
                    System.out.println("-wghtmap weight or variance map file");
                }
            }
        }
    }

    @Override
    protected void dataChanged() {
        super.dataChanged();
        this.badArray = null;
        this.psfEstimation = null;
        this.cursequence = null;
        this.pupil = null;
        this.deconvolver = null;
    }

    protected MicroscopeMetadata getMetaData(Sequence sequence) {
        OMEXMLMetadataImpl oMEXMLMetadataImpl = sequence.getMetadata();
        if (this.meta == null) {
            this.meta = new MicroscopeMetadata();
            if (oMEXMLMetadataImpl.getInstrumentCount() > 0) {
                try {
                    this.meta.na = oMEXMLMetadataImpl.getObjectiveLensNA(0, 0);
                }
                catch (Exception exception) {
                    System.out.println("Failed to get some metadatas, will use default values for na, lambda");
                }
            }
        }
        this.meta.nxy = sequence.getSizeX();
        this.meta.nz = sequence.getSizeZ();
        this.meta.dxy = sequence.getPixelSizeX() * 1000.0;
        this.meta.dz = sequence.getPixelSizeZ() * 1000.0;
        this.meta.na = (Double)this.na.getValue();
        this.meta.lambda = (Double)this.lambda.getValue();
        this.meta.ni = (Double)this.ni.getValue();
        return this.meta;
    }
}

