/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array;

import mitiv.array.Array1D;
import mitiv.array.Array3D;
import mitiv.array.ShapedArray;
import mitiv.base.Shape;
import mitiv.base.indexing.Range;

public abstract class Array4D
implements ShapedArray {
    protected final Shape shape;
    protected final int number;
    protected final int dim1;
    protected final int dim2;
    protected final int dim3;
    protected final int dim4;

    protected Array4D(int n, int n2, int n3, int n4) {
        this.shape = new Shape(n, n2, n3, n4);
        if (this.shape.number() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Total number of elements is too large");
        }
        this.number = (int)this.shape.number();
        this.dim1 = n;
        this.dim2 = n2;
        this.dim3 = n3;
        this.dim4 = n4;
    }

    protected Array4D(int[] nArray) {
        this(new Shape(nArray));
    }

    protected Array4D(Shape shape) {
        if (shape.rank() != 4) {
            throw new IllegalArgumentException("Bad number of dimensions for 4-D array");
        }
        if (shape.number() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Total number of elements is too large");
        }
        this.number = (int)shape.number();
        this.shape = shape;
        this.dim1 = shape.dimension(0);
        this.dim2 = shape.dimension(1);
        this.dim3 = shape.dimension(2);
        this.dim4 = shape.dimension(3);
    }

    @Override
    public final int getRank() {
        return 4;
    }

    @Override
    public final Shape getShape() {
        return this.shape;
    }

    @Override
    public final int getNumber() {
        return this.number;
    }

    @Override
    public final int getDimension(int n) {
        return this.shape.dimension(n);
    }

    @Override
    public abstract Array4D copy();

    public abstract Array3D slice(int var1);

    public abstract Array3D slice(int var1, int var2);

    public abstract Array4D view(Range var1, Range var2, Range var3, Range var4);

    public abstract Array4D view(int[] var1, int[] var2, int[] var3, int[] var4);

    @Override
    public abstract Array1D as1D();

    public static int checkViewStrides(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        int n11;
        int n12;
        int n13 = (n7 - 1) * n3;
        if (n13 >= 0) {
            n12 = n2;
            n11 = n2 + n13;
        } else {
            n12 = n2 + n13;
            n11 = n2;
        }
        n13 = (n8 - 1) * n4;
        if (n13 >= 0) {
            n11 += n13;
        } else {
            n12 += n13;
        }
        n13 = (n9 - 1) * n5;
        if (n13 >= 0) {
            n11 += n13;
        } else {
            n12 += n13;
        }
        n13 = (n10 - 1) * n6;
        if (n13 >= 0) {
            n11 += n13;
        } else {
            n12 += n13;
        }
        if (n12 < 0 || n11 >= n) {
            throw new IndexOutOfBoundsException("4D view is not within available space");
        }
        int n14 = Math.abs(n3);
        int n15 = Math.abs(n4);
        int n16 = Math.abs(n5);
        int n17 = Math.abs(n6);
        if (n14 <= n15 && n15 <= n16 && n16 <= n17) {
            return 1;
        }
        if (n14 >= n15 && n15 >= n16 && n16 >= n17) {
            return 2;
        }
        return 0;
    }
}

