/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array.impl;

import mitiv.array.Int1D;
import mitiv.array.IntScalar;
import mitiv.array.impl.Helper;
import mitiv.array.impl.SelectedInt1D;
import mitiv.array.impl.StriddenInt1D;
import mitiv.base.Shape;
import mitiv.base.indexing.CompiledRange;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.IntFunction;
import mitiv.base.mapping.IntScanner;
import mitiv.exception.NonConformableArrayException;
import mitiv.random.IntGenerator;

public class FlatInt1D
extends Int1D {
    static final int order = 1;
    final int[] data;

    public FlatInt1D(int n) {
        super(n);
        this.data = new int[this.number];
    }

    public FlatInt1D(int[] nArray) {
        super(nArray);
        this.data = new int[this.number];
    }

    public FlatInt1D(Shape shape) {
        super(shape);
        this.data = new int[this.number];
    }

    public FlatInt1D(int[] nArray, int n) {
        super(n);
        this.checkSize(nArray);
        this.data = nArray;
    }

    public FlatInt1D(int[] nArray, int[] nArray2) {
        super(nArray2);
        this.checkSize(nArray);
        this.data = nArray;
    }

    public FlatInt1D(int[] nArray, Shape shape) {
        super(shape);
        this.checkSize(nArray);
        this.data = nArray;
    }

    @Override
    public void checkSanity() {
        if (this.data == null) {
            throw new NonConformableArrayException("Wrapped array is null");
        }
        if (this.data.length < this.number) {
            throw new NonConformableArrayException("Wrapped array is too small");
        }
    }

    private void checkSize(int[] nArray) {
        if (nArray == null || nArray.length < this.number) {
            throw new NonConformableArrayException("Wrapped array is too small");
        }
    }

    final int index(int n) {
        return n;
    }

    @Override
    public final int get(int n) {
        return this.data[n];
    }

    @Override
    public final void set(int n, int n2) {
        this.data[n] = n2;
    }

    @Override
    public final int getOrder() {
        return 1;
    }

    @Override
    public void fill(int n) {
        for (int i = 0; i < this.number; ++i) {
            this.data[i] = n;
        }
    }

    @Override
    public void fill(IntGenerator intGenerator) {
        for (int i = 0; i < this.number; ++i) {
            this.data[i] = intGenerator.nextInt();
        }
    }

    @Override
    public void increment(int n) {
        int n2 = 0;
        while (n2 < this.number) {
            int n3 = n2++;
            this.data[n3] = this.data[n3] + n;
        }
    }

    @Override
    public void decrement(int n) {
        int n2 = 0;
        while (n2 < this.number) {
            int n3 = n2++;
            this.data[n3] = this.data[n3] - n;
        }
    }

    @Override
    public void scale(int n) {
        int n2 = 0;
        while (n2 < this.number) {
            int n3 = n2++;
            this.data[n3] = this.data[n3] * n;
        }
    }

    @Override
    public void map(IntFunction intFunction) {
        for (int i = 0; i < this.number; ++i) {
            this.data[i] = intFunction.apply(this.data[i]);
        }
    }

    @Override
    public void scan(IntScanner intScanner) {
        intScanner.initialize(this.data[0]);
        for (int i = 1; i < this.number; ++i) {
            intScanner.update(this.data[i]);
        }
    }

    @Override
    public final boolean isFlat() {
        return true;
    }

    @Override
    public int[] flatten(boolean bl) {
        if (bl) {
            int[] nArray = new int[this.number];
            System.arraycopy(this.data, 0, nArray, 0, this.number);
            return nArray;
        }
        return this.data;
    }

    @Override
    public int[] getData() {
        return this.data;
    }

    @Override
    public IntScalar slice(int n) {
        n = Helper.fixIndex(n, this.dim1);
        return new IntScalar(this.data, n);
    }

    @Override
    public IntScalar slice(int n, int n2) {
        Helper.fixSliceIndex(n2, 1);
        return new IntScalar(this.data, Helper.fixIndex(n, this.dim1));
    }

    @Override
    public Int1D view(Range range) {
        CompiledRange compiledRange = new CompiledRange(range, this.dim1, 0, 1);
        if (compiledRange.doesNothing()) {
            return this;
        }
        return new StriddenInt1D(this.data, compiledRange.getOffset(), compiledRange.getStride(), compiledRange.getNumber());
    }

    @Override
    public Int1D view(int[] nArray) {
        int[] nArray2 = Helper.select(0, 1, this.dim1, nArray);
        return new SelectedInt1D(this.data, nArray2);
    }

    @Override
    public Int1D as1D() {
        return this;
    }
}

