/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array.impl;

import mitiv.array.Int1D;
import mitiv.array.Int2D;
import mitiv.array.impl.FlatInt1D;
import mitiv.array.impl.Helper;
import mitiv.array.impl.SelectedInt2D;
import mitiv.array.impl.StriddenInt1D;
import mitiv.base.indexing.CompiledRange;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.IntFunction;
import mitiv.base.mapping.IntScanner;
import mitiv.random.IntGenerator;

public class StriddenInt2D
extends Int2D {
    final int order;
    final int[] data;
    final int offset;
    final int stride1;
    final int stride2;
    final boolean flat;

    public StriddenInt2D(int[] nArray, int n, int[] nArray2, int[] nArray3) {
        super(nArray3);
        if (nArray2.length != 2) {
            throw new IllegalArgumentException("There must be as many strides as the rank");
        }
        this.data = nArray;
        this.offset = n;
        this.stride1 = nArray2[0];
        this.stride2 = nArray2[1];
        this.order = Int2D.checkViewStrides(this.data.length, n, this.stride1, this.stride2, this.dim1, this.dim2);
        this.flat = n == 0 && this.stride1 == 1 && this.stride2 == this.dim1;
    }

    public StriddenInt2D(int[] nArray, int n, int n2, int n3, int n4, int n5) {
        super(n4, n5);
        this.data = nArray;
        this.offset = n;
        this.stride1 = n2;
        this.stride2 = n3;
        this.order = Int2D.checkViewStrides(this.data.length, n, n2, n3, n4, n5);
        this.flat = n == 0 && n2 == 1 && n3 == n4;
    }

    @Override
    public void checkSanity() {
        Int2D.checkViewStrides(this.data.length, this.offset, this.stride1, this.stride2, this.dim1, this.dim2);
    }

    final int index(int n, int n2) {
        return this.offset + this.stride2 * n2 + this.stride1 * n;
    }

    @Override
    public final int get(int n, int n2) {
        return this.data[this.offset + this.stride2 * n2 + this.stride1 * n];
    }

    @Override
    public final void set(int n, int n2, int n3) {
        this.data[this.offset + this.stride2 * n2 + this.stride1 * n] = n3;
    }

    @Override
    public final int getOrder() {
        return this.order;
    }

    @Override
    public void fill(int n) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                int n2 = this.stride1 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n3 = this.stride2 * j + n2;
                    this.data[n3] = n;
                }
            }
        } else {
            for (int i = 0; i < this.dim2; ++i) {
                int n4 = this.stride2 * i + this.offset;
                for (int j = 0; j < this.dim1; ++j) {
                    int n5 = this.stride1 * j + n4;
                    this.data[n5] = n;
                }
            }
        }
    }

    @Override
    public void fill(IntGenerator intGenerator) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                int n = this.stride1 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n2 = this.stride2 * j + n;
                    this.data[n2] = intGenerator.nextInt();
                }
            }
        } else {
            for (int i = 0; i < this.dim2; ++i) {
                int n = this.stride2 * i + this.offset;
                for (int j = 0; j < this.dim1; ++j) {
                    int n3 = this.stride1 * j + n;
                    this.data[n3] = intGenerator.nextInt();
                }
            }
        }
    }

    @Override
    public void increment(int n) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                int n2 = this.stride1 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n3;
                    int n4 = n3 = this.stride2 * j + n2;
                    this.data[n4] = this.data[n4] + n;
                }
            }
        } else {
            for (int i = 0; i < this.dim2; ++i) {
                int n5 = this.stride2 * i + this.offset;
                for (int j = 0; j < this.dim1; ++j) {
                    int n6;
                    int n7 = n6 = this.stride1 * j + n5;
                    this.data[n7] = this.data[n7] + n;
                }
            }
        }
    }

    @Override
    public void decrement(int n) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                int n2 = this.stride1 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n3;
                    int n4 = n3 = this.stride2 * j + n2;
                    this.data[n4] = this.data[n4] - n;
                }
            }
        } else {
            for (int i = 0; i < this.dim2; ++i) {
                int n5 = this.stride2 * i + this.offset;
                for (int j = 0; j < this.dim1; ++j) {
                    int n6;
                    int n7 = n6 = this.stride1 * j + n5;
                    this.data[n7] = this.data[n7] - n;
                }
            }
        }
    }

    @Override
    public void scale(int n) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                int n2 = this.stride1 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n3;
                    int n4 = n3 = this.stride2 * j + n2;
                    this.data[n4] = this.data[n4] * n;
                }
            }
        } else {
            for (int i = 0; i < this.dim2; ++i) {
                int n5 = this.stride2 * i + this.offset;
                for (int j = 0; j < this.dim1; ++j) {
                    int n6;
                    int n7 = n6 = this.stride1 * j + n5;
                    this.data[n7] = this.data[n7] * n;
                }
            }
        }
    }

    @Override
    public void map(IntFunction intFunction) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                int n = this.stride1 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n2 = this.stride2 * j + n;
                    this.data[n2] = intFunction.apply(this.data[n2]);
                }
            }
        } else {
            for (int i = 0; i < this.dim2; ++i) {
                int n = this.stride2 * i + this.offset;
                for (int j = 0; j < this.dim1; ++j) {
                    int n3 = this.stride1 * j + n;
                    this.data[n3] = intFunction.apply(this.data[n3]);
                }
            }
        }
    }

    @Override
    public void scan(IntScanner intScanner) {
        boolean bl = false;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                int n = this.stride1 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n2 = this.stride2 * j + n;
                    if (bl) {
                        intScanner.update(this.data[n2]);
                        continue;
                    }
                    intScanner.initialize(this.data[n2]);
                    bl = true;
                }
            }
        } else {
            for (int i = 0; i < this.dim2; ++i) {
                int n = this.stride2 * i + this.offset;
                for (int j = 0; j < this.dim1; ++j) {
                    int n3 = this.stride1 * j + n;
                    if (bl) {
                        intScanner.update(this.data[n3]);
                        continue;
                    }
                    intScanner.initialize(this.data[n3]);
                    bl = true;
                }
            }
        }
    }

    @Override
    public final boolean isFlat() {
        return this.flat;
    }

    @Override
    public int[] flatten(boolean bl) {
        if (!bl && this.flat) {
            return this.data;
        }
        int[] nArray = new int[this.number];
        if (this.flat) {
            System.arraycopy(this.data, 0, nArray, 0, this.number);
        } else {
            int n = -1;
            for (int i = 0; i < this.dim2; ++i) {
                int n2 = this.stride2 * i + this.offset;
                for (int j = 0; j < this.dim1; ++j) {
                    int n3 = this.stride1 * j + n2;
                    nArray[++n] = this.data[n3];
                }
            }
        }
        return nArray;
    }

    @Override
    public int[] getData() {
        return this.flat ? this.data : null;
    }

    @Override
    public Int1D slice(int n) {
        return new StriddenInt1D(this.data, this.offset + this.stride2 * n, this.stride1, this.dim1);
    }

    @Override
    public Int1D slice(int n, int n2) {
        int n3;
        int n4;
        int n5;
        if (n2 < 0) {
            n2 += 2;
        }
        if (n2 == 0) {
            n5 = this.offset + this.stride1 * n;
            n4 = this.stride2;
            n3 = this.dim2;
        } else if (n2 == 1) {
            n5 = this.offset + this.stride2 * n;
            n4 = this.stride1;
            n3 = this.dim1;
        } else {
            throw new IndexOutOfBoundsException("Dimension index out of bounds");
        }
        return new StriddenInt1D(this.data, n5, n4, n3);
    }

    @Override
    public Int2D view(Range range, Range range2) {
        CompiledRange compiledRange = new CompiledRange(range, this.dim1, this.offset, this.stride1);
        CompiledRange compiledRange2 = new CompiledRange(range2, this.dim2, 0, this.stride2);
        if (compiledRange.doesNothing() && compiledRange2.doesNothing()) {
            return this;
        }
        return new StriddenInt2D(this.data, compiledRange.getOffset() + compiledRange2.getOffset(), compiledRange.getStride(), compiledRange2.getStride(), compiledRange.getNumber(), compiledRange2.getNumber());
    }

    @Override
    public Int2D view(int[] nArray, int[] nArray2) {
        int[] nArray3 = Helper.select(this.offset, this.stride1, this.dim1, nArray);
        int[] nArray4 = Helper.select(0, this.stride2, this.dim2, nArray2);
        return new SelectedInt2D(this.data, nArray3, nArray4);
    }

    @Override
    public Int1D as1D() {
        return new FlatInt1D(this.flatten(), this.number);
    }
}

