/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array.impl;

import mitiv.array.Int1D;
import mitiv.array.Int5D;
import mitiv.array.Int6D;
import mitiv.array.impl.FlatInt1D;
import mitiv.array.impl.Helper;
import mitiv.array.impl.SelectedInt6D;
import mitiv.array.impl.StriddenInt5D;
import mitiv.base.indexing.CompiledRange;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.IntFunction;
import mitiv.base.mapping.IntScanner;
import mitiv.random.IntGenerator;

public class StriddenInt6D
extends Int6D {
    final int order;
    final int[] data;
    final int offset;
    final int stride1;
    final int stride2;
    final int stride3;
    final int stride4;
    final int stride5;
    final int stride6;
    final boolean flat;

    public StriddenInt6D(int[] nArray, int n, int[] nArray2, int[] nArray3) {
        super(nArray3);
        if (nArray2.length != 6) {
            throw new IllegalArgumentException("There must be as many strides as the rank");
        }
        this.data = nArray;
        this.offset = n;
        this.stride1 = nArray2[0];
        this.stride2 = nArray2[1];
        this.stride3 = nArray2[2];
        this.stride4 = nArray2[3];
        this.stride5 = nArray2[4];
        this.stride6 = nArray2[5];
        this.order = Int6D.checkViewStrides(this.data.length, n, this.stride1, this.stride2, this.stride3, this.stride4, this.stride5, this.stride6, this.dim1, this.dim2, this.dim3, this.dim4, this.dim5, this.dim6);
        this.flat = n == 0 && this.stride1 == 1 && this.stride2 == this.dim1 && this.stride3 == this.dim2 * this.stride2 && this.stride4 == this.dim3 * this.stride3 && this.stride5 == this.dim4 * this.stride4 && this.stride6 == this.dim5 * this.stride5;
    }

    public StriddenInt6D(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13) {
        super(n8, n9, n10, n11, n12, n13);
        this.data = nArray;
        this.offset = n;
        this.stride1 = n2;
        this.stride2 = n3;
        this.stride3 = n4;
        this.stride4 = n5;
        this.stride5 = n6;
        this.stride6 = n7;
        this.order = Int6D.checkViewStrides(this.data.length, n, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, n13);
        this.flat = n == 0 && n2 == 1 && n3 == n8 && n4 == n9 * n3 && n5 == n10 * n4 && n6 == n11 * n5 && n7 == n12 * n6;
    }

    @Override
    public void checkSanity() {
        Int6D.checkViewStrides(this.data.length, this.offset, this.stride1, this.stride2, this.stride3, this.stride4, this.stride5, this.stride6, this.dim1, this.dim2, this.dim3, this.dim4, this.dim5, this.dim6);
    }

    final int index(int n, int n2, int n3, int n4, int n5, int n6) {
        return this.offset + this.stride6 * n6 + this.stride5 * n5 + this.stride4 * n4 + this.stride3 * n3 + this.stride2 * n2 + this.stride1 * n;
    }

    @Override
    public final int get(int n, int n2, int n3, int n4, int n5, int n6) {
        return this.data[this.offset + this.stride6 * n6 + this.stride5 * n5 + this.stride4 * n4 + this.stride3 * n3 + this.stride2 * n2 + this.stride1 * n];
    }

    @Override
    public final void set(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.data[this.offset + this.stride6 * n6 + this.stride5 * n5 + this.stride4 * n4 + this.stride3 * n3 + this.stride2 * n2 + this.stride1 * n] = n7;
    }

    @Override
    public final int getOrder() {
        return this.order;
    }

    @Override
    public void fill(int n) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                int n2 = this.stride1 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n3 = this.stride2 * j + n2;
                    for (int k = 0; k < this.dim3; ++k) {
                        int n4 = this.stride3 * k + n3;
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            int n5 = this.stride4 * i2 + n4;
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                int n6 = this.stride5 * i3 + n5;
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    int n7 = this.stride6 * i4 + n6;
                                    this.data[n7] = n;
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim6; ++i) {
                int n8 = this.stride6 * i + this.offset;
                for (int j = 0; j < this.dim5; ++j) {
                    int n9 = this.stride5 * j + n8;
                    for (int k = 0; k < this.dim4; ++k) {
                        int n10 = this.stride4 * k + n9;
                        for (int i5 = 0; i5 < this.dim3; ++i5) {
                            int n11 = this.stride3 * i5 + n10;
                            for (int i6 = 0; i6 < this.dim2; ++i6) {
                                int n12 = this.stride2 * i6 + n11;
                                for (int i7 = 0; i7 < this.dim1; ++i7) {
                                    int n13 = this.stride1 * i7 + n12;
                                    this.data[n13] = n;
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void fill(IntGenerator intGenerator) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                int n = this.stride1 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n2 = this.stride2 * j + n;
                    for (int k = 0; k < this.dim3; ++k) {
                        int n3 = this.stride3 * k + n2;
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            int n4 = this.stride4 * i2 + n3;
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                int n5 = this.stride5 * i3 + n4;
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    int n6 = this.stride6 * i4 + n5;
                                    this.data[n6] = intGenerator.nextInt();
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim6; ++i) {
                int n = this.stride6 * i + this.offset;
                for (int j = 0; j < this.dim5; ++j) {
                    int n7 = this.stride5 * j + n;
                    for (int k = 0; k < this.dim4; ++k) {
                        int n8 = this.stride4 * k + n7;
                        for (int i5 = 0; i5 < this.dim3; ++i5) {
                            int n9 = this.stride3 * i5 + n8;
                            for (int i6 = 0; i6 < this.dim2; ++i6) {
                                int n10 = this.stride2 * i6 + n9;
                                for (int i7 = 0; i7 < this.dim1; ++i7) {
                                    int n11 = this.stride1 * i7 + n10;
                                    this.data[n11] = intGenerator.nextInt();
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void increment(int n) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                int n2 = this.stride1 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n3 = this.stride2 * j + n2;
                    for (int k = 0; k < this.dim3; ++k) {
                        int n4 = this.stride3 * k + n3;
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            int n5 = this.stride4 * i2 + n4;
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                int n6 = this.stride5 * i3 + n5;
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    int n7;
                                    int n8 = n7 = this.stride6 * i4 + n6;
                                    this.data[n8] = this.data[n8] + n;
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim6; ++i) {
                int n9 = this.stride6 * i + this.offset;
                for (int j = 0; j < this.dim5; ++j) {
                    int n10 = this.stride5 * j + n9;
                    for (int k = 0; k < this.dim4; ++k) {
                        int n11 = this.stride4 * k + n10;
                        for (int i5 = 0; i5 < this.dim3; ++i5) {
                            int n12 = this.stride3 * i5 + n11;
                            for (int i6 = 0; i6 < this.dim2; ++i6) {
                                int n13 = this.stride2 * i6 + n12;
                                for (int i7 = 0; i7 < this.dim1; ++i7) {
                                    int n14;
                                    int n15 = n14 = this.stride1 * i7 + n13;
                                    this.data[n15] = this.data[n15] + n;
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void decrement(int n) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                int n2 = this.stride1 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n3 = this.stride2 * j + n2;
                    for (int k = 0; k < this.dim3; ++k) {
                        int n4 = this.stride3 * k + n3;
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            int n5 = this.stride4 * i2 + n4;
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                int n6 = this.stride5 * i3 + n5;
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    int n7;
                                    int n8 = n7 = this.stride6 * i4 + n6;
                                    this.data[n8] = this.data[n8] - n;
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim6; ++i) {
                int n9 = this.stride6 * i + this.offset;
                for (int j = 0; j < this.dim5; ++j) {
                    int n10 = this.stride5 * j + n9;
                    for (int k = 0; k < this.dim4; ++k) {
                        int n11 = this.stride4 * k + n10;
                        for (int i5 = 0; i5 < this.dim3; ++i5) {
                            int n12 = this.stride3 * i5 + n11;
                            for (int i6 = 0; i6 < this.dim2; ++i6) {
                                int n13 = this.stride2 * i6 + n12;
                                for (int i7 = 0; i7 < this.dim1; ++i7) {
                                    int n14;
                                    int n15 = n14 = this.stride1 * i7 + n13;
                                    this.data[n15] = this.data[n15] - n;
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void scale(int n) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                int n2 = this.stride1 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n3 = this.stride2 * j + n2;
                    for (int k = 0; k < this.dim3; ++k) {
                        int n4 = this.stride3 * k + n3;
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            int n5 = this.stride4 * i2 + n4;
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                int n6 = this.stride5 * i3 + n5;
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    int n7;
                                    int n8 = n7 = this.stride6 * i4 + n6;
                                    this.data[n8] = this.data[n8] * n;
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim6; ++i) {
                int n9 = this.stride6 * i + this.offset;
                for (int j = 0; j < this.dim5; ++j) {
                    int n10 = this.stride5 * j + n9;
                    for (int k = 0; k < this.dim4; ++k) {
                        int n11 = this.stride4 * k + n10;
                        for (int i5 = 0; i5 < this.dim3; ++i5) {
                            int n12 = this.stride3 * i5 + n11;
                            for (int i6 = 0; i6 < this.dim2; ++i6) {
                                int n13 = this.stride2 * i6 + n12;
                                for (int i7 = 0; i7 < this.dim1; ++i7) {
                                    int n14;
                                    int n15 = n14 = this.stride1 * i7 + n13;
                                    this.data[n15] = this.data[n15] * n;
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void map(IntFunction intFunction) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                int n = this.stride1 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n2 = this.stride2 * j + n;
                    for (int k = 0; k < this.dim3; ++k) {
                        int n3 = this.stride3 * k + n2;
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            int n4 = this.stride4 * i2 + n3;
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                int n5 = this.stride5 * i3 + n4;
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    int n6 = this.stride6 * i4 + n5;
                                    this.data[n6] = intFunction.apply(this.data[n6]);
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim6; ++i) {
                int n = this.stride6 * i + this.offset;
                for (int j = 0; j < this.dim5; ++j) {
                    int n7 = this.stride5 * j + n;
                    for (int k = 0; k < this.dim4; ++k) {
                        int n8 = this.stride4 * k + n7;
                        for (int i5 = 0; i5 < this.dim3; ++i5) {
                            int n9 = this.stride3 * i5 + n8;
                            for (int i6 = 0; i6 < this.dim2; ++i6) {
                                int n10 = this.stride2 * i6 + n9;
                                for (int i7 = 0; i7 < this.dim1; ++i7) {
                                    int n11 = this.stride1 * i7 + n10;
                                    this.data[n11] = intFunction.apply(this.data[n11]);
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void scan(IntScanner intScanner) {
        boolean bl = false;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                int n = this.stride1 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n2 = this.stride2 * j + n;
                    for (int k = 0; k < this.dim3; ++k) {
                        int n3 = this.stride3 * k + n2;
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            int n4 = this.stride4 * i2 + n3;
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                int n5 = this.stride5 * i3 + n4;
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    int n6 = this.stride6 * i4 + n5;
                                    if (bl) {
                                        intScanner.update(this.data[n6]);
                                        continue;
                                    }
                                    intScanner.initialize(this.data[n6]);
                                    bl = true;
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim6; ++i) {
                int n = this.stride6 * i + this.offset;
                for (int j = 0; j < this.dim5; ++j) {
                    int n7 = this.stride5 * j + n;
                    for (int k = 0; k < this.dim4; ++k) {
                        int n8 = this.stride4 * k + n7;
                        for (int i5 = 0; i5 < this.dim3; ++i5) {
                            int n9 = this.stride3 * i5 + n8;
                            for (int i6 = 0; i6 < this.dim2; ++i6) {
                                int n10 = this.stride2 * i6 + n9;
                                for (int i7 = 0; i7 < this.dim1; ++i7) {
                                    int n11 = this.stride1 * i7 + n10;
                                    if (bl) {
                                        intScanner.update(this.data[n11]);
                                        continue;
                                    }
                                    intScanner.initialize(this.data[n11]);
                                    bl = true;
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public final boolean isFlat() {
        return this.flat;
    }

    @Override
    public int[] flatten(boolean bl) {
        if (!bl && this.flat) {
            return this.data;
        }
        int[] nArray = new int[this.number];
        if (this.flat) {
            System.arraycopy(this.data, 0, nArray, 0, this.number);
        } else {
            int n = -1;
            for (int i = 0; i < this.dim6; ++i) {
                int n2 = this.stride6 * i + this.offset;
                for (int j = 0; j < this.dim5; ++j) {
                    int n3 = this.stride5 * j + n2;
                    for (int k = 0; k < this.dim4; ++k) {
                        int n4 = this.stride4 * k + n3;
                        for (int i2 = 0; i2 < this.dim3; ++i2) {
                            int n5 = this.stride3 * i2 + n4;
                            for (int i3 = 0; i3 < this.dim2; ++i3) {
                                int n6 = this.stride2 * i3 + n5;
                                for (int i4 = 0; i4 < this.dim1; ++i4) {
                                    int n7 = this.stride1 * i4 + n6;
                                    nArray[++n] = this.data[n7];
                                }
                            }
                        }
                    }
                }
            }
        }
        return nArray;
    }

    @Override
    public int[] getData() {
        return this.flat ? this.data : null;
    }

    @Override
    public Int5D slice(int n) {
        return new StriddenInt5D(this.data, this.offset + this.stride6 * n, this.stride1, this.stride2, this.stride3, this.stride4, this.stride5, this.dim1, this.dim2, this.dim3, this.dim4, this.dim5);
    }

    @Override
    public Int5D slice(int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        if (n2 < 0) {
            n2 += 6;
        }
        if (n2 == 0) {
            n13 = this.offset + this.stride1 * n;
            n12 = this.stride2;
            n11 = this.stride3;
            n10 = this.stride4;
            n9 = this.stride5;
            n8 = this.stride6;
            n7 = this.dim2;
            n6 = this.dim3;
            n5 = this.dim4;
            n4 = this.dim5;
            n3 = this.dim6;
        } else if (n2 == 1) {
            n13 = this.offset + this.stride2 * n;
            n12 = this.stride1;
            n11 = this.stride3;
            n10 = this.stride4;
            n9 = this.stride5;
            n8 = this.stride6;
            n7 = this.dim1;
            n6 = this.dim3;
            n5 = this.dim4;
            n4 = this.dim5;
            n3 = this.dim6;
        } else if (n2 == 2) {
            n13 = this.offset + this.stride3 * n;
            n12 = this.stride1;
            n11 = this.stride2;
            n10 = this.stride4;
            n9 = this.stride5;
            n8 = this.stride6;
            n7 = this.dim1;
            n6 = this.dim2;
            n5 = this.dim4;
            n4 = this.dim5;
            n3 = this.dim6;
        } else if (n2 == 3) {
            n13 = this.offset + this.stride4 * n;
            n12 = this.stride1;
            n11 = this.stride2;
            n10 = this.stride3;
            n9 = this.stride5;
            n8 = this.stride6;
            n7 = this.dim1;
            n6 = this.dim2;
            n5 = this.dim3;
            n4 = this.dim5;
            n3 = this.dim6;
        } else if (n2 == 4) {
            n13 = this.offset + this.stride5 * n;
            n12 = this.stride1;
            n11 = this.stride2;
            n10 = this.stride3;
            n9 = this.stride4;
            n8 = this.stride6;
            n7 = this.dim1;
            n6 = this.dim2;
            n5 = this.dim3;
            n4 = this.dim4;
            n3 = this.dim6;
        } else if (n2 == 5) {
            n13 = this.offset + this.stride6 * n;
            n12 = this.stride1;
            n11 = this.stride2;
            n10 = this.stride3;
            n9 = this.stride4;
            n8 = this.stride5;
            n7 = this.dim1;
            n6 = this.dim2;
            n5 = this.dim3;
            n4 = this.dim4;
            n3 = this.dim5;
        } else {
            throw new IndexOutOfBoundsException("Dimension index out of bounds");
        }
        return new StriddenInt5D(this.data, n13, n12, n11, n10, n9, n8, n7, n6, n5, n4, n3);
    }

    @Override
    public Int6D view(Range range, Range range2, Range range3, Range range4, Range range5, Range range6) {
        CompiledRange compiledRange = new CompiledRange(range, this.dim1, this.offset, this.stride1);
        CompiledRange compiledRange2 = new CompiledRange(range2, this.dim2, 0, this.stride2);
        CompiledRange compiledRange3 = new CompiledRange(range3, this.dim3, 0, this.stride3);
        CompiledRange compiledRange4 = new CompiledRange(range4, this.dim4, 0, this.stride4);
        CompiledRange compiledRange5 = new CompiledRange(range5, this.dim5, 0, this.stride5);
        CompiledRange compiledRange6 = new CompiledRange(range6, this.dim6, 0, this.stride6);
        if (compiledRange.doesNothing() && compiledRange2.doesNothing() && compiledRange3.doesNothing() && compiledRange4.doesNothing() && compiledRange5.doesNothing() && compiledRange6.doesNothing()) {
            return this;
        }
        return new StriddenInt6D(this.data, compiledRange.getOffset() + compiledRange2.getOffset() + compiledRange3.getOffset() + compiledRange4.getOffset() + compiledRange5.getOffset() + compiledRange6.getOffset(), compiledRange.getStride(), compiledRange2.getStride(), compiledRange3.getStride(), compiledRange4.getStride(), compiledRange5.getStride(), compiledRange6.getStride(), compiledRange.getNumber(), compiledRange2.getNumber(), compiledRange3.getNumber(), compiledRange4.getNumber(), compiledRange5.getNumber(), compiledRange6.getNumber());
    }

    @Override
    public Int6D view(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int[] nArray5, int[] nArray6) {
        int[] nArray7 = Helper.select(this.offset, this.stride1, this.dim1, nArray);
        int[] nArray8 = Helper.select(0, this.stride2, this.dim2, nArray2);
        int[] nArray9 = Helper.select(0, this.stride3, this.dim3, nArray3);
        int[] nArray10 = Helper.select(0, this.stride4, this.dim4, nArray4);
        int[] nArray11 = Helper.select(0, this.stride5, this.dim5, nArray5);
        int[] nArray12 = Helper.select(0, this.stride6, this.dim6, nArray6);
        return new SelectedInt6D(this.data, nArray7, nArray8, nArray9, nArray10, nArray11, nArray12);
    }

    @Override
    public Int1D as1D() {
        return new FlatInt1D(this.flatten(), this.number);
    }
}

