/*
 * Decompiled with CFR 0.152.
 */
package mitiv.base;

import mitiv.base.Shape;
import mitiv.base.Shaped;
import mitiv.base.Traits;
import mitiv.base.Typed;

public class ArrayDescriptor
implements Shaped,
Typed {
    final int type;
    final int number;
    final Shape shape;

    public ArrayDescriptor(int n, int ... nArray) {
        this(n, new Shape(nArray));
    }

    public ArrayDescriptor(int n, Shape shape) {
        this.type = n;
        this.shape = shape;
        if (this.shape.number() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Total number of elements is too large");
        }
        this.number = (int)this.shape.number();
    }

    public static int computeNumber(int[] nArray) {
        if (nArray == null) {
            throw new IllegalArgumentException("Illegal NULL shape");
        }
        int n = 1;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] <= 0) {
                throw new IllegalArgumentException("Bad dimension length");
            }
            n *= nArray[i];
        }
        return n;
    }

    @Override
    public final int getType() {
        return this.type;
    }

    @Override
    public final int getOrder() {
        return 1;
    }

    @Override
    public final int getRank() {
        return this.shape.rank();
    }

    @Override
    public final int getNumber() {
        return this.number;
    }

    @Override
    public final int getDimension(int n) {
        return this.shape.dimension(n);
    }

    @Override
    public final Shape getShape() {
        return this.shape;
    }

    public final boolean equals(ArrayDescriptor arrayDescriptor) {
        return arrayDescriptor == this || arrayDescriptor.type == this.type && arrayDescriptor.shape.equals(this.shape);
    }

    public String toString() {
        return Traits.nameOf(this.type) + this.shape.toString();
    }
}

