/*
 * Decompiled with CFR 0.152.
 */
package mitiv.deconv;

import mitiv.base.Shape;
import mitiv.deconv.ConvolutionDouble;
import mitiv.linalg.shaped.ShapedVectorSpace;
import org.jtransforms.fft.DoubleFFT_2D;

class ConvolutionDouble2D
extends ConvolutionDouble {
    private DoubleFFT_2D fft = null;
    private final PushPullOperator R;
    private final PushPullOperator S;
    private final int dim1;
    private final int dim2;

    public ConvolutionDouble2D(Shape shape, ShapedVectorSpace shapedVectorSpace, int[] nArray, ShapedVectorSpace shapedVectorSpace2, int[] nArray2) {
        super(shape, shapedVectorSpace, nArray, shapedVectorSpace2, nArray2);
        if (this.getRank() != 2) {
            throw new IllegalArgumentException("Input and output spaces must be 2D");
        }
        this.dim1 = this.workShape.dimension(1);
        this.dim2 = this.workShape.dimension(0);
        this.R = new PushPullOperator(this.workShape, shapedVectorSpace2.getShape(), this.outputOffsets, this.fastOutput);
        this.S = new PushPullOperator(this.workShape, shapedVectorSpace.getShape(), this.inputOffsets, this.fastInput);
    }

    private final void createFFT() {
        if (this.fft == null) {
            this.fft = new DoubleFFT_2D(this.dim1, this.dim2);
        }
    }

    @Override
    public final void forwardFFT(double[] dArray) {
        if (dArray.length != 2 * this.getNumberOfFrequencies()) {
            throw new IllegalArgumentException("Bad argument size");
        }
        this.timerForFFT.resume();
        if (this.fft == null) {
            this.createFFT();
        }
        this.fft.complexForward(dArray);
        this.timerForFFT.stop();
    }

    @Override
    public final void backwardFFT(double[] dArray) {
        if (dArray.length != 2 * this.getNumberOfFrequencies()) {
            throw new IllegalArgumentException("Bad argument size");
        }
        this.timerForFFT.resume();
        if (this.fft == null) {
            this.createFFT();
        }
        this.fft.complexInverse(dArray, false);
        this.timerForFFT.stop();
    }

    @Override
    public void push(double[] dArray, double[] dArray2, boolean bl) {
        if (bl) {
            this.R.push(dArray, dArray2);
        } else {
            this.S.push(dArray, dArray2);
        }
    }

    @Override
    public void pull(double[] dArray, double[] dArray2, boolean bl) {
        if (bl) {
            this.S.pull(dArray, dArray2);
        } else {
            this.R.pull(dArray, dArray2);
        }
    }

    private class PushPullOperator {
        private final boolean fast;
        private final int off1;
        private final int off2;
        private final int end1;
        private final int end2;

        private PushPullOperator(Shape shape, Shape shape2, int[] nArray, boolean bl) {
            this.fast = bl;
            this.off1 = nArray[0];
            this.end1 = this.off1 + shape2.dimension(0);
            this.off2 = nArray[1];
            this.end2 = this.off2 + shape2.dimension(1);
        }

        private void push(double[] dArray, double[] dArray2) {
            if (this.fast) {
                int n = 0;
                int n2 = 0;
                while (n < dArray2.length) {
                    dArray[n2] = dArray2[n];
                    dArray[n2 + 1] = 0.0;
                    ++n;
                    n2 += 2;
                }
            } else {
                int n;
                int n3;
                int n4 = 0;
                int n5 = 0;
                for (n3 = 0; n3 < this.off2; ++n3) {
                    n = 0;
                    while (n < ConvolutionDouble2D.this.dim1) {
                        dArray[n5] = 0.0;
                        dArray[n5 + 1] = 0.0;
                        ++n;
                        n5 += 2;
                    }
                }
                for (n3 = this.off2; n3 < this.end2; ++n3) {
                    n = 0;
                    while (n < this.off1) {
                        dArray[n5] = 0.0;
                        dArray[n5 + 1] = 0.0;
                        ++n;
                        n5 += 2;
                    }
                    n = this.off1;
                    while (n < this.end1) {
                        dArray[n5] = dArray2[n4];
                        dArray[n5 + 1] = 0.0;
                        ++n;
                        ++n4;
                        n5 += 2;
                    }
                    n = this.end1;
                    while (n < ConvolutionDouble2D.this.dim1) {
                        dArray[n5] = 0.0;
                        dArray[n5 + 1] = 0.0;
                        ++n;
                        n5 += 2;
                    }
                }
                for (n3 = this.end2; n3 < ConvolutionDouble2D.this.dim2; ++n3) {
                    n = 0;
                    while (n < ConvolutionDouble2D.this.dim1) {
                        dArray[n5] = 0.0;
                        dArray[n5 + 1] = 0.0;
                        ++n;
                        n5 += 2;
                    }
                }
            }
        }

        private void pull(double[] dArray, double[] dArray2) {
            if (this.fast) {
                int n = 0;
                int n2 = 0;
                while (n < dArray.length) {
                    dArray[n] = dArray2[n2];
                    ++n;
                    n2 += 2;
                }
            } else {
                int n = 0;
                for (int i = this.off2; i < this.end2; ++i) {
                    int n3 = (this.off1 + ConvolutionDouble2D.this.dim1 * i) * 2;
                    int n4 = this.off1;
                    while (n4 < this.end1) {
                        dArray[n] = dArray2[n3];
                        ++n4;
                        ++n;
                        n3 += 2;
                    }
                }
            }
        }
    }
}

