/*
 * Decompiled with CFR 0.152.
 */
package mitiv.deconv;

import mitiv.base.Shape;
import mitiv.deconv.ConvolutionFloat;
import mitiv.linalg.shaped.ShapedVectorSpace;
import org.jtransforms.fft.FloatFFT_2D;

class ConvolutionFloat2D
extends ConvolutionFloat {
    private FloatFFT_2D fft = null;
    private final PushPullOperator R;
    private final PushPullOperator S;
    private final int dim1;
    private final int dim2;

    public ConvolutionFloat2D(Shape shape, ShapedVectorSpace shapedVectorSpace, int[] nArray, ShapedVectorSpace shapedVectorSpace2, int[] nArray2) {
        super(shape, shapedVectorSpace, nArray, shapedVectorSpace2, nArray2);
        if (this.getRank() != 2) {
            throw new IllegalArgumentException("Input and output spaces must be 2D");
        }
        this.dim1 = this.workShape.dimension(1);
        this.dim2 = this.workShape.dimension(0);
        this.R = new PushPullOperator(this.workShape, shapedVectorSpace2.getShape(), this.outputOffsets, this.fastOutput);
        this.S = new PushPullOperator(this.workShape, shapedVectorSpace.getShape(), this.inputOffsets, this.fastInput);
    }

    private final void createFFT() {
        if (this.fft == null) {
            this.fft = new FloatFFT_2D(this.dim1, this.dim2);
        }
    }

    @Override
    public final void forwardFFT(float[] fArray) {
        if (fArray.length != 2 * this.getNumberOfFrequencies()) {
            throw new IllegalArgumentException("Bad argument size");
        }
        this.timerForFFT.resume();
        if (this.fft == null) {
            this.createFFT();
        }
        this.fft.complexForward(fArray);
        this.timerForFFT.stop();
    }

    @Override
    public final void backwardFFT(float[] fArray) {
        if (fArray.length != 2 * this.getNumberOfFrequencies()) {
            throw new IllegalArgumentException("Bad argument size");
        }
        this.timerForFFT.resume();
        if (this.fft == null) {
            this.createFFT();
        }
        this.fft.complexInverse(fArray, false);
        this.timerForFFT.stop();
    }

    @Override
    public void push(float[] fArray, float[] fArray2, boolean bl) {
        if (bl) {
            this.R.push(fArray, fArray2);
        } else {
            this.S.push(fArray, fArray2);
        }
    }

    @Override
    public void pull(float[] fArray, float[] fArray2, boolean bl) {
        if (bl) {
            this.S.pull(fArray, fArray2);
        } else {
            this.R.pull(fArray, fArray2);
        }
    }

    private class PushPullOperator {
        private final boolean fast;
        private final int off1;
        private final int off2;
        private final int end1;
        private final int end2;

        private PushPullOperator(Shape shape, Shape shape2, int[] nArray, boolean bl) {
            this.fast = bl;
            this.off1 = nArray[0];
            this.end1 = this.off1 + shape2.dimension(0);
            this.off2 = nArray[1];
            this.end2 = this.off2 + shape2.dimension(1);
        }

        private void push(float[] fArray, float[] fArray2) {
            if (this.fast) {
                int n = 0;
                int n2 = 0;
                while (n < fArray2.length) {
                    fArray[n2] = fArray2[n];
                    fArray[n2 + 1] = 0.0f;
                    ++n;
                    n2 += 2;
                }
            } else {
                int n;
                int n3;
                int n4 = 0;
                int n5 = 0;
                for (n3 = 0; n3 < this.off2; ++n3) {
                    n = 0;
                    while (n < ConvolutionFloat2D.this.dim1) {
                        fArray[n5] = 0.0f;
                        fArray[n5 + 1] = 0.0f;
                        ++n;
                        n5 += 2;
                    }
                }
                for (n3 = this.off2; n3 < this.end2; ++n3) {
                    n = 0;
                    while (n < this.off1) {
                        fArray[n5] = 0.0f;
                        fArray[n5 + 1] = 0.0f;
                        ++n;
                        n5 += 2;
                    }
                    n = this.off1;
                    while (n < this.end1) {
                        fArray[n5] = fArray2[n4];
                        fArray[n5 + 1] = 0.0f;
                        ++n;
                        ++n4;
                        n5 += 2;
                    }
                    n = this.end1;
                    while (n < ConvolutionFloat2D.this.dim1) {
                        fArray[n5] = 0.0f;
                        fArray[n5 + 1] = 0.0f;
                        ++n;
                        n5 += 2;
                    }
                }
                for (n3 = this.end2; n3 < ConvolutionFloat2D.this.dim2; ++n3) {
                    n = 0;
                    while (n < ConvolutionFloat2D.this.dim1) {
                        fArray[n5] = 0.0f;
                        fArray[n5 + 1] = 0.0f;
                        ++n;
                        n5 += 2;
                    }
                }
            }
        }

        private void pull(float[] fArray, float[] fArray2) {
            if (this.fast) {
                int n = 0;
                int n2 = 0;
                while (n < fArray.length) {
                    fArray[n] = fArray2[n2];
                    ++n;
                    n2 += 2;
                }
            } else {
                int n = 0;
                for (int i = this.off2; i < this.end2; ++i) {
                    int n3 = (this.off1 + ConvolutionFloat2D.this.dim1 * i) * 2;
                    int n4 = this.off1;
                    while (n4 < this.end1) {
                        fArray[n] = fArray2[n3];
                        ++n4;
                        ++n;
                        n3 += 2;
                    }
                }
            }
        }
    }
}

