/*
 * Decompiled with CFR 0.152.
 */
package mitiv.deconv;

import mitiv.base.Shape;
import mitiv.deconv.ConvolutionFloat;
import mitiv.linalg.shaped.ShapedVectorSpace;
import org.jtransforms.fft.FloatFFT_3D;

class ConvolutionFloat3D
extends ConvolutionFloat {
    private FloatFFT_3D fft = null;
    private final PushPullOperator R;
    private final PushPullOperator S;
    private final int dim1;
    private final int dim2;
    private final int dim3;

    public ConvolutionFloat3D(Shape shape, ShapedVectorSpace shapedVectorSpace, int[] nArray, ShapedVectorSpace shapedVectorSpace2, int[] nArray2) {
        super(shape, shapedVectorSpace, nArray, shapedVectorSpace2, nArray2);
        if (this.getRank() != 3) {
            throw new IllegalArgumentException("Input and output spaces must be 3D");
        }
        this.dim1 = this.workShape.dimension(2);
        this.dim2 = this.workShape.dimension(1);
        this.dim3 = this.workShape.dimension(0);
        this.R = new PushPullOperator(this.workShape, shapedVectorSpace2.getShape(), this.outputOffsets, this.fastOutput);
        this.S = new PushPullOperator(this.workShape, shapedVectorSpace.getShape(), this.inputOffsets, this.fastInput);
    }

    private final void createFFT() {
        if (this.fft == null) {
            this.fft = new FloatFFT_3D(this.dim1, this.dim2, this.dim3);
        }
    }

    @Override
    public final void forwardFFT(float[] fArray) {
        if (fArray.length != 2 * this.getNumberOfFrequencies()) {
            throw new IllegalArgumentException("Bad argument size");
        }
        this.timerForFFT.resume();
        if (this.fft == null) {
            this.createFFT();
        }
        this.fft.complexForward(fArray);
        this.timerForFFT.stop();
    }

    @Override
    public final void backwardFFT(float[] fArray) {
        if (fArray.length != 2 * this.getNumberOfFrequencies()) {
            throw new IllegalArgumentException("Bad argument size");
        }
        this.timerForFFT.resume();
        if (this.fft == null) {
            this.createFFT();
        }
        this.fft.complexInverse(fArray, false);
        this.timerForFFT.stop();
    }

    @Override
    public void push(float[] fArray, float[] fArray2, boolean bl) {
        if (bl) {
            this.R.push(fArray, fArray2);
        } else {
            this.S.push(fArray, fArray2);
        }
    }

    @Override
    public void pull(float[] fArray, float[] fArray2, boolean bl) {
        if (bl) {
            this.S.pull(fArray, fArray2);
        } else {
            this.R.pull(fArray, fArray2);
        }
    }

    private class PushPullOperator {
        private final boolean fast;
        private final int off1;
        private final int off2;
        private final int off3;
        private final int end1;
        private final int end2;
        private final int end3;

        private PushPullOperator(Shape shape, Shape shape2, int[] nArray, boolean bl) {
            this.fast = bl;
            this.off1 = nArray[0];
            this.end1 = this.off1 + shape2.dimension(0);
            this.off2 = nArray[1];
            this.end2 = this.off2 + shape2.dimension(1);
            this.off3 = nArray[2];
            this.end3 = this.off3 + shape2.dimension(2);
        }

        private void push(float[] fArray, float[] fArray2) {
            if (this.fast) {
                int n = 0;
                int n2 = 0;
                while (n < fArray2.length) {
                    fArray[n2] = fArray2[n];
                    fArray[n2 + 1] = 0.0f;
                    ++n;
                    n2 += 2;
                }
            } else {
                int n;
                int n3;
                int n4;
                int n5 = 0;
                int n6 = 0;
                for (n4 = 0; n4 < this.off3; ++n4) {
                    for (n3 = 0; n3 < ConvolutionFloat3D.this.dim2; ++n3) {
                        n = 0;
                        while (n < ConvolutionFloat3D.this.dim1) {
                            fArray[n6] = 0.0f;
                            fArray[n6 + 1] = 0.0f;
                            ++n;
                            n6 += 2;
                        }
                    }
                }
                for (n4 = this.off3; n4 < this.end3; ++n4) {
                    for (n3 = 0; n3 < this.off2; ++n3) {
                        n = 0;
                        while (n < ConvolutionFloat3D.this.dim1) {
                            fArray[n6] = 0.0f;
                            fArray[n6 + 1] = 0.0f;
                            ++n;
                            n6 += 2;
                        }
                    }
                    for (n3 = this.off2; n3 < this.end2; ++n3) {
                        n = 0;
                        while (n < this.off1) {
                            fArray[n6] = 0.0f;
                            fArray[n6 + 1] = 0.0f;
                            ++n;
                            n6 += 2;
                        }
                        n = this.off1;
                        while (n < this.end1) {
                            fArray[n6] = fArray2[n5];
                            fArray[n6 + 1] = 0.0f;
                            ++n;
                            ++n5;
                            n6 += 2;
                        }
                        n = this.end1;
                        while (n < ConvolutionFloat3D.this.dim1) {
                            fArray[n6] = 0.0f;
                            fArray[n6 + 1] = 0.0f;
                            ++n;
                            n6 += 2;
                        }
                    }
                    for (n3 = this.end2; n3 < ConvolutionFloat3D.this.dim2; ++n3) {
                        n = 0;
                        while (n < ConvolutionFloat3D.this.dim1) {
                            fArray[n6] = 0.0f;
                            fArray[n6 + 1] = 0.0f;
                            ++n;
                            n6 += 2;
                        }
                    }
                }
                for (n4 = this.end3; n4 < ConvolutionFloat3D.this.dim3; ++n4) {
                    for (n3 = 0; n3 < ConvolutionFloat3D.this.dim2; ++n3) {
                        n = 0;
                        while (n < ConvolutionFloat3D.this.dim1) {
                            fArray[n6] = 0.0f;
                            fArray[n6 + 1] = 0.0f;
                            ++n;
                            n6 += 2;
                        }
                    }
                }
            }
        }

        private void pull(float[] fArray, float[] fArray2) {
            if (this.fast) {
                int n = 0;
                int n2 = 0;
                while (n < fArray.length) {
                    fArray[n] = fArray2[n2];
                    ++n;
                    n2 += 2;
                }
            } else {
                int n = 0;
                for (int i = this.off3; i < this.end3; ++i) {
                    for (int j = this.off2; j < this.end2; ++j) {
                        int n3 = (this.off1 + ConvolutionFloat3D.this.dim1 * (j + ConvolutionFloat3D.this.dim3 * i)) * 2;
                        int n4 = this.off1;
                        while (n4 < this.end1) {
                            fArray[n] = fArray2[n3];
                            ++n4;
                            ++n;
                            n3 += 2;
                        }
                    }
                }
            }
        }
    }
}

