/*
 * Decompiled with CFR 0.152.
 */
package mitiv.deconv;

import mitiv.array.ShapedArray;
import mitiv.base.Shape;
import mitiv.deconv.ConvolutionFloat1D;
import mitiv.deconv.WeightedConvolutionFloat;
import mitiv.linalg.Vector;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.ShapedVector;

class WeightedConvolutionFloat1D
extends WeightedConvolutionFloat {
    private final int dim1;
    private final int off1;
    private final int end1;
    private final ConvolutionFloat1D cnvl;

    public WeightedConvolutionFloat1D(ConvolutionFloat1D convolutionFloat1D) {
        super(convolutionFloat1D.getInputSpace(), convolutionFloat1D.getOutputSpace());
        this.cnvl = convolutionFloat1D;
        Shape shape = convolutionFloat1D.workShape;
        Shape shape2 = convolutionFloat1D.getOutputSpace().getShape();
        int[] nArray = convolutionFloat1D.outputOffsets;
        this.dim1 = shape.dimension(0);
        this.off1 = nArray[0];
        this.end1 = this.off1 + shape2.dimension(0);
    }

    @Override
    protected double _cost(double d, Vector vector) {
        this.checkSetup();
        this.cnvl.push((ShapedVector)vector, false);
        this.cnvl.convolve(false);
        double d2 = 0.0;
        float[] fArray = this.cnvl.getWorkArray();
        int n = 0;
        int n2 = 2 * this.off1;
        if (this.wgt == null) {
            for (int i = this.off1; i < this.end1; ++i) {
                float f = fArray[n2] - this.dat[n];
                d2 += (double)(f * f);
                ++n;
                n2 += 2;
            }
        } else {
            for (int i = this.off1; i < this.end1; ++i) {
                float f = this.wgt[n];
                float f2 = fArray[n2] - this.dat[n];
                d2 += (double)(f * f2 * f2);
                ++n;
                n2 += 2;
            }
        }
        return d * d2 / 2.0;
    }

    @Override
    protected double _cost(double d, Vector vector, Vector vector2, boolean bl) {
        float f;
        int n;
        this.checkSetup();
        this.cnvl.push((ShapedVector)vector, false);
        this.cnvl.convolve(false);
        boolean bl2 = this.wgt != null;
        float f2 = (float)d;
        double d2 = 0.0;
        float[] fArray = this.cnvl.getWorkArray();
        int n2 = 0;
        int n3 = 0;
        for (n = 0; n < this.off1; ++n) {
            fArray[n3] = 0.0f;
            fArray[n3 + 1] = 0.0f;
            n3 += 2;
        }
        if (bl2) {
            for (n = this.off1; n < this.end1; ++n) {
                f = this.wgt[n2];
                float f3 = fArray[n3] - this.dat[n2];
                float f4 = f * f3;
                d2 += (double)(f3 * f4);
                fArray[n3] = f2 * f4;
                fArray[n3 + 1] = 0.0f;
                ++n2;
                n3 += 2;
            }
        } else {
            for (n = this.off1; n < this.end1; ++n) {
                f = fArray[n3] - this.dat[n2];
                d2 += (double)(f * f);
                fArray[n3] = f2 * f;
                fArray[n3 + 1] = 0.0f;
                ++n2;
                n3 += 2;
            }
        }
        for (n = this.end1; n < this.dim1; ++n) {
            fArray[n3] = 0.0f;
            fArray[n3 + 1] = 0.0f;
            n3 += 2;
        }
        float[] fArray2 = ((FloatShapedVector)vector2).getData();
        this.cnvl.convolve(true);
        if (bl) {
            n2 = 0;
            n3 = 0;
            while (n2 < fArray2.length) {
                fArray2[n2] = fArray[n3];
                ++n2;
                n3 += 2;
            }
        } else {
            n2 = 0;
            n3 = 0;
            while (n2 < fArray2.length) {
                int n4 = n2++;
                fArray2[n4] = fArray2[n4] + fArray[n3];
                n3 += 2;
            }
        }
        return d * d2 / 2.0;
    }

    @Override
    public void setPSF(ShapedArray shapedArray, int[] nArray, boolean bl) {
        this.cnvl.setPSF(shapedArray, nArray, bl);
    }

    @Override
    public void setPSF(ShapedVector shapedVector) {
        this.cnvl.setPSF(shapedVector);
    }
}

