/*
 * Decompiled with CFR 0.152.
 */
package mitiv.optim;

import mitiv.linalg.Vector;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.ShapedVectorSpace;
import mitiv.optim.BoundProjector;

public class GeneralBounds
extends BoundProjector {
    private final Vector lowerBound;
    private final Vector upperBound;
    private final boolean single;

    public GeneralBounds(ShapedVectorSpace shapedVectorSpace, Vector vector, Vector vector2) {
        super(shapedVectorSpace);
        if (shapedVectorSpace.getType() == 5) {
            this.single = false;
        } else if (shapedVectorSpace.getType() == 4) {
            this.single = true;
        } else {
            throw new IllegalArgumentException("Only double/double type supported");
        }
        if (!vector.belongsTo(shapedVectorSpace)) {
            throw new IllegalArgumentException("Lower bound does not belong to the same vector space as the variables");
        }
        if (!vector2.belongsTo(shapedVectorSpace)) {
            throw new IllegalArgumentException("Upper bound does not belong to the same vector space as the variables");
        }
        int n = shapedVectorSpace.getNumber();
        if (this.single) {
            float[] fArray = ((FloatShapedVector)vector).getData();
            float[] fArray2 = ((FloatShapedVector)vector2).getData();
            for (int i = 0; i < n; ++i) {
                if (Float.isNaN(fArray[i]) || Float.isInfinite(fArray[i]) && fArray[i] != Float.NEGATIVE_INFINITY) {
                    throw new IllegalArgumentException("Invalid lower bound value(s)");
                }
                if (Float.isNaN(fArray2[i]) || Float.isInfinite(fArray2[i]) && fArray2[i] != Float.POSITIVE_INFINITY) {
                    throw new IllegalArgumentException("Invalid upper bound value(s)");
                }
                if (!(fArray[i] > fArray2[i])) continue;
                throw new IllegalArgumentException("Lower bound must be less or equal upper bound");
            }
        } else {
            double[] dArray = ((DoubleShapedVector)vector).getData();
            double[] dArray2 = ((DoubleShapedVector)vector2).getData();
            for (int i = 0; i < n; ++i) {
                if (Double.isNaN(dArray[i]) || Double.isInfinite(dArray[i]) && dArray[i] != Double.NEGATIVE_INFINITY) {
                    throw new IllegalArgumentException("Invalid lower bound value(s)");
                }
                if (Double.isNaN(dArray2[i]) || Double.isInfinite(dArray2[i]) && dArray2[i] != Double.POSITIVE_INFINITY) {
                    throw new IllegalArgumentException("Invalid upper bound value(s)");
                }
                if (!(dArray[i] > dArray2[i])) continue;
                throw new IllegalArgumentException("Lower bound must be less or equal upper bound");
            }
        }
        this.lowerBound = vector;
        this.upperBound = vector2;
    }

    @Override
    protected void _projectVariables(Vector vector, Vector vector2) {
        int n = vector2.getNumber();
        if (this.single) {
            float[] fArray = ((FloatShapedVector)this.lowerBound).getData();
            float[] fArray2 = ((FloatShapedVector)this.upperBound).getData();
            float[] fArray3 = ((FloatShapedVector)vector2).getData();
            float[] fArray4 = ((FloatShapedVector)vector).getData();
            for (int i = 0; i < n; ++i) {
                fArray4[i] = GeneralBounds.clamp(fArray3[i], fArray[i], fArray2[i]);
            }
        } else {
            double[] dArray = ((DoubleShapedVector)this.lowerBound).getData();
            double[] dArray2 = ((DoubleShapedVector)this.upperBound).getData();
            double[] dArray3 = ((DoubleShapedVector)vector2).getData();
            double[] dArray4 = ((DoubleShapedVector)vector).getData();
            for (int i = 0; i < n; ++i) {
                dArray4[i] = GeneralBounds.clamp(dArray3[i], dArray[i], dArray2[i]);
            }
        }
    }

    @Override
    protected void _projectDirection(Vector vector, Vector vector2, boolean bl, Vector vector3, double[] dArray) {
        int n = vector.getNumber();
        if (this.single) {
            float[] fArray = ((FloatShapedVector)this.lowerBound).getData();
            float[] fArray2 = ((FloatShapedVector)this.upperBound).getData();
            float[] fArray3 = ((FloatShapedVector)vector).getData();
            float[] fArray4 = ((FloatShapedVector)vector2).getData();
            float[] fArray5 = ((FloatShapedVector)vector3).getData();
            if (dArray == null) {
                if (bl) {
                    for (int i = 0; i < n; ++i) {
                        fArray5[i] = fArray4[i] < 0.0f ? (fArray3[i] < fArray2[i] ? fArray4[i] : 0.0f) : (fArray4[i] > 0.0f ? (fArray3[i] > fArray[i] ? fArray4[i] : 0.0f) : 0.0f);
                    }
                } else {
                    for (int i = 0; i < n; ++i) {
                        fArray5[i] = fArray4[i] > 0.0f ? (fArray3[i] < fArray2[i] ? fArray4[i] : 0.0f) : (fArray4[i] < 0.0f ? (fArray3[i] > fArray[i] ? fArray4[i] : 0.0f) : 0.0f);
                    }
                }
            } else {
                float f = Float.POSITIVE_INFINITY;
                float f2 = 0.0f;
                if (bl) {
                    for (int i = 0; i < n; ++i) {
                        float f3;
                        if (fArray4[i] < 0.0f) {
                            if (fArray3[i] < fArray2[i]) {
                                fArray5[i] = fArray4[i];
                                if (fArray2[i] == Float.POSITIVE_INFINITY) {
                                    f2 = Float.POSITIVE_INFINITY;
                                    continue;
                                }
                                f3 = (fArray3[i] - fArray2[i]) / fArray4[i];
                                if (f3 < f) {
                                    f = f3;
                                }
                                if (!(f3 > f2)) continue;
                                f2 = f3;
                                continue;
                            }
                            fArray5[i] = 0.0f;
                            continue;
                        }
                        if (fArray4[i] > 0.0f) {
                            if (fArray3[i] > fArray[i]) {
                                fArray5[i] = fArray4[i];
                                if (fArray[i] == Float.NEGATIVE_INFINITY) {
                                    f2 = Float.POSITIVE_INFINITY;
                                    continue;
                                }
                                f3 = (fArray3[i] - fArray[i]) / fArray4[i];
                                if (f3 < f) {
                                    f = f3;
                                }
                                if (!(f3 > f2)) continue;
                                f2 = f3;
                                continue;
                            }
                            fArray5[i] = 0.0f;
                            continue;
                        }
                        fArray5[i] = 0.0f;
                    }
                } else {
                    for (int i = 0; i < n; ++i) {
                        float f4;
                        if (fArray4[i] > 0.0f) {
                            if (fArray3[i] < fArray2[i]) {
                                fArray5[i] = fArray4[i];
                                if (fArray2[i] == Float.POSITIVE_INFINITY) {
                                    f2 = Float.POSITIVE_INFINITY;
                                    continue;
                                }
                                f4 = (fArray2[i] - fArray3[i]) / fArray4[i];
                                if (f4 < f) {
                                    f = f4;
                                }
                                if (!(f4 > f2)) continue;
                                f2 = f4;
                                continue;
                            }
                            fArray5[i] = 0.0f;
                            continue;
                        }
                        if (fArray4[i] < 0.0f) {
                            if (fArray3[i] > fArray[i]) {
                                fArray5[i] = fArray4[i];
                                if (fArray[i] == Float.NEGATIVE_INFINITY) {
                                    f2 = Float.POSITIVE_INFINITY;
                                    continue;
                                }
                                f4 = (fArray[i] - fArray3[i]) / fArray4[i];
                                if (f4 < f) {
                                    f = f4;
                                }
                                if (!(f4 > f2)) continue;
                                f2 = f4;
                                continue;
                            }
                            fArray5[i] = 0.0f;
                            continue;
                        }
                        fArray5[i] = 0.0f;
                    }
                }
                dArray[0] = f;
                dArray[1] = f2;
            }
        } else {
            double[] dArray2 = ((DoubleShapedVector)this.lowerBound).getData();
            double[] dArray3 = ((DoubleShapedVector)this.upperBound).getData();
            double[] dArray4 = ((DoubleShapedVector)vector).getData();
            double[] dArray5 = ((DoubleShapedVector)vector2).getData();
            double[] dArray6 = ((DoubleShapedVector)vector3).getData();
            if (dArray == null) {
                if (bl) {
                    for (int i = 0; i < n; ++i) {
                        dArray6[i] = dArray5[i] < 0.0 ? (dArray4[i] < dArray3[i] ? dArray5[i] : 0.0) : (dArray5[i] > 0.0 ? (dArray4[i] > dArray2[i] ? dArray5[i] : 0.0) : 0.0);
                    }
                } else {
                    for (int i = 0; i < n; ++i) {
                        dArray6[i] = dArray5[i] > 0.0 ? (dArray4[i] < dArray3[i] ? dArray5[i] : 0.0) : (dArray5[i] < 0.0 ? (dArray4[i] > dArray2[i] ? dArray5[i] : 0.0) : 0.0);
                    }
                }
            } else {
                double d = Double.POSITIVE_INFINITY;
                double d2 = 0.0;
                if (bl) {
                    for (int i = 0; i < n; ++i) {
                        double d3;
                        if (dArray5[i] < 0.0) {
                            if (dArray4[i] < dArray3[i]) {
                                dArray6[i] = dArray5[i];
                                if (dArray3[i] == Double.POSITIVE_INFINITY) {
                                    d2 = Double.POSITIVE_INFINITY;
                                    continue;
                                }
                                d3 = (dArray4[i] - dArray3[i]) / dArray5[i];
                                if (d3 < d) {
                                    d = d3;
                                }
                                if (!(d3 > d2)) continue;
                                d2 = d3;
                                continue;
                            }
                            dArray6[i] = 0.0;
                            continue;
                        }
                        if (dArray5[i] > 0.0) {
                            if (dArray4[i] > dArray2[i]) {
                                dArray6[i] = dArray5[i];
                                if (dArray2[i] == Double.NEGATIVE_INFINITY) {
                                    d2 = Double.POSITIVE_INFINITY;
                                    continue;
                                }
                                d3 = (dArray4[i] - dArray2[i]) / dArray5[i];
                                if (d3 < d) {
                                    d = d3;
                                }
                                if (!(d3 > d2)) continue;
                                d2 = d3;
                                continue;
                            }
                            dArray6[i] = 0.0;
                            continue;
                        }
                        dArray6[i] = 0.0;
                    }
                } else {
                    for (int i = 0; i < n; ++i) {
                        double d4;
                        if (dArray5[i] > 0.0) {
                            if (dArray4[i] < dArray3[i]) {
                                dArray6[i] = dArray5[i];
                                if (dArray3[i] == Double.POSITIVE_INFINITY) {
                                    d2 = Double.POSITIVE_INFINITY;
                                    continue;
                                }
                                d4 = (dArray3[i] - dArray4[i]) / dArray5[i];
                                if (d4 < d) {
                                    d = d4;
                                }
                                if (!(d4 > d2)) continue;
                                d2 = d4;
                                continue;
                            }
                            dArray6[i] = 0.0;
                            continue;
                        }
                        if (dArray5[i] < 0.0) {
                            if (dArray4[i] > dArray2[i]) {
                                dArray6[i] = dArray5[i];
                                if (dArray2[i] == Double.NEGATIVE_INFINITY) {
                                    d2 = Double.POSITIVE_INFINITY;
                                    continue;
                                }
                                d4 = (dArray2[i] - dArray4[i]) / dArray5[i];
                                if (d4 < d) {
                                    d = d4;
                                }
                                if (!(d4 > d2)) continue;
                                d2 = d4;
                                continue;
                            }
                            dArray6[i] = 0.0;
                            continue;
                        }
                        dArray6[i] = 0.0;
                    }
                }
                dArray[0] = d;
                dArray[1] = d2;
            }
        }
    }
}

