/*
 * Decompiled with CFR 0.152.
 */
package mitiv.optim;

import mitiv.optim.LineSearch;
import mitiv.optim.LineSearchTask;
import mitiv.optim.OptimStatus;

public class NonmonotoneLineSearch
extends LineSearch {
    private double sigma1 = 0.1;
    private double sigma2 = 0.9;
    private double ftol = 1.0E-4;
    private double[] fsav;
    private double fmax = Double.NEGATIVE_INFINITY;
    private final int m;
    private int mp;

    public double getTolerance() {
        return this.ftol;
    }

    public void setTolerance(double d) {
        if (Double.isNaN(d) || d <= 0.0 || d >= 1.0) {
            throw new IllegalArgumentException();
        }
        this.ftol = d;
    }

    public double getLowerBound() {
        return this.sigma1;
    }

    public double getUpperBound() {
        return this.sigma2;
    }

    public void setBounds(double d, double d2) {
        if (Double.isNaN(d) || Double.isNaN(d2) || d <= 0.0 || d >= d2 || d2 >= 1.0) {
            throw new IllegalArgumentException();
        }
        this.sigma1 = d;
        this.sigma2 = d2;
    }

    public NonmonotoneLineSearch() {
        this(10);
    }

    public NonmonotoneLineSearch(int n) {
        if (n < 1) {
            n = 1;
        }
        this.m = n;
        this.fsav = new double[n];
        this.reset();
    }

    @Override
    public boolean useDerivative() {
        return true;
    }

    private void reset() {
        this.mp = 0;
        for (int i = 0; i < this.m; ++i) {
            this.fsav[i] = Double.NEGATIVE_INFINITY;
        }
    }

    @Override
    protected void startHook() {
        this.fsav[this.mp % this.m] = this.finit;
        ++this.mp;
        int n = Math.min(this.mp, this.mp);
        this.fmax = this.fsav[0];
        for (int i = 1; i < n; ++i) {
            if (!(this.fmax < this.fsav[i])) continue;
            this.fmax = this.fsav[i];
        }
        this.success(LineSearchTask.SEARCH);
    }

    @Override
    public void iterateHook(double d, double d2) {
        if (d <= this.fmax + this.stp * this.ftol * this.ginit) {
            this.success(LineSearchTask.CONVERGENCE);
            return;
        }
        if (this.stp <= this.stpmin) {
            this.stp = this.stpmin;
            this.warning(OptimStatus.STEP_EQ_STPMIN);
            return;
        }
        double d3 = -this.ginit * this.stp * this.stp;
        double d4 = (d - this.finit - this.stp * this.ginit) * 2.0;
        this.stp = d4 > 0.0 && this.sigma1 * d4 <= d3 && d3 <= this.sigma2 * d4 * this.stp ? d3 / d4 : (this.stp + this.stpmin) / 2.0;
        this.stp = Math.max(this.stp, this.stpmin);
        if (this.stp > 0.0) {
            this.success(LineSearchTask.SEARCH);
        } else {
            this.warning(OptimStatus.STEP_EQ_STPMIN);
        }
    }

    public static void main(String[] stringArray) {
        NonmonotoneLineSearch nonmonotoneLineSearch = new NonmonotoneLineSearch(10);
        double d = 12.0;
        double d2 = 0.0;
        double d3 = -1.0;
        double d4 = 5.0;
        LineSearchTask lineSearchTask = nonmonotoneLineSearch.start(d2, d3, d, 0.0, 1.0E20 * d);
        System.out.println("state = " + (Object)((Object)lineSearchTask));
        System.out.println("finished = " + nonmonotoneLineSearch.finished());
        for (int i = 1; i <= 6; ++i) {
            d = nonmonotoneLineSearch.getStep();
            double d5 = d2 + d * (d3 + 0.5 * d4 * d);
            double d6 = d3 + d4 * d;
            lineSearchTask = nonmonotoneLineSearch.iterate(d5, d6);
            System.out.println("alpha[" + i + "] = " + d + ";" + " f[" + i + "] = " + d5 + ";" + " g[" + i + "] = " + d6 + ";" + " state[" + i + "] = " + (Object)((Object)lineSearchTask) + ";" + " finished[" + i + "] = " + nonmonotoneLineSearch.finished() + ";");
        }
    }
}

