/*
 * Decompiled with CFR 0.152.
 */
package mitiv.utils;

public class Poly {
    static final double THIRD = 0.3333333333333333;
    static final double HALF = 0.5;
    static final double TWO_PI_OVER_THREE = 2.0943951023931953;

    public static int solveQuadratic(double[] dArray, double d, double d2, double d3) {
        if (d != 0.0) {
            double d4 = d + d;
            double d5 = d3 + d3;
            double d6 = d2 * d2 - d4 * d5;
            if (d6 > 0.0) {
                double d7;
                d6 = d2 >= 0.0 ? -Math.sqrt(d6) - d2 : Math.sqrt(d6) - d2;
                double d8 = d5 / d6;
                if (d8 < (d7 = d6 / d4)) {
                    dArray[0] = d8;
                    dArray[1] = d7;
                } else {
                    dArray[0] = d7;
                    dArray[1] = d8;
                }
                return 2;
            }
            if (d6 == 0.0) {
                dArray[0] = dArray[1] = -d2 / d4;
                return 1;
            }
        } else if (d2 != 0.0) {
            dArray[0] = dArray[1] = -d3 / d2;
            return 1;
        }
        return 0;
    }

    public static int solveCubic(double[] dArray, double d, double d2, double d3) {
        double d4 = d * d;
        double d5 = 0.3333333333333333 * d;
        double d6 = (d4 - 0.5 * d2) * d5 + 0.5 * d3;
        double d7 = d6 * d6;
        double d8 = d4 - 0.3333333333333333 * d2;
        double d9 = d8 * d8 * d8;
        if (d7 < d9) {
            double d10;
            double d11 = 0.3333333333333333 * Math.acos(d6 / Math.sqrt(d9));
            double d12 = -2.0 * Math.sqrt(d8);
            double d13 = d12 * Math.cos(d11) - d5;
            double d14 = d12 * Math.cos(d11 - 2.0943951023931953) - d5;
            double d15 = d12 * Math.cos(d11 + 2.0943951023931953) - d5;
            if (d13 > d14) {
                d10 = d13;
                d13 = d14;
                d14 = d10;
            }
            if (d13 > d15) {
                d10 = d13;
                d13 = d15;
                d15 = d10;
            }
            if (d14 > d15) {
                d10 = d14;
                d14 = d15;
                d15 = d10;
            }
            dArray[0] = d13;
            dArray[1] = d14;
            dArray[2] = d15;
            return 3;
        }
        double d16 = Math.sqrt(d7 - d9);
        double d17 = d6 >= 0.0 ? -Math.cbrt(d6 + d16) : Math.cbrt(d16 - d6);
        dArray[0] = d17 == 0.0 ? -d5 : d17 + d8 / d17 - d5;
        return 1;
    }
}

