/*
 * Decompiled with CFR 0.152.
 */
package mitiv.utils;

import mitiv.array.ArrayFactory;
import mitiv.array.ByteArray;
import mitiv.array.DoubleArray;
import mitiv.array.FloatArray;
import mitiv.array.IntArray;
import mitiv.array.LongArray;
import mitiv.array.ShapedArray;
import mitiv.array.ShortArray;

public class WeightFactory {
    private WeightFactory() {
    }

    public static ShapedArray defaultWeights(ShapedArray shapedArray) {
        switch (shapedArray.getType()) {
            case 4: {
                float[] fArray = new float[shapedArray.getNumber()];
                WeightFactory.defaultWeights(fArray, ((FloatArray)shapedArray).flatten(false));
                return ArrayFactory.wrap(fArray, shapedArray.getShape());
            }
            case 5: {
                double[] dArray = new double[shapedArray.getNumber()];
                WeightFactory.defaultWeights(dArray, ((DoubleArray)shapedArray).flatten(false));
                return ArrayFactory.wrap(dArray, shapedArray.getShape());
            }
        }
        throw new IllegalArgumentException("Unsupported data type");
    }

    public static void defaultWeights(float[] fArray, float[] fArray2) {
        WeightFactory.computeWeightsFromData(fArray, fArray2, 0.0f, 1.0f);
    }

    public static void defaultWeights(double[] dArray, double[] dArray2) {
        WeightFactory.computeWeightsFromData(dArray, dArray2, 0.0, 1.0);
    }

    public static ShapedArray computeWeightsFromVariance(ShapedArray shapedArray) {
        switch (shapedArray.getType()) {
            case 4: {
                float[] fArray = new float[shapedArray.getNumber()];
                WeightFactory.computeWeightsFromVariance(fArray, ((FloatArray)shapedArray).flatten(false));
                return ArrayFactory.wrap(fArray, shapedArray.getShape());
            }
            case 5: {
                double[] dArray = new double[shapedArray.getNumber()];
                WeightFactory.computeWeightsFromVariance(dArray, ((DoubleArray)shapedArray).flatten(false));
                return ArrayFactory.wrap(dArray, shapedArray.getShape());
            }
        }
        throw new IllegalArgumentException("Unsupported data type");
    }

    public static void computeWeightsFromVariance(float[] fArray, float[] fArray2) {
        if (fArray.length != fArray2.length) {
            throw new IllegalArgumentException("Weighting and variance arrays must have the same length");
        }
        for (int i = 0; i < fArray.length; ++i) {
            if (WeightFactory.isnan(fArray2[i]) || fArray2[i] <= 0.0f) {
                throw new IllegalArgumentException("Invalid variance value(s)");
            }
            fArray[i] = WeightFactory.isinf(fArray2[i]) ? 0.0f : 1.0f / fArray2[i];
        }
    }

    public static void computeWeightsFromVariance(double[] dArray, double[] dArray2) {
        if (dArray.length != dArray2.length) {
            throw new IllegalArgumentException("Weighting and variance arrays must have the same length");
        }
        for (int i = 0; i < dArray.length; ++i) {
            if (WeightFactory.isnan(dArray2[i]) || dArray2[i] <= 0.0) {
                throw new IllegalArgumentException("Invalid variance value(s)");
            }
            dArray[i] = WeightFactory.isinf(dArray2[i]) ? 0.0 : 1.0 / dArray2[i];
        }
    }

    public static ShapedArray computeWeightsFromData(ShapedArray shapedArray, double d, double d2, double d3) {
        switch (shapedArray.getType()) {
            case 4: {
                float[] fArray = new float[shapedArray.getNumber()];
                WeightFactory.computeWeightsFromData(fArray, ((FloatArray)shapedArray).flatten(false), (float)d, (float)d2, (float)d3);
                return ArrayFactory.wrap(fArray, shapedArray.getShape());
            }
            case 5: {
                double[] dArray = new double[shapedArray.getNumber()];
                WeightFactory.computeWeightsFromData(dArray, ((DoubleArray)shapedArray).flatten(false), d, d2, d3);
                return ArrayFactory.wrap(dArray, shapedArray.getShape());
            }
        }
        throw new IllegalArgumentException("Unsupported data type");
    }

    public static ShapedArray computeWeightsFromData(ShapedArray shapedArray, double d, double d2) {
        return WeightFactory.computeWeightsFromData(shapedArray, d, d2, Double.NaN);
    }

    public static int computeWeightsFromData(float[] fArray, float[] fArray2, float f, float f2, float f3) {
        int n = 0;
        if (WeightFactory.isnan(f) || WeightFactory.isinf(f) || f < 0.0f) {
            throw new IllegalArgumentException("Parameter ALPHA must be finite and nonnegative");
        }
        if (WeightFactory.isnan(f2) || WeightFactory.isinf(f2) || f2 <= 0.0f) {
            throw new IllegalArgumentException("Parameter BETA must be finite and strictly positive");
        }
        if (fArray.length != fArray2.length) {
            throw new IllegalArgumentException("Weighting and data arrays must have the same length");
        }
        float f4 = 1.0f / f2;
        int n2 = fArray2.length;
        if (WeightFactory.isnan(f3) || WeightFactory.isinf(f3)) {
            if (f > 0.0f) {
                for (int i = 0; i < n2; ++i) {
                    if (WeightFactory.isinf(fArray2[i]) || WeightFactory.isnan(fArray2[i])) {
                        fArray[i] = 0.0f;
                        continue;
                    }
                    if (fArray2[i] > 0.0f) {
                        fArray[i] = 1.0f / (f * fArray2[i] + f2);
                        ++n;
                        continue;
                    }
                    fArray[i] = f4;
                    ++n;
                }
            } else {
                for (int i = 0; i < n2; ++i) {
                    if (WeightFactory.isinf(fArray2[i]) || WeightFactory.isnan(fArray2[i])) {
                        fArray[i] = 0.0f;
                        continue;
                    }
                    fArray[i] = f4;
                    ++n;
                }
            }
        } else if (f > 0.0f) {
            for (int i = 0; i < n2; ++i) {
                if (fArray2[i] == f3 || WeightFactory.isinf(fArray2[i]) || WeightFactory.isnan(fArray2[i])) {
                    fArray[i] = 0.0f;
                    continue;
                }
                if (fArray2[i] > 0.0f) {
                    fArray[i] = 1.0f / (f * fArray2[i] + f2);
                    ++n;
                    continue;
                }
                fArray[i] = f4;
                ++n;
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                if (fArray2[i] == f3 || WeightFactory.isinf(fArray2[i]) || WeightFactory.isnan(fArray2[i])) {
                    fArray[i] = 0.0f;
                    continue;
                }
                if (!(fArray[i] > 0.0f)) continue;
                fArray[i] = f4;
                ++n;
            }
        }
        return n;
    }

    public static int computeWeightsFromData(float[] fArray, float[] fArray2, float f, float f2) {
        return WeightFactory.computeWeightsFromData(fArray, fArray2, f, f2, Float.NaN);
    }

    public static int computeWeightsFromData(double[] dArray, double[] dArray2, double d, double d2, double d3) {
        int n = 0;
        if (WeightFactory.isnan(d) || WeightFactory.isinf(d) || d < 0.0) {
            throw new IllegalArgumentException("Parameter ALPHA must be finite and nonnegative");
        }
        if (WeightFactory.isnan(d2) || WeightFactory.isinf(d2) || d2 <= 0.0) {
            throw new IllegalArgumentException("Parameter BETA must be finite and strictly positive");
        }
        if (dArray.length != dArray2.length) {
            throw new IllegalArgumentException("Weighting and data arrays must have the same length");
        }
        double d4 = 1.0 / d2;
        int n2 = dArray2.length;
        if (WeightFactory.isnan(d3) || WeightFactory.isinf(d3)) {
            if (d > 0.0) {
                for (int i = 0; i < n2; ++i) {
                    if (WeightFactory.isinf(dArray2[i]) || WeightFactory.isnan(dArray2[i])) {
                        dArray[i] = 0.0;
                        continue;
                    }
                    if (dArray2[i] > 0.0) {
                        dArray[i] = 1.0 / (d * dArray2[i] + d2);
                        ++n;
                        continue;
                    }
                    dArray[i] = d4;
                    ++n;
                }
            } else {
                for (int i = 0; i < n2; ++i) {
                    if (WeightFactory.isinf(dArray2[i]) || WeightFactory.isnan(dArray2[i])) {
                        dArray[i] = 0.0;
                        continue;
                    }
                    dArray[i] = d4;
                    ++n;
                }
            }
        } else if (d > 0.0) {
            for (int i = 0; i < n2; ++i) {
                if (dArray2[i] == d3 || WeightFactory.isinf(dArray2[i]) || WeightFactory.isnan(dArray2[i])) {
                    dArray[i] = 0.0;
                    continue;
                }
                if (dArray2[i] > 0.0) {
                    dArray[i] = 1.0 / (d * dArray2[i] + d2);
                    ++n;
                    continue;
                }
                dArray[i] = d4;
                ++n;
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                if (dArray2[i] == d3 || WeightFactory.isinf(dArray2[i]) || WeightFactory.isnan(dArray2[i])) {
                    dArray[i] = 0.0;
                    continue;
                }
                if (!(dArray[i] > 0.0)) continue;
                dArray[i] = d4;
                ++n;
            }
        }
        return n;
    }

    public static int computeWeightsFromData(double[] dArray, double[] dArray2, double d, double d2) {
        return WeightFactory.computeWeightsFromData(dArray, dArray2, d, d2, Double.NaN);
    }

    public static void removeBads(ShapedArray shapedArray, ShapedArray shapedArray2) {
        boolean[] blArray;
        if (!shapedArray.getShape().equals(shapedArray2.getShape())) {
            throw new IllegalArgumentException("Array of weights and bad data must have the same shape");
        }
        if (!shapedArray.isFlat()) {
            throw new IllegalArgumentException("Weights must be a flat array");
        }
        switch (shapedArray2.getType()) {
            case 0: {
                blArray = WeightFactory.toBoolean(((ByteArray)shapedArray2).flatten(false));
                break;
            }
            case 1: {
                blArray = WeightFactory.toBoolean(((ShortArray)shapedArray2).flatten(false));
                break;
            }
            case 2: {
                blArray = WeightFactory.toBoolean(((IntArray)shapedArray2).flatten(false));
                break;
            }
            case 3: {
                blArray = WeightFactory.toBoolean(((LongArray)shapedArray2).flatten(false));
                break;
            }
            case 4: {
                blArray = WeightFactory.toBoolean(((FloatArray)shapedArray2).flatten(false));
                break;
            }
            case 5: {
                blArray = WeightFactory.toBoolean(((DoubleArray)shapedArray2).flatten(false));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported data type");
            }
        }
        switch (shapedArray.getType()) {
            case 4: {
                WeightFactory.removeBads(((FloatArray)shapedArray).flatten(false), blArray);
                break;
            }
            case 5: {
                WeightFactory.removeBads(((DoubleArray)shapedArray).flatten(false), blArray);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported data type");
            }
        }
    }

    public static final void removeBads(float[] fArray, boolean[] blArray) {
        if (fArray.length != blArray.length) {
            throw new IllegalArgumentException("Array of weights and bad data must have the same length");
        }
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            if (!blArray[i]) continue;
            fArray[i] = 0.0f;
        }
    }

    public static final void removeBads(double[] dArray, boolean[] blArray) {
        if (dArray.length != blArray.length) {
            throw new IllegalArgumentException("Array of weights and bad data must have the same length");
        }
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            if (!blArray[i]) continue;
            dArray[i] = 0.0;
        }
    }

    public static void checkWeights(ShapedArray shapedArray) {
        switch (shapedArray.getType()) {
            case 4: {
                WeightFactory.checkWeights(((FloatArray)shapedArray).flatten(false));
                break;
            }
            case 5: {
                WeightFactory.checkWeights(((DoubleArray)shapedArray).flatten(false));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported data type");
            }
        }
    }

    public static void checkWeights(float[] fArray) {
        int n = fArray.length;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (WeightFactory.isinf(fArray[i]) || WeightFactory.isnan(fArray[i]) || fArray[i] < 0.0f) {
                throw new IllegalArgumentException("Invalid weight value");
            }
            if (!(fArray[i] > 0.0f)) continue;
            ++n2;
        }
        if (n2 < 1) {
            throw new IllegalArgumentException("No valid data!");
        }
    }

    public static void checkWeights(double[] dArray) {
        int n = dArray.length;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (WeightFactory.isinf(dArray[i]) || WeightFactory.isnan(dArray[i]) || dArray[i] < 0.0) {
                throw new IllegalArgumentException("Invalid weight value");
            }
            if (!(dArray[i] > 0.0)) continue;
            ++n2;
        }
        if (n2 < 1) {
            throw new IllegalArgumentException("No valid data!");
        }
    }

    public static void fixWeightsAndData(ShapedArray shapedArray, ShapedArray shapedArray2) {
        if (!shapedArray.getShape().equals(shapedArray2.getShape())) {
            throw new IllegalArgumentException("Array of weights and data must have the same shape");
        }
        if (!shapedArray.isFlat()) {
            throw new IllegalArgumentException("Weights must be a flat array");
        }
        if (!shapedArray2.isFlat()) {
            throw new IllegalArgumentException("Data must be a flat array");
        }
        if (shapedArray.getType() != shapedArray2.getType()) {
            throw new IllegalArgumentException("Data and weights have the same element type");
        }
        switch (shapedArray2.getType()) {
            case 4: {
                WeightFactory.fixWeightsAndData(((FloatArray)shapedArray).flatten(false), ((FloatArray)shapedArray2).flatten(false));
                break;
            }
            case 5: {
                WeightFactory.fixWeightsAndData(((DoubleArray)shapedArray).flatten(false), ((DoubleArray)shapedArray2).flatten(false));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported data type");
            }
        }
    }

    public static void fixWeightsAndData(float[] fArray, float[] fArray2) {
        if (fArray.length != fArray2.length) {
            throw new IllegalArgumentException("Weighting and data arrays must have the same length");
        }
        int n = fArray.length;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (fArray[i] == 0.0f) {
                fArray2[i] = 0.0f;
                continue;
            }
            if (WeightFactory.isinf(fArray[i]) || WeightFactory.isnan(fArray[i]) || fArray[i] < 0.0f) {
                throw new IllegalArgumentException("Invalid weight value");
            }
            if (WeightFactory.isinf(fArray2[i]) || WeightFactory.isnan(fArray2[i])) {
                fArray[i] = 0.0f;
                fArray2[i] = 0.0f;
                continue;
            }
            ++n2;
        }
        if (n2 < 1) {
            throw new IllegalArgumentException("No valid data!");
        }
    }

    public static void fixWeightsAndData(double[] dArray, double[] dArray2) {
        if (dArray.length != dArray2.length) {
            throw new IllegalArgumentException("Weighting and data arrays must have the same length");
        }
        int n = dArray.length;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (dArray[i] == 0.0) {
                dArray2[i] = 0.0;
                continue;
            }
            if (WeightFactory.isinf(dArray[i]) || WeightFactory.isnan(dArray[i]) || dArray[i] < 0.0) {
                throw new IllegalArgumentException("Invalid weight value");
            }
            if (WeightFactory.isinf(dArray2[i]) || WeightFactory.isnan(dArray2[i])) {
                dArray[i] = 0.0;
                dArray2[i] = 0.0;
                continue;
            }
            ++n2;
        }
        if (n2 < 1) {
            throw new IllegalArgumentException("No valid data!");
        }
    }

    private static final boolean isinf(float f) {
        return Float.isInfinite(f);
    }

    private static final boolean isnan(float f) {
        return Float.isNaN(f);
    }

    private static final boolean isinf(double d) {
        return Double.isInfinite(d);
    }

    private static final boolean isnan(double d) {
        return Double.isNaN(d);
    }

    private static final boolean[] toBoolean(byte[] byArray) {
        boolean[] blArray = new boolean[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            blArray[i] = byArray[i] != 0;
        }
        return blArray;
    }

    private static final boolean[] toBoolean(short[] sArray) {
        boolean[] blArray = new boolean[sArray.length];
        for (int i = 0; i < sArray.length; ++i) {
            blArray[i] = sArray[i] != 0;
        }
        return blArray;
    }

    private static final boolean[] toBoolean(int[] nArray) {
        boolean[] blArray = new boolean[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            blArray[i] = nArray[i] != 0;
        }
        return blArray;
    }

    private static final boolean[] toBoolean(long[] lArray) {
        boolean[] blArray = new boolean[lArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            blArray[i] = lArray[i] != 0L;
        }
        return blArray;
    }

    private static final boolean[] toBoolean(float[] fArray) {
        boolean[] blArray = new boolean[fArray.length];
        for (int i = 0; i < fArray.length; ++i) {
            blArray[i] = fArray[i] != 0.0f;
        }
        return blArray;
    }

    private static final boolean[] toBoolean(double[] dArray) {
        boolean[] blArray = new boolean[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            blArray[i] = dArray[i] != 0.0;
        }
        return blArray;
    }
}

