package plugins.ylemontag.sequencecomparator;

import icy.image.IcyBufferedImage;
import icy.sequence.Sequence;
import icy.type.DataType;

/**
 * 
 * @author Yoann Le Montagner
 *
 * Compute an error map between two sequences
 */
public abstract class LocalComparator extends Comparator<Sequence>
{
	/**
	 * Constructor
	 */
	public LocalComparator(String distanceName)
	{
		super(distanceName);
	}
	
	@Override
	protected Sequence allocateResult()
	{
		return new Sequence();
	}
	
	/**
	 * Initialize a new difference map
	 */
	protected void makeDifferenceMap(Sequence ref, Sequence seq, Sequence out)
	{
		// Update the name of the output map
		out.setName(getComparisonLabel(ref, seq));
		
		// Check that the error map has a correct size
		int sizeX = seq.getSizeX();
		int sizeY = seq.getSizeY();
		int sizeZ = seq.getSizeZ();
		int sizeT = seq.getSizeT();
		int sizeC = seq.getSizeC();
		if(
			out.getSizeX()!=sizeX ||
			out.getSizeY()!=sizeY ||
			out.getSizeZ()!=sizeZ ||
			out.getSizeT()!=sizeT ||
			out.getSizeC()!=sizeC
		)
		{
			// If not the case, resize the output sequence 
			out.beginUpdate();
			try {
				out.removeAllImages();
				for(int t=0; t<sizeT; ++t) {
					for(int z=0; z<sizeZ; ++z) {
						IcyBufferedImage currentFrame = new IcyBufferedImage(sizeX, sizeY, sizeC, DataType.DOUBLE);
						out.setImage(t, z, currentFrame);
					}
				}
			}
			finally {
				out.endUpdate();
			}
		}
	}
}
