package plugins.ylemontag.sequencecomparator.comparators;


/**
 * 
 * @author Yoann Le Montagner
 * 
 * Global distance generator for distances which can be computed by aggregating
 * the pixelwise distances between the two compared sequences
 */
public abstract class PixelSeparableGlobalComparator extends PlaneSeparableGlobalComparator
{
	/**
	 * Constructor
	 */
	public PixelSeparableGlobalComparator(String distanceName)
	{
		super(distanceName);
	}
	
	/**
	 * Aggregation function
	 */
	protected abstract double aggregateInsideXY(double accu, double refPixel, double seqPixel);
	
	@Override
	protected double computePlaneError(int sizeX, int sizeY, double[] refPlane, double[] seqPlane)
	{
		int sizeXY = sizeX*sizeY;
		double accu = 0;
		for(int xy=0; xy<sizeXY; ++xy) {
			accu = aggregateInsideXY(accu, refPlane[xy], seqPlane[xy]);
		}
		return accu;
	}
}
