package plugins.tprovoost.painting.shapes;

import java.awt.Point;
import java.awt.geom.QuadCurve2D;

import plugins.tprovoost.painting.PaintingTools;

public class CurveShape extends PaintingShape
{

    private int x1;
    private int y1;
    private int ctrlx;
    private int ctrly;
    private int x2;
    private int y2;
    private boolean lockB = false;

    public CurveShape(PaintingTools tools, int x1, int y1, int x2, int y2)
    {
        super(tools);

        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
        this.ctrlx = x2;
        this.ctrly = y2;
        shape = new QuadCurve2D.Double(x1, y1, ctrlx, ctrly, x2, y2);
    }

    @Override
    public void update(Point p)
    {
        if (!lockB)
        {
            this.x2 = p.x;
            this.y2 = p.y;
        }
        else
        {
            ctrlx = p.x;
            ctrly = p.y;
        }
        ((QuadCurve2D) shape).setCurve(x1, y1, ctrlx, ctrly, x2, y2);
    }

    public void lockPointB()
    {
        this.lockB = true;
    }

    public boolean isPointBLocked()
    {
        return lockB;
    }
}
