package plugins.tboudier.filters3D;

import icy.sequence.Sequence;
import icy.sequence.VolumetricImage;
import icy.type.DataType;
import mcib3d.image3d.ICY_Utils;
import mcib3d.image3d.ImageHandler;
import mcib3d.image3d.processing.FastFilters3D;
import mcib3d.utils.Logger.ICYProgress;
import mcib3d.utils.Logger.NoLog;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.ezplug.*;

enum EnumFilters {
    MEAN, MEDIAN, ADAPTATIVE, MAXIMUM, MINIMUM, MAXLOCAL, OPENGRAY, CLOSEGRAY, TOPHAT, VARIANCE
}

public class Filters3D extends EzPlug implements Block {

    EzVarEnum<EnumFilters> EZEnum = new EzVarEnum<EnumFilters>("enumeration", EnumFilters.values());
    private EzVarDouble EZVarRadXY = new EzVarDouble("Radius XY", 2, 0, 100, 0.5);
    private EzVarDouble EZVarRadZ = new EzVarDouble("Radius Z", 2, 0, 100, 0.5);
    private EzVarBoolean EZVarMultithreading = new EzVarBoolean("Multithreading", true);
    private EzVarSequence EZSequence = new EzVarSequence("Image");
    private EzVarSequence EZSequence2 = new EzVarSequence("Image2");

    @Override
    protected void initialize() {
        // TODO Auto-generated by Icy4Eclipse
        super.addEzComponent(EZSequence);
        super.addEzComponent(EZEnum);
        super.addEzComponent(EZVarRadXY);
        super.addEzComponent(EZVarRadZ);
        super.addEzComponent(EZVarMultithreading);
    }

    @Override
    protected void execute() {
        Sequence seq = EZSequence.getValue();

        DataType type = (seq.getDataType_());
        int nbcol = seq.getSizeC();
        int nbframe = seq.getSizeT();
        int nbCpus = EZVarMultithreading.getValue() ? 0 : 1;
        ImageHandler img;
        boolean gui = !isHeadLess();

        if (gui) {
            super.getUI().setProgressBarVisible(true);
        }

        for (int c = 0; c < nbcol; c++) {
            Sequence seqOut = new Sequence();
            for (int t = 0; t < nbframe; t++) {
                /*
                if (gui) {
                    super.getUI().setProgressBarMessage("Processing " + (t + 1));
                }
                */
                if (gui) {
                    super.getUI().setProgressBarValue((double) ((t + 1) + (c * nbframe)) / (double) (nbframe * nbcol));
                }


                img = ICY_Utils.createImageHandlerFromSequence(seq, t, c);

                // filters 3D
                int filt = 0;
                switch (EZEnum.getValue()) {
                    case MEAN:
                        filt = FastFilters3D.MEAN;
                        break;
                    case MEDIAN:
                        filt = FastFilters3D.MEDIAN;
                        break;
                    case TOPHAT:
                        filt = FastFilters3D.TOPHAT;
                        break;
                    case MAXIMUM:
                        filt = FastFilters3D.MAX;
                        break;
                    case MINIMUM:
                        filt = FastFilters3D.MIN;
                        break;
                    case MAXLOCAL:
                        filt = FastFilters3D.MAXLOCAL;
                        break;
                    case OPENGRAY:
                        filt = FastFilters3D.OPENGRAY;
                        break;
                    case VARIANCE:
                        filt = FastFilters3D.VARIANCE;
                        break;
                    case CLOSEGRAY:
                        filt = FastFilters3D.CLOSEGRAY;
                        break;
                    case ADAPTATIVE:
                        filt = FastFilters3D.ADAPTIVE;
                        break;
                }

                if (gui) {
                    String header = "";
                    if ((nbcol > 1) && (nbframe > 1)) header = header.concat("C" + c + " T" + t);
                    else if (nbframe > 1) header = header.concat("T" + t);
                    else if (nbcol > 1) header = header.concat("C" + c);
                    FastFilters3D.setLog(new ICYProgress(super.getUI(), header));
                } else FastFilters3D.setLog(new NoLog());
                ImageHandler res = FastFilters3D.filterImage(img, filt, EZVarRadXY.getValue().floatValue(), EZVarRadXY.getValue().floatValue(), EZVarRadZ.getValue().floatValue(), nbCpus, false);
                VolumetricImage vol = seqOut.addVolumetricImage();
                ICY_Utils.createVolumeFromImageHandler(res, type, vol);
            }
            seqOut.setName("Filter3D-" + EZEnum.getValue() + "-C" + c);
            seqOut.setPixelSizeX(seq.getPixelSizeX());
            seqOut.setPixelSizeY(seq.getPixelSizeY());
            seqOut.setPixelSizeZ(seq.getPixelSizeZ());
            seqOut.dataChanged();
            if (gui) {
                addSequence(seqOut);
            }
            EZSequence2.setValue(seqOut);
        }
    }


    @Override
    public void clean() {
    }

    @Override
    public void declareInput(VarList inputMap) {
        inputMap.add("RadiusXY", EZVarRadXY.getVariable());
        inputMap.add("RadiusZ", EZVarRadZ.getVariable());
        inputMap.add("Mutithreading", EZVarMultithreading.getVariable());
        inputMap.add("Image", EZSequence.getVariable());
        inputMap.add("Filter", EZEnum.getVariable());
    }

    @Override
    public void declareOutput(VarList outputMap) {
        outputMap.add("filteredSequence", EZSequence2.getVariable());
    }
}
