/*
 * Decompiled with CFR 0.152.
 */
package mcib3d.utils;

import java.util.Arrays;

public class KDTreeC {
    private final int dimensions;
    private final int bucket_size;
    private NodeKD root;
    private double[] scale;

    public KDTreeC(int dimensions) {
        this.dimensions = dimensions;
        this.bucket_size = 64;
        this.root = new NodeKD(this);
        double[] tmp = new double[]{1.0, 1.0, 1.0};
    }

    public KDTreeC(int dimensions, int bucket) {
        this.dimensions = dimensions;
        this.bucket_size = bucket;
        this.root = new NodeKD(this);
    }

    public void setScale(double[] sc) {
        double[] tmp = new double[]{sc[0] * sc[0], sc[1] * sc[1], sc[2] * sc[2]};
        this.setScaleSq(tmp);
    }

    public void setScale3(double rx, double ry, double rz) {
        double[] tmp = new double[]{rx * rx, ry * ry, rz * rz};
        this.setScaleSq(tmp);
    }

    private void setScaleSq(double[] scale_) {
        this.scale = scale_;
    }

    public void add(double[] key, Object val) {
        this.root.add(new Item(key, val));
    }

    public Item[] getRange(double[] low, double[] high) {
        return this.root.range(high, low);
    }

    public Item[] getNearestNeighbor(double[] key, int num) {
        ShiftArray arr = new ShiftArray(num);
        this.root.nearestn(arr, key);
        return arr.getArray();
    }

    public double distance(double[] a, double[] b) {
        double total = 0.0;
        for (int i = 0; i < a.length; ++i) {
            total += (b[i] - a[i]) * (b[i] - a[i]) * this.scale[i];
        }
        return Math.sqrt(total);
    }

    public double distanceSq(double[] a, double[] b) {
        double total = 0.0;
        for (int i = 0; i < a.length; ++i) {
            total += (b[i] - a[i]) * (b[i] - a[i]) * this.scale[i];
        }
        return total;
    }

    private class ShiftArray {
        private Item[] items;
        private final int max;
        private int current;

        private ShiftArray(int maximum) {
            this.max = maximum;
            this.current = 0;
            this.items = new Item[this.max];
        }

        private void add(Item m) {
            int i;
            for (i = this.current; i > 0 && this.items[i - 1].distanceSq > m.distanceSq; --i) {
            }
            if (i >= this.max) {
                return;
            }
            if (this.current < this.max) {
                ++this.current;
            }
            System.arraycopy(this.items, i, this.items, i + 1, this.current - (i + 1));
            this.items[i] = m;
        }

        private double getLongest() {
            if (this.current < this.max) {
                return Double.POSITIVE_INFINITY;
            }
            return this.items[this.max - 1].distanceSq;
        }

        private Item[] getArray() {
            return (Item[])this.items.clone();
        }
    }

    private class NodeKD {
        private KDTreeC owner;
        private NodeKD left;
        private NodeKD right;
        private double[] upper;
        private double[] lower;
        private Item[] bucket;
        private int current;
        private int dim;
        private double slice;

        private NodeKD(KDTreeC own) {
            this.owner = own;
            this.lower = null;
            this.upper = null;
            this.right = null;
            this.left = null;
            this.bucket = new Item[own.bucket_size];
            this.current = 0;
            this.dim = 0;
        }

        private NodeKD(NodeKD node) {
            this.owner = node.owner;
            this.dim = node.dim + 1;
            this.bucket = new Item[this.owner.bucket_size];
            if (this.dim + 1 > this.owner.dimensions) {
                this.dim = 0;
            }
            this.right = null;
            this.left = null;
            this.lower = null;
            this.upper = null;
            this.current = 0;
        }

        private void add(Item m) {
            if (this.bucket == null) {
                if (m.pnt[this.dim] > this.slice) {
                    this.right.add(m);
                } else {
                    this.left.add(m);
                }
            } else {
                if (this.current + 1 > this.owner.bucket_size) {
                    this.split(m);
                    return;
                }
                this.bucket[this.current++] = m;
            }
            this.expand(m.pnt);
        }

        private void nearestn(ShiftArray arr, double[] data) {
            block4: {
                block2: {
                    block3: {
                        if (this.bucket != null) break block2;
                        if (!(data[this.dim] > this.slice)) break block3;
                        this.right.nearestn(arr, data);
                        if (this.left.current != 0 && this.owner.distanceSq(this.left.nearestRect(data), data) < arr.getLongest()) {
                            this.left.nearestn(arr, data);
                        }
                        break block4;
                    }
                    this.left.nearestn(arr, data);
                    if (this.right.current == 0 || !(this.owner.distanceSq(this.right.nearestRect(data), data) < arr.getLongest())) break block4;
                    this.right.nearestn(arr, data);
                    break block4;
                }
                for (int i = 0; i < this.current; ++i) {
                    this.bucket[i].distanceSq = this.owner.distanceSq(this.bucket[i].pnt, data);
                    arr.add(this.bucket[i]);
                }
            }
        }

        private Item[] range(double[] upper, double[] lower) {
            if (this.bucket == null) {
                Item[] tmp = new Item[]{};
                if (this.intersects(upper, lower, this.left.upper, this.left.lower)) {
                    Item[] tmpl = this.left.range(upper, lower);
                    if (0 == tmp.length) {
                        tmp = tmpl;
                    }
                }
                if (this.intersects(upper, lower, this.right.upper, this.right.lower)) {
                    Item[] tmpr = this.right.range(upper, lower);
                    if (0 == tmp.length) {
                        tmp = tmpr;
                    } else if (0 < tmpr.length) {
                        Item[] tmp2 = new Item[tmp.length + tmpr.length];
                        System.arraycopy(tmp, 0, tmp2, 0, tmp.length);
                        System.arraycopy(tmpr, 0, tmp2, tmp.length, tmpr.length);
                        tmp = tmp2;
                    }
                }
                return tmp;
            }
            Item[] tmp = new Item[this.current];
            int n = 0;
            for (int i = 0; i < this.current; ++i) {
                if (!this.contains(upper, lower, this.bucket[i].pnt)) continue;
                tmp[n++] = this.bucket[i];
            }
            Item[] tmp2 = new Item[n];
            System.arraycopy(tmp, 0, tmp2, 0, n);
            return tmp2;
        }

        public boolean contains(double[] upper, double[] lower, double[] point) {
            if (this.current == 0) {
                return false;
            }
            for (int i = 0; i < point.length; ++i) {
                if (!(point[i] > upper[i]) && !(point[i] < lower[i])) continue;
                return false;
            }
            return true;
        }

        public boolean intersects(double[] up0, double[] low0, double[] up1, double[] low1) {
            for (int i = 0; i < up0.length; ++i) {
                if (!(up1[i] < low0[i]) && !(low1[i] > up0[i])) continue;
                return false;
            }
            return true;
        }

        private void split(Item m) {
            this.slice = (this.upper[this.dim] + this.lower[this.dim]) / 2.0;
            this.left = new NodeKD(this);
            this.right = new NodeKD(this);
            for (int i = 0; i < this.current; ++i) {
                if (this.bucket[i].pnt[this.dim] > this.slice) {
                    this.right.add(this.bucket[i]);
                    continue;
                }
                this.left.add(this.bucket[i]);
            }
            this.bucket = null;
            this.add(m);
        }

        private double[] nearestRect(double[] data) {
            double[] nearest = (double[])data.clone();
            for (int i = 0; i < data.length; ++i) {
                if (nearest[i] > this.upper[i]) {
                    nearest[i] = this.upper[i];
                }
                if (!(nearest[i] < this.lower[i])) continue;
                nearest[i] = this.lower[i];
            }
            return nearest;
        }

        private void expand(double[] data) {
            if (this.upper == null) {
                this.upper = Arrays.copyOf(data, this.owner.dimensions);
                this.lower = Arrays.copyOf(data, this.owner.dimensions);
                return;
            }
            for (int i = 0; i < data.length; ++i) {
                if (this.upper[i] < data[i]) {
                    this.upper[i] = data[i];
                }
                if (!(this.lower[i] > data[i])) continue;
                this.lower[i] = data[i];
            }
        }
    }

    public class Item {
        public double[] pnt;
        public Object obj;
        public double distanceSq;

        private Item(double[] p, Object o) {
            this.pnt = p;
            this.obj = o;
        }
    }
}

