/*
 * Decompiled with CFR 0.152.
 */
package mcib3d.image3d;

import java.util.ArrayList;
import java.util.Comparator;
import mcib3d.geom.IntCoord3D;
import mcib3d.geom.Voxel3D;
import mcib3d.image3d.ImageHandler;

public class Coordinate3D {
    public int sizeX;
    public int sizeY;
    public int sizeZ;
    public int sizeXY;
    public int sizeXYZ;
    private int coord;
    public int x;
    public int y;
    public int z;
    private int[][] vois;
    private float[] distances;

    public Coordinate3D(int coord, int sizeX, int sizeY, int sizeZ) {
        this.coord = coord;
        this.sizeX = sizeX;
        this.sizeY = sizeY;
        this.sizeXY = sizeX * sizeY;
        this.sizeZ = sizeZ;
        this.sizeXYZ = this.sizeXY * sizeZ;
        this.computeXYZ();
    }

    public void setCoord(int c) {
        this.coord = c;
        this.computeXYZ();
    }

    public void setCoord(int c, int x, int y, int z) {
        this.coord = c;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void setCoord(int x, int y, int z) {
        this.coord = x + z * this.sizeXY + y * this.sizeX;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public boolean hasNext() {
        ++this.coord;
        ++this.x;
        if (this.x == this.sizeX) {
            this.x = 0;
            ++this.y;
            if (this.y == this.sizeY) {
                this.y = 0;
                ++this.z;
                if (this.z == this.sizeZ) {
                    return false;
                }
            }
        }
        return true;
    }

    public boolean isIn() {
        return this.x >= 0 && this.x < this.sizeX && this.y >= 0 && this.y < this.sizeY && this.z >= 0 && this.z < this.sizeZ;
    }

    public boolean isIn(int xx, int yy, int zz) {
        return xx >= 0 && xx < this.sizeX && yy >= 0 && yy < this.sizeY && zz >= 0 && zz < this.sizeZ;
    }

    public String print() {
        return " x:" + this.x + " y:" + this.y + " z:" + this.z;
    }

    public String toString() {
        return this.print();
    }

    public ArrayList<Integer> getVois1() {
        ArrayList<Integer> res = new ArrayList<Integer>(6);
        if (this.x > 0) {
            res.add(this.coord - 1);
        }
        if (this.x < this.sizeX - 1) {
            res.add(this.coord + 1);
        }
        if (this.y > 0) {
            res.add(this.coord - this.sizeX);
        }
        if (this.y < this.sizeY - 1) {
            res.add(this.coord + this.sizeX);
        }
        if (this.z > 0) {
            res.add(this.coord - this.sizeXY);
        }
        if (this.z < this.sizeZ - 1) {
            res.add(this.coord + this.sizeXY);
        }
        return res;
    }

    public ArrayList<Voxel3D> getVois1Vox() {
        ArrayList<Voxel3D> res = new ArrayList<Voxel3D>(6);
        if (this.x > 0) {
            res.add(new Voxel3D(this.x - 1, this.y, this.z, 0.0f));
        }
        if (this.x < this.sizeX - 1) {
            res.add(new Voxel3D(this.x + 1, this.y, this.z, 0.0f));
        }
        if (this.y > 0) {
            res.add(new Voxel3D(this.x, this.y - 1, this.z, 0.0f));
        }
        if (this.y < this.sizeY - 1) {
            res.add(new Voxel3D(this.x, this.y + 1, this.z, 0.0f));
        }
        if (this.z > 0) {
            res.add(new Voxel3D(this.x, this.y, this.z - 1, 0.0f));
        }
        if (this.z < this.sizeZ - 1) {
            res.add(new Voxel3D(this.x, this.y, this.z + 1, 0.0f));
        }
        return res;
    }

    public ArrayList<IntCoord3D> getVois1C3D() {
        ArrayList<IntCoord3D> res = new ArrayList<IntCoord3D>(6);
        if (this.x > 0) {
            res.add(new IntCoord3D(this.x - 1, this.y, this.z));
        }
        if (this.x < this.sizeX - 1) {
            res.add(new IntCoord3D(this.x + 1, this.y, this.z));
        }
        if (this.y > 0) {
            res.add(new IntCoord3D(this.x, this.y - 1, this.z));
        }
        if (this.y < this.sizeY - 1) {
            res.add(new IntCoord3D(this.x, this.y + 1, this.z));
        }
        if (this.z > 0) {
            res.add(new IntCoord3D(this.x, this.y, this.z - 1));
        }
        if (this.z < this.sizeZ - 1) {
            res.add(new IntCoord3D(this.x, this.y, this.z + 1));
        }
        return res;
    }

    public ArrayList<Integer> getVois1(ImageHandler mask) {
        if (mask != null) {
            ArrayList<Integer> res = new ArrayList<Integer>(6);
            if (this.x > 0 && mask.getPixel(this.x - 1 + this.y * this.sizeX, this.z) != 0.0f) {
                res.add(this.coord - 1);
            }
            if (this.x < this.sizeX - 1 && mask.getPixel(this.x + 1 + this.y * this.sizeX, this.z) != 0.0f) {
                res.add(this.coord + 1);
            }
            if (this.y > 0 && mask.getPixel(this.x + (this.y - 1) * this.sizeX, this.z) != 0.0f) {
                res.add(this.coord - this.sizeX);
            }
            if (this.y < this.sizeY - 1 && mask.getPixel(this.x + (this.y + 1) * this.sizeX, this.z) != 0.0f) {
                res.add(this.coord + this.sizeX);
            }
            if (this.z > 0 && mask.getPixel(this.x + this.y * this.sizeX, this.z - 1) != 0.0f) {
                res.add(this.coord - this.sizeXY);
            }
            if (this.z < this.sizeZ - 1 && mask.getPixel(this.x + this.y * this.sizeX, this.z + 1) != 0.0f) {
                res.add(this.coord + this.sizeXY);
            }
            return res;
        }
        return this.getVois1();
    }

    public ArrayList<Integer> getVois15(ImageHandler mask) {
        if (mask != null) {
            ArrayList<Integer> res = new ArrayList<Integer>();
            for (int zz = -1; zz <= 1; ++zz) {
                if (zz + this.z >= this.sizeZ || this.z < -zz) continue;
                for (int yy = -1; yy <= 1; ++yy) {
                    if (yy + this.y >= this.sizeY || this.y < -yy) continue;
                    for (int xx = -1; xx <= 1; ++xx) {
                        if (xx + this.x >= this.sizeX || this.x < -xx || xx == 0 && yy == 0 && zz == 0 || mask.getPixel(xx + this.x + (yy + this.y) * this.sizeX, this.z + zz) == 0.0f) continue;
                        res.add(this.coord + xx + yy * this.sizeX + zz * this.sizeXY);
                    }
                }
            }
            return res;
        }
        return this.getVois15();
    }

    public ArrayList<Integer> getVois15() {
        ArrayList<Integer> res = new ArrayList<Integer>();
        for (int zz = -1; zz <= 1; ++zz) {
            if (zz + this.z >= this.sizeZ || this.z < -zz) continue;
            for (int yy = -1; yy <= 1; ++yy) {
                if (yy + this.y >= this.sizeY || this.y < -yy) continue;
                for (int xx = -1; xx <= 1; ++xx) {
                    if (xx + this.x >= this.sizeX || this.x < -xx || xx == 0 && yy == 0 && zz == 0) continue;
                    res.add(this.coord + xx + yy * this.sizeX + zz * this.sizeXY);
                }
            }
        }
        return res;
    }

    public void setVois(float radius, float radiusZ) {
        float r = radius / radiusZ;
        int rad = (int)(radius + 0.5f);
        int radZ = (int)(radiusZ + 0.5f);
        int[][] temp = new int[3][(2 * rad + 1) * (2 * rad + 1) * (2 * radZ + 1)];
        float[] tempDist = new float[temp[0].length];
        int count = 0;
        float rad2 = radius * radius;
        for (int zz = -radZ; zz <= radZ; ++zz) {
            for (int yy = -rad; yy <= rad; ++yy) {
                for (int xx = -rad; xx <= rad; ++xx) {
                    float d2 = (float)zz * r * (float)zz * r + (float)(yy * yy) + (float)(xx * xx);
                    if (!(d2 <= rad2) || xx == 0 && yy == 0 && zz == 0) continue;
                    temp[0][count] = xx;
                    temp[1][count] = yy;
                    temp[2][count] = zz;
                    tempDist[count] = (float)Math.sqrt(d2);
                    ++count;
                }
            }
        }
        this.distances = new float[count];
        System.arraycopy(tempDist, 0, this.distances, 0, count);
        this.vois = new int[3][count];
        System.arraycopy(temp[0], 0, this.vois[0], 0, count);
        System.arraycopy(temp[1], 0, this.vois[1], 0, count);
        System.arraycopy(temp[2], 0, this.vois[2], 0, count);
    }

    public void setVois1(float scaleZ) {
        this.vois = new int[3][6];
        this.distances = new float[6];
        this.vois[0][0] = 1;
        this.vois[1][0] = 0;
        this.vois[2][0] = 0;
        this.distances[0] = 1.0f;
        this.vois[0][1] = 0;
        this.vois[1][1] = 1;
        this.vois[2][1] = 0;
        this.distances[1] = 1.0f;
        this.vois[0][2] = -1;
        this.vois[1][2] = 0;
        this.vois[2][2] = 0;
        this.distances[2] = 1.0f;
        this.vois[0][3] = 0;
        this.vois[1][3] = -1;
        this.vois[2][3] = 0;
        this.distances[3] = 1.0f;
        this.vois[0][4] = 0;
        this.vois[1][4] = 0;
        this.vois[2][4] = 1;
        this.distances[4] = scaleZ;
        this.vois[0][5] = 0;
        this.vois[1][5] = 0;
        this.vois[2][5] = -1;
        this.distances[5] = scaleZ;
    }

    public ArrayList<Integer> getVois(ImageHandler mask) {
        if (mask != null) {
            ArrayList<Integer> res = new ArrayList<Integer>();
            for (int i = 0; i < this.vois[0].length; ++i) {
                int xx = this.vois[0][i] + this.x;
                int yy = this.vois[1][i] + this.y;
                int zz = this.vois[2][i] + this.z;
                if (!this.isIn(xx, yy, zz) || mask.getPixel(xx + yy * this.sizeX, zz) == 0.0f) continue;
                res.add(xx + yy * this.sizeX + zz * this.sizeXY);
            }
            return res;
        }
        return this.getVois();
    }

    public ArrayList<Integer> getVois() {
        ArrayList<Integer> res = new ArrayList<Integer>();
        for (int i = 0; i < this.vois[0].length; ++i) {
            int xx = this.vois[0][i] + this.x;
            int yy = this.vois[1][i] + this.y;
            int zz = this.vois[2][i] + this.z;
            if (!this.isIn(xx, yy, zz)) continue;
            res.add(xx + yy * this.sizeX + zz * this.sizeXY);
        }
        return res;
    }

    private void computeXYZ() {
        this.z = this.coord / this.sizeXY;
        int xy = this.coord % this.sizeXY;
        this.y = xy / this.sizeX;
        this.x = xy % this.sizeX;
    }

    private class ComparatorDistances
    implements Comparator<Integer> {
        private ComparatorDistances() {
        }

        @Override
        public int compare(Integer i1, Integer i2) {
            if (Coordinate3D.this.distances[i1] > Coordinate3D.this.distances[i2]) {
                return 1;
            }
            if (Coordinate3D.this.distances[i1] < Coordinate3D.this.distances[i2]) {
                return -1;
            }
            return 0;
        }
    }
}

