/*
 * Decompiled with CFR 0.152.
 */
package mcib3d.image3d.processing;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.Roi;
import ij.plugin.frame.RoiManager;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mcib3d.geom.Object3D;
import mcib3d.geom.Object3DVoxels;
import mcib3d.geom.Objects3DPopulation;
import mcib3d.geom.Voxel3D;
import mcib3d.image3d.BlankMask;
import mcib3d.image3d.ImageHandler;
import mcib3d.image3d.ImageInt;
import mcib3d.image3d.ImageShort;
import mcib3d.image3d.Segment3DSpots;
import mcib3d.utils.ArrayUtil;

public class ManualSpot
extends JFrame {
    int threshold_method = 0;
    int spot_method = 0;
    int threshold_constant = 10000;
    int rad_gauss = 10;
    double sd_gauss = 1.0;
    int r0 = 2;
    int r1 = 4;
    int r2 = 6;
    double weight = 0.5;
    ImagePlus plusorig = null;
    ImageHandler spot3DImage = null;
    Objects3DPopulation popOrig;
    ImageInt labelImage = null;
    ImagePlus plusres = null;
    Object3D[] objs = null;
    int col = 1;
    public JButton jButtonClose;
    public JButton jButtonOK;
    private JButton jButtonTest;
    private JComboBox jComboBoxMethod;
    private JComboBox jComboBoxThreshold;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanelConstant;
    private JPanel jPanelGauss;
    private JPanel jPanelLocalMean;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSlider jSliderConstant;
    private JSlider jSliderSDGauss;
    private JTextArea jTextArea1;
    private JTextField jTextFieldConstant;
    private JTextArea jTextFieldLog;
    private JTextField jTextFieldR0;
    private JTextField jTextFieldR1;
    private JTextField jTextFieldR2;
    private JTextField jTextFieldRadGauss;
    private JTextField jTextFieldSdGauss;
    private JTextField jTextFieldWeight;

    public ManualSpot() {
        this.initComponents();
        this.jComboBoxMethod.setSelectedIndex(this.spot_method);
        this.jComboBoxThreshold.setSelectedIndex(this.threshold_method);
        if (this.plusorig == null) {
            this.plusorig = IJ.getImage();
        }
        if (this.spot3DImage == null) {
            this.spot3DImage = ImageHandler.wrap(this.plusorig);
            this.labelImage = new ImageShort("SegmentedSpots", this.spot3DImage.sizeX, this.spot3DImage.sizeY, this.spot3DImage.sizeZ);
            this.labelImage.show();
            this.popOrig = new Objects3DPopulation();
            this.popOrig.addImage(this.plusorig);
            this.col = this.popOrig.getNbObjects();
        }
        this.initInterface();
    }

    public ManualSpot(ImagePlus raw, ImagePlus seg, int firstLabel) {
        this.initComponents();
        this.col = firstLabel;
        this.jComboBoxMethod.setSelectedIndex(this.spot_method);
        this.jComboBoxThreshold.setSelectedIndex(this.threshold_method);
        this.plusorig = raw;
        this.spot3DImage = ImageHandler.wrap(this.plusorig);
        this.plusres = seg;
        this.labelImage = ImageInt.wrap(this.plusres);
        this.popOrig = new Objects3DPopulation();
        this.popOrig.addImage(this.plusres);
        this.initInterface();
    }

    public ManualSpot(ImagePlus raw, ImagePlus seg) {
        this.initComponents();
        this.jComboBoxMethod.setSelectedIndex(this.spot_method);
        this.jComboBoxThreshold.setSelectedIndex(this.threshold_method);
        this.plusorig = raw;
        this.spot3DImage = ImageInt.wrap(this.plusorig);
        this.plusres = seg;
        this.labelImage = ImageInt.wrap(this.plusres);
        this.col = (int)this.labelImage.getMax() + 1;
        this.popOrig = new Objects3DPopulation();
        this.popOrig.addImage(this.plusres);
        this.initInterface();
    }

    private void initInterface() {
        this.jSliderConstant.setMaximum((int)this.spot3DImage.getMax());
        this.jSliderConstant.setMinimum(0);
        ArrayUtil hist = new ArrayUtil(this.spot3DImage.getHistogram(new BlankMask(this.spot3DImage)));
        int pcHigh = hist.indexOfSumPercent(0.999);
        this.jSliderConstant.setValue(pcHigh);
        IJ.setTool((int)7);
        RoiManager manager = RoiManager.getInstance();
        if (manager == null) {
            manager = new RoiManager();
        }
    }

    private void initComponents() {
        this.jComboBoxThreshold = new JComboBox();
        this.jComboBoxMethod = new JComboBox();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jPanelConstant = new JPanel();
        this.jLabel3 = new JLabel();
        this.jSliderConstant = new JSlider();
        this.jTextFieldConstant = new JTextField();
        this.jPanelGauss = new JPanel();
        this.jLabel4 = new JLabel();
        this.jTextFieldRadGauss = new JTextField();
        this.jLabel5 = new JLabel();
        this.jSliderSDGauss = new JSlider();
        this.jLabel6 = new JLabel();
        this.jTextFieldSdGauss = new JTextField();
        this.jPanelLocalMean = new JPanel();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jTextFieldR0 = new JTextField();
        this.jLabel9 = new JLabel();
        this.jTextFieldR1 = new JTextField();
        this.jLabel10 = new JLabel();
        this.jTextFieldR2 = new JTextField();
        this.jLabel11 = new JLabel();
        this.jTextFieldWeight = new JTextField();
        this.jButtonTest = new JButton();
        this.jButtonOK = new JButton();
        this.jButtonClose = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTextFieldLog = new JTextArea();
        this.jScrollPane2 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.setDefaultCloseOperation(0);
        this.setResizable(false);
        this.jComboBoxThreshold.setModel(new DefaultComboBoxModel<String>(new String[]{"Constant", "Local mean", "Gauss fitting"}));
        this.jComboBoxThreshold.setSelectedIndex(this.threshold_method);
        this.jComboBoxThreshold.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManualSpot.this.jComboBoxThresholdActionPerformed(evt);
            }
        });
        this.jComboBoxMethod.setModel(new DefaultComboBoxModel<String>(new String[]{"Classical", "Maximum", "block"}));
        this.jComboBoxMethod.setSelectedIndex(this.spot_method);
        this.jComboBoxMethod.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManualSpot.this.jComboBoxMethodActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Threshold :");
        this.jLabel2.setText("Method :");
        this.jPanelConstant.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jLabel3.setText("Constant :");
        this.jSliderConstant.setMaximum(10000);
        this.jSliderConstant.setValue(this.threshold_constant);
        this.jSliderConstant.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                ManualSpot.this.jSliderConstantStateChanged(evt);
            }
        });
        this.jTextFieldConstant.setText("  " + this.threshold_constant + "  ");
        this.jTextFieldConstant.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManualSpot.this.jTextFieldConstantActionPerformed(evt);
            }
        });
        GroupLayout jPanelConstantLayout = new GroupLayout(this.jPanelConstant);
        this.jPanelConstant.setLayout(jPanelConstantLayout);
        jPanelConstantLayout.setHorizontalGroup(jPanelConstantLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelConstantLayout.createSequentialGroup().addContainerGap().addGroup(jPanelConstantLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelConstantLayout.createSequentialGroup().addComponent(this.jLabel3, -2, 76, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSliderConstant, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, jPanelConstantLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jTextFieldConstant, -2, -1, -2).addGap(95, 95, 95)))));
        jPanelConstantLayout.setVerticalGroup(jPanelConstantLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelConstantLayout.createSequentialGroup().addContainerGap().addGroup(jPanelConstantLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jSliderConstant, -2, -1, -2).addComponent(this.jLabel3, -2, 23, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldConstant, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanelGauss.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jLabel4.setText("Gauss : ");
        this.jTextFieldRadGauss.setText("" + this.rad_gauss);
        this.jLabel5.setText("Rad :");
        this.jSliderSDGauss.setMaximum(50);
        this.jSliderSDGauss.setValue(10);
        this.jSliderSDGauss.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                ManualSpot.this.jSliderSDGaussStateChanged(evt);
            }
        });
        this.jLabel6.setText("SD :");
        this.jTextFieldSdGauss.setText("" + this.sd_gauss);
        this.jTextFieldSdGauss.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManualSpot.this.jTextFieldSdGaussActionPerformed(evt);
            }
        });
        GroupLayout jPanelGaussLayout = new GroupLayout(this.jPanelGauss);
        this.jPanelGauss.setLayout(jPanelGaussLayout);
        jPanelGaussLayout.setHorizontalGroup(jPanelGaussLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelGaussLayout.createSequentialGroup().addContainerGap().addGroup(jPanelGaussLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelGaussLayout.createSequentialGroup().addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jTextFieldRadGauss, -2, 34, -2).addGap(72, 72, 72)).addGroup(GroupLayout.Alignment.TRAILING, jPanelGaussLayout.createSequentialGroup().addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jTextFieldSdGauss, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSliderSDGauss, -2, -1, -2).addContainerGap()))));
        jPanelGaussLayout.setVerticalGroup(jPanelGaussLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelGaussLayout.createSequentialGroup().addContainerGap().addGroup(jPanelGaussLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4, -2, 30, -2).addComponent(this.jTextFieldRadGauss, -2, -1, -2).addComponent(this.jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanelGaussLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSliderSDGauss, -2, -1, -2).addGroup(jPanelGaussLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.jTextFieldSdGauss, -2, -1, -2))).addContainerGap(29, Short.MAX_VALUE)));
        this.jPanelLocalMean.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jLabel7.setText("Local mean :");
        this.jLabel8.setText("R0");
        this.jTextFieldR0.setText("  " + this.r0 + " ");
        this.jTextFieldR0.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManualSpot.this.jTextFieldR0ActionPerformed(evt);
            }
        });
        this.jLabel9.setText("R1");
        this.jTextFieldR1.setText("  " + this.r1 + " ");
        this.jTextFieldR1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManualSpot.this.jTextFieldR1ActionPerformed(evt);
            }
        });
        this.jLabel10.setText("R2");
        this.jTextFieldR2.setText("  " + this.r2 + " ");
        this.jTextFieldR2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManualSpot.this.jTextFieldR2ActionPerformed(evt);
            }
        });
        this.jLabel11.setText("Weight");
        this.jTextFieldWeight.setText("  " + this.weight + " ");
        this.jTextFieldWeight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManualSpot.this.jTextFieldWeightActionPerformed(evt);
            }
        });
        GroupLayout jPanelLocalMeanLayout = new GroupLayout(this.jPanelLocalMean);
        this.jPanelLocalMean.setLayout(jPanelLocalMeanLayout);
        jPanelLocalMeanLayout.setHorizontalGroup(jPanelLocalMeanLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelLocalMeanLayout.createSequentialGroup().addGroup(jPanelLocalMeanLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(jPanelLocalMeanLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel7, -2, 99, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel8, -2, 28, -2)).addGroup(jPanelLocalMeanLayout.createSequentialGroup().addGap(117, 117, 117).addComponent(this.jLabel11).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldWeight)).addGroup(jPanelLocalMeanLayout.createSequentialGroup().addGap(117, 117, 117).addGroup(jPanelLocalMeanLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel9, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel10, -1, -1, Short.MAX_VALUE)).addGap(35, 35, 35).addGroup(jPanelLocalMeanLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jTextFieldR2).addComponent(this.jTextFieldR1, GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldR0, GroupLayout.Alignment.LEADING)))).addContainerGap(-1, Short.MAX_VALUE)));
        jPanelLocalMeanLayout.setVerticalGroup(jPanelLocalMeanLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelLocalMeanLayout.createSequentialGroup().addContainerGap().addGroup(jPanelLocalMeanLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7, -2, 24, -2).addComponent(this.jLabel8).addComponent(this.jTextFieldR0, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelLocalMeanLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldR1, -2, -1, -2).addComponent(this.jLabel9)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelLocalMeanLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldR2, -2, -1, -2).addComponent(this.jLabel10)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelLocalMeanLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldWeight, -2, -1, -2).addComponent(this.jLabel11)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jButtonTest.setText("Test");
        this.jButtonTest.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManualSpot.this.jButtonTestActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("Confirm");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManualSpot.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonClose.setText("Quit");
        this.jButtonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManualSpot.this.jButtonCloseActionPerformed(evt);
            }
        });
        this.jTextFieldLog.setColumns(20);
        this.jTextFieldLog.setRows(5);
        this.jScrollPane1.setViewportView(this.jTextFieldLog);
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setBackground(new Color(204, 204, 204));
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setRows(5);
        this.jTextArea1.setText("1- Choose the method of segmentation.\n2- Click on seeds position and add them\n    to the RoiManager ([t]). \n3- Test the results of segmentation.\n4- Confirm to draw the results in the label\n     Image.");
        this.jTextArea1.setToolTipText("Instructions");
        this.jScrollPane2.setViewportView(this.jTextArea1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jComboBoxMethod, -2, 165, -2).addComponent(this.jComboBoxThreshold, -2, 165, -2))).addGroup(layout.createSequentialGroup().addGap(83, 83, 83).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jButtonClose, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonTest, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonOK, -1, 93, Short.MAX_VALUE))).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane2))).addGap(38, 38, 38).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jPanelGauss, -1, -1, Short.MAX_VALUE).addComponent(this.jPanelConstant, -1, -1, Short.MAX_VALUE)).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jPanelLocalMean, -1, -1, Short.MAX_VALUE))).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jPanelConstant, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1, -2, 35, -2).addComponent(this.jComboBoxThreshold, -2, 35, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2, -2, 35, -2).addComponent(this.jComboBoxMethod, -2, 35, -2)))).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanelGauss, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanelLocalMean, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 33, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGap(18, 18, 18).addComponent(this.jScrollPane2).addGap(18, 18, 18).addComponent(this.jButtonTest).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonOK).addGap(53, 53, 53).addComponent(this.jButtonClose).addGap(18, 18, 18))).addComponent(this.jScrollPane1, -2, 110, -2).addContainerGap()));
        this.pack();
    }

    private void jComboBoxThresholdActionPerformed(ActionEvent evt) {
        this.threshold_method = this.jComboBoxThreshold.getSelectedIndex();
        System.out.println("threshold " + this.threshold_method);
        if (this.threshold_method == 0) {
            this.jPanelConstant.setBackground(Color.white);
            this.jPanelGauss.setBackground(Color.red);
            this.jPanelLocalMean.setBackground(Color.red);
        } else if (this.threshold_method == 1) {
            this.jPanelConstant.setBackground(Color.red);
            this.jPanelGauss.setBackground(Color.red);
            this.jPanelLocalMean.setBackground(Color.white);
        } else if (this.threshold_method == 2) {
            this.jPanelConstant.setBackground(Color.red);
            this.jPanelGauss.setBackground(Color.white);
            this.jPanelLocalMean.setBackground(Color.red);
        }
    }

    private void jComboBoxMethodActionPerformed(ActionEvent evt) {
        this.spot_method = this.jComboBoxMethod.getSelectedIndex();
    }

    private void jTextFieldR0ActionPerformed(ActionEvent evt) {
        this.r0 = Integer.parseInt(this.jTextFieldR0.getText().trim());
    }

    private void jTextFieldWeightActionPerformed(ActionEvent evt) {
        this.weight = Double.parseDouble(this.jTextFieldWeight.getText().trim());
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        this.updateLabelImage();
        this.objs = null;
    }

    private void jTextFieldConstantActionPerformed(ActionEvent evt) {
        this.threshold_constant = Integer.parseInt(this.jTextFieldConstant.getText().trim());
        this.jSliderConstant.setValue(this.threshold_constant);
    }

    private void jTextFieldR1ActionPerformed(ActionEvent evt) {
        this.r1 = Integer.parseInt(this.jTextFieldR1.getText().trim());
    }

    private void jTextFieldR2ActionPerformed(ActionEvent evt) {
        this.r2 = Integer.parseInt(this.jTextFieldR2.getText().trim());
    }

    private void jSliderConstantStateChanged(ChangeEvent evt) {
        this.threshold_constant = this.jSliderConstant.getValue();
        this.jTextFieldConstant.setText("" + this.threshold_constant);
        this.plusorig.getProcessor().setThreshold((double)this.threshold_constant, 100000.0, 0);
        this.plusorig.updateAndDraw();
    }

    private void jSliderSDGaussStateChanged(ChangeEvent evt) {
        this.sd_gauss = this.jSliderSDGauss.getValue();
        this.jTextFieldSdGauss.setText("" + this.sd_gauss / 10.0);
    }

    private void jButtonTestActionPerformed(ActionEvent evt) {
        this.segmentSpots();
    }

    private void jTextFieldSdGaussActionPerformed(ActionEvent evt) {
        this.sd_gauss = Double.parseDouble(this.jTextFieldSdGauss.getText().trim());
        this.jSliderSDGauss.setValue((int)(this.sd_gauss * 10.0));
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.close();
    }

    public void close() {
        this.dispose();
        WindowManager.removeWindow((Frame)this);
    }

    public void windowClosing(WindowEvent e) {
        if (e.getSource() == this) {
            this.close();
        }
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(ManualSpot.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(ManualSpot.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(ManualSpot.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(ManualSpot.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new ManualSpot().setVisible(true);
            }
        });
    }

    private void segmentSpots() {
        RoiManager manager = RoiManager.getInstance();
        Roi[] rois = manager.getRoisAsArray();
        if (manager == null || rois.length == 0) {
            IJ.showMessage((String)"Put rois in the RoiManager");
            return;
        }
        if (this.objs == null) {
            this.objs = new Object3D[rois.length];
        }
        String text = "";
        for (int r = 0; r < rois.length; ++r) {
            Roi roi = rois[r];
            Rectangle rect = roi.getBounds();
            int x = rect.x;
            int y = rect.y;
            int z = manager.getSliceNumber(manager.getName(r));
            text = text.concat("\nx=" + x + " " + y + " " + z);
            this.jTextFieldLog.setText(text);
            Segment3DSpots segSpots = new Segment3DSpots(this.spot3DImage, null);
            segSpots.setLabelImage(this.labelImage);
            segSpots.show = true;
            Voxel3D v = segSpots.getLocalMaximum(x, y, z, 2.0f, 2.0f, 2.0f);
            if (v != null) {
                text = text.concat("\nMax local " + v.getX() + " " + v.getY() + " " + v.getZ() + " " + v.getValue());
                this.jTextFieldLog.setText(text);
                x = v.getRoundX();
                y = v.getRoundY();
                z = v.getRoundZ();
            }
            if (this.threshold_method == 0) {
                segSpots.setMethodLocal(1);
            } else if (this.threshold_method == 1) {
                segSpots.setMethodLocal(2);
            } else {
                segSpots.setMethodLocal(3);
            }
            if (this.spot_method == 0) {
                segSpots.setMethodSeg(1);
            } else if (this.spot_method == 0) {
                segSpots.setMethodSeg(3);
            } else {
                segSpots.setMethodSeg(4);
            }
            segSpots.setLocalThreshold(this.threshold_constant);
            segSpots.setGaussMaxr(this.rad_gauss);
            segSpots.setGaussPc(this.sd_gauss / 10.0);
            segSpots.setRadiusLocalMean(this.r0, this.r1, this.r2, this.weight);
            segSpots.setWatershed(false);
            if (this.objs[r] != null) {
                this.objs[r].draw(this.labelImage, 0);
            }
            this.popOrig.draw(this.labelImage);
            segSpots.setLabelImage(this.labelImage);
            ArrayList<Voxel3D> spot = segSpots.segmentOneSpot(x, y, z, this.col);
            if (spot != null) {
                if (spot.size() > 0) {
                    this.objs[r] = new Object3DVoxels(spot);
                    this.objs[r].draw(this.labelImage, this.col);
                }
                if (this.plusres == null) {
                    this.plusres = this.labelImage.getImagePlus();
                    this.plusres.show();
                    IJ.run((ImagePlus)this.plusres, (String)"3-3-2 RGB", (String)"");
                }
                IJ.setMinAndMax((ImagePlus)this.plusres, (double)0.0, (double)this.col);
                this.plusres.setSlice((int)this.objs[r].getCenterZ() + 1);
                this.plusres.updateAndDraw();
                continue;
            }
            this.jTextFieldLog.setText(this.jTextFieldLog.getText() + "\nno spot found !");
        }
        this.labelImage.updateDisplay();
    }

    public Object3D[] getObjects() {
        return this.objs;
    }

    protected void updateLabelImage() {
        for (Object3D o : this.objs) {
            o.draw(this.labelImage.getImageStack(), this.col);
            IJ.log((String)("Manual segmenter paint object:" + this.col));
            ++this.col;
        }
        this.labelImage.updateDisplay();
    }
}

