/*
 * Decompiled with CFR 0.152.
 */
package mcib3d.image3d.regionGrowing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.TreeSet;
import mcib3d.geom.ComparatorVoxel;
import mcib3d.geom.Voxel3D;
import mcib3d.geom.Voxel3DComparable;
import mcib3d.image3d.ImageHandler;
import mcib3d.image3d.ImageInt;
import mcib3d.image3d.ImageLabeller;
import mcib3d.image3d.ImageShort;

public class Watershed3D {
    private final int DAM = 1;
    private final int QUEUE = 2;
    private final int seedsThreshold;
    ImageHandler rawImage;
    ImageHandler seedsImage;
    ImageInt watershedImage = null;
    ImageInt labelQueueImage = null;
    LinkedList<Voxel3DComparable> voxels = null;
    boolean okseeds = false;
    boolean anim = false;
    private int rawThreshold;
    private boolean labelSeeds = true;

    public Watershed3D(ImageHandler image, ImageHandler seeds, int noi, int seth) {
        this.rawImage = image;
        this.seedsImage = seeds;
        this.rawThreshold = noi;
        this.seedsThreshold = seth;
    }

    public ImageHandler getRawImage() {
        return this.rawImage;
    }

    public void setRawImage(ImageHandler image) {
        this.rawImage = image;
    }

    public ImageHandler getSeeds() {
        return this.seedsImage;
    }

    public void setSeeds(ImageInt seeds) {
        this.seedsImage = seeds;
    }

    public void setLabelSeeds(boolean labelSeeds) {
        this.labelSeeds = labelSeeds;
    }

    public void setAnim(boolean anim) {
        this.anim = anim;
    }

    public int getDamValue() {
        return 1;
    }

    public ImageInt getWatershedImage3D() {
        return this.getClassicWatershed();
    }

    private ImageInt getClassicWatershed() {
        long step = 100L;
        this.createNeigList();
        long t0 = System.currentTimeMillis();
        if (this.anim) {
            this.watershedImage.show();
        }
        if (this.rawImage.getMin() > (double)this.rawThreshold) {
            this.rawThreshold = (int)this.rawImage.getMin();
        }
        ComparatorVoxel comp = new ComparatorVoxel();
        TreeSet<Voxel3DComparable> tree = new TreeSet<Voxel3DComparable>(comp);
        int idx = 1;
        for (Voxel3DComparable V : this.voxels) {
            V.setMax(idx, 0);
            ++idx;
            tree.add(V);
        }
        boolean newt = true;
        while (newt) {
            newt = false;
            while (!tree.isEmpty()) {
                Voxel3DComparable V;
                V = tree.pollFirst();
                ArrayList<Voxel3D> Nei = this.watershedImage.getNeighborhood3x3x3ListNoCenter(V.getRoundX(), V.getRoundY(), V.getRoundZ());
                if (this.watershedImage.getPixel(V) == 1.0f) continue;
                this.watershedImage.setPixel(V, this.labelQueueImage.getPixel(V));
                for (Voxel3D N : Nei) {
                    int rawN = (int)this.rawImage.getPixel(N);
                    if (rawN <= this.rawThreshold) continue;
                    if (N.getValue() == 0.0) {
                        this.watershedImage.setPixel(N, 2.0f);
                        this.labelQueueImage.setPixel(N, (float)((int)V.getLabel()));
                        Voxel3DComparable Vnew = new Voxel3DComparable(N.getRoundX(), N.getRoundY(), N.getRoundZ(), rawN, V.getLabel());
                        Vnew.setMax(idx, 0);
                        ++idx;
                        tree.add(Vnew);
                        continue;
                    }
                    if (N.getValue() != 2.0 || this.labelQueueImage.getPixel(V) == this.labelQueueImage.getPixel(N)) continue;
                    this.watershedImage.setPixel(N, 1.0f);
                }
                if (System.currentTimeMillis() - t0 <= step) continue;
                if (this.anim) {
                    this.watershedImage.updateDisplay();
                }
                t0 = System.currentTimeMillis();
            }
        }
        return this.watershedImage;
    }

    private void createNeigList() {
        this.voxels = new LinkedList();
        int sx = this.rawImage.sizeX;
        int sy = this.rawImage.sizeY;
        int sz = this.rawImage.sizeZ;
        this.watershedImage = new ImageShort("watershed", sx, sy, sz);
        this.labelQueueImage = new ImageShort("labelQ", sx, sy, sz);
        this.okseeds = false;
        ImageInt seedsLabel = (ImageInt)this.seedsImage.duplicate();
        seedsLabel.thresholdCut(this.seedsThreshold, false, true);
        if (this.labelSeeds) {
            ImageLabeller labeller = new ImageLabeller();
            seedsLabel = labeller.getLabels(seedsLabel);
        }
        int max = (int)seedsLabel.getMax();
        seedsLabel.replacePixelsValue(2, max + 1);
        seedsLabel.replacePixelsValue(1, max + 2);
        seedsLabel.resetStats(null);
        for (int z = sz - 1; z >= 0; --z) {
            for (int y = sy - 1; y >= 0; --y) {
                for (int x = sx - 1; x >= 0; --x) {
                    float pix = this.rawImage.getPixel(x, y, z);
                    float se = seedsLabel.getPixel(x, y, z);
                    if (!(pix > (float)this.rawThreshold) || !(se > 0.0f)) continue;
                    this.watershedImage.setPixel(x, y, z, se);
                    this.okseeds = true;
                    ArrayList<Voxel3D> list = this.watershedImage.getNeighborhood3x3x3ListNoCenter(x, y, z);
                    Collections.shuffle(list);
                    for (Voxel3D N : list) {
                        int vz;
                        int vy;
                        int vx = (int)N.getX();
                        int raw = (int)this.rawImage.getPixel(vx, vy = (int)N.getY(), vz = (int)N.getZ());
                        if (raw <= this.rawThreshold || seedsLabel.getPixel(vx, vy, vz) != 0.0f || this.watershedImage.getPixel(vx, vy, vz) == 2.0f) continue;
                        this.voxels.add(new Voxel3DComparable(vx, vy, vz, raw, se));
                        this.watershedImage.setPixel(vx, vy, vz, 2);
                        this.labelQueueImage.setPixel(vx, vy, vz, se);
                    }
                }
            }
        }
    }
}

