/*
 * Decompiled with CFR 0.152.
 */
package mcib3d.utils;

import java.util.concurrent.atomic.AtomicInteger;

public class ThreadRunner {
    public final int start;
    public final int end;
    public final Thread[] threads;
    public final AtomicInteger ai;

    public ThreadRunner(int start, int end, int cpulimit) {
        this.start = start;
        this.end = end;
        this.ai = new AtomicInteger(this.start);
        int nb = this.getNbCpus();
        if (cpulimit > 0 && nb > cpulimit) {
            nb = cpulimit;
        }
        this.threads = new Thread[nb];
    }

    public void startAndJoin() {
        ThreadRunner.startAndJoin(this.threads);
    }

    protected static void startAndJoin(Thread[] threads) {
        for (Thread thread : threads) {
            thread.setPriority(5);
            thread.start();
        }
        try {
            for (Thread thread : threads) {
                thread.join();
            }
        }
        catch (InterruptedException ie) {
            throw new RuntimeException(ie);
        }
    }

    public void resetAi() {
        this.ai.set(this.start);
    }

    private int getNbCpus() {
        return Math.max(1, Math.min(Runtime.getRuntime().availableProcessors(), this.end - this.start));
    }
}

