package plugins.ylemontag.matlabfunctioncaller;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import plugins.ylemontag.matlabio.ComplexMode;
import plugins.ylemontag.matlabio.DimensionMapping;

/**
 * 
 * @author Yoann Le Montagner
 * 
 * Set of input or output arguments for a Matlab function
 */
public class ArgumentSet
{
	protected Map<String, Variant> _data;
	
	/**
	 * Constructor
	 */
	public ArgumentSet(String[] names)
	{
		_data = new HashMap<String, Variant>();
		for(String s : names) {
			_data.put(s, null);
		}
	}
	
	/**
	 * List of arguments
	 */
	public Set<String> getArgumentNames()
	{
		return _data.keySet();
	}
	
	/**
	 * Return the given argument
	 */
	public Variant getArgument(String name)
	{
		return _data.get(name);
	}
	
	/**
	 * Check whether all the arguments are binded or not
	 */
	public boolean allBinded()
	{
		for(Variant v : _data.values()) {
			if(v==null) {
				return false;
			}
		}
		return true;
	}
	
	/**
	 * Check whether the given argument is binded or not
	 */
	public boolean isBinded(String name)
	{
		return _data.get(name)!=null;
	}
	
	/**
	 * Dimension mapping to use when dealing with sequences
	 */
	protected DimensionMapping getDimensionMapping()
	{
		return new DimensionMapping(); // Always the default dimension mapping
	}
	
	/**
	 * Complex data option for output arguments
	 */
	protected ComplexMode getComplexModeForOutput()
	{
		return ComplexMode.BOTH;
	}
	
	/**
	 * Complex data option for input arguments
	 */
	protected boolean getComplexModeForInput()
	{
		return false;
	}
}
