/*
 * Decompiled with CFR 0.152.
 */
package bilib.commons.job.worker;

import bilib.commons.job.ExecutionMode;
import bilib.commons.job.JobEvent;
import bilib.commons.job.MonitorAbstract;
import bilib.commons.job.MonitorProgressBar;
import bilib.commons.job.MonitorTimedLog;
import bilib.commons.job.MonitorTimedProgressBar;
import bilib.commons.job.worker.Job;
import bilib.commons.job.worker.Pool;
import bilib.commons.job.worker.PoolResponder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class WorkerDemo
extends JFrame
implements PoolResponder,
ActionListener {
    public JRadioButton rbSequential = new JRadioButton("Sequential", false);
    public JRadioButton rbAsynchronized = new JRadioButton("Parallel - Asynchronized jobs (not wait)", false);
    public JRadioButton rbSynchronized = new JRadioButton("Parallel - Synchronized jobs (wait termination)", true);
    public JButton execute = new JButton("Execute");
    public JTextField nthreads = new JTextField("0");
    public JTextField njobs = new JTextField("10");
    public JButton simulateAbort = new JButton("Abort");
    public JButton simulateException = new JButton("Simulate an Exception");
    public JButton simulateJobException = new JButton("Simulate an JobException");
    public JButton simulateInterruption = new JButton("Simulate an Interruption");
    public JButton simulateCancellation = new JButton("Simulate an Cancellation");
    public JButton simulateTimeOut = new JButton("Simulate an TimeOut");
    public MonitorTimedProgressBar bar = new MonitorTimedProgressBar();
    public MonitorProgressBar bar1 = new MonitorProgressBar();
    public MonitorTimedLog log = new MonitorTimedLog(10, 10);
    private double chrono;
    private MainProcessing main = new MainProcessing(this);

    public static void main(String[] args) {
        new WorkerDemo();
    }

    public WorkerDemo() {
        super("Worker Demo");
        ButtonGroup bg1 = new ButtonGroup();
        bg1.add(this.rbSequential);
        bg1.add(this.rbAsynchronized);
        bg1.add(this.rbSynchronized);
        JPanel panel1 = new JPanel(new GridLayout(20, 1));
        panel1.add(this.rbSequential);
        panel1.add(this.rbAsynchronized);
        panel1.add(this.rbSynchronized);
        panel1.add(new JLabel("Number of threads (0 = nb of jobs)"));
        panel1.add(this.nthreads);
        panel1.add(new JLabel("Number of jobs"));
        panel1.add(this.njobs);
        panel1.add(this.execute);
        panel1.add(new JLabel(""));
        panel1.add(this.simulateAbort);
        panel1.add(this.simulateException);
        panel1.add(this.simulateJobException);
        panel1.add(this.simulateInterruption);
        panel1.add(this.simulateCancellation);
        panel1.add(this.simulateTimeOut);
        JPanel panel3 = new JPanel(new BorderLayout());
        panel3.add((Component)this.bar, "North");
        panel3.add((Component)this.bar1, "South");
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        panel.add((Component)panel1, "North");
        panel.add((Component)panel3, "South");
        panel.add((Component)this.log, "Center");
        this.execute.addActionListener(this);
        this.simulateAbort.addActionListener(this);
        this.simulateException.addActionListener(this);
        this.simulateJobException.addActionListener(this);
        this.simulateInterruption.addActionListener(this);
        this.simulateCancellation.addActionListener(this);
        this.simulateTimeOut.addActionListener(this);
        this.getContentPane().add(panel);
        this.pack();
        this.setVisible(true);
    }

    private ExecutionMode getMode() {
        ExecutionMode mode = ExecutionMode.MULTITHREAD_NO;
        if (this.rbSynchronized.isSelected()) {
            mode = ExecutionMode.MULTITHREAD_SYNCHRONIZED;
        }
        if (this.rbAsynchronized.isSelected()) {
            mode = ExecutionMode.MULTITHREAD_ASYNCHRONIZED;
        }
        return mode;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.execute) {
            this.main.setMode(this.getMode(), Integer.parseInt(this.nthreads.getText()), Integer.parseInt(this.njobs.getText()));
            System.out.println("\n\n");
            Pool pool = new Pool("Main", (PoolResponder)this);
            pool.register(this.main);
            pool.execute(ExecutionMode.MULTITHREAD_ASYNCHRONIZED);
            this.chrono = System.nanoTime();
        }
        if (event.getSource() == this.simulateAbort) {
            this.main.simulateAbort();
        }
        if (event.getSource() == this.simulateException) {
            this.main.simulateException();
        }
        if (event.getSource() == this.simulateJobException) {
            this.main.simulateJobException();
        }
        if (event.getSource() == this.simulateInterruption) {
            this.main.simulateInterruption();
        }
        if (event.getSource() == this.simulateCancellation) {
            this.main.simulateCancellation();
        }
        if (event.getSource() == this.simulateTimeOut) {
            this.main.simulateTimeOut();
        }
    }

    @Override
    public void onEvent(Pool pool, JobEvent event) {
        if (event.getTypeEvent() == JobEvent.INTERRUPTED) {
            System.out.println("Main side: Job Event " + event);
        }
    }

    @Override
    public void onSuccess(Pool pool, JobEvent event) {
        System.out.println(">>> Success " + event + " from pool " + pool.getName());
        System.out.println("Computation time: " + ((double)System.nanoTime() - this.chrono) / 1000000.0);
    }

    @Override
    public void onFailure(Pool pool, JobEvent event) {
        System.out.println(">>> Failure " + event + " from pool " + pool.getName());
        if (event.getException() != null) {
            event.getException().printStackTrace();
        }
    }

    public class MainProcessing
    extends Job
    implements PoolResponder {
        private ExecutionMode mode;
        private int nthreads = 0;
        private int njobs;
        private PoolResponder responder;
        private Pool pool;
        private int niter = 15;

        public MainProcessing(PoolResponder responder) {
            this.responder = responder;
        }

        public void setMode(ExecutionMode mode, int nthreads, int njobs) {
            this.mode = mode;
            this.njobs = njobs;
            this.nthreads = nthreads;
        }

        @Override
        public Object process() {
            WorkerDemo.this.bar.rewind();
            WorkerDemo.this.bar1.rewind();
            WorkerDemo.this.log.rewind();
            this.pool = new Pool("my", this.responder);
            MyWorker p1 = new MyWorker(this.niter, WorkerDemo.this.bar);
            p1.addMonitor(WorkerDemo.this.log);
            p1.addMonitor(WorkerDemo.this.bar1);
            this.pool.register(p1);
            int i = 0;
            while (i < this.njobs) {
                this.pool.register(new MyWorker(this.niter, WorkerDemo.this.bar));
                ++i;
            }
            this.pool.execute(this.mode, this.nthreads);
            System.out.println("End of main");
            return "End";
        }

        public void simulateAbort() {
            if (this.pool != null) {
                this.pool.getRegisteredJob(this.pool.size() - 1).abort();
            }
        }

        public void simulateCancellation() {
            if (this.pool != null) {
                this.pool.cancel();
            }
        }

        public void simulateException() {
            if (this.pool != null) {
                ((MyWorker)this.pool.getRegisteredJob((int)(this.pool.size() / 2 - 1))).withException = true;
            }
        }

        public void simulateJobException() {
            if (this.pool != null) {
                ((MyWorker)this.pool.getRegisteredJob((int)(this.pool.size() - 1))).withJobException = true;
            }
        }

        public void simulateInterruption() {
            if (this.pool != null) {
                ((MyWorker)this.pool.getRegisteredJob((int)(this.pool.size() - 1))).withInterruption = true;
            }
        }

        public void simulateTimeOut() {
            if (this.pool != null) {
                ((MyWorker)this.pool.getRegisteredJob((int)(this.pool.size() - 1))).withTimeOut = true;
            }
        }

        @Override
        public void onEvent(Pool pool, JobEvent event) {
            this.responder.onEvent(pool, event);
        }

        @Override
        public void onSuccess(Pool pool, JobEvent event) {
            this.responder.onSuccess(pool, event);
        }

        @Override
        public void onFailure(Pool pool, JobEvent event) {
            this.responder.onFailure(pool, event);
        }
    }

    public class MyWorker
    extends Job {
        public boolean withTimeOut;
        public boolean withInterruption;
        public boolean withException;
        public boolean withJobException;
        private int niter;

        public MyWorker(int niter, MonitorAbstract monitor) {
            super(monitor);
            this.withTimeOut = false;
            this.withInterruption = false;
            this.withException = false;
            this.withJobException = false;
            this.niter = 15;
            this.niter = niter;
        }

        @Override
        public Object process() throws RuntimeException {
            int i = 0;
            i = 0;
            while (i < this.niter && this.live) {
                this.increment(2.0, String.valueOf(this.getName()) + " " + this.live + " " + this.done);
                int j = 0;
                while (j < 600000 && this.live) {
                    Math.round(Math.cos(Math.exp(Math.pow(j, -3.0))));
                    ++j;
                }
                if (this.withJobException) {
                    throw new RuntimeException("It is a programming exception");
                }
                if (this.withInterruption) {
                    this.interrupt();
                }
                if (this.withTimeOut) {
                    this.niter += 2;
                }
                if (this.withException) {
                    double[] a = new double[2];
                    a[3] = 1.0;
                }
                if (!this.live) {
                    return "KO";
                }
                ++i;
            }
            System.out.println("End of " + this.getName() + " iterations:" + i + " " + this.live + " " + this.done);
            return "End of " + this.getName() + " iterations:" + i + " " + this.live + " " + this.done;
        }
    }
}

