/*
 * Decompiled with CFR 0.152.
 */
package psf.bornwolf;

import bilib.commons.components.GridToolbar;
import bilib.commons.components.SpinnerRangeDouble;
import bilib.commons.job.runnable.Job;
import bilib.commons.job.runnable.Pool;
import bilib.commons.settings.Settings;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import psf.PSF;
import psf.bornwolf.KirchhoffDiffractionSimpson;

public class BornWolfPSF
extends PSF {
    private double ni_Default = 1.5;
    private SpinnerRangeDouble spnNI = new SpinnerRangeDouble(this.ni_Default, 0.0, 3.0, 0.1);
    private JComboBox cmbAccuracy = new JComboBox<String>(new String[]{"Good", "Better", "Best"});
    private double ni = this.ni_Default;
    private int accuracy = 0;

    public BornWolfPSF() {
        this.fullname = "Born & Wolf 3D Optical Model";
        this.shortname = "BW";
    }

    public void setParameters(double ni, int accuracy) {
        this.ni = ni;
        this.accuracy = accuracy;
    }

    @Override
    public String getDescription() {
        String desc = "<h1>Born and Wolf</h1>";
        desc = String.valueOf(desc) + "<p>This model describes the scalar-based ";
        desc = String.valueOf(desc) + "diffraction that occurs in the microscope ";
        desc = String.valueOf(desc) + "when the particle is in focus ";
        desc = String.valueOf(desc) + "The imaging plane need not be in focus.</p>";
        return desc;
    }

    @Override
    public String checkSize(int nx, int ny, int nz) {
        if (nz < 3) {
            return "nz should be greater than 3.";
        }
        if (nx < 4) {
            return "nz should be greater than 4.";
        }
        if (ny < 4) {
            return "nz should be greater than 4.";
        }
        return "";
    }

    @Override
    public void resetParameters() {
        this.spnNI.set(this.ni_Default);
        this.cmbAccuracy.setSelectedIndex(0);
    }

    @Override
    public void fetchParameters() {
        this.ni = this.spnNI.get();
        this.accuracy = this.cmbAccuracy.getSelectedIndex();
    }

    @Override
    public JPanel buildPanel(Settings settings) {
        GridToolbar pn = new GridToolbar(false);
        pn.place(3, 0, "<html>Refractive index immersion</html>");
        pn.place(6, 0, "<html>Accuracy computation</html>");
        pn.place(3, 1, this.spnNI);
        pn.place(6, 1, this.cmbAccuracy);
        pn.place(3, 2, new JLabel("<html>ni</html>"));
        JPanel panel = new JPanel();
        panel.add(pn);
        settings.record("psf-" + this.shortname + "-NI", this.spnNI, "" + this.ni_Default);
        settings.record("psf-" + this.shortname + "-accuracy", this.cmbAccuracy, (String)this.cmbAccuracy.getItemAt(0));
        return panel;
    }

    @Override
    public void generate(Pool pool) {
        int z = 0;
        while (z < this.nz) {
            double defocus = this.resAxial * 1.0E-9 * ((double)z - ((double)this.nz - 1.0) / 2.0);
            BornWolf plane = new BornWolf(z, defocus);
            plane.addMonitor(this);
            pool.register(plane);
            ++z;
        }
    }

    public class BornWolf
    extends Job {
        private int OVER_SAMPLING = 1;
        private int z;
        private double defocus;

        public BornWolf(int z, double defocus) {
            this.z = z;
            this.defocus = defocus;
        }

        @Override
        public void process() {
            double x0 = (double)(BornWolfPSF.this.nx - 1) / 2.0;
            double y0 = (double)(BornWolfPSF.this.ny - 1) / 2.0;
            double xp = x0;
            double yp = y0;
            int maxRadius = (int)Math.round(Math.sqrt(((double)BornWolfPSF.this.nx - x0) * ((double)BornWolfPSF.this.nx - x0) + ((double)BornWolfPSF.this.ny - y0) * ((double)BornWolfPSF.this.ny - y0))) + 1;
            double[] r = new double[maxRadius * this.OVER_SAMPLING];
            double[] h = new double[r.length];
            KirchhoffDiffractionSimpson I = new KirchhoffDiffractionSimpson(this.defocus, BornWolfPSF.this.ni, BornWolfPSF.this.accuracy, BornWolfPSF.this.NA, BornWolfPSF.this.lambda);
            int n = 0;
            while (n < r.length) {
                r[n] = (double)n / (double)this.OVER_SAMPLING;
                h[n] = I.calculate(r[n] * BornWolfPSF.this.resLateral * 1.0E-9);
                if (!this.live) {
                    return;
                }
                ++n;
            }
            double[] slice = new double[BornWolfPSF.this.nx * BornWolfPSF.this.ny];
            int x = 0;
            while (x < BornWolfPSF.this.nx) {
                int y = 0;
                while (y < BornWolfPSF.this.ny) {
                    double rPixel = Math.sqrt(((double)x - xp) * ((double)x - xp) + ((double)y - yp) * ((double)y - yp));
                    int index = (int)Math.floor(rPixel * (double)this.OVER_SAMPLING);
                    slice[x + BornWolfPSF.this.nx * y] = h[index] + (h[index + 1] - h[index]) * (rPixel - r[index]) * (double)this.OVER_SAMPLING;
                    ++y;
                }
                if (!this.live) {
                    return;
                }
                ++x;
            }
            this.increment(90.0 / (double)BornWolfPSF.this.nz, this.z + " / " + BornWolfPSF.this.nz);
            ((BornWolfPSF)BornWolfPSF.this).data.data[this.z] = slice;
        }
    }
}

