/*
 * Decompiled with CFR 0.152.
 */
package mitiv.optim;

import mitiv.linalg.LinearEndomorphism;
import mitiv.linalg.Vector;
import mitiv.linalg.VectorSpace;
import mitiv.optim.BoundProjector;
import mitiv.optim.LBFGSOperator;
import mitiv.optim.OptimStatus;
import mitiv.optim.OptimTask;
import mitiv.optim.QuasiNewton;

public class BLMVM
extends QuasiNewton {
    protected LBFGSOperator H = null;
    protected double pginit;
    protected double pnorm;
    protected double sftol = 0.01;
    protected double[] bnd = new double[2];
    private final boolean saveMemory = true;
    protected Vector x0 = null;
    protected double f0 = 0.0;
    protected Vector g0 = null;
    protected Vector pg0 = null;
    protected Vector pg = null;
    protected double pgnorm = 0.0;
    protected Vector tmp = null;
    protected Vector p = null;
    protected double alpha;
    protected final BoundProjector projector;

    public BLMVM(VectorSpace vsp, BoundProjector bp, int m) {
        this(new LBFGSOperator(vsp, m), bp);
    }

    public BLMVM(LinearEndomorphism H0, BoundProjector bp, int m) {
        this(new LBFGSOperator(H0, m), bp);
    }

    private BLMVM(LBFGSOperator H, BoundProjector bp) {
        super(H.getSpace(), null);
        this.H = H;
        if (bp == null) {
            throw new IllegalArgumentException("Illegal null projector");
        }
        this.projector = bp;
        this.p = H.getSpace().create();
        this.getClass();
        this.pg0 = H.getSpace().create();
        this.pg = H.getSpace().create();
        this.tmp = H.getSpace().create();
    }

    @Override
    public OptimTask start() {
        this.evaluations = 0;
        this.iterations = 0;
        this.restarts = 0;
        return this.begin();
    }

    @Override
    public OptimTask restart() {
        ++this.restarts;
        return this.begin();
    }

    private OptimTask begin() {
        this.H.reset();
        return this.success(OptimTask.COMPUTE_FG);
    }

    @Override
    public OptimTask iterate(Vector x, double f, Vector g) {
        switch (this.getTask()) {
            case COMPUTE_FG: {
                ++this.evaluations;
                this.projector.projectDirection(x, g, true, this.pg);
                this.pgnorm = this.pg.norm2();
                if (this.evaluations == 1) {
                    this.pginit = this.pgnorm;
                }
                if (this.pgnorm <= this.getGradientThreshold(this.pginit)) {
                    return this.success(OptimTask.FINAL_X);
                }
                if (this.evaluations == 1) {
                    return this.success(OptimTask.NEW_X);
                }
                this.tmp.combine(1.0, x, -1.0, this.x0);
                if (f <= this.f0 + this.sftol * this.tmp.dot(this.g0)) {
                    ++this.iterations;
                    return this.success(OptimTask.NEW_X);
                }
                this.alpha /= 2.0;
                return this.nextStep(x);
            }
            case NEW_X: {
                if (this.iterations >= 1) {
                    this.H.update(x, this.x0, this.pg, this.pg0);
                }
            }
            case FINAL_X: {
                while (true) {
                    this.H.apply(this.p, g);
                    this.projector.projectDirection(x, this.p, true, this.tmp, this.bnd);
                    if (this.tmp.dot(g) > 0.0) break;
                    if (this.H.mp < 1) {
                        return this.failure(OptimStatus.BAD_PRECONDITIONER);
                    }
                    this.H.reset();
                    ++this.restarts;
                }
                this.alpha = Math.min(this.initialStep(x, this.p.norm2()), this.bnd[1]);
                this.x0 = this.H.s(0);
                this.g0 = this.H.y(0);
                if (this.H.mp == this.H.m) {
                    --this.H.mp;
                }
                this.x0.copy(x);
                this.g0.copy(g);
                this.pg0.copy(this.pg);
                this.f0 = f;
                return this.nextStep(x);
            }
        }
        return this.getTask();
    }

    protected OptimTask nextStep(Vector x) {
        x.combine(1.0, this.x0, -this.alpha, this.p);
        this.projector.projectVariables(x);
        return this.success(OptimTask.COMPUTE_FG);
    }

    protected double initialStep(Vector x, double dnorm) {
        double xnorm;
        if (this.H.mp >= 1 || this.H.rule == 0) {
            return 1.0;
        }
        if (0.0 < this.delta && this.delta < 1.0 && (xnorm = x.norm2()) > 0.0) {
            return xnorm / dnorm * this.delta;
        }
        return 1.0 / dnorm;
    }

    public Vector getProjectedGradient() {
        return this.evaluations >= 1 ? this.pg : null;
    }

    public double getProjectedGradientNorm2() {
        return this.evaluations >= 1 ? this.pgnorm : -1.0;
    }
}

