package plugins.lagache.roisr;

import icy.roi.BooleanMask2D;
import icy.roi.BooleanMask3D;

import icy.type.point.Point3D;
import icy.type.rectangle.Rectangle3D;

import java.awt.Point;
import java.util.ArrayList;


import plugins.adufour.vars.lang.VarDouble;
import plugins.adufour.vars.lang.VarSequence;
import plugins.kernel.roi.roi2d.ROI2DArea;
import plugins.kernel.roi.roi3d.ROI3DArea;

public class Ripley2D {
	// Calcul de la fonction de correlation (Ripley)
	public static ROI2DArea correlation_new(Window2D[][] imageWindows_1, double distance, VarSequence sequence1, int nbdeta,VarDouble threshold,VarDouble buffer) {

		
		ArrayList<Point3D> point_liste = new ArrayList<Point3D>();		
		for (int i = 0; i < imageWindows_1.length; i++) {
			for (int j = 0; j < imageWindows_1[i].length; j++) {					
				for (Point3D pos_a : imageWindows_1[i][j].detectionlist) {	
					double K=0;					
					for (int k = Math.max(i - 1, 0); k <= Math.min(i + 1, imageWindows_1.length - 1); k++) {
						for (int l = Math.max(j - 1, 0); l <= Math.min(j + 1, imageWindows_1[i].length - 1); l++) {							

							for (Point3D pos_b : imageWindows_1[k][l].detectionlist) {
								
								double temp = Math.sqrt(Math.pow(pos_a.getX() - pos_b.getX(), 2)
										+ Math.pow(pos_a.getY() - pos_b.getY(), 2));
								// Calcul du poids (Ripley)
								// calcul de la fonction de Ripley locale								
									if ((temp < distance) & (temp > 0.0)) {
										K += 1;																				
									}
								}
							}
						}					
					//calcul de la fonction L_a associée et ajout su nombre de coloc associé					
					if (K>threshold.getValue()){
						//on définit le pixel de la position a
						int ax = (int)(pos_a.getX());int ay = (int)(pos_a.getY());
						//on ajoute les pixels les points (i,j) dans un rayon de buffer 
						for (int k=Math.max((int)(ax-buffer.getValue()),0);k<Math.min(sequence1.getValue().getWidth(),(int)(ax+buffer.getValue()));k++){
							for (int l=Math.max((int)(ay-buffer.getValue()),0);l<Math.min(sequence1.getValue().getHeight(),(int)(ay+buffer.getValue()));l++){															
								//on crée le Point si il est dans le rayon distance
								if (Math.pow(k-ax, 2)+Math.pow(l-ay, 2)<Math.pow(buffer.getValue(), 2)){
								Point3D pt = new Point3D.Integer(k, l,0);
								point_liste.add(pt);
							}}}}}					
					}
				}						
		//on transforme la lsite de points en tableau
		Point[] point_tab=new Point[point_liste.size()];
		int inc=0;
		for (Point3D pt:point_liste)
		{
			Point pt0 = new Point((int)pt.getX(), (int)pt.getY());
			point_tab[inc]=pt0;inc++;}
		
		BooleanMask2D mask = new BooleanMask2D(point_tab);
		 ROI2DArea roi2d = new ROI2DArea(mask);
		return roi2d;
	}
}