package plugins.lagache.sequencegenerator;



import icy.image.IcyBufferedImage;
import icy.plugin.abstract_.Plugin;
import icy.sequence.Sequence;
import icy.type.DataType;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.lang.VarBoolean;
import plugins.adufour.vars.lang.VarInteger;
import plugins.adufour.vars.lang.VarSequence;

public class SequenceGenerator extends Plugin implements Block {

		VarInteger width = new VarInteger("Sequence width",200);
		VarInteger height = new VarInteger("Sequence height",200);		
		VarInteger depth = new VarInteger("Sequence depth",1);
		VarInteger length = new VarInteger("Sequence length",1);
		VarSequence sequence = new VarSequence("Sequence", null);

		@Override
		public void declareInput(VarList inputMap) {
			
			inputMap.add("Sequence width", width);
			inputMap.add("Sequence height", height);
			inputMap.add("Sequence depth", depth);
			inputMap.add("Sequence length", length);			
			}

		@Override
		public void declareOutput(VarList outputMap) {
			outputMap.add("Sequence", sequence);
		}


		@Override
		public void run() {
			 final Sequence out = new Sequence("ROI conversion");

		        out.beginUpdate();
		        try
		        {
		            for (int t = 0; t < length.getValue(); t++)
		                for (int z = 0; z < depth.getValue(); z++)
		                
		                    out.setImage(t, z, new IcyBufferedImage(width.getValue(),height.getValue(),1,DataType.UBYTE));
		            		            // notify data changed
		            out.dataChanged();
		        }
		        finally
		        {
		            out.endUpdate();
		        }
		        sequence.setValue(out);
		    }
}

