

from icy.image import IcyBufferedImage
from icy.sequence import SequenceUtil
from icy.type import DataType
from icy.type.collection.array import Array1DUtil
from icy.roi import ROI2DRectangle, BooleanMask2D


def getROI(input_seq):

    #
    #   1. get ROIs from input_seq
    #   2. build mask with ROIs
    #   3. convert mask to binary_sequence
    #
    
    rois = input_seq.getROI2Ds()

    # buid mask with ROIs
    if rois.size() == 0:
        bm = ROI2DRectangle(input_seq.getBounds()).getAsBooleanMask()
    else:
        bm = BooleanMask2D.getUnionBooleanMask(rois)
        
    bm.setBounds(input_seq.getBounds())
    mask = bm.mask

    # convert mask to bianary_sequence
    binary_img = IcyBufferedImage(input_seq.getSizeX(),
                                  input_seq.getSizeY(),
                                  1, DataType.UBYTE)
        
    binary_data = binary_img.getDataXY(0)
    bin_double = Array1DUtil.arrayToDoubleArray(binary_data,
                                                binary_img.isSignedDataType())
    counter = 0
    for i in range(len(bin_double)):
        if mask[i]:
            bin_double[i] = 255
            counter += 1   # count mask size(pixel)
        else:
            bin_double[i] = 0
        
    Array1DUtil.doubleArrayToSafeArray(bin_double,binary_data, 
                                       binary_img.isSignedDataType())
    binary_img.dataChanged()
    
    return binary_img, counter




if __name__ == "__main__" :
    from icy.main import Icy
    from icy.sequence import Sequence 
    
    seq = Icy.getMainInterface().getFocusedSequence() #Sequence
    img = Icy.getMainInterface().getFocusedImage() #IcyBufferedImage
    
    if seq == None:
        import sys
        sys.exit("No sequence")

    bin_img, count = getROI(seq)
            
    print count
    bin_seq = Sequence(bin_img)
    Icy.addSequence(bin_seq)
