

from icy.gui.dialog import MessageDialog
from icy.file import FileUtil, Saver
from icy.sequence import Sequence

import sys
import os
import datetime

# create save location
def createSaveLocation(input_seq, usersetting):
    
    save_dir = FileUtil.getDirectory(input_seq.getFilename())
    
    if save_dir:
        # save folder is made in the folder of the original image.
        save_dir += "save"

        if os.path.isdir(save_dir) == False:
            os.mkdir(save_dir)

        seq_name = input_seq.getName()
        name, ext = os.path.splitext(seq_name)
        name_img = name + "_result_image.tif"
        name_bin = name + "_result_bin.tif"
        name_data = name + "_result_data.txt"

        file_name_img = save_dir + FileUtil.separator + name_img
        file_name_bin = save_dir + FileUtil.separator + name_bin
        file_name_data = save_dir + FileUtil.separator + name_data
    else:
        # No pass in "input_seq",
        #            do not save result image. 

        MessageDialog.showDialog("Analysis result can not be saved because the saving location of this image can not be detected.")
        
        usersetting["export_out"] = False
        usersetting["export_bin"] = False
        usersetting["export_data"] = False

        file_name_img = "result_image.tif"
        file_name_bin = "result_bin.tif"
        file_name_data ="result_data.txt"
        

    return file_name_img, file_name_bin, file_name_data, usersetting
 
# save count data
def saveData(file_name_data, cc_list, input_seq, roi_size, parm_list):

    # basic information
    
    spots_area = 0
    for cc in cc_list:
        spots_area += cc.getSize()

    header = ("Date of creating this page\n",
              "{0}\n\n".format(datetime.datetime.now()),
              "Input :\t{0}\n".format(input_seq.getFilename()),
              "-"*20 + "\n",
              "Detector :\tMultiple RMP\n",
              "-"*20 + "\n",
              "Parameters\n",
              "upper limit :\t{0}\n".format(parm_list[0]),
              "lower limit :\t{0}\n".format(parm_list[1]),
              "threshold :\t{0}\n".format(parm_list[2]),
              "-"*20 + "\n"
              "ROI(pixel) :\t{0}\n".format(roi_size),
              "SPOT COUNTS :\t{0}\n".format(len(cc_list)),
              "AREA OF ALL SPOTS :\t{0}\n".format(spots_area),
              "-"*20 + "\n",
              "No.\tSize(pixel)\tMeanIntensity\tx-coordinate\ty-coordinate\n",)

    # detail information
    try:
        new = open(file_name_data,'w')
        new.writelines(header)
        for count, cc in enumerate(cc_list):
            intensity = cc.computeMeanIntensity(input_seq)
            line = "{0}\t{1}\t{2}\t{3}\t{4}\n".format(count, 
                                                 cc.getSize(),
                                                 intensity[0],
                                                 cc.getX(),
                                                 cc.getY())
            new.write(line)

        new.write("-"*20)        
    finally:
        new.close()

    return None
    
# save image
def saveImage(out_list, bin_list, out_save=False, bin_save=False):
    
    #save result image
    if out_save:
        file_out = FileUtil.createFile(out_list[0])
        out_seq = Sequence(out_list[1])
        Saver.save(out_seq,file_out,False,True)
    
    # save binary image
    if bin_save:
        file_bin = FileUtil.createFile(bin_list[0])
        bin_seq = Sequence(bin_list[1])
        Saver.save(bin_seq,file_bin,False,True)

    return None



if __name__ == "__main__" :
    from icy.main import Icy

    seq = Icy.getMainInterface().getFocusedSequence() #Sequence
    img = Icy.getMainInterface().getFocusedImage() #IcyBufferedImage
            
    if seq == None:
        import sys
        sys.exit("No sequence")
                
    fname_out, fname_bin, fname_data = createSaveLocation(seq)
    print fname_out
    print fname_bin
    print fname_data
    saveImage([fname_out,img],[fname_bin,img],True,True)

