

import sys

from icy.main import Icy
from icy.sequence import Sequence
from icy.file import Saver, FileUtil
from icy.gui.dialog import MessageDialog

from callosecountercascade import usingexecnet
from callosecountercascade import usingconnectedcomponents
from callosecountercascade import saving
from callosecountercascade import roi

# main processing
def mainCascade(usersetting, input_seq, is_act_seq):
            
    
    if input_seq == None:
        #MessageDialog.showDialog("Please load or reload the image.")
        return

    if input_seq.getSizeC() != 1:
        #MessageDialog.showDialog("\"Callose Counter\" requires an image of type : 8-bit grayscale")
        return
    
    # get channel[0]
    input_img = input_seq.getImage(0,0,0) 

        
    # get roi -> binary image
    roi_mask, roi_size = roi.getROI(input_seq)
        
    # using execnet 
    code = usingexecnet.callCode(usersetting["parm"])
    out, bin = usingexecnet.useExecnet(code, input_img, roi_mask,
                                       usersetting["pypath"])
        
    # create save location
    fname_out,fname_bin ,fname_data, usersetting = saving.createSaveLocation(
        input_seq,usersetting)
        
    # get spot data from binary image
    bin_seq = Sequence(bin)
    cc_list = usingconnectedcomponents.useConnectedComponents(bin_seq)
        
    # write and save .txt file 
    if usersetting["export_data"]:
        saving.saveData(fname_data, cc_list, input_seq, 
                        roi_size, usersetting["parm"])
    
    # save image
    saving.saveImage([fname_out,out], [fname_bin,bin],
                     usersetting["export_out"], usersetting["export_bin"])
    
        
        
    # display output image
    if is_act_seq:
        name_img = FileUtil.getFileName(fname_out)
        out_seq = Sequence(name_img,out)
        Icy.addSequence(out_seq)

    return None




if __name__ == "__main__" :
    from icy.main import Icy
    from icy.sequence import Sequence 
    
    seq = Icy.getMainInterface().getFocusedSequence() #Sequence
    img = Icy.getMainInterface().getFocusedImage() #IcyBufferedImage
    
    if seq == None:
        import sys
        sys.exit("No sequence")

    mainCascade(seq)
