package plugins.pparutto.trackmanager.processors;

import icy.gui.dialog.MessageDialog;
import icy.gui.util.GuiUtil;
import icy.main.Icy;
import icy.system.IcyExceptionHandler;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;

import plugins.fab.trackmanager.PluginTrackManagerProcessor;
import plugins.fab.trackmanager.TrackSegment;
import plugins.nchenouard.spot.Detection;

/**
 * Export tracks to CSV format.
 * 
 * @author Pierre Parutto
 */
public class TrackProcessorExportTrackToCSV extends PluginTrackManagerProcessor implements ActionListener
{
    public TrackProcessorExportTrackToCSV()
    {
        JButton exportTracksToCSVButton = new JButton("export tracks to CSV");
        setName("Export Tracks to CSV");

        panel.setLayout(new BoxLayout(panel, BoxLayout.PAGE_AXIS));
        panel.add(GuiUtil.createLineBoxPanel(exportTracksToCSVButton));
        exportTracksToCSVButton.addActionListener(this);
    }

    @Override
    public void Close()
    {
        //
    }

    @Override
    public void Compute()
    {
        //
    }

    @Override
    public void displaySequenceChanged()
    {
        //
    }

    @Override
    public void actionPerformed(ActionEvent e)
    {
        exportToCSV(new ArrayList<TrackSegment>(trackPool.getTrackSegmentList()));
    }

    private static void exportToCSV(List<TrackSegment> tracks)
    {
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle("Select CSV file.");

        int returnVal = chooser.showOpenDialog(null);
        if (returnVal != JFileChooser.APPROVE_OPTION)
            return;

        exportToCSV(tracks, chooser.getSelectedFile());
    }

    public static boolean exportToCSV(List<TrackSegment> trackSegmentList, File file)
    {
        try
        {
        	Writer writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file)));

            writer.write("TrackID,t,x,y,z\n");
            for (int i = 0; i < trackSegmentList.size(); ++i)
            {
            	TrackSegment ts = trackSegmentList.get(i);

                for (Detection d:  ts.getDetectionList())
                {
                    if (d.isEnabled())
                    {
                    	writer.write(String.valueOf(i) + "," +
                    				 String.valueOf(d.getT()) + "," +
                    				 String.valueOf(d.getX()) + "," +
                    				 String.valueOf(d.getY()) + "," +
                    				 String.valueOf(d.getZ()) + "\n");
                    }
                }
            }

            writer.close();
        }
        catch (Exception e)
        {
            if (Icy.getMainInterface().isHeadLess())
                IcyExceptionHandler.showErrorMessage(e, true);
            else
                MessageDialog.showDialog("Cannot open file.", MessageDialog.ERROR_MESSAGE);

            return false;
        }

        return true;
    }
}