/*
 * Decompiled with CFR 0.152.
 */
package plugins.ofuica.psfmoments;

import icy.image.IcyBufferedImage;
import icy.image.IcyBufferedImageUtil;
import icy.math.ArrayMath;
import icy.sequence.Sequence;
import plugins.adufour.ezplug.EzStatus;
import plugins.ofuica.psfmoments.MathUtils;
import plugins.ofuica.psfmoments.Result;

public class Moments {
    private final double maxRadius_;
    private final double precis_ = 0.01;
    private final double xs_;
    private final double ys_;
    private boolean normalize_ = true;

    public Moments(int X_dim, int Y_dim, double xs, double ys) throws Exception {
        this.maxRadius_ = X_dim > Y_dim ? (double)Y_dim / 2.0 - 1.0 : (double)X_dim / 2.0 - 1.0;
        this.xs_ = xs;
        this.ys_ = ys;
        if (this.maxRadius_ < 1.0) {
            throw new Exception("maxRadius: Wrong interest region.");
        }
    }

    public Moments(int X_dim, int Y_dim) throws Exception {
        this(X_dim, Y_dim, 1.0, 1.0);
    }

    public void setNormalize(boolean normalize) {
        this.normalize_ = normalize;
    }

    protected Object[] momentCentres(IcyBufferedImage image2d) {
        double S;
        int i;
        double[] v0m = new double[6];
        double[] v1m = new double[9];
        int X_dim = image2d.getWidth();
        int Y_dim = image2d.getHeight();
        double u00 = MathUtils.moment(image2d, 0, 0);
        double u10 = MathUtils.moment(image2d, 1, 0);
        double u01 = MathUtils.moment(image2d, 0, 1);
        double u11 = 0.0;
        double u20 = 0.0;
        double u02 = 0.0;
        for (i = 0; i < X_dim; ++i) {
            double di = i;
            double x = di - u10 / u00;
            for (int j = 0; j < Y_dim; ++j) {
                double dj = j;
                double y = dj - u01 / u00;
                u11 += x * y * image2d.getData(i, j, 0);
            }
        }
        if (Math.abs(u11) < 0.01) {
            u11 = 0.0;
        }
        for (i = 0; i < X_dim; ++i) {
            S = 0.0;
            for (int j = 0; j < Y_dim; ++j) {
                S += image2d.getData(i, j, 0);
            }
            double di = i;
            double T = di - u10 / u00;
            u20 += T * T * S;
        }
        for (int j = 0; j < Y_dim; ++j) {
            S = 0.0;
            for (int i2 = 0; i2 < X_dim; ++i2) {
                S += image2d.getData(i2, j, 0);
            }
            double dj = j;
            double T = dj - u01 / u00;
            u02 += T * T * S;
        }
        v0m[0] = u10;
        v0m[1] = u01;
        v0m[2] = u11;
        v0m[3] = u20;
        v0m[4] = u02;
        v0m[5] = u00;
        double u21 = 0.0;
        double u31 = 0.0;
        double u13 = 0.0;
        double u40 = 0.0;
        double u22 = 0.0;
        double u04 = 0.0;
        double u12 = 0.0;
        double u30 = 0.0;
        double u03 = 0.0;
        for (int i3 = 0; i3 < X_dim; ++i3) {
            double di = i3;
            double X = di - u10 / u00;
            double X2 = X * X;
            double X3 = X2 * X;
            double X4 = X3 * X;
            for (int j = 0; j < Y_dim; ++j) {
                double dj = j;
                double Y = dj - u01 / u00;
                double Y2 = Y * Y;
                double Y3 = Y2 * Y;
                double Y4 = Y3 * Y;
                double value = image2d.getData(i3, j, 0);
                u21 += X2 * Y * value;
                u31 += X3 * Y * value;
                u13 += X * Y3 * value;
                u12 += X * Y2 * value;
                u22 += X2 * Y2 * value;
                u40 += X4 * value;
                u04 += Y4 * value;
                u30 += X3 * value;
                u03 += Y3 * value;
            }
        }
        if (Math.abs(u31) < 0.01) {
            u31 = 0.0;
        }
        if (Math.abs(u13) < 0.01) {
            u13 = 0.0;
        }
        v1m[0] = u31;
        v1m[1] = u13;
        v1m[2] = u40;
        v1m[3] = u04;
        v1m[4] = u22;
        v1m[5] = u21;
        v1m[6] = u12;
        v1m[7] = u30;
        v1m[8] = u03;
        return new Object[]{v0m, v1m};
    }

    protected double alpha0(double[] v0m) {
        double t = v0m[3] - v0m[4];
        double s = 2.0 * v0m[2];
        if (Math.abs(t) < 0.01) {
            t = 0.0;
        }
        if (Math.abs(s) < 0.01) {
            s = 0.0;
        }
        if (t == 0.0) {
            if (s == 0.0) {
                return 0.0;
            }
            if (s > 0.0) {
                return 45.0;
            }
            return -45.0;
        }
        if (s == 0.0) {
            if (t < 0.0) {
                return -90.0;
            }
            if (t > 0.0) {
                return 0.0;
            }
        }
        double angle = 0.5 * Math.atan(s / t);
        if (t < 0.0 && s > 0.0) {
            angle += 1.5707963267948966;
        }
        if (t < 0.0 && s < 0.0) {
            angle -= 1.5707963267948966;
        }
        return angle * 180.0 / Math.PI;
    }

    protected double alpha1(double[] v1m) {
        double t = v1m[2] - v1m[3];
        double s = 2.0 * (v1m[0] + v1m[1]);
        if (Math.abs(t) < 0.01) {
            t = 0.0;
        }
        if (t == 0.0) {
            if (s == 0.0) {
                return 0.0;
            }
            if (s > 0.0) {
                return 45.0;
            }
            return -45.0;
        }
        if (s == 0.0) {
            if (t < 0.0) {
                return -90.0;
            }
            if (t > 0.0) {
                return 0.0;
            }
        }
        double angle = 0.5 * Math.atan(s / t);
        if (t < 0.0 && s > 0.0) {
            angle += 1.5707963267948966;
        }
        if (t < 0.0 && s < 0.0) {
            angle -= 1.5707963267948966;
        }
        return angle * 180.0 / Math.PI;
    }

    public Result[] calculate(Sequence seq) {
        return this.calculate(seq, null);
    }

    public Result[] calculate(Sequence seq, EzStatus status) {
        IcyBufferedImage image;
        int i;
        Sequence sequence = seq;
        int c = 0;
        int X_dim = sequence.getSizeX();
        int Y_dim = sequence.getSizeY();
        int Z_dim = sequence.getSizeZ();
        if (status != null) {
            status.setMessage("preparing image...");
        }
        double totalsom = 0.0;
        if (this.normalize_) {
            for (i = 0; i < Z_dim; ++i) {
                image = sequence.getImage(0, i, c);
                Object dataXY = image.getDataXY(c);
                totalsom += ArrayMath.sum((Object)dataXY, (boolean)sequence.isSignedDataType());
            }
        }
        for (i = 0; i < Z_dim; ++i) {
            if (status != null) {
                status.setCompletion((1.0 + (double)i) / (double)Z_dim);
            }
            image = sequence.getImage(0, i, c);
            image.beginUpdate();
            for (int j = 0; j < X_dim; ++j) {
                double x = j;
                x -= (double)X_dim / 2.0;
                x *= x;
                for (int k = 0; k < Y_dim; ++k) {
                    double y = k;
                    y -= (double)Y_dim / 2.0;
                    if (!(Math.sqrt(x + (y *= y)) > this.maxRadius_)) continue;
                    image.setData(j, k, 0, 0.0);
                }
            }
            if (this.normalize_) {
                Object dataXY = image.getDataXY(c);
                if (totalsom > 0.0) {
                    image.setDataXY(c, ArrayMath.multiply((Object)dataXY, (Number)(1.0 / totalsom)));
                }
            }
            image.endUpdate();
        }
        double u00 = 0.0;
        double a = 0.0;
        double b = 0.0;
        Result[] results = new Result[Z_dim];
        if (status != null) {
            status.setMessage("computing moments...");
        }
        for (int k = 0; k < Z_dim; ++k) {
            IcyBufferedImage tmp;
            if (status != null) {
                status.setCompletion((1.0 + (double)k) / (double)Z_dim);
            }
            IcyBufferedImage V0 = sequence.getImage(0, k, c);
            Object[] vms = this.momentCentres(V0);
            double[] v0m = (double[])vms[0];
            double[] v1m = (double[])vms[1];
            a = u00;
            b = u00 = v0m[5];
            double u20 = v0m[3];
            double u02 = v0m[4];
            double u11 = v0m[2];
            double XC = v0m[0] / u00;
            double YC = v0m[1] / u00;
            double u31 = v1m[0];
            double u13 = v1m[1];
            double u40 = v1m[2];
            double u04 = v1m[3];
            double u22 = v1m[4];
            double u21 = v1m[5];
            double u12 = v1m[6];
            double u30 = v1m[7];
            double u03 = v1m[8];
            double angle0 = this.alpha0(v0m);
            double angle1 = this.alpha1(v1m);
            IcyBufferedImage V0orig = IcyBufferedImageUtil.getCopy((IcyBufferedImage)V0);
            if (u00 == 0.0 || a == b) continue;
            double u002 = Math.pow(u00, 2.0);
            double u003 = Math.pow(u00, 3.0);
            double u0025 = Math.pow(u00, 2.5);
            Result result = new Result();
            result.plan = k;
            result.n11 = u11 / u002;
            result.n20 = u20 / u002;
            result.n02 = u02 / u002;
            result.n40 = u40 / u003;
            result.n04 = u04 / u003;
            result.n31 = u31 / u003;
            result.n13 = u13 / u003;
            result.n22 = u22 / u003;
            result.n21 = u21 / u0025;
            result.n12 = u12 / u0025;
            result.n30 = u30 / u0025;
            result.n03 = u03 / u0025;
            V0 = tmp = IcyBufferedImageUtil.rotate((IcyBufferedImage)V0, (double)XC, (double)YC, (double)(angle0 * Math.PI / 180.0), (IcyBufferedImageUtil.FilterType)IcyBufferedImageUtil.FilterType.BILINEAR);
            double[] para0 = this.rotCentralV0(V0, XC, YC);
            V0 = tmp = IcyBufferedImageUtil.rotate((IcyBufferedImage)V0orig, (double)XC, (double)YC, (double)(angle1 * Math.PI / 180.0), (IcyBufferedImageUtil.FilterType)IcyBufferedImageUtil.FilterType.BILINEAR);
            double[] para1 = this.rotCentralV1(V0, XC, YC);
            para0[0] = para0[0] * this.xs_;
            para0[1] = para0[1] * this.ys_;
            para1[0] = para1[0] * this.xs_;
            para1[1] = para1[1] * this.ys_;
            para1[2] = para1[2] * this.xs_;
            para1[3] = para1[3] * this.ys_;
            result.a0 = para0[0];
            result.b0 = para0[1];
            result.E0 = para0[2];
            result.Angle0 = angle0;
            result.R0 = para0[3];
            result.a1 = para1[0];
            result.b1 = para1[1];
            result.x1 = para1[2];
            result.y1 = para1[3];
            result.E1 = para1[4];
            result.Angle1 = angle1;
            result.R1 = para1[5];
            result.Xc = XC;
            result.Yc = YC;
            result.u00 = u00;
            results[k] = result;
        }
        return results;
    }

    protected double[] rotCentralV0(IcyBufferedImage V0, double XC, double YC) {
        double R0;
        double S;
        int i;
        double u20 = 0.0;
        double u02 = 0.0;
        for (i = 0; i < V0.getWidth(); ++i) {
            S = 0.0;
            double di = i;
            for (int j = 0; j < V0.getHeight(); ++j) {
                S += V0.getData(i, j, 0);
            }
            double T = di - XC;
            u20 += T * T * S;
        }
        for (i = 0; i < V0.getHeight(); ++i) {
            S = 0.0;
            for (int j = 0; j < V0.getWidth(); ++j) {
                S += V0.getData(j, i, 0);
            }
            double T = (double)i - YC;
            u02 += T * T * S;
        }
        double[] para0 = new double[]{Math.sqrt(u20), Math.sqrt(u02), 0.0, R0 = Math.sqrt(0.5 * (u20 + u02)), u20, u02};
        for (int i2 = 0; i2 < V0.getWidth(); ++i2) {
            double x = (double)i2 - XC;
            x *= x;
            for (int j = 0; j < V0.getHeight(); ++j) {
                double y = (double)j - YC;
                if (!(Math.sqrt(x + (y *= y)) < R0)) continue;
                para0[2] = para0[2] + V0.getData(i2, j, 0);
            }
        }
        return para0;
    }

    protected double[] rotCentralV1(IcyBufferedImage V0, double XC, double YC) {
        double R1;
        double u03 = 0.0;
        double u30 = 0.0;
        double u22 = 0.0;
        double u21 = 0.0;
        double u12 = 0.0;
        double u20 = 0.0;
        double u02 = 0.0;
        double u40 = 0.0;
        double u04 = 0.0;
        double u11 = 0.0;
        double u31 = 0.0;
        double u13 = 0.0;
        for (int i = 0; i < V0.getWidth(); ++i) {
            double X = (double)i - XC;
            double X2 = X * X;
            double X3 = X2 * X;
            double X4 = X3 * X;
            for (int j = 0; j < V0.getHeight(); ++j) {
                double Y = (double)j - YC;
                double Y2 = Y * Y;
                double Y3 = Y2 * Y;
                double Y4 = Y3 * Y;
                double val = V0.getData(i, j, 0);
                u11 += X * Y * val;
                u30 += X3 * val;
                u03 += Y3 * val;
                u31 += X3 * Y * val;
                u13 += X * Y3 * val;
                u40 += X4 * val;
                u04 += Y4 * val;
                u21 += X2 * Y * val;
                u12 += X * Y2 * val;
                u22 += X2 * Y2 * val;
                u20 += X2 * val;
                u02 += Y2 * val;
            }
        }
        double[] para1 = new double[16];
        para1[0] = Math.sqrt((u40 + u22) / (u02 + u20));
        para1[1] = Math.sqrt((u04 + u22) / (u02 + u20));
        para1[2] = (u30 + u12) / (u02 + u20);
        para1[3] = (u03 + u21) / (u02 + u20);
        para1[4] = 0.0;
        para1[5] = R1 = Math.sqrt(0.5 * (Math.pow(para1[0], 2.0) + Math.pow(para1[1], 2.0)));
        for (int i = 0; i < V0.getWidth(); ++i) {
            double x = (double)i - XC;
            x *= x;
            for (int j = 0; j < V0.getHeight(); ++j) {
                double y = (double)j - YC;
                if (!(Math.sqrt(x + (y *= y)) < R1)) continue;
                para1[4] = para1[4] + V0.getData(i, j, 0);
            }
        }
        para1[6] = u40;
        para1[7] = u04;
        para1[8] = u11;
        para1[9] = u31;
        para1[10] = u13;
        para1[11] = u22;
        para1[12] = u21;
        para1[13] = u12;
        para1[14] = u03;
        para1[15] = u30;
        if (Math.abs(para1[2]) < 0.01) {
            para1[2] = 0.0;
        }
        if (Math.abs(para1[3]) < 0.01) {
            para1[3] = 0.0;
        }
        return para1;
    }
}

