/*
 * Decompiled with CFR 0.152.
 */
package plugins.ofuica.psfmoments;

import icy.gui.frame.progress.FailedAnnounceFrame;
import icy.image.IcyBufferedImage;
import icy.sequence.MetaDataUtil;
import icy.sequence.Sequence;
import icy.sequence.SequenceUtil;
import icy.type.DataType;
import icy.type.collection.array.Array1DUtil;
import icy.type.point.Point3D;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import ome.xml.meta.OMEXMLMetadata;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.ezplug.EzComponent;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzVar;
import plugins.adufour.ezplug.EzVarBoolean;
import plugins.adufour.ezplug.EzVarChannel;
import plugins.adufour.ezplug.EzVarDouble;
import plugins.adufour.ezplug.EzVarIntegerArrayNative;
import plugins.adufour.ezplug.EzVarListener;
import plugins.adufour.ezplug.EzVarSequence;
import plugins.adufour.vars.gui.swing.WorkbookEditor;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarWorkbook;
import plugins.adufour.vars.util.VarException;
import plugins.adufour.vars.util.VarReferencingPolicy;
import plugins.adufour.workbooks.Workbooks;
import plugins.ofuica.psfmoments.Moments;
import plugins.ofuica.psfmoments.Result;

public class PSFMoments
extends EzPlug
implements Block {
    private final EzVarSequence sequence_ = new EzVarSequence("sequence");
    private final EzVarChannel channel_ = new EzVarChannel("channel", (Var)this.sequence_.getVariable(), false);
    private final EzVarBoolean clipping_ = new EzVarBoolean("clipping", true);
    private final EzVarBoolean normalize_ = new EzVarBoolean("normalize", true);
    private final EzVarBoolean autoScaling_ = new EzVarBoolean("auto scaling", false);
    private final EzVarDouble xs_ = new EzVarDouble("X scale factor", 0.00124, 0.0, Double.MAX_VALUE, 0.001);
    private final EzVarDouble ys_ = new EzVarDouble("Y scale factor", 0.00124, 0.0, Double.MAX_VALUE, 0.001);
    private final VarWorkbook book_ = new VarWorkbook("Workbook", (Workbook)null);
    private final EzVarBoolean autoSelectZone_ = new EzVarBoolean("auto select image's zone", false);
    private final EzVarIntegerArrayNative zoneShape_ = new EzVarIntegerArrayNative("zone shape", (int[][])new int[][]{{64, 64, 64}}, false);
    private final EzVarSequence outSequence_ = new EzVarSequence("image sequence");
    private final EzVarSequence momentSequence_ = new EzVarSequence("moments as sequence");
    private Moments moments_ = null;

    public void clean() {
    }

    public static void autoThreshold(Sequence sequence) {
        int c = 0;
        int X_dim = sequence.getSizeX();
        int Y_dim = sequence.getSizeY();
        int Z_dim = sequence.getSizeZ();
        double sum = 0.0;
        double zeros = 0.0;
        for (int z = 0; z < Z_dim; ++z) {
            for (int j = 0; j < Y_dim; ++j) {
                for (int i = 0; i < X_dim; ++i) {
                    double val = sequence.getData(0, z, c, j, i);
                    if (val == 0.0) {
                        zeros += 1.0;
                    }
                    sum += val;
                }
            }
        }
        double thr = sum / ((double)(X_dim * Y_dim * Z_dim) - zeros);
        int pixelClipped = 0;
        System.out.println("threhold: " + thr);
        System.out.println("zeros: " + zeros);
        for (int z = 0; z < Z_dim; ++z) {
            IcyBufferedImage img = sequence.getImage(0, z);
            Object data = img.getDataXY(c);
            sequence.beginUpdate();
            for (int j = 0; j < Y_dim; ++j) {
                for (int i = 0; i < X_dim; ++i) {
                    double newval = img.getData(i, j, c);
                    if (!(newval < thr)) continue;
                    Array1DUtil.setValue((Object)data, (int)img.getOffset(i, j), (double)0.0);
                    ++pixelClipped;
                }
            }
            sequence.endUpdate();
        }
        System.out.println("Clipping: " + (double)pixelClipped * 100.0 / ((double)(X_dim * Y_dim * Z_dim) - zeros) + " %");
    }

    private boolean validateMaxPoint(Point3D.Integer pt, int[] shape, Sequence s) {
        int shape_x_m = (int)((double)shape[0] * 0.5);
        int shape_y_m = (int)((double)shape[1] * 0.5);
        int shape_z_m = (int)((double)shape[2] * 0.5);
        boolean valid = pt.x >= shape_x_m && pt.y >= shape_y_m && pt.z >= shape_z_m && pt.x + shape_x_m < s.getSizeX() && pt.y + shape_y_m < s.getSizeY() && pt.z + shape_z_m < s.getSizeZ();
        return valid;
    }

    private Point3D.Integer findMaxPoint(Sequence sequence) {
        Point3D.Integer ret = new Point3D.Integer(-1, -1, -1);
        double maxValue = Double.MIN_VALUE;
        for (int x = 0; x < sequence.getSizeX(); ++x) {
            for (int y = 0; y < sequence.getSizeY(); ++y) {
                for (int z = 0; z < sequence.getSizeZ(); ++z) {
                    double v = sequence.getData(0, z, ((Integer)this.channel_.getValue()).intValue(), y, x);
                    if (!(v > maxValue)) continue;
                    ret.setX((double)x);
                    ret.setY((double)y);
                    ret.setZ((double)z);
                    maxValue = v;
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute() {
        if (this.sequence_.getValue() == null) {
            throw new VarException((Var)this.sequence_.getVariable(), "You should assign a sequence.");
        }
        if (this.channel_.getValue() == null) {
            throw new VarException(this.channel_.getVariable(), "You should select a channel.");
        }
        if (((int[])this.zoneShape_.getValue()).length != 3) {
            throw new VarException(this.zoneShape_.getVariable(), "The shape should contains three dimensions in (x, y, z) order.");
        }
        Sequence s = SequenceUtil.convertToType((Sequence)SequenceUtil.getCopy((Sequence)((Sequence)this.sequence_.getValue())), (DataType)DataType.DOUBLE, (boolean)false);
        Sequence sequence = SequenceUtil.extractChannel((Sequence)s, (int)((Integer)this.channel_.getValue()));
        if (((Boolean)this.clipping_.getValue()).booleanValue()) {
            PSFMoments.autoThreshold(sequence);
        }
        if (((Boolean)this.autoSelectZone_.getValue()).booleanValue()) {
            sequence = new Sequence("reshaped image");
            for (int z = 0; z < ((int[])this.zoneShape_.getValue())[2]; ++z) {
                IcyBufferedImage planImage = new IcyBufferedImage(((int[])this.zoneShape_.getValue())[0], ((int[])this.zoneShape_.getValue())[1], 1, DataType.DOUBLE);
                sequence.setImage(0, z, (BufferedImage)planImage);
            }
            Point3D.Integer maxPt = this.findMaxPoint(s);
            if (!this.validateMaxPoint(maxPt, (int[])this.zoneShape_.getValue(), s)) {
                System.out.println("The shape selected is not appropiate for the found hot point. ");
                return;
            }
            try {
                int shape_x_m = (int)((double)((int[])this.zoneShape_.getValue())[0] * 0.5);
                int shape_y_m = (int)((double)((int[])this.zoneShape_.getValue())[1] * 0.5);
                int shape_z_m = (int)((double)((int[])this.zoneShape_.getValue())[2] * 0.5);
                sequence.beginUpdate();
                int x = maxPt.x - shape_x_m;
                int i = 0;
                while (x < maxPt.x + shape_x_m) {
                    int y = maxPt.y - shape_y_m;
                    int j = 0;
                    while (y < maxPt.y + shape_y_m) {
                        int z = maxPt.z - shape_z_m;
                        int k = 0;
                        while (z < maxPt.z + shape_z_m) {
                            double value = s.getData(0, z, 0, y, x);
                            IcyBufferedImage icyimg = sequence.getImage(0, k);
                            if (icyimg != null) {
                                icyimg.setDataAsDouble(i, j, 0, value);
                            }
                            ++z;
                            ++k;
                        }
                        ++y;
                        ++j;
                    }
                    ++x;
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                sequence.endUpdate();
            }
        }
        if (((Boolean)this.autoScaling_.getValue()).booleanValue()) {
            OMEXMLMetadata meta = sequence.getOMEXMLMetadata();
            double xs = MetaDataUtil.getPixelSizeX((OMEXMLMetadata)meta, (int)0, (double)1.0);
            double ys = MetaDataUtil.getPixelSizeY((OMEXMLMetadata)meta, (int)0, (double)1.0);
            double mag = 64.0;
            this.xs_.setValue((Object)(xs / mag));
            this.ys_.setValue((Object)(ys / mag));
        }
        try {
            this.moments_ = new Moments(sequence.getSizeX(), sequence.getSizeY(), (Double)this.xs_.getValue(), (Double)this.ys_.getValue());
        }
        catch (Exception e) {
            new FailedAnnounceFrame(e.getMessage());
            return;
        }
        this.moments_.setNormalize((Boolean)this.normalize_.getValue());
        Result[] results = this.moments_.calculate(sequence, this.getStatus());
        Workbook wb = Workbooks.createEmptyWorkbook();
        this.book_.setValue((Object)wb);
        Sheet sheet = ((Workbook)this.book_.getValue()).createSheet("moments");
        Row header = sheet.createRow(0);
        header.getCell(0).setCellValue("plan");
        header.getCell(1).setCellValue("a0");
        header.getCell(2).setCellValue("b0");
        header.getCell(3).setCellValue("E0");
        header.getCell(4).setCellValue("Angle0");
        header.getCell(5).setCellValue("R0 en pixel");
        header.getCell(6).setCellValue("a1");
        header.getCell(7).setCellValue("b1");
        header.getCell(8).setCellValue("x1");
        header.getCell(9).setCellValue("y1");
        header.getCell(10).setCellValue("E1");
        header.getCell(11).setCellValue("Angle1");
        header.getCell(12).setCellValue("XC");
        header.getCell(13).setCellValue("YC");
        header.getCell(14).setCellValue("R1 en pixel");
        header.getCell(15).setCellValue("u00");
        header.getCell(16).setCellValue("n20");
        header.getCell(17).setCellValue("n02");
        header.getCell(18).setCellValue("n40");
        header.getCell(19).setCellValue("n04");
        header.getCell(20).setCellValue("n11");
        header.getCell(21).setCellValue("n31");
        header.getCell(22).setCellValue("n13");
        header.getCell(23).setCellValue("n22");
        header.getCell(24).setCellValue("n21");
        header.getCell(25).setCellValue("n12");
        header.getCell(26).setCellValue("n03");
        header.getCell(27).setCellValue("n30");
        Sequence msequence = new Sequence("moments");
        IcyBufferedImage image = new IcyBufferedImage(12, results.length, 1, DataType.DOUBLE);
        for (int k = 0; k < results.length; ++k) {
            Row row = sheet.createRow(k + 1);
            Result result = results[k];
            if (result == null) continue;
            row.createCell(0).setCellValue((double)result.plan);
            row.createCell(1).setCellValue(result.a0);
            row.createCell(2).setCellValue(result.b0);
            row.createCell(3).setCellValue(result.E0);
            row.createCell(4).setCellValue(result.Angle0);
            row.createCell(5).setCellValue(result.R0);
            row.createCell(6).setCellValue(result.a1);
            row.createCell(7).setCellValue(result.b1);
            row.createCell(8).setCellValue(result.x1);
            row.createCell(9).setCellValue(result.y1);
            row.createCell(10).setCellValue(result.E1);
            row.createCell(11).setCellValue(result.Angle1);
            row.createCell(12).setCellValue(result.R1);
            row.createCell(13).setCellValue(result.Xc);
            row.createCell(14).setCellValue(result.Yc);
            row.createCell(15).setCellValue(result.u00);
            row.createCell(16).setCellValue(result.n20);
            row.createCell(17).setCellValue(result.n02);
            row.createCell(18).setCellValue(result.n40);
            row.createCell(19).setCellValue(result.n04);
            row.createCell(20).setCellValue(result.n11);
            row.createCell(21).setCellValue(result.n31);
            row.createCell(22).setCellValue(result.n13);
            row.createCell(23).setCellValue(result.n22);
            row.createCell(24).setCellValue(result.n21);
            row.createCell(25).setCellValue(result.n12);
            row.createCell(26).setCellValue(result.n03);
            row.createCell(27).setCellValue(result.n30);
            image.setDataAsDouble(0, k, 0, result.a0);
            image.setDataAsDouble(1, k, 0, result.b0);
            image.setDataAsDouble(2, k, 0, result.E0);
            image.setDataAsDouble(3, k, 0, result.Angle0);
            image.setDataAsDouble(4, k, 0, result.R0);
            image.setDataAsDouble(5, k, 0, result.a1);
            image.setDataAsDouble(6, k, 0, result.b1);
            image.setDataAsDouble(7, k, 0, result.x1);
            image.setDataAsDouble(8, k, 0, result.y1);
            image.setDataAsDouble(9, k, 0, result.E1);
            image.setDataAsDouble(10, k, 0, result.Angle1);
            image.setDataAsDouble(11, k, 0, result.R1);
        }
        msequence.setImage(0, 0, (BufferedImage)image);
        this.outSequence_.setValue(sequence);
        this.momentSequence_.setValue(msequence);
    }

    protected void initialize() {
        this.getUI().setActionPanelVisible(true);
        this.addEzComponent((EzComponent)this.sequence_);
        this.addEzComponent((EzComponent)this.channel_);
        this.addEzComponent((EzComponent)this.clipping_);
        this.addEzComponent((EzComponent)this.normalize_);
        this.addEzComponent((EzComponent)this.autoScaling_);
        this.addEzComponent((EzComponent)this.xs_);
        this.addEzComponent((EzComponent)this.ys_);
        this.addEzComponent((EzComponent)this.autoSelectZone_);
        this.addEzComponent((EzComponent)this.zoneShape_);
        this.addEzComponent((EzComponent)this.momentSequence_);
        this.addEzComponent((EzComponent)this.outSequence_);
        if (this.book_.getValue() == null) {
            Workbook wb = Workbooks.createEmptyWorkbook();
            this.book_.setValue((Object)wb);
        }
        WorkbookEditor viewer = new WorkbookEditor(this.book_);
        viewer.setReadOnly(true);
        viewer.setEnabled(true);
        viewer.setFirstRowAsHeader(true);
        viewer.setOpenButtonVisible(false);
        viewer.setFirstRowAsHeader(true);
        JComponent jc = viewer.getEditorComponent();
        jc.setPreferredSize(new Dimension(400, 300));
        this.addComponent(jc);
        this.autoScaling_.addVarChangeListener((EzVarListener)new EzVarListener<Boolean>(){

            public void variableChanged(EzVar<Boolean> source, Boolean newValue) {
                PSFMoments.this.xs_.setEnabled(newValue == false);
                PSFMoments.this.ys_.setEnabled(newValue == false);
            }
        });
        this.autoSelectZone_.addVarChangeListener((EzVarListener)new EzVarListener<Boolean>(){

            public void variableChanged(EzVar<Boolean> source, Boolean newValue) {
                PSFMoments.this.zoneShape_.setEnabled(newValue.booleanValue());
            }
        });
        this.clipping_.setToolTipText("Enable this to clip the sequence");
        this.xs_.setToolTipText("x scaling factor (pixel_size/magnification)");
        this.ys_.setToolTipText("y scaling factor (pixel_size/magnification)");
        this.normalize_.setToolTipText("Enable this to normalize using the volume intensities");
        this.autoScaling_.setToolTipText("Enabling this scaling custom scaling factors are not taking in account.");
        this.autoSelectZone_.setToolTipText("Enable this to use automatic location and custom shape.");
    }

    public void declareInput(VarList inputMap) {
        this.clipping_.getVariable().setReferencingPolicy(VarReferencingPolicy.IN);
        this.normalize_.getVariable().setReferencingPolicy(VarReferencingPolicy.IN);
        inputMap.add(this.sequence_.getVariable().getName(), (Var)this.sequence_.getVariable());
        inputMap.add(this.channel_.getVariable().getName(), this.channel_.getVariable());
        inputMap.add(this.clipping_.getVariable().getName(), this.clipping_.getVariable());
        inputMap.add(this.autoScaling_.getVariable().getName(), this.autoScaling_.getVariable());
        inputMap.add(this.normalize_.getVariable().getName(), this.normalize_.getVariable());
        inputMap.add(this.autoSelectZone_.getVariable().getName(), this.autoSelectZone_.getVariable());
        inputMap.add(this.zoneShape_.getVariable().getName(), this.zoneShape_.getVariable());
    }

    public void declareOutput(VarList outputMap) {
        outputMap.add(this.outSequence_.getVariable().getName(), (Var)this.outSequence_.getVariable());
        outputMap.add(this.momentSequence_.getVariable().getName(), (Var)this.momentSequence_.getVariable());
        outputMap.add(this.book_.getName(), (Var)this.book_);
    }
}

