package plugins.adufour.ctc;

import icy.file.FileUtil;
import icy.file.Saver;
import icy.image.IcyBufferedImage;
import icy.plugin.abstract_.Plugin;
import icy.plugin.interface_.PluginBundled;
import icy.roi.ROI;
import icy.sequence.Sequence;
import icy.sequence.SequenceDataIterator;
import icy.sequence.SequenceUtil;
import icy.type.DataType;
import icy.util.StringUtil;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;

import plugins.adufour.activecontours.ActiveContour;
import plugins.adufour.activecontours.ActiveContours.ROIType;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.roi.Convexify;
import plugins.adufour.vars.gui.FileMode;
import plugins.adufour.vars.gui.model.FileTypeModel;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarFile;
import plugins.adufour.vars.lang.VarSequence;
import plugins.fab.trackmanager.TrackGroup;
import plugins.fab.trackmanager.TrackSegment;

public class ExportCTCResults extends Plugin implements Block, PluginBundled
{
    VarSequence     inSeq  = new VarSequence("Sequence dimensions", null);
    
    Var<TrackGroup> tracks = new Var<TrackGroup>("Tracks", TrackGroup.class);
    
    VarFile         folder = new VarFile("Export folder", null);
    
    @Override
    public void declareInput(VarList inputMap)
    {
        inputMap.add("dim", inSeq);
        inputMap.add("tracks", tracks);
        folder.setDefaultEditorModel(new FileTypeModel(null, FileMode.FOLDERS, null, false));
        inputMap.add("folder", folder);
    }
    
    @Override
    public void declareOutput(VarList outputMap)
    {
    }
    
    @Override
    public void run()
    {
        Sequence binSeq = new Sequence("Labeled output");
        
        Sequence seqIN = inSeq.getValue(true);
        
        for (int t = 0; t < seqIN.getSizeT(); t++)
        {
            binSeq.setImage(t, 0, new IcyBufferedImage(seqIN.getSizeX(), seqIN.getSizeY(), 1, DataType.USHORT));
        }
        
        try
        {
            String exportFolder = folder.getValue(true).getPath();
            
            File resFile = FileUtil.createFile(exportFolder + File.separator + "res_track.txt");
            FileWriter w = new FileWriter(resFile);
            
            ArrayList<TrackSegment> currentTracks = tracks.getValue(true).getTrackSegmentList();
            
            for (TrackSegment segment : currentTracks)
            {
                // id must be 1-based (0 is not used)
                int id = currentTracks.indexOf(segment) + 1;
                
                if (segment.getDetectionList().size() == 0) continue;
                
                // first frame of the segment
                int start = segment.getFirstDetection().getT();
                
                // last frame of the segment
                int end = segment.getLastDetection().getT();
                
                // export the labeled object
                for (int t = start; t <= end; t++)
                {
                    ActiveContour contour = (ActiveContour) segment.getDetectionAtTime(t);
                    
                    if (exportFolder.contains("SIM+") && exportFolder.contains("02_RES"))
                    {
                        ROI roi = Convexify.createConvexROI(contour.toROI(ROIType.POLYGON, null));
                        SequenceDataIterator it = new SequenceDataIterator(binSeq, roi, true, 0, t, 0);
                        while(!it.done())
                        {
                            it.set(id);
                            it.next();
                        }
                    }
                    else
                    {
                        contour.toSequence(binSeq, id);
                    }
                }
                
                // get the (unique) parent id
                
                // @Fabrice: why no getter for this field??
                Field field = TrackSegment.class.getDeclaredField("previousList");
                field.setAccessible(true);
                @SuppressWarnings("unchecked")
                ArrayList<TrackSegment> parents = (ArrayList<TrackSegment>) field.get(segment);
                // list should only have zero or one...
                int parent = parents.size() == 0 ? 0 : currentTracks.indexOf(parents.get(0)) + 1;
                
                w.write(id + " " + start + " " + end + " " + parent + "\n");
            }
            
            System.out.println("Exporting labels...");
            for (int t = 0; t < binSeq.getSizeT(); t++)
            {
                File imageFile = FileUtil.createFile(exportFolder + File.separator + "mask" + StringUtil.toString(t, 3) + ".tif");
                Saver.save(SequenceUtil.extractFrame(binSeq, t), imageFile, false, false);
            }
            
            w.flush();
            w.close();
        }
        catch (IOException e)
        {
            e.printStackTrace();
        }
        catch (SecurityException e)
        {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e)
        {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e)
        {
            e.printStackTrace();
        }
        catch (IllegalAccessException e)
        {
            e.printStackTrace();
        }
    }

    @Override
    public String getMainPluginClassName()
    {
        return CellTrackingChallenge2015.class.getName();
    }
}
