package plugins.adufour.ctc;

import icy.plugin.abstract_.Plugin;
import icy.plugin.interface_.PluginBundled;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.gui.FileMode;
import plugins.adufour.vars.gui.model.FileTypeModel;
import plugins.adufour.vars.lang.VarFile;
import plugins.adufour.vars.util.VarException;

public class CTCInput extends Plugin implements Block, PluginBundled
{
    VarFile dataFolder   = new VarFile("Input data", null);
    VarFile resultFolder = new VarFile("Result folder", null);
    
    @Override
    public void declareInput(VarList inputMap)
    {
        dataFolder.setDefaultEditorModel(new FileTypeModel(null, FileMode.FOLDERS, null, false));
        inputMap.add("input", dataFolder);
        
        resultFolder.setDefaultEditorModel(new FileTypeModel(null, FileMode.FOLDERS, null, false));
        inputMap.add("output", resultFolder);
    }
    
    @Override
    public void declareOutput(VarList outputMap)
    {
    }
    
    @Override
    public void run()
    {
        // just check that the inputs are correct
        if (!dataFolder.getValue(true).exists()) throw new VarException(dataFolder, "Invalid input folder");
    }
    
    @Override
    public String getMainPluginClassName()
    {
        return CellTrackingChallenge2015.class.getName();
    }
}
