package plugins.adufour.ctc;

import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;

import icy.file.FileUtil;
import icy.file.Loader;
import icy.plugin.abstract_.Plugin;
import icy.plugin.interface_.PluginBundled;
import icy.sequence.Sequence;
import icy.sequence.SequenceUtil;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.gui.FileMode;
import plugins.adufour.vars.gui.model.FileTypeModel;
import plugins.adufour.vars.lang.VarFile;
import plugins.adufour.vars.lang.VarSequence;

public class ReadCTCData extends Plugin implements Block, PluginBundled
{
    private VarFile     folder = new VarFile("Folder", null);
    
    private VarSequence seq    = new VarSequence("Sequence", null);
    
    @Override
    public void declareInput(VarList inputMap)
    {
        folder.setDefaultEditorModel(new FileTypeModel(null, FileMode.FOLDERS, null, false));
        inputMap.add("input folder", folder);
    }
    
    @Override
    public void declareOutput(VarList outputMap)
    {
        outputMap.add("sequence", seq);
    }

    @Override
    public void run()
    {
        String[] files = FileUtil.getFiles(folder.getValue().getPath(), new FileFilter()
        {
            @Override
            public boolean accept(File arg0)
            {
                return arg0.getPath().toLowerCase().endsWith("tif");
            }
        }, false, false, false);
        
        // 1) Load each file into a individual sequence
        // 2) Convert each sequence to a stack (necessary in 3D)
        // 3) Concatenate all into one sequence
        
        Arrays.sort(files);
        
        Sequence[] frames = new Sequence[files.length];
        for (int i = 0; i < files.length; i++)
        {
            Sequence frame = Loader.loadSequence(files[i], 0, false);
            if (frame.getSizeT() > 0) SequenceUtil.convertToStack(frame);
            frames[i] = frame;
        }
        
        Sequence out = SequenceUtil.concatT(frames);
        out.setName(FileUtil.getFileName(folder.getValue().getPath()));
        seq.setValue(out);
    }    
    
    /**
     * @param path
     */
    public void setFolder(String path)
    {
        folder.setValue(new File(path));
    }
    
    public Sequence getSequence()
    {
        return seq.getValue();
    }
    
    @Override
    public String getMainPluginClassName()
    {
        return CellTrackingChallenge2015.class.getName();
    }
}
