package plugins.lagache.endocytosissimulator;

import flanagan.math.PsRandom;
import plugins.adufour.ezplug.EzGroup;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzVarBoolean;
import plugins.adufour.ezplug.EzVarDouble;
import plugins.adufour.ezplug.EzVarEnum;
import plugins.adufour.ezplug.EzVarFile;
import plugins.adufour.ezplug.EzVarInteger;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;

import icy.file.FileUtil;
import icy.image.IcyBufferedImage;
import icy.main.Icy;
import icy.sequence.Sequence;
import icy.sequence.SequenceEvent;
import icy.sequence.SequenceListener;
import icy.util.XLSUtil;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;

public class EndocytosisSimulator extends EzPlug implements ActionListener , SequenceListener {
	
	
	//paramètre de la sequence, taille, intensité des spots, niveau de bruit..
	private EzVarInteger	seq_width = new EzVarInteger("Sequence width",512,1,100000,1);
	private EzVarInteger	seq_height = new EzVarInteger("Sequence height",512,1,100000,1);
	private EzVarInteger	seq_length = new EzVarInteger("Sequence length",100,0,1000,1);
	private EzVarDouble minIntensity = new EzVarDouble("Min. Spot intensity",5,0,100,1);
	private EzVarDouble maxIntensity = new EzVarDouble("Max. Spot intensity",10,0,100,1);	
	private EzVarDouble stdGaussian = new EzVarDouble("Std Gaussian noise",1,0,100,1);
	private EzVarDouble PoissonNoise = new EzVarDouble("Poisson noise",1,0,100,1);
	//paramètres spots motion	
	private EzVarDouble stdMotion = new EzVarDouble("Std. deviation of confined motion",1, 0,10 , 1);
	
	private enum type
    {
        EXPONENTIAL, GAUSSIAN
    }
	EzVarBoolean active_1= new EzVarBoolean("Population 1 is active",false);
	private EzVarInteger num_tracks_1 = new EzVarInteger("Number of Tracks Pop 1",100,0,100000,1);	
	private EzVarEnum<type> type1        = new EzVarEnum<type>("Type 1", type.values(), type.EXPONENTIAL);
	EzVarDouble tau_1 = new EzVarDouble("Time exponential 1");
	EzVarDouble mu_1 = new EzVarDouble("Mean time gaussian 1");
	EzVarDouble sigma_1 = new EzVarDouble("Std. time gaussian 1");
	
	EzVarBoolean active_2= new EzVarBoolean("Population 2 is active",false);
	private EzVarInteger num_tracks_2 = new EzVarInteger("Number of Tracks Pop 2",100,0,100000,1);
	private EzVarEnum<type> type2        = new EzVarEnum<type>("Type 2", type.values(), type.EXPONENTIAL);
	EzVarDouble tau_2 = new EzVarDouble("Time exponential 2");
	EzVarDouble mu_2 = new EzVarDouble("Mean time gaussian 2");
	EzVarDouble sigma_2 = new EzVarDouble("Std. time gaussian 2");
	
	
	EzVarBoolean active_3= new EzVarBoolean("Population 3 is active",false);
	private EzVarInteger num_tracks_3 = new EzVarInteger("Number of Tracks Pop 3",100,0,100000,1);
	private EzVarEnum<type> type3        = new EzVarEnum<type>("Type 3", type.values(), type.EXPONENTIAL);
	EzVarDouble tau_3 = new EzVarDouble("Time exponential 3");
	EzVarDouble mu_3 = new EzVarDouble("Mean time gaussian 3");
	EzVarDouble sigma_3 = new EzVarDouble("Std. time gaussian 3");
		
	EzVarBoolean active_4= new EzVarBoolean("Population 4 is active",false);
	private EzVarInteger num_tracks_4 = new EzVarInteger("Number of Tracks Pop 4",100,0,100000,1);
	private EzVarEnum<type> type4        = new EzVarEnum<type>("Type 4", type.values(), type.EXPONENTIAL);
	EzVarDouble tau_4 = new EzVarDouble("Time exponential 4");
	EzVarDouble mu_4 = new EzVarDouble("Mean time gaussian 4");
	EzVarDouble sigma_4 = new EzVarDouble("Std. time gaussian 4");
	
	EzVarBoolean active_5= new EzVarBoolean("Population 5 is active",false);
	private EzVarInteger num_tracks_5 = new EzVarInteger("Number of Tracks Pop 5",100,0,100000,1);
	private EzVarEnum<type> type5        = new EzVarEnum<type>("Type 5", type.values(), type.EXPONENTIAL);
	EzVarDouble tau_5 = new EzVarDouble("Time exponential 5");
	EzVarDouble mu_5 = new EzVarDouble("Mean time gaussian 5");
	EzVarDouble sigma_5 = new EzVarDouble("Std. time gaussian 5");
	
	EzVarBoolean active_6= new EzVarBoolean("Population 6 is active",false);
	private EzVarInteger num_tracks_6 = new EzVarInteger("Number of Tracks Pop 6",100,0,100000,1);
	private EzVarEnum<type> type6        = new EzVarEnum<type>("Type  6", type.values(), type.EXPONENTIAL);
	EzVarDouble tau_6 = new EzVarDouble("Time exponential 6");
	EzVarDouble mu_6 = new EzVarDouble("Mean time gaussian 6");
	EzVarDouble sigma_6 = new EzVarDouble("Std. time gaussian 6");	
	protected EzVarBoolean exportExcel = new EzVarBoolean("Export tracks to Excel",false);
	protected EzVarFile exportExcelFile = new EzVarFile("Excel file", "");
	    

	@Override
	protected void initialize() {

		EzGroup image_parameters = new EzGroup("Sequence parameters", seq_width,seq_height,seq_length,minIntensity,maxIntensity,stdGaussian,PoissonNoise);
		super.addEzComponent(image_parameters);
		super.addEzComponent(stdMotion);		
		
		super.addEzComponent(active_1);					
		super.addEzComponent(type1);
		super.addEzComponent(num_tracks_1);
		active_1.addVisibilityTriggerTo(num_tracks_1, true);
		active_1.addVisibilityTriggerTo(type1, true);
		super.addEzComponent(tau_1);
		type1.addVisibilityTriggerTo(tau_1, type.EXPONENTIAL);
		EzGroup gaussian1 = new EzGroup("Gaussian 1 parameters", mu_1,sigma_1);
		super.addEzComponent(gaussian1);
		type1.addVisibilityTriggerTo(gaussian1, type.GAUSSIAN);
		
		
		super.addEzComponent(active_2);					
		super.addEzComponent(type2);
		super.addEzComponent(num_tracks_2);
		active_2.addVisibilityTriggerTo(num_tracks_2, true);	
		active_2.addVisibilityTriggerTo(type2, true);
		super.addEzComponent(tau_2);
		type2.addVisibilityTriggerTo(tau_2, type.EXPONENTIAL);
		EzGroup gaussian2 = new EzGroup("Gaussian 2 parameters", mu_2,sigma_2);
		super.addEzComponent(gaussian2);
		type2.addVisibilityTriggerTo(gaussian2, type.GAUSSIAN);
		
		super.addEzComponent(active_3);
		super.addEzComponent(num_tracks_3);
		active_3.addVisibilityTriggerTo(num_tracks_3, true);									
		super.addEzComponent(type3);
		active_3.addVisibilityTriggerTo(type3, true);
		super.addEzComponent(tau_3);
		type3.addVisibilityTriggerTo(tau_3, type.EXPONENTIAL);
		EzGroup gaussian3 = new EzGroup("Gaussian 3 parameters", mu_3,sigma_3);
		super.addEzComponent(gaussian3);
		type3.addVisibilityTriggerTo(gaussian3, type.GAUSSIAN);
		
		super.addEzComponent(active_4);
		super.addEzComponent(num_tracks_4);
		active_4.addVisibilityTriggerTo(num_tracks_4, true);		
		super.addEzComponent(type4);
		active_4.addVisibilityTriggerTo(type4, true);
		super.addEzComponent(tau_4);
		type4.addVisibilityTriggerTo(tau_4, type.EXPONENTIAL);
		EzGroup gaussian4 = new EzGroup("Gaussian 4 parameters", mu_4,sigma_4);
		super.addEzComponent(gaussian4);
		type4.addVisibilityTriggerTo(gaussian4, type.GAUSSIAN);
		
		super.addEzComponent(active_5);
		super.addEzComponent(num_tracks_5);
		active_5.addVisibilityTriggerTo(num_tracks_5, true);				
		super.addEzComponent(type5);
		active_5.addVisibilityTriggerTo(type5, true);
		super.addEzComponent(tau_5);
		type5.addVisibilityTriggerTo(tau_5, type.EXPONENTIAL);
		EzGroup gaussian5 = new EzGroup("Gaussian 5 parameters", mu_5,sigma_5);
		super.addEzComponent(gaussian5);
		type5.addVisibilityTriggerTo(gaussian5, type.GAUSSIAN);
		
		
		super.addEzComponent(active_6);
		super.addEzComponent(type6);
		super.addEzComponent(num_tracks_6);
		active_6.addVisibilityTriggerTo(num_tracks_6, true);		
		active_6.addVisibilityTriggerTo(type6, true);
		super.addEzComponent(tau_6);
		type6.addVisibilityTriggerTo(tau_6, type.EXPONENTIAL);
		EzGroup gaussian6 = new EzGroup("Gaussian 6 parameters", mu_6,sigma_6);
		super.addEzComponent(gaussian6);
		type6.addVisibilityTriggerTo(gaussian6, type.GAUSSIAN);
		
		addEzComponent(new EzGroup("Export",exportExcel, exportExcelFile));		
		exportExcel.addVisibilityTriggerTo(exportExcelFile, true);	
			}

	@Override
	protected void execute() {
		//initialisation excel
		int row = 0;		
		WritableWorkbook WW = null;
		WritableSheet WS = null;
		if (exportExcel.getValue()) {
			int page = 1;
			try {
				File f = exportExcelFile.getValue(true);
				if (!FileUtil.getFileExtension(f.getPath(), false)
						.equalsIgnoreCase("xls"))
					f = new File(f.getPath() + ".xls");
				WW = XLSUtil.loadWorkbookForWrite(f); 
				}							
			 catch (Exception e) {
				e.printStackTrace();
				return;}			
			WS  = XLSUtil.createNewPage(WW, "Page" + page);
			XLSUtil.setCellString(WS, 0, 0, "Date of XLS page:");
			row++;
			XLSUtil.setCellString(WS, 0, row, new Date().toString());			
			row++;}
		//on crée autant de tracks que nécessaire (positions random, length determined by population parameters)
		ArrayList<EndoTrack> track_list = new ArrayList<EndoTrack>();
		PsRandom ran = new PsRandom();
		if (active_1.getValue()){		
			for (int i=0;i<num_tracks_1.getValue();i++)
			{
				//position de la tracks ds l'image
				double x = seq_width.getValue()*Math.random();
				double y = seq_height.getValue()*Math.random();	
				
				//int t_ini = (int)(seq_length.getValue()*Math.random());
				//int t_ini=(int)(0.1*Math.log(1-ran.nextDouble())*(-seq_length.getValue()));
				int t_ini=0;
				//par defaut on prend un temps de vie exponentiel
				int duration = (int)(Math.log(1-ran.nextDouble())*(-tau_1.getValue()));				
				//si le type est gaussien on change
				if (type1.getValue()==type.GAUSSIAN)				
					duration = (int)(ran.nextGaussian(mu_1.getValue(), sigma_1.getValue()));
				
				//on crée ensuite la track correspondante
				EndoTrack track = new EndoTrack(new Point2D.Double(x, y), t_ini, duration);
				//que l'on ajoute à la liste complète des tracks
				track_list.add(track);
			}}				
		if (active_2.getValue()){		
			for (int i=0;i<num_tracks_2.getValue();i++)
			{
				//position de la tracks ds l'image
				double x = seq_width.getValue()*Math.random();
				double y = seq_height.getValue()*Math.random();	
				
				//int t_ini=(int)(0.1*Math.log(1-ran.nextDouble())*(-seq_length.getValue()));
				int t_ini=0;
				//par defaut on prend un temps de vie exponentiel
				int duration = (int)(Math.log(1-ran.nextDouble())*(-tau_2.getValue()));				
				//si le type est gaussien on change
				if (type2.getValue()==type.GAUSSIAN)				
					duration = Math.max((int)(ran.nextGaussian(mu_2.getValue(), sigma_2.getValue())),0);
				
				//on crée ensuite la track correspondante
				EndoTrack track = new EndoTrack(new Point2D.Double(x, y), t_ini, duration);
				//que l'on ajoute à la liste complète des tracks
				track_list.add(track);
			}}	
		//ArrayList<Integer> tps=new ArrayList<Integer>();
		if (active_3.getValue()){		
			for (int i=0;i<num_tracks_3.getValue();i++)
			{
				//position de la tracks ds l'image
				double x = seq_width.getValue()*Math.random();
				double y = seq_height.getValue()*Math.random();					
				//int t_ini=(int)(0.1*Math.log(1-ran.nextDouble())*(-seq_length.getValue()));
				int t_ini=0;
				//tps.add(t_ini);
				//par defaut on prend un temps de vie exponentiel
				int duration = (int)(Math.log(1-ran.nextDouble())*(-tau_3.getValue()));				
				//si le type est gaussien on change
				if (type3.getValue()==type.GAUSSIAN)				
					duration = Math.max((int)(ran.nextGaussian(mu_3.getValue(), sigma_3.getValue())),0);
				
				//on crée ensuite la track correspondante
				EndoTrack track = new EndoTrack(new Point2D.Double(x, y), t_ini, duration);
				//que l'on ajoute à la liste complète des tracks
				track_list.add(track);
			}}	
		if (active_4.getValue()){		
			for (int i=0;i<num_tracks_4.getValue();i++)
			{
				//position de la tracks ds l'image
				double x = seq_width.getValue()*Math.random();
				double y = seq_height.getValue()*Math.random();	
				
				//int t_ini=(int)(0.1*Math.log(1-ran.nextDouble())*(-seq_length.getValue()));
				int t_ini=0;
				//par defaut on prend un temps de vie exponentiel
				int duration = (int)(Math.log(1-ran.nextDouble())*(-tau_4.getValue()));				
				//si le type est gaussien on change
				if (type4.getValue()==type.GAUSSIAN)				
					duration = Math.max((int)(ran.nextGaussian(mu_4.getValue(), sigma_4.getValue())),0);
				
				//on crée ensuite la track correspondante
				EndoTrack track = new EndoTrack(new Point2D.Double(x, y), t_ini, duration);
				//que l'on ajoute à la liste complète des tracks
				track_list.add(track);
			}}	
		if (active_5.getValue()){		
			for (int i=0;i<num_tracks_5.getValue();i++)
			{
				//position de la tracks ds l'image
				double x = seq_width.getValue()*Math.random();
				double y = seq_height.getValue()*Math.random();	
				
				//int t_ini=(int)(0.1*Math.log(1-ran.nextDouble())*(-seq_length.getValue()));
				int t_ini=0;
				//par defaut on prend un temps de vie exponentiel
				int duration = (int)(Math.log(1-ran.nextDouble())*(-tau_5.getValue()));				
				//si le type est gaussien on change
				if (type5.getValue()==type.GAUSSIAN)				
					duration = Math.max( (int)(ran.nextGaussian(mu_5.getValue(), sigma_5.getValue())),0);
				
				//on crée ensuite la track correspondante
				EndoTrack track = new EndoTrack(new Point2D.Double(x, y), t_ini, duration);
				//que l'on ajoute à la liste complète des tracks
				track_list.add(track);
			}}	
		if (active_6.getValue()){		
			for (int i=0;i<num_tracks_6.getValue();i++)
			{
				//position de la tracks ds l'image
				double x = seq_width.getValue()*Math.random();
				double y = seq_height.getValue()*Math.random();			
				
				//int t_ini=(int)(0.1*Math.log(1-ran.nextDouble())*(-seq_length.getValue()));
				int t_ini=0;
				//par defaut on prend un temps de vie exponentiel
				int duration = (int)(Math.log(1-ran.nextDouble())*(-tau_6.getValue()));				
				//si le type est gaussien on change
				if (type6.getValue()==type.GAUSSIAN)				
					duration = Math.max( (int)(ran.nextGaussian(mu_6.getValue(), sigma_6.getValue())),0);
				
				//on crée ensuite la track correspondante
				EndoTrack track = new EndoTrack(new Point2D.Double(x, y), t_ini, duration);
				//que l'on ajoute à la liste complète des tracks
				track_list.add(track);
			}}	
		
////////////////////////////////////////////////////////////////////
//export excel
if (exportExcel.getValue()){				
int nb = 1;
int col = 0;

// summary page

XLSUtil.setCellString(WS,col, row, "track : ");
XLSUtil.setCellString(WS,col + 1, row, "position x: ");
XLSUtil.setCellString(WS,col + 2, row, "position y: ");
XLSUtil.setCellString(WS,col + 3, row, "t_init  ");
XLSUtil.setCellString(WS,col + 4, row, "t_final  ");
XLSUtil.setCellString(WS,col + 5, row, "duration ");
row++;

for (EndoTrack track : track_list) {

XLSUtil.setCellNumber(WS,col, row, nb);
XLSUtil.setCellNumber(WS,col + 1, row, track.position.getX());
XLSUtil.setCellNumber(WS,col + 2, row, track.position.getY());
XLSUtil.setCellNumber(WS,col + 3, row, track.t_ini);
double t_final = Math.min(seq_length.getValue(), track.t_ini+track.duration);
XLSUtil.setCellNumber(WS,col + 4, row, t_final);
double duration = t_final - track.t_ini + 1;
XLSUtil.setCellNumber(WS,col + 5, row, duration);
row++;
nb++;
}}
///////////////////////////////	
if (exportExcel.getValue()) {
try {
XLSUtil.saveAndClose(WW);
} catch (WriteException e) {
//TODO Auto-generated catch block
e.printStackTrace();
} catch (IOException e) {
//TODO Auto-generated catch block
e.printStackTrace();}}
		
		Sequence sequence = new Sequence();		
		for (int t=0;t<seq_length.getValue();t++)
		{
			ArrayList<Point2D> positions = new ArrayList<Point2D>();
			//à xhaque temps, on récupère ttes les positions des tracks tq t_ini < t <t_ini+duration
			for (EndoTrack track:track_list){
				if ((track.t_ini <= t)&&(track.t_ini+track.duration >= t))
				{ Point2D pt = new Point2D.Double(track.position.getX()+ran.nextGaussian(0, stdMotion.getValue()),track.position.getY()+ran.nextGaussian(0, stdMotion.getValue()));
					positions.add(pt);
				}
			}
			//on crée ensuite l'image correspondante avec toutes les positions
			IcyBufferedImage image = image2D.main(positions,minIntensity.getValue(), maxIntensity.getValue(), seq_width, seq_height, seq_length, stdGaussian, PoissonNoise);
			sequence.addImage(t,image);					
			}
//on affice la sequence
		Icy.getMainInterface().addSequence(sequence);
}	
				
	
	@Override
	public void sequenceChanged(SequenceEvent sequenceEvent) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void sequenceClosed(Sequence sequence) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void actionPerformed(ActionEvent arg0) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void clean() {
		// TODO Auto-generated method stub
		
	}
}

