package plugins.lagache.endocytosissimulator;
import flanagan.math.PsRandom;
import icy.image.IcyBufferedImage;
import icy.type.DataType;
import java.awt.geom.Point2D;
import java.util.ArrayList;

import plugins.adufour.ezplug.*;
import plugins.nchenouard.particleTracking.sequenceGenerator.Profile;
import plugins.nchenouard.particleTracking.sequenceGenerator.TrackGeneratorWithProfiles;

public class image2D {
	
	public static IcyBufferedImage main(ArrayList<Point2D> positions,double iMin,double iMax,EzVarInteger seq_width,EzVarInteger seq_height,EzVarInteger seq_length, EzVarDouble stdGaussian, EzVarDouble PoissonNoise){
	
	int numParticles = positions.size();
	ArrayList<Profile> tmpProfiles1 = TrackGeneratorWithProfiles.createCLSM05Profiles_2d(numParticles, iMin, iMax, 0, 0);
	//crée l'Icy image avec les positions			
		double noiseSig=stdGaussian.getValue();
		double darkNoise=PoissonNoise.getValue();	
		double gain =1;	
		int[] dims=new int[2];
		dims[0]=seq_width.getValue();
		dims[1]=seq_height.getValue();		
		PsRandom ran = new PsRandom();
		double[] array1 =  new double[dims[0]*dims[1]];	

	int cnt = 0;
	for (Point2D d:positions)
	{			
							
		int[] maxDist = new int []{20,20};
		Profile p = tmpProfiles1.get(cnt);
		int minX = Math.max((int)(d.getX() - maxDist[0]), 0);
		int minY = Math.max((int)(d.getY() - maxDist[1]), 0);
		int maxX = Math.min((int)(d.getX() + maxDist[0]), dims[0]-1);
		int maxY = Math.min((int)(d.getY() + maxDist[1]), dims[1]-1);			
		for (int y0 = minY; y0<= maxY; y0++)
			for (int x0 = minX; x0<= maxX; x0++)
				array1[x0+y0*dims[0]] = array1[x0+y0*dims[0]] + p.getValue(new double[]{x0, y0, d.getX(), d.getY()});
		
		cnt++;
		}
		
	for(int i =0; i < array1.length; i++)
	{
	array1[i] = ran.nextGaussian(0, noiseSig) + gain*(ran.nextPoissonian(array1[i]) + ran.nextPoissonian(darkNoise));	
	}	
	
	IcyBufferedImage img1 = new IcyBufferedImage(dims[0], dims[1], 1, DataType.DOUBLE);	
	img1.setDataXYAsDouble(0, array1);		
	img1.dataChanged();	
	return img1;	
	}	
}



