package plugins.lagache.importlocalizations;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;

import icy.file.FileUtil;
import icy.plugin.abstract_.Plugin;
import icy.util.XLSUtil;
import jxl.Cell;
import jxl.Sheet;
import jxl.Workbook;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.lang.VarBoolean;
import plugins.adufour.vars.lang.VarDouble;
import plugins.adufour.vars.lang.VarDoubleArrayNative;
import plugins.adufour.vars.lang.VarFile;
import plugins.adufour.vars.lang.VarInteger;
import plugins.adufour.vars.lang.VarSequence;


public class ImportLocalizations extends Plugin implements Block {	
	
	VarFile input = new VarFile("Input",null);
	VarInteger col_x=new VarInteger("Column x", 1);
	VarInteger col_y=new VarInteger("Column y", 2);
	VarInteger col_z=new VarInteger("Column z", 3);
	VarBoolean proton_threshold = new VarBoolean("Define a protons'threshold for localizations", false);
	VarInteger col_p=new VarInteger("Column photons", 4);
	VarDouble photon_threshold = new VarDouble("Photon threshold (%)",0.5);
	VarBoolean scale_to_sequence = new VarBoolean("Scale localizations to sequence", false);
	VarSequence sequence = new VarSequence("Sequence to scale", null);
	VarDouble min_x = new VarDouble("Min. x of localizations", 0.0);
	VarDouble max_x = new VarDouble("Max. x of localizations", 20000.0);
	VarDouble min_y = new VarDouble("Min. y of localizations", 0.0);
	VarDouble max_y = new VarDouble("Max. y of localizations", 20000.0);
	VarDouble min_z = new VarDouble("Min. z of localizations", -1000.0);
	VarDouble max_z = new VarDouble("Max. z of localizations", 1000.0);
		
	
	
	VarDoubleArrayNative loc_x=new VarDoubleArrayNative("Localizations (x)", null);
	VarDoubleArrayNative loc_y=new VarDoubleArrayNative("Localizations (y)", null);
	VarDoubleArrayNative loc_z=new VarDoubleArrayNative("Localizations (z)", null);
	VarDoubleArrayNative nb_photons=new VarDoubleArrayNative("Number of photons", null);
		@Override
		public void declareInput(VarList inputMap) {
			inputMap.add("File with localizations",input);
			inputMap.add("Nb of column x",col_x);
			inputMap.add("Nb of column y",col_y);
			inputMap.add("Nb of column z",col_z);
			inputMap.add("Threshold protons'number per localization",proton_threshold);			
			inputMap.add("Nb of column photons",col_p);
			inputMap.add("Photon threshold (%)",photon_threshold);
			inputMap.add("Scaling to sequence?",scale_to_sequence);
			inputMap.add("Sequence to scale to",sequence);
			inputMap.add("Minimum x of localizations",min_x);
			inputMap.add("Maximum x of localizations",max_x);
			inputMap.add("Minimum y of localizations",min_y);
			inputMap.add("Maximum y of localizations",max_y);			
			inputMap.add("Minimum z of localizations",min_z);
			inputMap.add("Maximum z of localizations",max_z);
		}

		@Override
		public void declareOutput(VarList outputMap) {		
			outputMap.add("Localizations (x)",loc_x);
			outputMap.add("Localizations (y)",loc_y);
			outputMap.add("Localizations (z)",loc_z);
			outputMap.add("Number of photons",nb_photons);
		}

			@Override
		public void run() {
				ArrayList<Double> positions_x = new ArrayList<Double>();
				ArrayList<Double> positions_y = new ArrayList<Double>();
				ArrayList<Double> positions_z = new ArrayList<Double>();
				ArrayList<Double> nb_p = new ArrayList<Double>();
				ArrayList<Double> nb_p_copy = new ArrayList<Double>();
				
				int width = sequence.getValue().getWidth();
				int height = sequence.getValue().getHeight();
				int depth = sequence.getValue().getSizeZ();
				double amplitude_x=max_x.getValue()-min_x.getValue();
				double amplitude_y=max_y.getValue()-min_y.getValue();
				double amplitude_z=max_z.getValue()-min_z.getValue();
				double scaling_x = (double)width/amplitude_x;
				double scaling_y = (double)height/amplitude_y;
				double scaling_z = (double)depth/amplitude_z;
			
				Workbook WW;
								
				try {
						File f = input.getValue();
						if (!FileUtil.getFileExtension(f.getPath(), false)
								.equalsIgnoreCase("xls"))
							f = new File(f.getPath() + ".xls");
						WW = XLSUtil.loadWorkbookForRead(f);																				
						}							
					 catch (Exception e) {
						e.printStackTrace();
						return;}
				int nb_sheets = WW.getNumberOfSheets();				
				for (int s=0;s<nb_sheets;s++){
				Sheet sheet = WW.getSheet(s);
				 int rows; // No of rows
				    rows = sheet.getRows();
				    int cols = 0; // No of columns
				    int tmp = 0;

				    // This trick ensures that we get the data properly even if it doesn't start from first few rows
				    for(int i = 0; i < 10 || i < rows; i++) {
				        Cell[] row = sheet.getRow(i);
				        if(row != null) {
				            tmp = sheet.getRow(i).length;
				            if(tmp > cols) cols = tmp;
				        }
				    }

				    
				    for(int r = 1; r < rows; r++) {
				        Cell[] row = sheet.getRow(r);
				        if(row != null) {
				        	//on détermine si les cellules x,y,z et nb photons existent		        	 
				        		Cell cell_x= row[col_x.getValue()-1];Cell cell_y= row[col_y.getValue()-1];Cell cell_z= row[col_z.getValue()-1];
				        		if ((cell_x !=null)&(cell_y !=null))
			        			{
			        			//on remplit les listes			        	
			        				String x=cell_x.getContents().toString();x = x.replaceAll(",",".");
			        				positions_x.add(Double.parseDouble(x));
			        				String y=cell_y.getContents().toString();y = y.replaceAll(",",".");
			        				positions_y.add(Double.parseDouble(y));
			        			//eventuellement on remplit nombre de photons et positions 3D
			        				if (proton_threshold.getValue()){
						        		Cell cell_p=row[col_p.getValue()-1];				        		
					        			if(cell_p !=null){String p=cell_p.getContents().toString();p = p.replaceAll(",",".");nb_p.add(Double.parseDouble(p));nb_p_copy.add(Double.parseDouble(p));}}
			        				if(cell_z !=null){String z=cell_z.getContents().toString();z = z.replaceAll(",",".");positions_z.add(Double.parseDouble(z));}
			        			}}}
				//à la fin on vérifie que les listes ont la même taille pour l'export tableau
				int length_x=positions_x.size();int length_y=positions_y.size();int length_z=positions_z.size();
				if (proton_threshold.getValue()){	        						        		        			
				int length_p=nb_p.size();								
				//on ne choisit ensuite que les localizations avec suffisamment de photons
				Collections.sort(nb_p_copy);int index = (int)(photon_threshold.getValue()*length_p);
				double threshold_p = nb_p_copy.get(index);
				ArrayList<Double> positions_x_th = new ArrayList<Double>();
				ArrayList<Double> positions_y_th = new ArrayList<Double>();
				ArrayList<Double> positions_z_th = new ArrayList<Double>();
				ArrayList<Double> nb_p_th = new ArrayList<Double>();
				
				if ((length_x==length_y)&(length_x==length_p)){														
					for (int i=0;i<length_x;i++){
						if (nb_p.get(i)>threshold_p){
							positions_x_th.add(positions_x.get(i));
							positions_y_th.add(positions_y.get(i));
							if(length_x==length_z){
							positions_z_th.add(positions_z.get(i));}
							nb_p_th.add(nb_p.get(i));
						}
					}
				}
				if ((length_x==length_y)&(length_x==length_p)){
				//on recalcule les length
				length_x = positions_x_th.size();length_y=positions_y_th.size();length_p=nb_p_th.size();length_z=positions_z_th.size();							
				}				
				double[] pos_x=new double[length_x];double[] pos_y=new double[length_y];double[] pos_z=new double[length_z];double[] photons=new double[length_p];								
				for (int i=0;i<length_x;i++){
					if ((length_x==length_y)&(length_x==length_p)){
						pos_x[i]=positions_x_th.get(i);
						pos_y[i]=positions_y_th.get(i);
						if (scale_to_sequence.getValue()){
							//alors il faut recaler toutes les coordonnées par rapport aux dimensions de la sequence
							pos_x[i]=(min_x.getValue()+pos_x[i])*scaling_x;
							pos_y[i]=height-scaling_y*(pos_y[i]+min_y.getValue());}						
						if(length_x==length_z){
						pos_z[i]=positions_z_th.get(i);
						if (scale_to_sequence.getValue()){
						pos_z[i] = depth+(min_z.getValue()+pos_z[i]) *scaling_z;}
						}					
						photons[i]=nb_p_th.get(i);}}
				nb_photons.setValue(photons);
				loc_x.setValue(pos_x);loc_y.setValue(pos_y);loc_z.setValue(pos_z);
				}
				else{
						double[] pos_x=new double[length_x];double[] pos_y=new double[length_y];double[] pos_z=new double[length_z];
						if (length_x==length_y){
							for (int i=0;i<length_x;i++){	
						pos_x[i]=positions_x.get(i);pos_y[i]=positions_y.get(i);
						if (scale_to_sequence.getValue()){
							//alors il faut recaler toutes les coordonnées par rapport aux dimensions de la sequence
							pos_x[i]=(min_x.getValue()+pos_x[i])*scaling_x;
							pos_y[i]=height-scaling_y*(pos_y[i]+min_y.getValue());}		
						if(length_x==length_z){
							pos_z[i]=positions_z.get(i);
							if (scale_to_sequence.getValue()){
								pos_z[i] = depth+(min_z.getValue()+pos_z[i]) *scaling_z;}								
								}
							}
						}
						loc_x.setValue(pos_x);loc_y.setValue(pos_y);loc_z.setValue(pos_z);
						}				
					}				
			}
}
			
			
