package plugins.lagache.drawpoints;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.ArrayList;

import icy.plugin.abstract_.Plugin;
import icy.roi.BooleanMask2D;
import icy.roi.ROI2D;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.lang.VarColor;
import plugins.adufour.vars.lang.VarDouble;
import plugins.adufour.vars.lang.VarROIArray;
import plugins.adufour.vars.lang.VarSequence;
import plugins.adufour.vars.lang.VarString;
import plugins.kernel.roi.roi2d.ROI2DPoint;

// Colocalisation with Ripley function K
// Significant 

public class DrawPoints extends Plugin implements Block {

	// EzVarSwimmingObject<DetectionResult> detections = new
	// EzVarSwimmingObject<DetectionResult>("Detections");
	VarROIArray points = new VarROIArray("List of points");
	//VarDoubleArrayNative depth = new VarDoubleArrayNative("Depth of points",null);
	VarSequence input_sequence = new VarSequence("Input sequence", null);
	VarColor color = new VarColor("Cross color", Color.GREEN);
	VarString name = new VarString("Name of the overlay", "detections");
	VarDouble size = new VarDouble("Size", 1.0);	
		@Override
	public void declareInput(VarList inputMap) {

		inputMap.add("Points", points);
		//inputMap.add("Depth of points", depth);
		inputMap.add("Input Sequence", input_sequence);		
		inputMap.add("Color",color);
		inputMap.add("Size",size);		
		inputMap.add("Name of the overlay",name);
	}

	@Override
	public void declareOutput(VarList outputMap) {		
	}

		@Override
	public void run() {
			/*double z_min = depth.getValue()[0];
			double z_max = depth.getValue()[0];
			for (double d:depth.getValue()){				
				if (d>z_max){z_max=d;}
				if (d<z_min){z_min=d;}
			}
			double amplitude_z = z_max-z_min;*/
			ArrayList<scaledPositions> positions = new ArrayList<scaledPositions>();
		for (int i =0;i<points.getValue().length;i++){			
			Point2D pt = getMassCenter((ROI2D) points.getValue()[i]);
			double scale = 1.0;
			positions.add(new scaledPositions(pt, scale));			
		}
		 // Add the cross overlay, it becomes active after being added.				
        input_sequence.getValue().addOverlay(new crossPaint(positions,color.getValue(),size.getValue(),name.getValue()));
		}
		
		public static Point2D getMassCenter(ROI2D roi) {

			if (roi instanceof ROI2DPoint) {
				return roi.getPosition2D();
			} else {
				double x = 0, y = 0;

				final BooleanMask2D mask = roi.getBooleanMask(true);
				final boolean m[] = mask.mask;
				final int h = mask.bounds.height;
				final int w = mask.bounds.width;

				int off = 0;
				double total_weight = 0;
				final Point2D pos2d = roi.getPosition2D();
				for (int j = 0; j < h; j++) {
					for (int i = 0; i < w; i++) {
						if (m[off++]) {
							total_weight += 1;
							x += i;
							y += j;
						}
					}
				}
				return new Point2D.Double(pos2d.getX() + (x / total_weight), pos2d.getY() + (y / total_weight));
			}}
}
		
	

	