package plugins.lagache.drawpoints;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import icy.canvas.IcyCanvas;
import icy.canvas.IcyCanvas2D;
import icy.painter.Overlay;
import icy.sequence.Sequence;
import icy.type.point.Point5D;

public class crossPaint extends Overlay
{
	ArrayList<scaledPositions> positions;
	Color color;
	double size;	
	public crossPaint(ArrayList<scaledPositions> positions,Color color,double size,String name) {
		super(name);
		this.positions=positions;
		this.color=color;
		this.size=size;		
	}
       @Override
    public void paint(Graphics2D g, Sequence sequence, IcyCanvas canvas)
    {
        // check if we are dealing with a 2D canvas and we have a valid Graphics object
        if ((canvas instanceof IcyCanvas2D) && (g != null))
        {           
            g.setColor(color);
            
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);                      
            for (scaledPositions pt:positions){
            double size_rendering = size*pt.scale;	
            g.setStroke(new BasicStroke((float)size_rendering));
            Shape l1 = new Line2D.Double(pt.position.getX()-size_rendering, pt.position.getY()-size_rendering,pt.position.getX()+size_rendering,pt.position.getY()+size_rendering);
            g.draw(l1);
            Shape l2 = new Line2D.Double(pt.position.getX()-size_rendering, pt.position.getY()+size_rendering,pt.position.getX()+size_rendering,pt.position.getY()-size_rendering);
            g.draw(l2);}
        }
    }

       @Override
       public void mouseClick(MouseEvent e, Point5D.Double imagePoint, IcyCanvas canvas)
       {
           // check if we are dealing with a 2D canvas
           if (canvas instanceof IcyCanvas2D)
           {
            this.setReadOnly(true);             
           }
       }
}
