/*
 * Decompiled with CFR 0.152.
 */
package mcib3d.image3d;

import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.ImageCanvas;
import ij.io.FileInfo;
import ij.io.FileSaver;
import ij.io.Opener;
import ij.io.TiffEncoder;
import ij.measure.Calibration;
import ij.plugin.ContrastEnhancer;
import ij.plugin.ZProjector;
import ij.process.ImageProcessor;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import mcib3d.geom.Object3D;
import mcib3d.geom.Point3D;
import mcib3d.geom.Vector3D;
import mcib3d.geom.Voxel3D;
import mcib3d.image3d.BlankMask;
import mcib3d.image3d.ImageByte;
import mcib3d.image3d.ImageFloat;
import mcib3d.image3d.ImageInt;
import mcib3d.image3d.ImageShort;
import mcib3d.image3d.ImageStats;
import mcib3d.image3d.distanceMap3d.EDT;
import mcib3d.utils.ArrayUtil;
import mcib3d.utils.exceptionPrinter;

public abstract class ImageHandler {
    public static double defZoomFactor = 1.0;
    public int sizeX;
    public int sizeY;
    public int sizeZ;
    public int sizeXY;
    public int sizeXYZ;
    public int offsetX;
    public int offsetY;
    public int offsetZ;
    protected ImagePlus img;
    protected String title;
    double scaleXY = 1.0;
    double scaleZ = 1.0;
    String unit = "pix";
    HashMap<ImageHandler, ImageStats> stats = new HashMap(2);

    protected ImageHandler(ImagePlus img) {
        this.img = img;
        this.title = img.getShortTitle();
        this.sizeX = img.getWidth();
        this.sizeY = img.getHeight();
        this.sizeZ = img.getNSlices();
        this.sizeXY = this.sizeX * this.sizeY;
        this.sizeXYZ = this.sizeXY * this.sizeZ;
    }

    protected ImageHandler(ImageStack stack) {
        this.img = new ImagePlus("Image", stack);
        this.title = this.img.getShortTitle();
        this.sizeX = this.img.getWidth();
        this.sizeY = this.img.getHeight();
        this.sizeZ = this.img.getNSlices();
        this.sizeXY = this.sizeX * this.sizeY;
        this.sizeXYZ = this.sizeXY * this.sizeZ;
    }

    protected ImageHandler(String title, int sizeX, int sizeY, int sizeZ) {
        this.title = title;
        this.sizeX = sizeX;
        this.sizeY = sizeY;
        this.sizeZ = sizeZ;
        this.sizeXY = sizeX * sizeY;
        this.sizeXYZ = this.sizeXY * sizeZ;
    }

    protected ImageHandler(String title, int sizeX, int sizeY, int sizeZ, int offsetX, int offsetY, int offsetZ) {
        this.title = title;
        this.sizeX = sizeX;
        this.sizeY = sizeY;
        this.sizeZ = sizeZ;
        this.sizeXY = sizeX * sizeY;
        this.sizeXYZ = this.sizeXY * sizeZ;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.offsetZ = offsetZ;
    }

    public static ImageHandler wrap(ImagePlus imp) {
        switch (imp.getBitDepth()) {
            case 8: {
                return new ImageByte(imp);
            }
            case 16: {
                return new ImageShort(imp);
            }
            case 32: {
                return new ImageFloat(imp);
            }
        }
        return null;
    }

    public static ImageHandler wrap(ImageStack stack) {
        switch (stack.getBitDepth()) {
            case 8: {
                return new ImageByte(stack);
            }
            case 16: {
                return new ImageShort(stack);
            }
            case 32: {
                return new ImageFloat(stack);
            }
        }
        return null;
    }

    public static ImageHandler openImage(File f) throws Exception {
        Opener op = new Opener();
        op.setSilentMode(true);
        ImagePlus i = op.openImage(f.getAbsolutePath());
        i.setTitle(f.getName());
        i.setTitle(i.getShortTitle());
        switch (i.getBitDepth()) {
            case 8: {
                return new ImageByte(i);
            }
            case 16: {
                return new ImageShort(i);
            }
            case 32: {
                return new ImageFloat(i);
            }
        }
        return null;
    }

    public static ImageHandler newBlankImageHandler(String title, ImageHandler ih) {
        switch (ih.img.getBitDepth()) {
            case 8: {
                return new ImageByte(title, ih.sizeX, ih.sizeY, ih.sizeZ);
            }
            case 16: {
                return new ImageShort(title, ih.sizeX, ih.sizeY, ih.sizeZ);
            }
            case 32: {
                return new ImageFloat(title, ih.sizeX, ih.sizeY, ih.sizeZ);
            }
        }
        return null;
    }

    public static void zoom(ImagePlus image, double magnitude) {
        block4: {
            ImageCanvas ic;
            block3: {
                ic = image.getCanvas();
                if (ic == null) {
                    return;
                }
                ic.zoom100Percent();
                if (!(magnitude > 1.0)) break block3;
                for (int i = 0; i < (int)(magnitude + 0.5); ++i) {
                    ic.zoomIn(image.getWidth() / 2, image.getHeight() / 2);
                }
                break block4;
            }
            if (!(magnitude > 0.0) || !(magnitude < 1.0)) break block4;
            for (int i = 0; i < (int)(1.0 / magnitude + 0.5); ++i) {
                ic.zoomOut(image.getWidth() / 2, image.getHeight() / 2);
            }
        }
    }

    public static ImageShort merge3DBinary(ImageInt[] images, int sizeX, int sizeY, int sizeZ) {
        ImageShort out = new ImageShort("merge", sizeX, sizeY, sizeZ);
        if (images == null || images.length == 0 || images[0] == null) {
            return out;
        }
        for (int idx = 0; idx < images.length; ++idx) {
            short label = (short)(idx + 1);
            for (int z = 0; z < images[idx].sizeZ; ++z) {
                for (int y = 0; y < images[idx].sizeY; ++y) {
                    for (int x = 0; x < images[idx].sizeX; ++x) {
                        if (images[idx].getPixel(x, y, z) == 0.0f) continue;
                        int xx = x + images[idx].offsetX;
                        int yy = y + images[idx].offsetY;
                        int zz = z + images[idx].offsetZ;
                        if (zz < 0 || zz >= sizeZ || xx < 0 || xx >= sizeX || yy < 0 || yy >= sizeY) continue;
                        out.pixels[zz][xx + yy * sizeX] = label;
                    }
                }
            }
        }
        return out;
    }

    public static ImageShort merge3D(ImageInt[] images, int sizeX, int sizeY, int sizeZ) {
        ImageShort out = new ImageShort("merge", sizeX, sizeY, sizeZ);
        if (images == null || images.length == 0 || images[0] == null) {
            return out;
        }
        int offset = 1;
        for (ImageInt image : images) {
            short min = (short)image.getMinAboveValue(0.0f);
            short max = (short)image.getMax();
            for (int z = 0; z < image.sizeZ; ++z) {
                for (int y = 0; y < image.sizeY; ++y) {
                    for (int x = 0; x < image.sizeX; ++x) {
                        if (image.getPixel(x, y, z) == 0.0f) continue;
                        int val = image.getPixelInt(x, y, z);
                        int xx = x + image.offsetX;
                        int yy = y + image.offsetY;
                        int zz = z + image.offsetZ;
                        if (zz < 0 || zz >= sizeZ || xx < 0 || xx >= sizeX || yy < 0 || yy >= sizeY) continue;
                        out.pixels[zz][xx + yy * sizeX] = (short)(val - min + offset);
                    }
                }
            }
            offset += max - min + 1;
        }
        return out;
    }

    public static ImagePlus getHyperStack(String title, ImageHandler[] images) {
        ImageHandler.homogenizeBitDepth(images);
        ImageStack stack = new ImageStack(images[0].sizeX, images[0].sizeY, images[0].sizeZ * images.length);
        int count = 1;
        for (ImageHandler ih : images) {
            if (ih == null) continue;
            ih.setMinAndMax(null);
        }
        for (int slice = 1; slice <= images[0].sizeZ; ++slice) {
            for (ImageHandler image : images) {
                stack.setPixels(image.img.getStack().getPixels(slice), count);
                ++count;
            }
        }
        ImagePlus res = new ImagePlus();
        res.setStack(stack, images.length, images[0].sizeZ, 1);
        res.setTitle(title);
        res.setOpenAsHyperStack(true);
        return res;
    }

    public static void homogenizeBitDepth(ImageHandler[] images) {
        block6: {
            boolean shortIm;
            block5: {
                shortIm = false;
                boolean floatIm = false;
                for (ImageHandler im : images) {
                    if (im instanceof ImageShort) {
                        shortIm = true;
                        continue;
                    }
                    if (!(im instanceof ImageFloat)) continue;
                    floatIm = true;
                }
                if (!floatIm) break block5;
                for (int i = 0; i < images.length; ++i) {
                    if (images[i] instanceof ImageByte) {
                        images[i] = ((ImageByte)images[i]).convertToFloat(false);
                    }
                    if (!(images[i] instanceof ImageShort)) continue;
                    images[i] = ((ImageShort)images[i]).convertToFloat(false);
                }
                break block6;
            }
            if (!shortIm) break block6;
            for (int i = 0; i < images.length; ++i) {
                if (!(images[i] instanceof ImageByte)) continue;
                images[i] = ((ImageByte)images[i]).convertToShort(false);
            }
        }
    }

    public static void convertToByte(ImageHandler[] images) {
        for (int i = 0; i < images.length; ++i) {
            if (images[i] instanceof ImageShort) {
                images[i] = ((ImageShort)images[i]).convertToByte(true);
                continue;
            }
            if (!(images[i] instanceof ImageFloat)) continue;
            images[i] = ((ImageFloat)images[i]).convertToByte(true);
        }
    }

    public static void convertToByte(ImageHandler image) {
        if (image instanceof ImageShort) {
            image = ((ImageShort)image).convertToByte(true);
        } else if (image instanceof ImageFloat) {
            image = ((ImageFloat)image).convertToByte(true);
        }
    }

    public static ImageByte ToByte(ImageHandler image) {
        ImageByte imageByte = null;
        if (image instanceof ImageShort) {
            imageByte = ((ImageShort)image).convertToByte(true);
        } else if (image instanceof ImageFloat) {
            imageByte = ((ImageFloat)image).convertToByte(true);
        } else if (image instanceof ImageByte) {
            imageByte = (ImageByte)image.duplicate();
        }
        return imageByte;
    }

    public abstract double getSizeInMb();

    public ImagePlus getImagePlus() {
        return this.img;
    }

    public abstract int getType();

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
        if (this.img != null) {
            this.img.setTitle(title);
        }
    }

    @Deprecated
    public boolean sameDimentions(ImageHandler other) {
        return this.sameDimensions(other);
    }

    public boolean sameDimensions(ImageHandler other) {
        if (other == null) {
            return false;
        }
        return this.sizeX == other.sizeX && this.sizeY == other.sizeY && this.sizeZ == other.sizeZ;
    }

    @Deprecated
    public boolean sameDimentions(ImagePlus other) {
        return this.sameDimensions(other);
    }

    public boolean sameDimensions(ImagePlus other) {
        if (other == null) {
            return false;
        }
        return this.sizeX == other.getWidth() && this.sizeY == other.getHeight() && this.sizeZ == other.getNSlices();
    }

    public boolean contains(int x, int y, int z) {
        return x >= 0 && x < this.sizeX && y >= 0 && y < this.sizeY && z >= 0 && z < this.sizeZ;
    }

    public boolean contains(double x, double y, double z) {
        return x >= 0.0 && x < (double)this.sizeX && y >= 0.0 && y < (double)this.sizeY && z >= 0.0 && z < (double)this.sizeZ;
    }

    public boolean contains(Voxel3D V) {
        return V.x >= 0.0 && V.x < (double)this.sizeX && V.y >= 0.0 && V.y < (double)this.sizeY && V.z >= 0.0 && V.z < (double)this.sizeZ;
    }

    public boolean maskContains(int x, int y, int z) {
        return this.contains(x, y, z) && this.getPixel(x, y, z) != 0.0f;
    }

    public abstract float getPixel(int var1);

    public abstract float getPixel(int var1, int var2, int var3);

    public abstract float getPixel(int var1, int var2);

    public abstract float getPixel(Point3D var1);

    public abstract float getPixelInterpolated(Point3D var1);

    public float getPixel(float x, float y, float z) {
        int xbase = (int)x;
        int ybase = (int)y;
        int zbase = (int)z;
        float xFraction = x - (float)xbase;
        float yFraction = y - (float)ybase;
        float zFraction = z - (float)zbase;
        float xyz = this.getPixel(xbase, ybase, zbase);
        float x1yz = xbase + 1 < this.sizeX ? this.getPixel(xbase + 1, ybase, zbase) : 0.0f;
        float x1y1z = xbase + 1 < this.sizeX && ybase + 1 < this.sizeY ? this.getPixel(xbase + 1, ybase + 1, zbase) : 0.0f;
        float x1y1z1 = xbase + 1 < this.sizeX && ybase + 1 < this.sizeY && zbase + 1 < this.sizeZ ? this.getPixel(xbase + 1, ybase + 1, zbase + 1) : 0.0f;
        float x1yz1 = xbase + 1 < this.sizeX && zbase + 1 < this.sizeZ ? this.getPixel(xbase + 1, ybase, zbase + 1) : 0.0f;
        float xy1z = ybase + 1 < this.sizeY ? this.getPixel(xbase, ybase + 1, zbase) : 0.0f;
        float xy1z1 = ybase + 1 < this.sizeY && zbase + 1 < this.sizeZ ? this.getPixel(xbase, ybase + 1, zbase + 1) : 0.0f;
        float xyz1 = zbase + 1 < this.sizeZ ? this.getPixel(xbase, ybase, zbase + 1) : 0.0f;
        float upperAvplane = xy1z + xFraction * (x1y1z - xy1z);
        float lowerAvplane = xyz + xFraction * (x1yz - xyz);
        float upperAvplane1 = xy1z1 + xFraction * (x1y1z1 - xy1z1);
        float lowerAvplane1 = xyz1 + xFraction * (x1yz1 - xyz1);
        float plane = lowerAvplane + yFraction * (upperAvplane - lowerAvplane);
        float plane1 = lowerAvplane1 + yFraction * (upperAvplane1 - lowerAvplane1);
        return plane + zFraction * (plane1 - plane);
    }

    public float getPixel(float x, float y, float z, ImageInt mask) {
        float plane1;
        float plane;
        float lowerAvplane1;
        float upperAvplane1;
        float lowerAvplane;
        float upperAvplane;
        float xyz1;
        int xbase = (int)x;
        int ybase = (int)y;
        int zbase = (int)z;
        float xFraction = x - (float)xbase;
        float yFraction = y - (float)ybase;
        float zFraction = z - (float)zbase;
        float xyz = mask.maskContains(xbase, ybase, zbase) ? this.getPixel(xbase, ybase, zbase) : Float.NaN;
        float x1yz = mask.maskContains(xbase + 1, ybase, zbase) ? this.getPixel(xbase + 1, ybase, zbase) : Float.NaN;
        float x1y1z = mask.maskContains(xbase + 1, ybase + 1, zbase) ? this.getPixel(xbase + 1, ybase + 1, zbase) : Float.NaN;
        float x1y1z1 = mask.maskContains(xbase + 1, ybase + 1, zbase + 1) ? this.getPixel(xbase + 1, ybase + 1, zbase + 1) : Float.NaN;
        float x1yz1 = mask.maskContains(xbase + 1, ybase, zbase + 1) ? this.getPixel(xbase + 1, ybase, zbase + 1) : Float.NaN;
        float xy1z = mask.maskContains(xbase, ybase + 1, zbase) ? this.getPixel(xbase, ybase + 1, zbase) : Float.NaN;
        float xy1z1 = mask.maskContains(xbase, ybase + 1, zbase + 1) ? this.getPixel(xbase, ybase + 1, zbase + 1) : Float.NaN;
        float f = xyz1 = mask.maskContains(xbase, ybase, zbase + 1) ? this.getPixel(xbase, ybase, zbase + 1) : Float.NaN;
        float f2 = Float.isNaN(xy1z) ? x1y1z : (upperAvplane = Float.isNaN(x1y1z) ? xy1z : xy1z + xFraction * (x1y1z - xy1z));
        float f3 = Float.isNaN(xyz) ? x1yz : (lowerAvplane = Float.isNaN(x1yz) ? xyz : xyz + xFraction * (x1yz - xyz));
        float f4 = Float.isNaN(xy1z1) ? x1y1z1 : (upperAvplane1 = Float.isNaN(x1y1z1) ? xy1z1 : xy1z1 + xFraction * (x1y1z1 - xy1z1));
        float f5 = Float.isNaN(x1yz1) ? xyz1 : (lowerAvplane1 = Float.isNaN(xyz1) ? x1yz1 : xyz1 + xFraction * (x1yz1 - xyz1));
        float f6 = Float.isNaN(lowerAvplane) ? upperAvplane : (plane = Float.isNaN(upperAvplane) ? lowerAvplane : lowerAvplane + yFraction * (upperAvplane - lowerAvplane));
        float f7 = Float.isNaN(lowerAvplane1) ? upperAvplane1 : (plane1 = Float.isNaN(upperAvplane1) ? lowerAvplane1 : lowerAvplane1 + yFraction * (upperAvplane1 - lowerAvplane1));
        return Float.isNaN(plane) ? plane1 : (Float.isNaN(plane1) ? (Float.isNaN(xyz) ? this.getPixel(xbase, ybase, zbase) : xyz) : plane + zFraction * (plane1 - plane));
    }

    public ArrayUtil getNeighborhood3x3x3(int x, int y, int z) {
        ArrayUtil res = new ArrayUtil(27);
        int idx = 0;
        for (int k = z - 1; k <= z + 1; ++k) {
            for (int j = y - 1; j <= y + 1; ++j) {
                for (int i = x - 1; i <= x + 1; ++i) {
                    if (i < 0 || j < 0 || k < 0 || i >= this.sizeX || j >= this.sizeY || k >= this.sizeZ) continue;
                    res.putValue(idx, this.getPixel(i, j, k));
                    ++idx;
                }
            }
        }
        res.setSize(idx);
        return res;
    }

    public ArrayUtil getNeighborhoodXY3x3(int x, int y, int z) {
        ArrayUtil res = new ArrayUtil(9);
        int idx = 0;
        int k = z;
        for (int j = y - 1; j <= y + 1; ++j) {
            for (int i = x - 1; i <= x + 1; ++i) {
                if (i < 0 || j < 0 || k < 0 || i >= this.sizeX || j >= this.sizeY || k >= this.sizeZ) continue;
                res.putValue(idx, this.getPixel(i, j, k));
                ++idx;
            }
        }
        res.setSize(idx);
        return res;
    }

    public ArrayList<Voxel3D> getNeighborhood3x3x3ListCenter(int x, int y, int z) {
        ArrayList<Voxel3D> res = new ArrayList<Voxel3D>(27);
        for (int k = z - 1; k <= z + 1; ++k) {
            for (int j = y - 1; j <= y + 1; ++j) {
                for (int i = x - 1; i <= x + 1; ++i) {
                    if (i < 0 || j < 0 || k < 0 || i >= this.sizeX || j >= this.sizeY || k >= this.sizeZ) continue;
                    res.add(new Voxel3D(i, j, k, this.getPixel(i, j, k)));
                }
            }
        }
        return res;
    }

    public ArrayList<Voxel3D> getNeighborhood3x3x3ListNoCenter(int x, int y, int z) {
        ArrayList<Voxel3D> res = new ArrayList<Voxel3D>(27);
        for (int k = z - 1; k <= z + 1; ++k) {
            for (int j = y - 1; j <= y + 1; ++j) {
                for (int i = x - 1; i <= x + 1; ++i) {
                    if (i == x && j == y && k == z || i < 0 || j < 0 || k < 0 || i >= this.sizeX || j >= this.sizeY || k >= this.sizeZ) continue;
                    res.add(new Voxel3D(i, j, k, this.getPixel(i, j, k)));
                }
            }
        }
        return res;
    }

    public ArrayUtil getNeighborhoodCross3D(int x, int y, int z) {
        ArrayUtil res = new ArrayUtil(7);
        res.putValue(0, this.getPixel(x, y, z));
        int idx = 1;
        if (x + 1 < this.sizeX) {
            res.putValue(idx, this.getPixel(x + 1, y, z));
            ++idx;
        }
        if (x - 1 >= 0) {
            res.putValue(idx, this.getPixel(x - 1, y, z));
            ++idx;
        }
        if (y + 1 < this.sizeY) {
            res.putValue(idx, this.getPixel(x, y + 1, z));
            ++idx;
        }
        if (y - 1 >= 0) {
            res.putValue(idx, this.getPixel(x, y - 1, z));
            ++idx;
        }
        if (z + 1 < this.sizeZ) {
            res.putValue(idx, this.getPixel(x, y, z + 1));
            ++idx;
        }
        if (z - 1 >= 0) {
            res.putValue(idx, this.getPixel(x, y, z - 1));
            ++idx;
        }
        res.setSize(idx);
        return res;
    }

    public ArrayList<Voxel3D> getNeighborhoodCross3DList(int x, int y, int z, boolean excludeCenter) {
        ArrayList<Voxel3D> res = new ArrayList<Voxel3D>();
        if (!excludeCenter) {
            res.add(new Voxel3D(x, y, z, this.getPixel(x, y, z)));
        }
        if (x + 1 < this.sizeX) {
            res.add(new Voxel3D(x + 1, y, z, this.getPixel(x + 1, y, z)));
        }
        if (x - 1 >= 0) {
            res.add(new Voxel3D(x - 1, y, z, this.getPixel(x - 1, y, z)));
        }
        if (y + 1 < this.sizeY) {
            res.add(new Voxel3D(x, y + 1, z, this.getPixel(x, y + 1, z)));
        }
        if (y - 1 >= 0) {
            res.add(new Voxel3D(x, y - 1, z, this.getPixel(x, y - 1, z)));
        }
        if (z + 1 < this.sizeZ) {
            res.add(new Voxel3D(x, y, z + 1, this.getPixel(x, y, z + 1)));
        }
        if (z - 1 >= 0) {
            res.add(new Voxel3D(x, y, z - 1, this.getPixel(x, y, z - 1)));
        }
        return res;
    }

    public ArrayUtil getNeighborhood(int x, int y, int z, float radx, float rady, float radz) {
        return this.getNeighborhoodSphere(x, y, z, radx, rady, radz);
    }

    public ArrayUtil getNeighborhoodSphere(int x, int y, int z, float radx, float rady, float radz) {
        int index = 0;
        double rx2 = radx != 0.0f ? (double)(radx * radx) : 1.0;
        double ry2 = rady != 0.0f ? (double)(rady * rady) : 1.0;
        double rz2 = radz != 0.0f ? (double)(radz * radz) : 1.0;
        int vx = (int)Math.ceil(radx);
        int vy = (int)Math.ceil(rady);
        int vz = (int)Math.ceil(radz);
        double[] pix = new double[(2 * vx + 1) * (2 * vy + 1) * (2 * vz + 1)];
        for (int k = z - vz; k <= z + vz; ++k) {
            for (int j = y - vy; j <= y + vy; ++j) {
                for (int i = x - vx; i <= x + vx; ++i) {
                    double dist;
                    if (i < 0 || j < 0 || k < 0 || i >= this.sizeX || j >= this.sizeY || k >= this.sizeZ || !((dist = (double)((x - i) * (x - i)) / rx2 + (double)((y - j) * (y - j)) / ry2 + (double)((z - k) * (z - k)) / rz2) <= 1.0)) continue;
                    pix[index] = this.getPixel(i, j, k);
                    ++index;
                }
            }
        }
        ArrayUtil t = new ArrayUtil(pix);
        t.setSize(index);
        return t;
    }

    public ArrayUtil getNeighborhoodKernel(int[] ker, int nbval, int x, int y, int z, float radx, float rady, float radz) {
        ArrayUtil pix = new ArrayUtil(nbval);
        int vx = (int)Math.ceil(radx);
        int vy = (int)Math.ceil(rady);
        int vz = (int)Math.ceil(radz);
        int index = 0;
        int c = 0;
        for (int k = z - vz; k <= z + vz; ++k) {
            for (int j = y - vy; j <= y + vy; ++j) {
                for (int i = x - vx; i <= x + vx; ++i) {
                    if (ker[c] > 0 && i >= 0 && j >= 0 && k >= 0 && i < this.sizeX && j < this.sizeY && k < this.sizeZ) {
                        pix.putValue(index, this.getPixel(i, j, k));
                        ++index;
                    }
                    ++c;
                }
            }
        }
        pix.setSize(index);
        return pix;
    }

    public ArrayUtil getNeighborhoodKernel(Object3D obj, int x, int y, int z) {
        int xmax;
        int xmin;
        int ymax;
        int ymin;
        int zmax;
        int nbval = obj.getVolumePixels();
        ArrayUtil pix = new ArrayUtil(nbval);
        ImageInt seg = obj.getLabelImage();
        int[] bb = obj.getBoundingBox();
        float radx = (float)(0.5 * (double)(bb[1] - bb[0]));
        float rady = (float)(0.5 * (double)(bb[3] - bb[2]));
        float radz = (float)(0.5 * (double)(bb[5] - bb[4]));
        int vx = (int)Math.ceil(radx);
        int vy = (int)Math.ceil(rady);
        int vz = (int)Math.ceil(radz);
        int index = 0;
        int zmin = z - vz;
        if (zmin < 0) {
            zmin = 0;
        }
        if ((zmax = z + vz) >= this.sizeZ) {
            zmax = this.sizeZ - 1;
        }
        if ((ymin = y - vy) < 0) {
            ymin = 0;
        }
        if ((ymax = y + vy) >= this.sizeY) {
            ymax = this.sizeY - 1;
        }
        if ((xmin = x - vx) < 0) {
            xmin = 0;
        }
        if ((xmax = x + vx) >= this.sizeX) {
            xmax = this.sizeX - 1;
        }
        int tx = xmin - bb[0];
        int ty = ymin - bb[2];
        int tz = zmin - bb[4];
        for (int k = zmin; k <= zmax; ++k) {
            for (int j = ymin; j <= ymax; ++j) {
                for (int i = xmin; i <= xmax; ++i) {
                    if (!seg.contains(i - tx, j - ty, k - tz) || !(seg.getPixel(i - tx, j - ty, k - tz) > 0.0f)) continue;
                    pix.putValue(index, this.getPixel(i, j, k));
                    ++index;
                }
            }
        }
        pix.setSize(index);
        return pix;
    }

    public ArrayUtil getNeighborhoodKernelAdd(Object3D obj, ImageHandler img, int x, int y, int z) {
        int xmax;
        int xmin;
        int ymax;
        int ymin;
        int zmax;
        int nbval = obj.getVolumePixels();
        ArrayUtil pix = new ArrayUtil(nbval);
        ImageInt seg = obj.getLabelImage();
        int[] bb = obj.getBoundingBox();
        float radx = (float)(0.5 * (double)(bb[1] - bb[0]));
        float rady = (float)(0.5 * (double)(bb[3] - bb[2]));
        float radz = (float)(0.5 * (double)(bb[5] - bb[4]));
        int vx = (int)Math.ceil(radx);
        int vy = (int)Math.ceil(rady);
        int vz = (int)Math.ceil(radz);
        int index = 0;
        int zmin = z - vz;
        if (zmin < 0) {
            zmin = 0;
        }
        if ((zmax = z + vz) >= this.sizeZ) {
            zmax = this.sizeZ - 1;
        }
        if ((ymin = y - vy) < 0) {
            ymin = 0;
        }
        if ((ymax = y + vy) >= this.sizeY) {
            ymax = this.sizeY - 1;
        }
        if ((xmin = x - vx) < 0) {
            xmin = 0;
        }
        if ((xmax = x + vx) >= this.sizeX) {
            xmax = this.sizeX - 1;
        }
        int tx = xmin - bb[0];
        int ty = ymin - bb[2];
        int tz = zmin - bb[4];
        for (int k = zmin; k <= zmax; ++k) {
            for (int j = ymin; j <= ymax; ++j) {
                for (int i = xmin; i <= xmax; ++i) {
                    if (!seg.contains(i - tx, j - ty, k - tz) || !(seg.getPixel(i - tx, j - ty, k - tz) > 0.0f)) continue;
                    pix.putValue(index, this.getPixel(i, j, k) + img.getPixel(i - tx, j - ty, k - tz));
                    ++index;
                }
            }
        }
        pix.setSize(index);
        return pix;
    }

    public ArrayUtil getNeighborhoodKernelSubstract(Object3D obj, ImageHandler img, int x, int y, int z) {
        int xmax;
        int xmin;
        int ymax;
        int ymin;
        int zmax;
        int nbval = obj.getVolumePixels();
        ArrayUtil pix = new ArrayUtil(nbval);
        ImageInt seg = obj.getLabelImage();
        int[] bb = obj.getBoundingBox();
        float radx = (float)(0.5 * (double)(bb[1] - bb[0]));
        float rady = (float)(0.5 * (double)(bb[3] - bb[2]));
        float radz = (float)(0.5 * (double)(bb[5] - bb[4]));
        int vx = (int)Math.ceil(radx);
        int vy = (int)Math.ceil(rady);
        int vz = (int)Math.ceil(radz);
        int index = 0;
        int zmin = z - vz;
        if (zmin < 0) {
            zmin = 0;
        }
        if ((zmax = z + vz) >= this.sizeZ) {
            zmax = this.sizeZ - 1;
        }
        if ((ymin = y - vy) < 0) {
            ymin = 0;
        }
        if ((ymax = y + vy) >= this.sizeY) {
            ymax = this.sizeY - 1;
        }
        if ((xmin = x - vx) < 0) {
            xmin = 0;
        }
        if ((xmax = x + vx) >= this.sizeX) {
            xmax = this.sizeX - 1;
        }
        int tx = xmin - bb[0];
        int ty = ymin - bb[2];
        int tz = zmin - bb[4];
        for (int k = zmin; k <= zmax; ++k) {
            for (int j = ymin; j <= ymax; ++j) {
                for (int i = xmin; i <= xmax; ++i) {
                    if (!seg.contains(i - tx, j - ty, k - tz) || !(seg.getPixel(i - tx, j - ty, k - tz) > 0.0f)) continue;
                    float diff = this.getPixel(i, j, k) - img.getPixel(i - tx, j - ty, k - tz);
                    pix.putValue(index, diff);
                    ++index;
                }
            }
        }
        pix.setSize(index);
        return pix;
    }

    public ArrayUtil getNeighborhoodLayer(int x, int y, int z, float r0, float r1) {
        return this.getNeighborhoodLayer(x, y, z, r0, r1, null);
    }

    public ArrayUtil getNeighborhoodLayer(int x, int y, int z, float r0, float r1, ImageInt water) {
        int index = 0;
        double r02 = r0 * r0;
        double r12 = r1 * r1;
        double ratio = this.getScaleZ() / this.getScaleXY();
        double ratio2 = ratio * ratio;
        int vx = (int)Math.ceil(r1);
        int vy = (int)Math.ceil(r1);
        int vz = (int)Math.ceil((double)r1 / ratio);
        double[] pix = new double[(2 * vx + 1) * (2 * vy + 1) * (2 * vz + 1)];
        int wat = 0;
        if (water != null) {
            wat = water.getPixelInt(x, y, z);
        }
        for (int k = z - vz; k <= z + vz; ++k) {
            for (int j = y - vy; j <= y + vy; ++j) {
                for (int i = x - vx; i <= x + vx; ++i) {
                    double dist;
                    if (i < 0 || j < 0 || k < 0 || i >= this.sizeX || j >= this.sizeY || k >= this.sizeZ || (water == null || water.getPixel(i, j, k) != (float)wat) && water != null || !((dist = (double)((x - i) * (x - i) + (y - j) * (y - j)) + (double)((z - k) * (z - k)) * ratio2) >= r02) || !(dist < r12)) continue;
                    pix[index] = this.getPixel(i, j, k);
                    ++index;
                }
            }
        }
        if (index > 0) {
            ArrayUtil t = new ArrayUtil(pix);
            t.setSize(index);
            return t;
        }
        return null;
    }

    public ArrayList<Voxel3D> getNeighborhoodLayerList(int x, int y, int z, float r0, float r1) {
        return this.getNeighborhoodLayerList(x, y, z, r0, r1, null);
    }

    public ArrayList<Voxel3D> getNeighborhoodLayerList(int x, int y, int z, float r0, float r1, ImageInt water) {
        double r02 = r0 * r0;
        double r12 = r1 * r1;
        ArrayList<Voxel3D> voxel3DS = new ArrayList<Voxel3D>();
        double ratio = this.getScaleZ() / this.getScaleXY();
        double ratio2 = ratio * ratio;
        int vx = (int)Math.ceil(r1);
        int vy = (int)Math.ceil(r1);
        int vz = (int)Math.ceil((double)r1 / ratio);
        int wat = 0;
        if (water != null) {
            wat = water.getPixelInt(x, y, z);
        }
        for (int k = z - vz; k <= z + vz; ++k) {
            for (int j = y - vy; j <= y + vy; ++j) {
                for (int i = x - vx; i <= x + vx; ++i) {
                    double dist;
                    if (i < 0 || j < 0 || k < 0 || i >= this.sizeX || j >= this.sizeY || k >= this.sizeZ || (water == null || water.getPixel(i, j, k) != (float)wat) && water != null || !((dist = (double)((x - i) * (x - i) + (y - j) * (y - j)) + (double)((z - k) * (z - k)) * ratio2) >= r02) || !(dist < r12)) continue;
                    voxel3DS.add(new Voxel3D(i, j, k, this.getPixel(i, j, k)));
                }
            }
        }
        return voxel3DS;
    }

    public ArrayUtil getNeighborhoodLayerAngle(int x, int y, int z, float r0, float r1, double angRef, Vector3D ref) {
        int index = 0;
        double r02 = r0 * r0;
        double r12 = r1 * r1;
        double ratio = this.getScaleZ() / this.getScaleXY();
        double ratio2 = ratio * ratio;
        int vx = (int)Math.ceil(r1);
        int vy = (int)Math.ceil(r1);
        int vz = (int)Math.ceil((double)r1 / ratio);
        double[] pix = new double[(2 * vx + 1) * (2 * vy + 1) * (2 * vz + 1)];
        for (int k = z - vz; k <= z + vz; ++k) {
            for (int j = y - vy; j <= y + vy; ++j) {
                for (int i = x - vx; i <= x + vx; ++i) {
                    double angle;
                    double dist;
                    if (i < 0 || j < 0 || k < 0 || i >= this.sizeX || j >= this.sizeY || k >= this.sizeZ || !((dist = (double)((x - i) * (x - i) + (y - j) * (y - j)) + (double)((z - k) * (z - k)) * ratio2) >= r02) || !(dist < r12) || !((angle = ref.angleDegrees(new Vector3D(i - x, j - y, k - z))) < angRef)) continue;
                    pix[index] = this.getPixel(i, j, k);
                    ++index;
                }
            }
        }
        if (index > 0) {
            ArrayUtil t = new ArrayUtil(pix);
            t.setSize(index);
            return t;
        }
        return null;
    }

    public ImageStack getImageStack() {
        return this.img.getImageStack();
    }

    public abstract void draw(Object3D var1, float var2);

    public abstract void setPixel(int var1, float var2);

    public abstract void setPixel(Point3D var1, float var2);

    public abstract void setPixel(int var1, int var2, int var3, float var4);

    public void setPixelIncrement(int x, int y, int z, float inc) {
        this.setPixel(x, y, z, this.getPixel(x, y, z) + inc);
    }

    public void setPixelIncrement(Point3D P, float inc) {
        this.setPixel(P, this.getPixel(P) + inc);
    }

    public abstract void setPixel(int var1, int var2, float var3);

    public abstract Object getArray1D();

    public abstract Object getArray1D(int var1);

    @Deprecated
    public Calibration getCalibration() {
        if (this.img == null) {
            return null;
        }
        return this.img.getCalibration();
    }

    @Deprecated
    public void setCalibration(Calibration cal) {
        if (this.img != null) {
            this.img.setCalibration(cal);
        }
    }

    public void setScale(double scaleXY, double scaleZ, String unit) {
        if (this.img != null) {
            Calibration cal = this.img.getCalibration();
            cal.pixelDepth = scaleZ;
            cal.pixelHeight = scaleXY;
            cal.pixelWidth = scaleXY;
            cal.setUnit(unit);
        }
        this.scaleXY = scaleXY;
        this.scaleZ = scaleZ;
        this.unit = unit;
    }

    public void setScale(ImageHandler other) {
        if (this.img != null) {
            Calibration cal = other.getImagePlus().getCalibration().copy();
            this.img.setCalibration(cal);
        }
        this.scaleXY = other.scaleXY;
        this.scaleZ = other.scaleZ;
        this.unit = other.unit;
    }

    public void setOffset(ImageHandler other) {
        this.offsetX = other.offsetX;
        this.offsetY = other.offsetY;
        this.offsetZ = other.offsetZ;
    }

    public void setOffset(int ox, int oy, int oz) {
        this.offsetX = ox;
        this.offsetY = oy;
        this.offsetZ = oz;
    }

    public double getScaleXY() {
        if (this.img != null) {
            Calibration cal = this.img.getCalibration();
            return cal.pixelWidth;
        }
        return this.scaleXY;
    }

    public String getUnit() {
        if (this.img != null) {
            Calibration cal = this.img.getCalibration();
            return cal.getUnit();
        }
        return this.unit;
    }

    public double getScaleZ() {
        if (this.img != null) {
            Calibration cal = this.img.getCalibration();
            return cal.pixelDepth;
        }
        return this.scaleZ;
    }

    public ImageHandler createSameDimensions() {
        if (this instanceof ImageByte) {
            ImageStack stack = ImageStack.create((int)this.sizeX, (int)this.sizeY, (int)this.sizeZ, (int)8);
            return new ImageByte(stack);
        }
        if (this instanceof ImageShort) {
            ImageStack stack = ImageStack.create((int)this.sizeX, (int)this.sizeY, (int)this.sizeZ, (int)16);
            return new ImageShort(stack);
        }
        if (this instanceof ImageFloat) {
            ImageStack stack = ImageStack.create((int)this.sizeX, (int)this.sizeY, (int)this.sizeZ, (int)32);
            return new ImageFloat(stack);
        }
        return null;
    }

    public ImageHandler createSameType(int sx, int sy, int sz) {
        if (this instanceof ImageByte) {
            ImageStack stack = ImageStack.create((int)sx, (int)sy, (int)sz, (int)8);
            return new ImageByte(stack);
        }
        if (this instanceof ImageShort) {
            ImageStack stack = ImageStack.create((int)sx, (int)sy, (int)sz, (int)16);
            return new ImageShort(stack);
        }
        if (this instanceof ImageFloat) {
            ImageStack stack = ImageStack.create((int)sx, (int)sy, (int)sz, (int)32);
            return new ImageFloat(stack);
        }
        return null;
    }

    public ImageHandler addImage(ImageHandler image, float s1, float s2) {
        if (!this.sameDimensions(image)) {
            return null;
        }
        ImageFloat res = new ImageFloat("res", this.sizeX, this.sizeY, this.sizeZ);
        for (int i = 0; i < this.sizeXYZ; ++i) {
            res.setPixel(i, s1 * this.getPixel(i) + s2 * image.getPixel(i));
        }
        return res;
    }

    public ImageHandler addImage(ImageHandler image, int s1, int s2) {
        if (!this.sameDimensions(image)) {
            return null;
        }
        ImageHandler res = this.createSameDimensions();
        for (int i = 0; i < this.sizeXYZ; ++i) {
            res.setPixel(i, (float)s1 * this.getPixel(i) + (float)s2 * image.getPixel(i));
        }
        return res;
    }

    public ImageHandler multiplyImage(ImageHandler image, float coeff) {
        ImageFloat res = new ImageFloat("multiply", this.sizeX, this.sizeY, this.sizeZ);
        for (int i = 0; i < this.sizeXYZ; ++i) {
            res.setPixel(i, coeff * this.getPixel(i) * image.getPixel(i));
        }
        return res;
    }

    public ImageHandler powImage(double pow) {
        ImageFloat res = new ImageFloat("pow", this.sizeX, this.sizeY, this.sizeZ);
        for (int i = 0; i < this.sizeXYZ; ++i) {
            res.setPixel(i, (float)Math.pow(this.getPixel(i), pow));
        }
        return res;
    }

    public ImageHandler divideImage(ImageHandler image, float coeff) {
        ImageFloat res = new ImageFloat("divide", this.sizeX, this.sizeY, this.sizeZ);
        for (int i = 0; i < this.sizeXYZ; ++i) {
            res.setPixel(i, this.getPixel(i) / (image.getPixel(i) * coeff));
        }
        return res;
    }

    public void divideByValue(float coeff) {
        for (int i = 0; i < this.sizeXYZ; ++i) {
            this.setPixel(i, this.getPixel(i) / coeff);
        }
    }

    public void multiplyByValue(float coeff) {
        for (int i = 0; i < this.sizeXYZ; ++i) {
            this.setPixel(i, this.getPixel(i) * coeff);
        }
    }

    public void addValue(float val) {
        for (int i = 0; i < this.sizeXYZ; ++i) {
            this.setPixel(i, this.getPixel(i) + val);
        }
    }

    public ImageHandler duplicate() {
        return ImageHandler.wrap(this.img.duplicate());
    }

    public abstract ImageHandler deleteSlices(int var1, int var2);

    public abstract void trimSlices(int var1, int var2);

    public abstract void erase();

    public void fill(double value) {
        this.fill(value, 0, this.sizeZ - 1);
    }

    public abstract void fill(double var1, int var3, int var4);

    public abstract boolean isOpened();

    public boolean isVisible() {
        return this.img != null && this.img.isVisible();
    }

    public void updateDisplay() {
        if (this.isVisible()) {
            this.img.updateAndRepaintWindow();
        }
    }

    public double[] getMinAndMaxArray(ArrayList<? extends Point3D> mask) {
        double min = Double.MAX_VALUE;
        double max = -min;
        for (Point3D point3D : mask) {
            double v = this.getPixel(point3D);
            if (v > max) {
                max = v;
            }
            if (!(v < min)) continue;
            min = v;
        }
        return new double[]{min, max};
    }

    protected abstract void getMinAndMax(ImageInt var1);

    public synchronized double getMin(ImageInt mask) {
        return this.getImageStats(mask).getMin();
    }

    public synchronized double getMax(ImageInt mask) {
        return this.getImageStats(mask).getMax();
    }

    public double getMin() {
        return this.getMin(new BlankMask(this));
    }

    public double getMax() {
        return this.getMax(new BlankMask(this));
    }

    public double getMean(ImageInt mask) {
        return this.getImageStats(mask).getMean();
    }

    public double getMean() {
        return this.getImageStats(new BlankMask(this)).getMean();
    }

    public double[] getLineX(int x0, int y0, int z0, int length) {
        int x1 = x0 + length;
        x0 = Math.max(0, x0);
        y0 = Math.max(0, y0);
        z0 = Math.max(0, z0);
        x1 = Math.min(this.sizeX - 1, x1);
        double[] line = new double[x1 - x0 + 1];
        for (int i = x0; i <= x1; ++i) {
            line[i - x0] = this.getPixel(i, y0, z0);
        }
        return line;
    }

    public double[] getLineY(int x0, int y0, int z0, int length) {
        int y1 = y0 + length;
        x0 = Math.max(0, x0);
        y0 = Math.max(0, y0);
        z0 = Math.max(0, z0);
        y1 = Math.min(this.sizeY - 1, y1);
        double[] line = new double[y1 - y0 + 1];
        for (int i = y0; i <= y1; ++i) {
            line[i - y0] = this.getPixel(x0, i, z0);
        }
        return line;
    }

    public double[] getLineZ(int x0, int y0, int z0, int length) {
        int z1 = z0 + length;
        x0 = Math.max(0, x0);
        y0 = Math.max(0, y0);
        z0 = Math.max(0, z0);
        z1 = Math.min(this.sizeZ - 1, z1);
        double[] line = new double[z1 - z0 + 1];
        for (int i = z0; i <= z1; ++i) {
            line[i - z0] = this.getPixel(x0, y0, i);
        }
        return line;
    }

    public void setLineX(int x0, int y0, int z0, double[] line) {
        int length = line.length;
        int x1 = x0 + length;
        x0 = Math.max(0, x0);
        y0 = Math.max(0, y0);
        z0 = Math.max(0, z0);
        x1 = Math.min(this.sizeX - 1, x1);
        for (int i = x0; i <= x1; ++i) {
            this.setPixel(i, y0, z0, (float)line[i - x0]);
        }
    }

    public void setLineY(int x0, int y0, int z0, double[] line) {
        int length = line.length;
        int y1 = y0 + length;
        x0 = Math.max(0, x0);
        y0 = Math.max(0, y0);
        z0 = Math.max(0, z0);
        y1 = Math.min(this.sizeY - 1, y1);
        for (int i = y0; i <= y1; ++i) {
            this.setPixel(x0, i, z0, (float)line[i - y0]);
        }
    }

    public void setLineZ(int x0, int y0, int z0, double[] line) {
        int length = line.length;
        int z1 = z0 + length;
        x0 = Math.max(0, x0);
        y0 = Math.max(0, y0);
        z0 = Math.max(0, z0);
        z1 = Math.min(this.sizeZ - 1, z1);
        for (int i = z0; i <= z1; ++i) {
            this.setPixel(x0, y0, i, (float)line[i - z0]);
        }
    }

    public double[] extractLine(int x0, int y0, int z0, int x1, int y1, int z1, boolean interpolate) {
        int dx = x1 - x0;
        int dy = y1 - y0;
        int dz = z1 - z0;
        int dist = Math.abs(dx) + Math.abs(dy) + Math.abs(dz);
        double[] line = new double[dist];
        float xStep = (float)dx / (float)dist;
        float yStep = (float)dy / (float)dist;
        float zStep = (float)dz / (float)dist;
        if (!this.contains(x1, y1, z1) || !this.contains(x0, y0, z0)) {
            for (int i = 0; i < dist; ++i) {
                float posX = (float)x0 + (float)i * xStep;
                float posY = (float)y0 + (float)i * yStep;
                float posZ = (float)z0 + (float)i * zStep;
                if (!this.contains(posX, posY, posZ)) {
                    if (i == 0) {
                        line[i] = 0.0;
                        continue;
                    }
                    line[i] = line[i - 1];
                    continue;
                }
                line[i] = interpolate ? (double)this.getPixel(posX, posY, posZ) : (double)this.getPixel(Math.round(posX), Math.round(posY), Math.round(posZ));
            }
        } else {
            for (int i = 0; i < dist; ++i) {
                float posX = (float)x0 + (float)i * xStep;
                float posY = (float)y0 + (float)i * yStep;
                float posZ = (float)z0 + (float)i * zStep;
                line[i] = interpolate ? (double)this.getPixel(posX, posY, posZ) : (double)this.getPixel(Math.round(posX), Math.round(posY), Math.round(posZ));
            }
        }
        return line;
    }

    public void setMinAndMax(ImageInt mask) {
        if (!this.isOpened()) {
            return;
        }
        this.getMinAndMax(mask);
        ImageStats s = this.getImageStats(mask);
        this.img.getProcessor().setMinAndMax(s.getMin(), s.getMax());
    }

    protected void getMoments(ImageInt mask) {
        ImageStats s;
        if (mask == null) {
            mask = new BlankMask(this);
        }
        if ((s = this.getImageStats(mask)).momentsSet()) {
            return;
        }
        double mean2 = 0.0;
        double mean = 0.0;
        double count = 0.0;
        for (int z = 0; z < this.sizeZ; ++z) {
            for (int xy = 0; xy < this.sizeXY; ++xy) {
                if (mask.getPixel(xy, z) == 0.0f) continue;
                double value = this.getPixel(xy, z);
                mean += value;
                mean2 += value * value;
                count += 1.0;
            }
        }
        if (count != 0.0) {
            s.setMoments(mean /= count, mean2, Math.sqrt(mean2 / count - mean * mean));
        } else {
            s.setMoments(0.0, 0.0, 0.0);
        }
    }

    public void setMinAndMax(float min, float max) {
        if (this.img != null) {
            this.img.getProcessor().setMinAndMax((double)min, (double)max);
        }
    }

    public int[] getHistogram(ImageInt mask) {
        if (mask == null) {
            mask = new BlankMask(this);
        }
        ImageStats s = this.getImageStats(mask);
        return s.getHisto256();
    }

    public int[] getHistogram() {
        return this.getHistogram(null);
    }

    public int[] getHistogram(ImageInt mask, int nBins, double min, double max) {
        return this.getHisto(mask, nBins, min, max);
    }

    public int[] getHistogram(ArrayList<? extends Point3D> mask, int nBins, double min, double max) {
        int[] histo = new int[nBins];
        double coeff = (double)nBins / (max - min);
        for (Point3D point3D : mask) {
            int idx = (int)(((double)this.getPixel(point3D) - min) * coeff);
            if (idx >= 255) {
                histo[255] = histo[255] + 1;
                continue;
            }
            int n = idx;
            histo[n] = histo[n] + 1;
        }
        return histo;
    }

    protected abstract int[] getHisto(ImageInt var1);

    protected abstract int[] getHisto(ImageInt var1, int var2, double var3, double var5);

    public double getPercentile(double percent, ImageInt mask) {
        ImageStats s = this.getImageStats(mask);
        int[] histo = s.getHisto256();
        int count = 0;
        for (int i : histo) {
            count += i;
        }
        double limit = (double)count * percent;
        if (limit >= (double)count) {
            return s.getMin();
        }
        count = histo[255];
        int idx = 255;
        while ((double)count < limit && idx > 0) {
            count += histo[--idx];
        }
        double idxInc = histo[idx] != 0 ? ((double)count - limit) / (double)histo[idx] : 0.0;
        return (double)((float)((double)idx + idxInc)) * s.getHisto256BinSize() + s.getMin();
    }

    public void show() {
        this.setMinAndMax(null);
        this.img.show();
        ImageHandler.zoom(this.img, defZoomFactor);
    }

    public void show(String title) {
        this.setMinAndMax(null);
        this.img.setTitle(title);
        this.img.show();
        ImageHandler.zoom(this.img, defZoomFactor);
    }

    public void showDuplicate(String title) {
        this.setMinAndMax(null);
        ImagePlus ip = this.img.duplicate();
        if (title != null) {
            ip.setTitle(title);
        } else {
            ip.setTitle(this.title);
        }
        ip.setCalibration(this.img.getCalibration());
        ip.show();
        ImageHandler.zoom(ip, defZoomFactor);
    }

    public void closeImagePlus() {
        if (this.img != null) {
            try {
                this.img.close();
            }
            catch (Exception e) {
                exceptionPrinter.print(e, "", false);
            }
        }
        this.img = null;
    }

    public void flush() {
        if (this.img != null) {
            try {
                this.img.hide();
                this.img.flush();
            }
            catch (Exception e) {
                exceptionPrinter.print(e, "", false);
            }
        }
        this.img = null;
        this.stats = new HashMap();
        this.flushPixels();
    }

    public synchronized ImageStats getImageStats(ImageInt mask) {
        ImageStats res;
        if (mask == null) {
            mask = new BlankMask(this);
        }
        if ((res = this.stats.get(mask)) == null) {
            res = new ImageStats(this, mask);
            this.stats.put(mask, res);
        }
        return res;
    }

    public synchronized void resetStats(ImageInt mask) {
        if (mask == null) {
            mask = new BlankMask(this);
        }
        this.stats.remove(mask);
    }

    public void hide() {
        if (this.img != null) {
            this.img.hide();
        }
    }

    protected abstract void flushPixels();

    public void save(String directory) {
        FileSaver fs = new FileSaver(this.img);
        this.setMinAndMax(null);
        fs.saveAsTiffStack(directory + File.separator + this.img.getTitle());
    }

    public void saveThumbNail(int sizeX, int sizeY, String directory) {
        ZProjector proj = new ZProjector(this.img);
        proj.setMethod(1);
        proj.doProjection();
        ImagePlus im = proj.getProjection();
        ImageProcessor ip = im.getProcessor().resize(sizeX, sizeY, true);
        ip.convertToByte(true);
        ip.setMinAndMax(0.0, 255.0);
        im = new ImagePlus(this.img.getShortTitle() + "_tmb", ip);
        FileSaver fs = new FileSaver(im);
        FileSaver.setJpegQuality((int)75);
        fs.saveAsJpeg(directory + File.separator + im.getTitle() + ".jpg");
    }

    public byte[] getThumbNail(int sizeX, int sizeY) {
        return this.getThumbNail(sizeX, sizeY, null);
    }

    public byte[] getThumbNail(int sizeX, int sizeY, ImageInt mask) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ImagePlus im = this.getThumbnailImage(sizeX, sizeY, 0, this.sizeZ - 1, mask);
        try {
            ImageIO.write((RenderedImage)im.getBufferedImage(), "png", out);
            byte[] res = out.toByteArray();
            out.close();
            return res;
        }
        catch (IOException ex) {
            Logger.getLogger(ImageHandler.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public ImagePlus getThumbnailImage(int sizeX, int sizeY, int minZ, int maxZ, ImageInt mask) {
        ImagePlus im;
        ZProjector proj;
        ImageProcessor imMask = null;
        this.setMinAndMax(mask);
        if (this.sizeZ > 1) {
            proj = new ZProjector(this.img);
            proj.setMethod(1);
            proj.setStartSlice(minZ + 1);
            proj.setStopSlice(maxZ + 1);
            proj.doProjection();
            im = proj.getProjection();
        } else {
            im = this.img;
        }
        if (mask != null) {
            if (mask.sizeZ > 1) {
                proj = new ZProjector(mask.img);
                proj.setMethod(1);
                proj.doProjection();
                imMask = proj.getProjection().getProcessor();
            } else {
                imMask = mask.img.getProcessor();
            }
            if (!(mask instanceof ImageByte)) {
                imMask = imMask.convertToByte(false);
            }
        }
        ContrastEnhancer ch = new ContrastEnhancer();
        if (im.getBitDepth() < 32) {
            ch.equalize(im);
        }
        ImageProcessor ip = im.getProcessor().resize(sizeX, sizeY, true);
        if (imMask != null) {
            ip.setMask(imMask);
        }
        ip = ip.convertToByte(true);
        ip.setMinAndMax(ip.getMin(), ip.getMax());
        im = new ImagePlus(this.img.getShortTitle() + "_tmb", ip);
        return im;
    }

    public byte[] getBinaryData() throws Exception, OutOfMemoryError {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        FileInfo fi = this.img.getFileInfo();
        TiffEncoder te = new TiffEncoder(fi);
        try {
            te.write((OutputStream)out);
            byte[] res = out.toByteArray();
            out.close();
            return res;
        }
        catch (Exception e) {
            exceptionPrinter.print(e, "", true);
            return null;
        }
    }

    public boolean touchBorders(int x, int y, int z) {
        return x == 0 || y == 0 || z == 0 || x == this.sizeX - 1 || y == this.sizeY - 1 || z == this.sizeZ - 1;
    }

    public abstract ImageByte thresholdRangeInclusive(float var1, float var2);

    public abstract ImageByte thresholdRangeExclusive(float var1, float var2);

    public abstract ImageByte threshold(float var1, boolean var2, boolean var3);

    public ImageByte thresholdAboveInclusive(float thld) {
        return this.threshold(thld, false, false);
    }

    public ImageByte thresholdAboveExclusive(float thld) {
        return this.threshold(thld, false, true);
    }

    public abstract void thresholdCut(float var1, boolean var2, boolean var3);

    public abstract ImageHandler cropRadius(int var1, int var2, int var3, int var4, int var5, int var6, boolean var7, boolean var8);

    public abstract ImageHandler crop3D(String var1, int var2, int var3, int var4, int var5, int var6, int var7);

    public abstract ImageHandler[] crop3D(TreeMap<Integer, int[]> var1);

    public abstract ImageHandler crop3DMask(String var1, ImageInt var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9);

    public void insert(ImageHandler vol, int x0, int y0, int z0, boolean average) {
        int xx0 = Math.max(x0, 0);
        int yy0 = Math.max(y0, 0);
        int zz0 = Math.max(z0, 0);
        int x1 = Math.min(x0 + vol.sizeX, this.sizeX);
        int y1 = Math.min(y0 + vol.sizeY, this.sizeY);
        int z1 = Math.min(z0 + vol.sizeZ, this.sizeZ);
        for (int z = zz0; z < z1; ++z) {
            for (int x = xx0; x < x1; ++x) {
                for (int y = yy0; y < y1; ++y) {
                    float pix = vol.getPixel(x - x0, y - y0, z - z0);
                    if (average) {
                        float pixo = this.getPixel(x, y, z);
                        this.setPixel(x, y, z, 0.5f * (pixo + pix));
                        continue;
                    }
                    this.setPixel(x, y, z, pix);
                }
            }
        }
    }

    public ImageHandler enlarge(int dx, int dy, int dz) {
        ImageHandler enlarged = this.createSameType(this.sizeX + 2 * dx, this.sizeY + 2 * dy, this.sizeZ + 2 * dz);
        enlarged.insert(this, dx, dy, dz, false);
        return enlarged;
    }

    public abstract ImageHandler resize(int var1, int var2, int var3);

    public abstract ImageHandler resample(int var1, int var2, int var3, int var4);

    public abstract ImageHandler resample(int var1, int var2);

    protected abstract ImageFloat normalize_(ImageInt var1, double var2);

    public abstract ImageFloat normalize(double var1, double var3);

    public ImageFloat normalize(ImageInt mask, double saturation) {
        return this.normalize_(mask, saturation);
    }

    public abstract void invert(ImageInt var1);

    public void invert() {
        this.invert(null);
    }

    public void invertBackground(float bckg, float value) {
        for (int i = 0; i < this.sizeXYZ; ++i) {
            if (this.getPixel(i) == bckg) {
                this.setPixel(i, value);
                continue;
            }
            this.setPixel(i, 0.0f);
        }
    }

    @Deprecated
    public ImageFloat substractImage(ImageHandler other) {
        if (!this.sameDimensions(other)) {
            return null;
        }
        ImageFloat res = ImageFloat.newBlankImageFloat(this.title + "-" + other.title, this);
        for (int z = 0; z < this.sizeZ; ++z) {
            for (int xy = 0; xy < this.sizeXY; ++xy) {
                res.pixels[z][xy] = this.getPixel(xy, z) - other.getPixel(xy, z);
            }
        }
        return res;
    }

    public ImageFloat subtractImage(ImageHandler other) {
        if (!this.sameDimensions(other)) {
            return null;
        }
        ImageFloat res = ImageFloat.newBlankImageFloat(this.title + "-" + other.title, this);
        for (int z = 0; z < this.sizeZ; ++z) {
            for (int xy = 0; xy < this.sizeXY; ++xy) {
                res.pixels[z][xy] = this.getPixel(xy, z) - other.getPixel(xy, z);
            }
        }
        return res;
    }

    public abstract void intersectMask(ImageInt var1);

    public abstract void intersectMask2D(ImageInt var1, int var2);

    public ImageFloat getDistanceMap(float thld, float scaleXY, float scaleZ, boolean invert, int nbCPUs) {
        return EDT.run(this, thld, scaleXY, scaleZ, invert, nbCPUs);
    }

    public void set332RGBLut() {
        IndexColorModel cm = this.get332RGB();
        this.img.getChannelProcessor().setColorModel((ColorModel)cm);
        this.img.getStack().setColorModel((ColorModel)cm);
        this.img.updateAndRepaintWindow();
    }

    public void setGraysLut() {
        IndexColorModel cm = this.getGrays();
        this.img.getChannelProcessor().setColorModel((ColorModel)cm);
        this.img.getStack().setColorModel((ColorModel)cm);
        this.img.updateAndRepaintWindow();
    }

    private IndexColorModel get332RGB() {
        FileInfo fi332RGB = new FileInfo();
        fi332RGB.reds = new byte[256];
        fi332RGB.greens = new byte[256];
        fi332RGB.blues = new byte[256];
        fi332RGB.lutSize = 256;
        for (int i = 0; i < 256; ++i) {
            fi332RGB.reds[i] = (byte)(i & 0xE0);
            fi332RGB.greens[i] = (byte)(i << 3 & 0xE0);
            fi332RGB.blues[i] = (byte)(i << 6 & 0xC0);
        }
        return new IndexColorModel(8, 256, fi332RGB.reds, fi332RGB.greens, fi332RGB.blues);
    }

    private IndexColorModel getGrays() {
        FileInfo fiGrays = new FileInfo();
        fiGrays.reds = new byte[256];
        fiGrays.greens = new byte[256];
        fiGrays.blues = new byte[256];
        fiGrays.lutSize = 256;
        for (int i = 0; i < 256; ++i) {
            fiGrays.reds[i] = (byte)i;
            fiGrays.greens[i] = (byte)i;
            fiGrays.blues[i] = (byte)i;
        }
        return new IndexColorModel(8, 256, fiGrays.reds, fiGrays.greens, fiGrays.blues);
    }

    public float getMinAboveValue(float value) {
        float mini = Float.MAX_VALUE;
        for (int p = 0; p < this.sizeXYZ; ++p) {
            float pix = this.getPixel(p);
            if (!(pix > value) || !(pix < mini)) continue;
            mini = pix;
        }
        return mini;
    }

    public float getMaxBelowValue(float value) {
        float mini = Float.MIN_VALUE;
        for (int p = 0; p < this.sizeXYZ; ++p) {
            float pix = this.getPixel(p);
            if (!(pix < value) || !(pix > mini)) continue;
            mini = pix;
        }
        return mini;
    }

    public double[] radialDistribution(int x0, int y0, int z0, int maxR, ImageInt water) {
        return this.radialDistribution(x0, y0, z0, maxR, 10, water);
    }

    public double[] radialDistribution(int x0, int y0, int z0, int maxR, int measure, ImageInt water) {
        ArrayUtil raddist;
        int r;
        int i;
        double[] radPlot = new double[2 * maxR + 1];
        int c = 0;
        for (i = -maxR; i <= 0; ++i) {
            r = -i;
            raddist = this.getNeighborhoodLayer(x0, y0, z0, r, r + 1, water);
            if (raddist != null) {
                if (measure == 10) {
                    radPlot[c] = raddist.getMean();
                } else if (measure == 13) {
                    radPlot[c] = raddist.getMaximum();
                }
                if (measure == 14) {
                    radPlot[c] = raddist.median();
                }
                if (measure == 12) {
                    radPlot[c] = raddist.getMinimum();
                }
                if (measure == 11) {
                    radPlot[c] = raddist.getStdDev();
                }
            } else {
                radPlot[c] = Double.NaN;
            }
            ++c;
        }
        for (i = 1; i <= maxR; ++i) {
            r = i;
            raddist = this.getNeighborhoodLayer(x0, y0, z0, r, r + 1, water);
            if (raddist != null) {
                if (measure == 10) {
                    radPlot[c] = raddist.getMean();
                } else if (measure == 13) {
                    radPlot[c] = raddist.getMaximum();
                }
                if (measure == 14) {
                    radPlot[c] = raddist.median();
                }
                if (measure == 12) {
                    radPlot[c] = raddist.getMinimum();
                }
                if (measure == 11) {
                    radPlot[c] = raddist.getStdDev();
                }
            } else {
                radPlot[c] = Double.NaN;
            }
            ++c;
        }
        return radPlot;
    }

    public double[] radialDistribution(int x0, int y0, int z0, int maxR) {
        return this.radialDistribution(x0, y0, z0, maxR, 10, null);
    }

    public boolean hasOneValue(float f) {
        for (int i = 0; i < this.sizeXYZ; ++i) {
            if (this.getPixel(i) != f) continue;
            return true;
        }
        return false;
    }

    public ArrayList<Voxel3D> createListVoxels(int thresh) {
        ArrayList<Voxel3D> voxelList = new ArrayList<Voxel3D>();
        for (int z = 0; z < this.sizeZ; ++z) {
            for (int x = 0; x < this.sizeX; ++x) {
                for (int y = 0; y < this.sizeY; ++y) {
                    if (!(this.getPixel(x, y, z) > (float)thresh)) continue;
                    Voxel3D v = new Voxel3D(x, y, z, this.getPixel(x, y, z));
                    voxelList.add(v);
                }
            }
        }
        return voxelList;
    }
}

