/*
 * Decompiled with CFR 0.152.
 */
package mcib3d.image3d.IterativeThresholding;

import java.util.ArrayList;
import mcib3d.geom.Object3D;
import mcib3d.geom.Voxel3D;
import mcib3d.image3d.ImageHandler;
import mcib3d.image3d.IterativeThresholding.Criterion;

public class ObjectTrack {
    public static int STATE_UNKNOWN = 0;
    public static int STATE_DIE = 1;
    public static int STATE_DIVIDE = 2;
    public static int STATE_MOVE = 3;
    public double valueCriteria;
    public double volume;
    public Voxel3D seed;
    public int threshold;
    public ImageHandler rawImage;
    private Object3D object = null;
    private int frame = 0;
    private ArrayList<ObjectTrack> children = null;
    private ObjectTrack parent = null;
    private int state = STATE_UNKNOWN;

    public ObjectTrack getParent() {
        return this.parent;
    }

    public void setParent(ObjectTrack parent) {
        this.parent = parent;
        this.state = STATE_UNKNOWN;
    }

    public int getFrame() {
        return this.frame;
    }

    public void setFrame(int frame) {
        this.frame = frame;
    }

    public int getState() {
        if (this.state == STATE_UNKNOWN) {
            this.computeState();
        }
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
    }

    public boolean isNew() {
        return this.parent == null;
    }

    public int getNbChildren() {
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    public void addChild(ObjectTrack child) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(child);
        this.state = STATE_UNKNOWN;
    }

    public void removeAllChildren() {
        this.children = null;
        this.state = STATE_UNKNOWN;
    }

    public void removeChild(ObjectTrack child) {
        this.children.remove(child);
        if (this.children.isEmpty()) {
            this.state = STATE_UNKNOWN;
        }
    }

    private void computeState() {
        this.state = this.children == null ? STATE_DIE : (this.children.size() == 1 ? STATE_MOVE : (this.children.size() > 1 ? STATE_DIVIDE : STATE_DIE));
    }

    public boolean hasBrothers() {
        if (this.parent == null) {
            return false;
        }
        return this.parent.getNbChildren() > 1;
    }

    public ObjectTrack getAncestor() {
        ObjectTrack par = this;
        while (!par.hasBrothers()) {
            if (par.getParent() == null) {
                return par;
            }
            par = par.getParent();
        }
        return par;
    }

    public ArrayList<ObjectTrack> getLineageTo(ObjectTrack anc) {
        ArrayList<ObjectTrack> list = new ArrayList<ObjectTrack>();
        ObjectTrack par = this;
        list.add(par);
        while (!par.equals(anc)) {
            if (par.getParent() == null) {
                return null;
            }
            par = par.getParent();
            list.add(par);
        }
        return list;
    }

    public Object3D getObject() {
        return this.object;
    }

    public void setObject(Object3D object) {
        this.object = object;
    }

    public void computeCriterion(Criterion criterion) {
        this.valueCriteria = criterion.computeCriterion(this.getObject());
    }
}

