/*
 * Decompiled with CFR 0.152.
 */
package plugins.sage.psfgenerator;

import bilib.commons.buttons.ButtonFactory;
import bilib.commons.job.JobEvent;
import bilib.commons.job.runnable.Pool;
import bilib.commons.job.runnable.PoolResponder;
import bilib.commons.settings.Settings;
import icy.file.FileUtil;
import icy.gui.frame.IcyFrame;
import icy.gui.frame.IcyFrameEvent;
import icy.gui.frame.IcyFrameListener;
import icy.image.IcyBufferedImage;
import icy.image.colormap.FireColorMap;
import icy.image.colormap.HSVColorMap;
import icy.image.colormap.IceColorMap;
import icy.image.colormap.IcyColorMap;
import icy.image.colormap.JETColorMap;
import icy.main.Icy;
import icy.sequence.Sequence;
import icy.type.DataType;
import icy.type.collection.array.Array1DUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import psf.Data3D;
import psf.PSF;
import psfgenerator.About;
import psfgenerator.CollectionPSF;
import psfgenerator.MainPanel;
import psfgenerator.ResultPlanesTable;
import psfgenerator.SummaryPanel;

public class PSFGeneratorIcyFrame
extends IcyFrame
implements IcyFrameListener,
PoolResponder,
ActionListener {
    private MainPanel panel;
    private String path = String.valueOf(FileUtil.getApplicationDirectory()) + File.separator + "plugins" + File.separator + "sage" + File.separator + "psfgenerator" + File.separator;
    private Settings settings = new Settings("PSF Generator", String.valueOf(this.path) + "config.txt");
    private String[] types = new String[]{"double", "float", "ubyte", "short"};
    private String[] luts = new String[]{"Fire", "HSV", "JET", "Glow", "Gray"};
    private HashMap<String, JButton> buttons = new HashMap();

    public PSFGeneratorIcyFrame() {
        super(About.title());
        ArrayList<PSF> psfs = CollectionPSF.getStandardCollection();
        this.buildButtons();
        this.panel = new MainPanel(this.settings, this.buttons, psfs, this.luts, this.types, this);
        this.getContentPane().add(this.panel);
        this.pack();
        this.addFrameListener(this);
        this.setVisible(true);
        this.toFront();
        this.addToDesktopPane();
    }

    private void buildButtons() {
        this.buttons.clear();
        this.buttons.put("run", ButtonFactory.run(false));
        this.buttons.put("stop", ButtonFactory.stop(false));
        this.buttons.put("settings", ButtonFactory.prefs(false));
        this.buttons.put("help", ButtonFactory.help(false));
        this.buttons.put("about", ButtonFactory.about(false));
        this.buttons.put("close", ButtonFactory.close(false));
        this.buttons.get("close").addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        JButton bn = (JButton)event.getSource();
        if (bn == this.buttons.get("close")) {
            this.settings.storeRecordedItems();
            this.settings.storeValue("PSF-shortname", this.panel.getSelectedPSFShortname());
            this.close();
        }
    }

    public void onClosed() {
        super.onClosed();
        this.panel.onClosed();
    }

    @Override
    public void onFailure(Pool pool, JobEvent event) {
        this.panel.setEnabledRun(true);
        Exception ex = event.getException();
        if (ex != null) {
            System.out.println(event);
            ex.printStackTrace();
        }
    }

    @Override
    public void onEvent(Pool pool, JobEvent event) {
    }

    @Override
    public void onSuccess(Pool pool, JobEvent event) {
        if (event.getJob() instanceof PSF) {
            int type = this.panel.getSelectedType();
            int lut = this.panel.getSelectedLUT();
            PSF psf = (PSF)event.getSource();
            this.display(psf, type, psf.getShortname(), lut);
            JFrame frame = new JFrame("Characterization of PSF");
            JTabbedPane tab = new JTabbedPane();
            tab.add("Summary", new SummaryPanel(psf));
            tab.add("Plane by plane", new ResultPlanesTable(psf));
            frame.getContentPane().add(tab);
            frame.pack();
            frame.setVisible(true);
            this.panel.finish();
        }
        this.panel.setEnabledRun(true);
    }

    private void display(PSF psf, int type, String name, int lut) {
        Sequence sequence = new Sequence();
        Data3D data = psf.getData();
        sequence.setName("PSF " + name);
        FireColorMap colormap = null;
        switch (lut) {
            case 0: {
                colormap = new FireColorMap();
                break;
            }
            case 1: {
                colormap = new HSVColorMap();
                break;
            }
            case 2: {
                colormap = new JETColorMap();
                break;
            }
            case 3: {
                colormap = new IceColorMap();
            }
        }
        int z = 0;
        while (z < data.nz) {
            IcyBufferedImage image;
            Object[] plane;
            if (type == 0) {
                plane = data.createAsDouble(z);
                image = new IcyBufferedImage(data.nx, data.ny, 1, DataType.DOUBLE);
                if (colormap != null) {
                    image.setColorMap(0, (IcyColorMap)colormap, true);
                }
                Array1DUtil.doubleArrayToSafeArray((double[])plane, (Object)image.getDataXY(0), (boolean)image.isSignedDataType());
                image.dataChanged();
                sequence.setImage(0, z, (BufferedImage)image);
            }
            if (type == 1) {
                plane = data.createAsFloat(z);
                image = new IcyBufferedImage(data.nx, data.ny, 1, DataType.FLOAT);
                if (colormap != null) {
                    image.setColorMap(0, (IcyColorMap)colormap, true);
                }
                Array1DUtil.floatArrayToSafeArray((float[])plane, (Object)image.getDataXY(0), (boolean)image.isSignedDataType());
                image.dataChanged();
                sequence.setImage(0, z, (BufferedImage)image);
            }
            if (type == 2) {
                plane = data.createAsByte(z);
                image = new IcyBufferedImage(data.nx, data.ny, 1, DataType.UBYTE);
                if (colormap != null) {
                    image.setColorMap(0, (IcyColorMap)colormap, true);
                }
                Array1DUtil.byteArrayToArray((byte[])plane, (Object)image.getDataXY(0), (boolean)image.isSignedDataType());
                image.dataChanged();
                sequence.setImage(0, z, (BufferedImage)image);
            }
            if (type == 3) {
                plane = data.createAsShort(z);
                image = new IcyBufferedImage(data.nx, data.ny, 1, DataType.SHORT);
                if (colormap != null) {
                    image.setColorMap(0, (IcyColorMap)colormap, true);
                }
                Array1DUtil.shortArrayToSafeArray((short[])plane, (Object)image.getDataXY(0), (boolean)image.isSignedDataType());
                image.dataChanged();
                sequence.setImage(0, z, (BufferedImage)image);
            }
            ++z;
        }
        sequence.setPixelSizeX(psf.resLateral * 0.001);
        sequence.setPixelSizeY(psf.resLateral * 0.001);
        sequence.setPixelSizeZ(psf.resAxial * 0.001);
        Icy.getMainInterface().addSequence(sequence);
    }

    public void icyFrameOpened(IcyFrameEvent e) {
    }

    public void icyFrameClosing(IcyFrameEvent e) {
    }

    public void icyFrameClosed(IcyFrameEvent e) {
    }

    public void icyFrameIconified(IcyFrameEvent e) {
    }

    public void icyFrameDeiconified(IcyFrameEvent e) {
    }

    public void icyFrameActivated(IcyFrameEvent e) {
    }

    public void icyFrameDeactivated(IcyFrameEvent e) {
    }

    public void icyFrameInternalized(IcyFrameEvent e) {
        this.pack();
    }

    public void icyFrameExternalized(IcyFrameEvent e) {
        this.pack();
    }
}

