/*
 * Decompiled with CFR 0.152.
 */
package psfgenerator;

import bilib.commons.components.HTMLPane;
import bilib.commons.table.CustomizedColumn;
import bilib.commons.table.CustomizedTable;
import bilib.commons.utils.NumFormat;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JPanel;
import psf.PSF;
import psf.Point3D;

public class SummaryPanel
extends JPanel {
    public SummaryPanel(PSF psf) {
        Point3D max = psf.getData().max;
        Point3D fwhm = psf.getData().fwhm;
        ArrayList<CustomizedColumn> columns = new ArrayList<CustomizedColumn>();
        columns.add(new CustomizedColumn("Feature", String.class, 40, false));
        columns.add(new CustomizedColumn("Value in nm", String.class, 40, false));
        columns.add(new CustomizedColumn("Value in pixel", String.class, 40, false));
        CustomizedTable table = new CustomizedTable(columns, true);
        table.append(new String[]{"Numerical Aperture", NumFormat.sci(psf.NA), ""});
        table.append(new String[]{"Wavelength", NumFormat.sci(psf.lambda), ""});
        table.append(new String[]{"Energy", NumFormat.sci(psf.getData().energy), ""});
        table.append(new String[]{"Size X", NumFormat.sci((double)psf.nx * psf.resLateral), "" + psf.nx});
        table.append(new String[]{"Size Y", NumFormat.sci((double)psf.ny * psf.resLateral), "" + psf.ny});
        table.append(new String[]{"Size Z", NumFormat.sci((double)psf.nz * psf.resAxial), "" + psf.nz});
        table.append(new String[]{"Pixelsize X", NumFormat.sci(psf.resLateral)});
        table.append(new String[]{"Pixelsize Y", NumFormat.sci(psf.resLateral)});
        table.append(new Object[]{"Axial Z-step", NumFormat.sci(psf.resAxial)});
        table.append(new String[]{"FWHM Lateral X", NumFormat.sci((double)fwhm.x * psf.resLateral), NumFormat.sci(fwhm.x)});
        table.append(new String[]{"FWHM Lateral Y", NumFormat.sci((double)fwhm.y * psf.resLateral), NumFormat.sci(fwhm.y)});
        table.append(new String[]{"FWHM Axial Z", NumFormat.sci((double)fwhm.z * psf.resAxial), NumFormat.sci(fwhm.z)});
        table.append(new String[]{"Energy under FWHM", NumFormat.sci(fwhm.value), ""});
        table.append(new String[]{"Max Lateral X", NumFormat.sci((double)max.x * psf.resLateral), NumFormat.sci(max.x)});
        table.append(new String[]{"Max Lateral Y", NumFormat.sci((double)max.y * psf.resLateral), NumFormat.sci(max.y)});
        table.append(new String[]{"Max Axial Z", NumFormat.sci((double)max.z * psf.resAxial), NumFormat.sci(max.z)});
        table.append(new String[]{"Max Value", NumFormat.sci(max.value), ""});
        HTMLPane panel = new HTMLPane();
        panel.append("<h1>" + psf.getFullname() + "</h1>");
        this.setLayout(new BorderLayout());
        this.add((Component)panel.getPane(), "North");
        this.add((Component)table.getPane(200, 200), "Center");
    }
}

