/*
 * Decompiled with CFR 0.152.
 */
package bilib.commons.random;

import bilib.commons.components.GridPanel;
import bilib.commons.components.SpinnerRangeDouble;
import bilib.commons.random.Noise;
import bilib.commons.settings.Settings;
import javax.swing.JPanel;

public class NoiseGaussian
extends Noise {
    private double mean = 0.0;
    private double stdev = 1.0;
    private SpinnerRangeDouble spnMean = new SpinnerRangeDouble(0.0, -1.7976931348623157E308, Double.MAX_VALUE, 1.0);
    private SpinnerRangeDouble spnStd = new SpinnerRangeDouble(1.0, 0.0, Double.MAX_VALUE, 0.5);

    public NoiseGaussian(double mean, double stdev) {
        this.mean = mean;
        this.stdev = stdev;
    }

    @Override
    public String getName() {
        return "Gaussian";
    }

    @Override
    public void fetchParameters() {
        this.mean = this.spnMean.get();
        this.stdev = this.spnStd.get();
    }

    @Override
    public double nextValue() {
        return this.mean + this.stdev * this.random.nextGaussian();
    }

    @Override
    public JPanel buildPanel(Settings settings) {
        GridPanel panel = new GridPanel(false);
        panel.place(1, 0, "Mean");
        panel.place(1, 1, this.spnMean);
        panel.place(2, 0, "Standard deviation");
        panel.place(2, 1, this.spnStd);
        settings.record("random-" + this.getName() + "-mean", this.spnMean, "0");
        settings.record("random-" + this.getName() + "-stdev", this.spnStd, "1");
        settings.loadRecordedItems();
        return panel;
    }
}

