/*
 * Decompiled with CFR 0.152.
 */
package bilib.commons.table;

import bilib.commons.table.CustomizedColumn;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class CustomizedTable
extends JTable {
    private JScrollPane pane = null;
    private ArrayList<CustomizedColumn> columns;

    public CustomizedTable(ArrayList<CustomizedColumn> columns, boolean sortable) {
        this.create(columns);
        this.setAutoCreateRowSorter(sortable);
        this.setRowHeight(20);
    }

    public CustomizedTable(String[] headers, boolean sortable) {
        ArrayList<CustomizedColumn> colums = new ArrayList<CustomizedColumn>();
        int i = 0;
        while (i < headers.length) {
            colums.add(new CustomizedColumn(headers[i], String.class, 150, false));
            ++i;
        }
        this.create(colums);
        this.setAutoCreateRowSorter(sortable);
        this.setRowHeight(20);
    }

    private void create(ArrayList<CustomizedColumn> column) {
        this.columns = column;
        DefaultTableModel model = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int row, int col) {
                return ((CustomizedColumn)CustomizedTable.this.columns.get(col)).isEditable();
            }

            @Override
            public Class<?> getColumnClass(int col) {
                return ((CustomizedColumn)CustomizedTable.this.columns.get(col)).getColumnClass();
            }
        };
        this.setModel(model);
        int n = this.columns.size();
        Object[] headers = new String[n];
        int col = 0;
        while (col < n) {
            headers[col] = this.columns.get(col).getHeader();
            ++col;
        }
        model.setColumnIdentifiers(headers);
        this.setFillsViewportHeight(true);
        col = 0;
        while (col < n) {
            TableColumn tc = this.getColumnModel().getColumn(col);
            tc.setPreferredWidth(this.columns.get(col).getWidth());
            if (this.columns.get(col).getChoices() != null) {
                JComboBox<String> cmb = new JComboBox<String>();
                String[] stringArray = this.columns.get(col).getChoices();
                int n2 = stringArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    String p = stringArray[n3];
                    cmb.addItem(p);
                    cmb.setToolTipText(this.columns.get(col).getTooltip());
                    tc.setCellEditor(new DefaultCellEditor(cmb));
                    ++n3;
                }
            }
            if (this.columns.get(col).getButton() != null) {
                ButtonRenderer bn = new ButtonRenderer();
                bn.setToolTipText(this.columns.get(col).getTooltip());
                tc.setCellRenderer(bn);
            }
            ++col;
        }
        this.getTableHeader().setReorderingAllowed(false);
    }

    public void setPreferredSize(int width, int height) {
        if (this.pane != null) {
            this.pane.setPreferredSize(new Dimension(width, height));
        }
    }

    public void removeRow(int row) {
        if (row >= 0 && row < this.getRowCount()) {
            ((DefaultTableModel)this.getModel()).removeRow(row);
        }
    }

    public void removeRows() {
        while (this.getRowCount() > 0) {
            ((DefaultTableModel)this.getModel()).removeRow(0);
        }
    }

    public String[] getRow(int row) {
        if (row >= 0) {
            int ncol = this.getColumnCount();
            String[] items = new String[ncol];
            int col = 0;
            while (col < ncol) {
                items[col] = (String)this.getModel().getValueAt(row, col);
                ++col;
            }
            return items;
        }
        return new String[1];
    }

    public String getCell(int row, int col) {
        if (row >= 0 && col >= 0) {
            return (String)this.getModel().getValueAt(row, col);
        }
        return "";
    }

    public void setCell(int row, int col, String value) {
        if (row >= 0 && col >= 0) {
            this.getModel().setValueAt(value, row, col);
        }
    }

    public String getRowCSV(int row, String seperator) {
        if (row >= 0) {
            int ncol = this.getColumnCount();
            String items = "";
            int col = 0;
            while (col < ncol - 1) {
                items = (String)this.getModel().getValueAt(row, col) == null ? String.valueOf(items) + seperator : String.valueOf(items) + (String)this.getModel().getValueAt(row, col) + seperator;
                ++col;
            }
            if (ncol >= 1) {
                items = String.valueOf(items) + (String)this.getModel().getValueAt(row, ncol - 1);
            }
            return items;
        }
        return "";
    }

    public void saveCSV(String filename) {
        File file = new File(filename);
        try {
            BufferedWriter buffer = new BufferedWriter(new FileWriter(file));
            int nrows = this.getRowCount();
            int ncols = this.getColumnCount();
            String row = "";
            int c = 0;
            while (c < this.columns.size()) {
                row = String.valueOf(row) + this.columns.get(c).getHeader() + (c == this.columns.size() - 1 ? "" : ", ");
                ++c;
            }
            buffer.write(String.valueOf(row) + "\n");
            int r = 0;
            while (r < nrows) {
                row = "";
                int c2 = 0;
                while (c2 < ncols) {
                    row = String.valueOf(row) + this.getCell(r, c2) + (c2 == ncols - 1 ? "" : ", ");
                    ++c2;
                }
                buffer.write(String.valueOf(row) + "\n");
                ++r;
            }
            buffer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String getSelectedAtColumn(int col) {
        int row = this.getSelectedRow();
        if (row >= 0) {
            return (String)this.getModel().getValueAt(row, col);
        }
        return "";
    }

    public void setSelectedAtColumn(int col, String selection) {
        int nrows = this.getRowCount();
        int i = 0;
        while (i < nrows) {
            String name = (String)this.getModel().getValueAt(i, col);
            if (name.equals(selection)) {
                this.setRowSelectionInterval(i, i + 1);
            }
            ++i;
        }
    }

    public void append(Object[] row) {
        DefaultTableModel model = (DefaultTableModel)this.getModel();
        int i = 0;
        try {
            model.addRow(row);
            i = this.getRowCount() - 1;
            if (i >= 0) {
                this.getSelectionModel().setSelectionInterval(i, i);
                this.scrollRectToVisible(new Rectangle(this.getCellRect(i, 0, true)));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.repaint();
    }

    public void insert(Object[] row) {
        DefaultTableModel model = (DefaultTableModel)this.getModel();
        int i = 0;
        try {
            model.insertRow(0, row);
            this.getSelectionModel().setSelectionInterval(i, i);
            this.scrollRectToVisible(new Rectangle(this.getCellRect(i, 0, true)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.repaint();
    }

    @Override
    public int getSelectedRow() {
        int row = super.getSelectedRow();
        if (row < 0) {
            if (this.getRowCount() > 0) {
                this.setRowSelectionInterval(0, 0);
                row = super.getSelectedRow();
            }
            return row;
        }
        return row;
    }

    public void update(ArrayList<String[]> data) {
        DefaultTableModel model = (DefaultTableModel)this.getModel();
        model.getDataVector().removeAllElements();
        for (Object[] objectArray : data) {
            model.addRow(objectArray);
        }
        this.repaint();
    }

    public JScrollPane getPane(int width, int height) {
        this.setAutoResizeMode(4);
        this.setPreferredScrollableViewportSize(new Dimension(width, height));
        this.setFillsViewportHeight(true);
        this.pane = new JScrollPane(this);
        return this.pane;
    }

    public JScrollPane getMinimumPane(int width, int height) {
        this.setAutoResizeMode(4);
        this.setMinimumSize(new Dimension(width, height));
        this.setShowVerticalLines(true);
        this.setPreferredScrollableViewportSize(new Dimension(width, height));
        this.setFillsViewportHeight(true);
        return new JScrollPane(this);
    }

    public JFrame show(String title, int w, int h) {
        JFrame frame = new JFrame(title);
        frame.add(this.getPane(w, h));
        frame.pack();
        frame.setVisible(true);
        return frame;
    }

    public class ButtonRenderer
    extends JButton
    implements TableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setText((String)value);
            this.setMargin(new Insets(1, 1, 1, 1));
            return this;
        }
    }
}

