package plugins.tboudier.watershed3D;

import icy.image.IcyBufferedImage;
import icy.sequence.Sequence;
import icy.sequence.VolumetricImage;
import icy.type.DataType;
import icy.type.collection.array.ArrayUtil;
import mcib3d.image3d.ImageByte;
import mcib3d.image3d.ImageFloat;
import mcib3d.image3d.ImageHandler;
import mcib3d.image3d.ImageInt;
import mcib3d.image3d.ImageShort;
import mcib3d.image3d.processing.FastFilters3D;
import mcib3d.image3d.regionGrowing.Watershed3D;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzVarDouble;
import plugins.adufour.ezplug.EzVarSequence;

public class Watershed_3D extends EzPlug implements Block {

    private final EzVarDouble EZVarRadXY = new EzVarDouble("RadiusXY", 2, 0,
	    100, 0.5);
    private final EzVarDouble EZVarRadZ = new EzVarDouble("RadiusZ", 2, 0, 100,
	    0.5);
    private final EzVarSequence EZSequence = new EzVarSequence("Signal");
    private final EzVarSequence EZSequence2 = new EzVarSequence("Seeds");
    private final EzVarSequence EZSequenceOut = new EzVarSequence("Watershed");
    private final EzVarDouble EZVarThSignal = new EzVarDouble(
	    "Threshold signal", 10, 0, 65535, 1);
    private final EzVarDouble EZVarThSeeds = new EzVarDouble("Threshold seeds",
	    100, 0, 65535, 1);

    @Override
    protected void initialize() {
	// TODO Auto-generated by Icy4Eclipse
	EZVarRadXY.setToolTipText(
		"The XY radius is used to compute seeds automatically as local maxima of the image, when no sequence is selected for seeds.");
	EZVarRadZ.setToolTipText(
		"The Z radius is used to compute seeds automatically as local maxima of the image, when no sequence is selected for seeds.");
	EZSequence.setToolTipText(
		"The signal image to be processed by watershed.");
	EZSequence2.setToolTipText(
		"The image containing the seeds for the watershed, if no sequence is selected, local maxima will be computed as seeds.");
	EZVarThSignal.setToolTipText(
		"Only the values from the signal image above this threshold will be processed by watershed");
	EZVarThSeeds.setToolTipText(
		"Only the values from the seeds image above this threshold will be used as seeds");
	super.addEzComponent(EZSequence);
	super.addEzComponent(EZSequence2);
	super.addEzComponent(EZVarThSignal);
	super.addEzComponent(EZVarThSeeds);
	super.addEzComponent(EZVarRadXY);
	super.addEzComponent(EZVarRadZ);
    }

    @Override
    protected void execute() {
	Sequence signal = EZSequence.getValue();

	DataType type = (signal.getDataType_());
	int nbSlice = signal.getSizeZ();
	int nbPixel = signal.getSizeX() * signal.getSizeY();
	boolean gui = !isHeadLess();

	ImageHandler signalImg;
	if (type.compareTo(DataType.USHORT) == 0) {
	    // convert to mcib format short
	    signalImg = new ImageShort(signal.getDataXYZAsShort(0, 0), "tmp",
		    signal.getWidth());
	} else if (type.compareTo(DataType.UBYTE) == 0) {
	    // convert to mcib format byte
	    signalImg = new ImageByte(signal.getDataXYZAsByte(0, 0), "tmp",
		    signal.getWidth());
	} else if (type.compareTo(DataType.FLOAT) == 0) {
	    // convert to mcib format float
	    signalImg = new ImageFloat(signal.getDataXYZAsFloat(0, 0), "tmp",
		    signal.getWidth());
	} else {
	    float[][] arrayImg = new float[nbSlice][nbPixel];
	    // convert to mcib format float
	    System.out.println("basic type " + type
		    + " not supported; converting to float");
	    for (int z = 0; z < nbSlice; z++) {
		arrayImg[z] = (float[]) (ArrayUtil.arrayToFloatArray(
			signal.getDataXY(0, z, 0), type.isSigned()));
	    }
	    signalImg = new ImageFloat(arrayImg, "tmp", signal.getWidth());
	}

	ImageHandler seedsImg;
	Sequence seeds = EZSequence2.getValue();
	if (seeds != null) {
	    type = (seeds.getDataType_());
	    if (type.compareTo(DataType.USHORT) == 0) {
		// convert to mcib format short
		seedsImg = new ImageShort(seeds.getDataXYZAsShort(0, 0), "tmp",
			signal.getWidth());
	    } else if (type.compareTo(DataType.UBYTE) == 0) {
		// convert to mcib format byte
		seedsImg = new ImageByte(seeds.getDataXYZAsByte(0, 0), "tmp",
			signal.getWidth());
	    } else if (type.compareTo(DataType.FLOAT) == 0) {
		// convert to mcib format float
		seedsImg = new ImageFloat(seeds.getDataXYZAsFloat(0, 0), "tmp",
			signal.getWidth());
	    } else {
		float[][] arrayImg = new float[nbSlice][nbPixel];
		// convert to mcib format float
		System.out.println("basic type " + type
			+ " not supported; converting to float");
		for (int z = 0; z < nbSlice; z++) {
		    arrayImg[z] = (float[]) (ArrayUtil.arrayToFloatArray(
			    seeds.getDataXY(0, z, 0), type.isSigned()));
		}
		seedsImg = new ImageFloat(arrayImg, "tmp", signal.getWidth());
	    }
	} else {
	    seedsImg = FastFilters3D.filterImage(signalImg,
		    FastFilters3D.MAXLOCAL, EZVarRadXY.getValue().floatValue(),
		    EZVarRadXY.getValue().floatValue(),
		    EZVarRadZ.getValue().floatValue(), 0, false);
	}

	// test
	// signalImg.show("signal");
	// seedsImg.show("seeds");
	Watershed3D water = new Watershed3D(signalImg, seedsImg,
		EZVarThSignal.getValue().intValue(),
		EZVarThSeeds.getValue().intValue());
	ImageInt res = water.getWatershedImage3D();
	// res.show();

	Sequence seqOut = new Sequence();
	VolumetricImage vol = seqOut.addVolumetricImage();
	createVolumeFromImageHandler(res, vol);
	seqOut.setName("Watershed3D");
	seqOut.setPixelSizeX(signal.getPixelSizeX());
	seqOut.setPixelSizeY(signal.getPixelSizeY());
	seqOut.setPixelSizeZ(signal.getPixelSizeZ());
	seqOut.dataChanged();
	if (gui) {
	    addSequence(seqOut);
	}
	EZSequenceOut.setValue(seqOut);
    }

    private void createVolumeFromImageHandler(ImageHandler res,
	    VolumetricImage vol) {
	for (int z = 0; z < res.sizeZ; z++) {
	    IcyBufferedImage icyimg;
	    short[] tabres = (short[]) res.getArray1D(z);
	    icyimg = new IcyBufferedImage(res.sizeX, res.sizeY, tabres);
	    vol.setImage(z, icyimg);
	}
    }

    @Override
    public void clean() {
    }

    @Override
    public void declareInput(VarList inputMap) {

	inputMap.add("Signal", EZSequence.getVariable());
	inputMap.add("Seeds", EZSequence2.getVariable());
	inputMap.add("Threshold Signal", EZVarThSignal.getVariable());
	inputMap.add("Threshold seeds", EZVarThSeeds.getVariable());
	inputMap.add("RadiusXY", EZVarRadXY.getVariable());
	inputMap.add("RadiusZ", EZVarRadZ.getVariable());
    }

    @Override
    public void declareOutput(VarList outputMap) {
	outputMap.add("watershed", EZSequenceOut.getVariable());
    }
}
